Maintaining Etcher
==================

This document is meant to serve as a guide for maintainers to perform common tasks.

Releasing
---------

### Release Types

- **draft**: A continues snapshot of current master, made by the CI services
- **pre-release** (default): A continues snapshot of current master, made by the CI services
- **release**: Full releases

Draft release is created from each PR, tagged with the branch name.
All merged PR will generate a new tag/version as a *pre-release*.
Mark the pre-release as final when it is necessary, then distribute the packages in alternative channels as necessary.


#### Preparation

- [Prepare the new version](#preparing-a-new-version)
- [Generate build artifacts](#generating-binaries) (binaries, archives, etc.)
- [Draft a release on GitHub](https://github.com/balena-io/etcher/releases)
    - Upload build artifacts to GitHub release draft

#### Testing

- Test the prepared release and build artifacts properly on **all supported operating systems** to prevent regressions that went uncaught by the CI tests (see [MANUAL-TESTING.md](MANUAL-TESTING.md))
- If regressions or other issues arise, create issues on the repository for each one, and decide whether to fix them in this release (meaning repeating the process up until this point), or to follow up with a patch release

#### Publishing

- [Publish release draft on GitHub](https://github.com/balena-io/etcher/releases)
- [Post release note to forums](https://forums.balena.io/c/etcher)
- [Submit Windows binaries to Symantec for whitelisting](#submitting-binaries-to-symantec)
- [Update the website](https://github.com/balena-io/etcher-homepage)
- Wait 2-3 hours for analytics (Sentry, Amplitude) to trickle in and check for elevated error rates, or regressions
- If regressions arise; pull the release, and release a patched version, else:
- [Upload deb & rpm packages to Cloudfront](#uploading-packages-to-cloudfront)
- Post changelog with `#release-notes` tag on internal chat
- If this release packs noteworthy major changes:
  - Write a blog post about it, and / or
  - Write about it to the Etcher mailing list

### Generating binaries

**Environment**

Make sure to set the analytics tokens when generating production release binaries:

```bash
export ANALYTICS_SENTRY_TOKEN="xxxxxx"
export ANALYTICS_AMPLITUDE_TOKEN="xxxxxx"
```

#### Linux

##### Clean dist folder

Delete `.webpack` and `out/`.

##### Generating artifacts

The artifacts are generated by the CI and published as draft-release or pre-release.
Etcher is built with electron-forge. Run:

```
npm run make
```

Our CI will appropriately sign artifacts for macOS and some Windows targets.


### Uploading packages to Cloudfront

Log in to cloudfront and upload the `rpm` and `deb` files.

### Dealing with a Problematic Release

There can be times where a release is accidentally plagued with bugs. If you
released a new version and notice the error rates are higher than normal, then
revert the problematic release as soon as possible, until the bugs are fixed.

You can revert a version by deleting its builds from the S3 bucket and Bintray.
Refer to the `Makefile` for the up to date information about the S3 bucket
where we push builds to, and get in touch with the balena.io operations team to
get write access to it.

The Etcher update notifier dialog and the website only show the a certain
version if all the expected files have been uploaded to it, so deleting a
single package or two is enough to bring down the whole version.

Use the following command to delete files from S3:

```bash
aws s3api delete-object --bucket <bucket name> --key <file name>
```

The Bintray dashboard provides an easy way to delete a version's files.


### Submitting binaries to Symantec

- [Report a Suspected Erroneous Detection](https://submit.symantec.com/false_positive/standard/)
- Fill out form:
  - **Select Submission Type:** "Provide a direct download URL"
  - **Name of the software being detected:** Etcher
  - **Name of detection given by Symantec product:** WS.Reputation.1
  - **Contact name:** Balena.io Ltd
  - **E-mail address:** hello@etcher.io
  - **Are you the creator or distributor of the software in question?** Yes
