# Akeru Glossary

This glossary is designed to provide clear, concise, and specific definitions of key terms and concepts used in the Akeru project, an open-source alternative to OpenAI's Assistant API. The explanations are tailored to how these terms are used within the context of Akeru, offering both general definitions and their application in the project.

---

## Threads

In the context of Akeru, a thread refers to a sequence of messages or interactions that are linked or related to a single topic or user query. Threads in Akeru are crucial for maintaining the continuity of conversation or data processing. They allow the API to handle complex, multi-turn interactions by keeping track of the context.

## Users

In the Akeru project, 'Users' encompasses a broad category that includes both human users and assistants (agents). Human users can be developers who integrate the Akeru API into their applications or end-users who interact with the final product. The user experience, whether for a developer or an end-user, is central to Akeru's design and functionality.

Additionally, users within Akeru also refer to assistants (agents) – AI-driven entities capable of performing tasks and making decisions autonomously. The permission system in Akeru is designed to apply universally to this diverse user base, governing both human interactions and automated processes performed by assistants. This ensures a controlled, secure operation and facilitates the potential for greater autonomy in AI-driven assistants, aligning with Akeru's vision of advanced AI functionality.

## API Keys

API keys are unique identifiers used for authenticating and authorizing access to the Akeru API, ensuring secure and controlled use.
<br>
**Example**: When a developer integrates Akeru into their application, they will use an API key to ensure secure communication between their application and the API.

## Messages

Messages are units of information processed by the Akeru API, encompassing both input queries and output responses. In Akeru, messages are the core components of interaction. They can range from user-generated text, queries or commands, to AI-generated responses, forming the basis of the conversational interface.

## Files

Files refer to any digital data that can be processed by the Akeru API potentially including text documents, images or other data formats supported by the API. While primarily focused on text, Akeru's capabilities may include processing and analyzing various file types, depending on the API's current features and future developments.

## Tools

Tools in the Akeru ecosystem refer to software components or utilities aiding in tasks like text analysis, data processing or API interaction.
**Example**: This might include a debug tool for testing API requests or a utility for analyzing text input patterns.

## Embeddings

Embeddings are representations of text or other data in a format (usually a vector) that the model can process. In Akeru, embeddings play a key role in understanding and generating human-like text, as they help the AI model grasp the nuances of language and context.

---

**Note**: This glossary is a starting point. Contributors and users are encouraged to refer to Akeru's detailed documentation for more comprehensive explanations. For further clarifications or suggestions on these definitions, engaging with the Akeru community through forums or discussions is highly recommended.
