# Akeru.ai Issue and Pull Request Templates

## Table of Contents

1. [Issue Template](#akeruai-issue-template)
2. [Pull Request Template](#akeruai-pull-request-template)

## Akeru.ai Issue Template

**Title**: [Enter a clear, concise title describing the issue]

### Description

Provide a detailed description of the problem or the enhancement proposed. Explain the background and the importance of addressing this issue.

### Objectives

- List the specific goals or outcomes expected from resolving this issue.
- Detail the sections of the project affected and suggest possible solutions, if applicable.

### Expected Outcomes

- Describe what a successful resolution will look like.
- Explain how it will improve the project (e.g., enhanced usability, reduced errors).

### Tags

- Include relevant tags to help categorize the issue (e.g., `documentation`, `enhancement`, `bug`).

### Assignees

- Tag potential contributors who might be best suited to tackle this issue.

### Example

#### Title: Enhance README Documentation for Akeru.ai

#### Description

The README file is the first point of interaction for potential users and contributors to Akeru.ai. As the project grows and incorporates more features, it's crucial that the README accurately reflects the capabilities and mission of Akeru.ai, providing clear and engaging content that facilitates understanding and involvement.

#### Objectives

- Expand Introduction: Clearly define what Akeru.ai does, the problems it solves, and how it's distinct from other AI platforms.
- Detail API Features: Include descriptions of current and upcoming features, expected use cases, and any associated limitations or costs.
- Update Self-Hosting and Validation Sections: Provide preliminary guidelines and expectations for users interested in self-hosting or participating as validators/miners.
- Visual Enhancements: Propose the creation of diagrams and workflows to help visually explain complex concepts.

#### Expected Outcomes

- A comprehensive, well-structured README that serves as an effective entry point for engaging new users and contributors.
- Enhanced clarity on technical aspects and project roadmap, facilitating easier onboarding and collaboration.

#### Tags

`documentation`, `enhancement`

#### Assignees

- @username (Documentation Lead)
- @username2 (Technical Reviewer)

## Akeru.ai Pull Request Template

**Title**: [Descriptive title reflecting the main change]

### Description

Briefly describe the purpose of the pull request and what it aims to achieve. Include key changes made, such as feature additions, bug fixes, or enhancements.

### Key Changes

- List significant changes and their impact on the project.
- Mention any particular areas of the codebase affected.

### Link to Issues

- Reference related issue numbers that this pull request addresses.

### Request for Review

- Tag reviewers who are familiar with the impacted areas of the codebase.

### Checklist

- [ ] I have written tests.
- [ ] My code does not produce new errors.
- [ ] I gave myself a code review before asking others.

### Example

#### Title: Update README for Enhanced Project Clarity and Information

#### Description

This pull request updates the README to provide a clearer and more comprehensive understanding of Akeru.ai. The enhancements include detailed descriptions of new API features, and improved section formatting. These updates aim to make the repository more welcoming and informative for new contributors and users.

#### Key Changes

- Expanded Introduction: Better explains Akeru.ai's unique features and its differentiation in the AI space.
- Detailed API Features: Includes use cases and development status for upcoming features.
- Preliminary Self-Hosting Info: Provides initial guidelines on self-hosting and the requirements for validators and miners.

#### Link to Issues

- Addresses feedback from issue #[issue_number] for more detailed documentation.

#### Request for Review

- @username1
- @username2

Looking forward to your feedback and suggestions to further refine our project documentation.
