# Contributing to Akeru.ai

Welcome to the Akeru.ai community! We are thrilled to have you onboard. This document is designed to ensure that your contributions to our open-source AI platform are as smooth and effective as possible.

## Table of Contents

1. [Legal and Licensing](#legal-and-licensing)
2. [Project Overview and Code of Conduct](#project-overview-and-code-of-conduct)
3. [Getting Started](#getting-started)
4. [Contribution Process](#contribution-process)
5. [Coding Conventions](#coding-conventions)
6. [Building and Testing](#building-and-testing)
7. [Documentation Standards](#documentation-standards)
8. [Handling Issues and Pull Requests](#handling-issues-and-pull-requests)
9. [Community and Communication](#community-and-communication)
10. [Recognition and Rewards](#recognition-and-rewards)
11. [Accessibility Guidelines](#accessibility-guidelines)
12. [Internationalization](#internationalization)
13. [Security Practices](#security-practices)

### Legal and Licensing

[Akeru.ai](https://www.akeru.ai) is released under the MIT License. It is important to understand how this affects your contributions. Read the full license [here](https://opensource.org/licenses/MIT).

### Project Overview and Code of Conduct

Akeru.ai is an API platform that offers transparent, safe, and highly available AI capabilities. We strive to maintain a welcoming and inclusive community.

Our [Code of Conduct](/docs/code_of_conduct.md) outlines expected behavior and practices to ensure a collaborative and respectful environment.

### Getting Started

Setting up your development environment is the first step in contributing:

- **Platform Setup Guide**: Additional setup instructions for the platform will be provided soon.

### Contribution Process

To contribute to [Akeru.ai](https://www.akeru.ai):

1. **Fork the repository** on GitHub.
2. **Clone your fork** to your local machine (`git clone url`).
3. **Create a branch** for your changes (`git checkout -b feature-branch-name`).
4. **Make your changes** and commit them (`git commit -am 'Add some feature'`).
5. **Push your branch** to your fork (`git push origin feature-branch-name`).
6. **Create a pull request** against our main branch.

### Coding Conventions

[Akeru.ai](https://www.akeru.ai) follows Next.js linting standards in the Next app and plans to setup ESLint for the API and service mesh parts. For coding styles, we use Prettier. Our Prettier config will serve as the source of truth. View the full coding convention [here](/docs/coding_conventions.md).

### Building and Testing

- **Website**: Automated by Vercel.
- **API**: Currently under development for automated processes.

### Documentation Standards

All contributions should include relevant documentation updates:

- **Formatting Guidelines**: Follow our documentation style guide [here](/docs/documentation_style_guide.md).
- **Where to Add Documentation**: Add to `/docs` or inline as appropriate.

### Handling Issues and Pull Requests

- **Reporting Issues**: Use our template [here](/docs/issue_and_pr_template.md). Ensure to include the detailed steps to reproduce the issue.
- **Pull Requests**: Use our PR template, link related issues, and provide a detailed description of your changes. Check that out [here](/PULL_REQUEST_DOC_TEMPLATE.md)

### Community and Communication

Join the conversation on [Discord] and stay updated:

- **Main Channels**: [Links to communication platforms]
- **Communication Norms**: Engage respectfully and frequently to collaborate effectively.

### Recognition and Rewards

Details on contributor recognition and rewards are currently being developed.

### Accessibility Guidelines

We are committed to making our project accessible and plan to enhance this by adding specific linting rules. Current Next.js accessibility rules are a good baseline.

### Internationalization

Plans are in development and will be documented accordingly.

### Security Practices

Detailed security protocols will be added upon completion.
