# Akeru.ai

Akeru.ai is an API platform that offers transparent, safe, and highly available AI capabilities. We strive to maintain a welcoming and inclusive community.

## What Sets Akeru.ai Apart?

Akeru.ai solves the critical problem of giving developers access to open-source and transparent AI resources. Unlike other platforms, Akeru.ai stands out with its decentralized, open-source nature hosted on an edge network, promising superior UI and UX in the long term.

## For Developers

The Akeru API, currently under development, aims for full compatibility with OpenAI's assistant API. It introduces a range of features designed to enrich applications across platforms:

- **Retrieval**: Retrieve information or files to enhance response accuracy.
- **Function Calling**: Perform specific tasks by calling external functions or APIs.
- **Conversation Management**: Organize interactions into threads for streamlined conversations.
- **Custom Instructions**: Tailor system functionality with user-defined instructions.
- **Data Input Optimization**: Ensure data quality for efficient and accurate responses.
- **User Privacy**: Robust protocols to protect user data and ensure compliance with data protection laws.
- **Testing and Iteration**: Continuously improve performance through real-world testing and feedback.
- **Comprehensive Documentation**: Detailed guides and documentation to help users maximize their use of the platform.

### API Features Coming Soon

- **Full Conversations**: Engage in detailed, dynamic dialogues.
- **Document Processing and Image Generation**: Expand the capabilities of your applications.
- **Function Calls for LLMs**: Integrate advanced AI features into your services.

### Use Cases

The Akeru API is ideal for creating AI agents and enhancing web and mobile applications with advanced AI capabilities. (Rate limits and costs are TBD).

### Rewards for Miners

- **Dynamic Model Popularity Rewards**: Miners offering popular models earn more.
- **Performance-Based Selection**: Validators prioritize high-performing, available miners.

## API Architecture

Utilizing a loosely formed hexagonal architecture, the Akeru API integrates with technologies like Bun for backend operations, Redis for data management, and Elysia for web frameworks, ensuring a robust, scalable solution.

## Self Hosting

While self-hosting options for validators and miners will require specific guidelines, general hosting on platforms like Vercel and through Docker will be supported with comprehensive guides.

## Validating and Mining

Details on how to engage with Akeru.ai as a validator or miner are in development, with full guides forthcoming.

## Contributing to Akeru.ai

We welcome contributions of all forms, from code to documentation. Here’s how you can help:

- **Get Involved**: Check out our issues tab on GitHub.
- **Submit Pull Requests**: Contributions are reviewed regularly—ensure your code adheres to our standards.
- **See full Contributing guide [here](./CONTRIBUTING.md).**

## Visuals and Diagrams

Coming soon are detailed diagrams illustrating our network architecture and API workflows, helping clarify the complexities of our systems.
