# 模型命名规范

模型命名规范主要是为了方便管理和查找模型。RWKV 官方模型通常有两种命名规则：

- RWKV-x060-World-3B-v2.1-20240208-ctx4096.pth
- RWKV-5-World-1B5-v2-20231113-ctx4096.pth

让我们逐一解析每个字段的含义：

| 字段 | 含义 |
| --- | --- |
| **RWKV** | 模型名称 |
| **x060/052/5** | RWKV 模型的架构版本号，只推荐使用 RWKV-6 模型 |
| **World** | 模型类型，World 指使用全球语言数据集训练的 RWKV 模型，因此支持多语言任务|
| **3B/1B5** | 模型的参数规模，"B"代表"Billions"（十亿） |
| **v2/v2.1** | 模型的训练集版本，v2 ≈ 1.1 T , v2.1 ≈ 2.5T（1.1T + 1.4T） ,v3 ≈ 5.6T(2.5T + 3.1T)  |
| **20240208 / 20231113** | 模型的发布日期 |
| **ctx4096** | 预训练的上下文长度 |

在为 RWKV 模型命名时，**架构版本号**、**模型类型**、**参数量**和**训练集版本**是必须的，示例命名： `RWKV-6-World-3B-v2.1`。

## RWKV state 文件命名规范

RWKV 官方 state 文件通常有两种命名规则：

- rwkv6-world-v3-7b-chn_文言文QA-20241114-ctx2048.pth
- rwkv-x060-OnlyForChnNovel_小说扩写-14B-20240806-ctx4096.pth

让我们逐一解析每个字段的含义：

| 字段 | 含义 |
| --- | --- |
| **rwkv6/rwkv-x060** | 模型架构版本号 |
| **world** | 模型类型，World 指使用全球语言数据集训练的 RWKV 模型，因此支持多语言任务 |
| **v3** | 模型的训练集版本 |
| **7b/14b** | 模型参数量 |
| **chn_文言文QA/OnlyForChnNovel_小说扩写** | state 的用途，通常是用于强化模型在特定任务上的表现 |
| **20241114/20240806** | state 的发布日期 |
| **ctx2048/ctx4096** | state 支持的上下文长度 |

在为 RWKV state 文件命名时，**架构版本号**、**模型类型**、**参数量** 和 **state 用途**是必须的。示例命名： `RWKV-6-World-3B-v2.1-chn_文言文QA`。

 RWKV state 文件**要配合对应的 RWKV 模型才能正常使用**。在 state 文件命名中保留以上信息，可以方便用户快速识别 state 文件适用的 RWKV 模型。