# Creating the pull request

> Please include a summary of the change and which issue is fixed\
> If the related issue does not exist in our repository, please create it before making pull request\
> It is highly recommended to use our [Web Reporting Tool](https://kb.adguard.com/technical-support/reporting-tool) instead of creating an issue on GitHub directly\
> Please note, that we verify every pull request manually, so it may take time to apply it

## Prerequisites

### To avoid invalid pull requests, please check and confirm following terms

- [ ] This is not an ad/bug report
- [ ] My code follows [syntax](https://adguard-dns.io/kb/general/dns-filtering-syntax/) of this project
- [ ] I have performed a self-review of my own changes
- [ ] My changes do not break web sites, apps and files structure

## What problem does the pull request fix?

### If the problem does not fall under any category that is listed here, please write a comment below in corresponding section

- [ ] Missed ads
- [ ] Website or app doesn't work properly
- [ ] Missed analytics or tracker
- [ ] Filters maintenance

## What issue is being fixed?

### Enter the issue address

Example: <https://github.com/AdguardTeam/AdGuardSDNSFilter/issues/10000>

### Add your comment and screenshots

#### If possible, a screenshot of a page or application should not be cropped too much. Otherwise, it is not always clear where the element is located

0. **DO NOT** upload screenshots with sexually explicit material on GitHub directly.\
 Instead, upload it to a third-party image hosting and post the link to it without preview (!) here.\
 Also, mention if the link leads to NSFW content;

1. Add screenshots of the problem. You can drag and drop images or paste them from clipboard

    Use `<details> </details>` tag to hide screenshots under the spoiler;

2. Describe the issue in detail until it is absolutely clear from the screenshot what the problem is

    You can also indicate any other information that you think the developers should know.

**Warning:** Please remove personal information before uploading screenshots!

1. Your comment

<!-- Please write a comment here -->

2. Screenshots

<details>

<summary>Screenshot 1:</summary>

<!-- paste screenshot here -->

</details>

<details>

<summary>Screenshot N:</summary>

<!-- paste screenshot here -->

</details>

### Terms

- [ ] By submitting this issue, I agree that pull request does not contain private info and all conditions are met
