import { AStore } from '../main/astore'
import {
    GenerationModeEnum,
    ScriptMode,
    SelectionInfoType,
} from '../util/ts/enum'

interface AStoreUISettings {
    batch_size: number
    // add other properties here as needed
}

interface AStoreData {
    // other properties...

    init_image: string
    active_mask: string // this is the mask that is been used in the current generation
    mask: string // the user inputted mask, also can be the mask generated by photoshop dependant on the generation mode
    expanded_mask: string // mask after expanded
    monoMask: string //monochrome mask, no gradation
    preprocessed_mask: string //
    sd_mask: string // mask send to sd as payload[mask]
    mode: GenerationModeEnum
    rb_mode: ScriptMode

    ui_settings: AStoreUISettings
    selectionInfo: SelectionInfoType | undefined //the session selection info
    current_selection_info: SelectionInfoType | undefined // any new selection, could be undefined too
    can_generate: boolean // is generation currently in progress
    can_generate_more: boolean //
    is_active: boolean // is session active
    is_interrupted: boolean // did we interrupt the generation
    generation_number: number // generation number per session, 0 mean first generation
    controlnet_input_image: string // the controlnet the image that will controlnet load

    //plugin related state:
    auto_photoshop_sd_extension_status: boolean

    doc_uuid: string
    current_session_id: number
    last_seed: string
}

export const store = new AStore<AStoreData>({
    // activeBase64InitImage: '',
    // activeBase64Mask: '',
    init_image: '',
    active_mask: '', // this is the mask that is been used in the current generation
    mask: '', // the user inputted mask, also can be the mask generated by photoshop dependant on the generation mode
    expanded_mask: '', // mask after expanded
    monoMask: '', //monochrome mask, no gradation
    preprocessed_mask: '', //
    sd_mask: '', // mask send to sd as payload[mask]
    mode: GenerationModeEnum.Txt2Img,
    rb_mode: ScriptMode.Txt2Img,
    ui_settings: { batch_size: 1 },
    selectionInfo: undefined, //the session selection info
    current_selection_info: undefined, // any new selection, could be undefined too
    can_generate: true, // is generation currently in progress
    can_generate_more: false, //
    is_active: false, // is session active
    is_interrupted: false, // did we interrupt the generation
    generation_number: 0, // generation number per session, 0 mean first generation
    controlnet_input_image: '', // the controlnet the image that will controlnet load

    //plugin related state:
    auto_photoshop_sd_extension_status: true,
    doc_uuid: '',
    current_session_id: 0,
    last_seed: '-1',
})
