let MASK_MERGE_INVERT = ['None', 'Merge', 'Merge and Invert']

export const model_list = [
    'face_yolov8n.pt',
    'face_yolov8s.pt',
    'mediapipe_face_full',
    'mediapipe_face_short',
    'mediapipe_face_mesh',
    'mediapipe_face_mesh_eyes_only',
    'hand_yolov8n.pt',
    'person_yolov8n-seg.pt',
    'person_yolov8s-seg.pt',

    'None',
]
export let ui_config = {
    ad_model: {
        label: 'ADetailer model',
        choices: model_list,
        value: 'face_yolov8n.pt',
        visible: true,
        type: 'value',
        elem_id: 'ad_model',
    },
    ad_prompt: {
        label: 'ad_prompt',
        show_label: false,
        lines: 3,
        placeholder: 'ADetailer prompt',
        elem_id: 'ad_prompt',
    },
    ad_negative_prompt: {
        label: 'ad_negative_prompt',
        show_label: false,
        lines: 2,
        placeholder: 'ADetailer negative prompt',
        elem_id: 'ad_negative_prompt',
    },

    ad_mask_min_ratio: {
        label: 'Mask min area ratio',
        minimum: 0.0,
        maximum: 1.0,
        step: 0.001,
        value: 0.0,
        visible: true,
        elem_id: 'ad_mask_min_ratio',
    },
    ad_mask_max_ratio: {
        label: 'Mask max area ratio',
        minimum: 0.0,
        maximum: 1.0,
        step: 0.001,
        value: 1.0,
        visible: true,
        elem_id: 'ad_mask_max_ratio',
    },
    ad_conf: {
        label: 'Detection model confidence threshold',
        minimum: 0.0,
        maximum: 1.0,
        step: 0.01,
        value: 0.3,
        visible: true,
        elem_id: 'ad_confidence',
    },
    ad_x_offset: {
        label: 'Mask x(→) offset',
        minimum: -200,
        maximum: 200,
        step: 1,
        value: 0,
        visible: true,
        elem_id: 'ad_x_offset',
    },
    ad_y_offset: {
        label: 'Mask y(↑) offset',
        minimum: -200,
        maximum: 200,
        step: 1,
        value: 0,
        visible: true,
        elem_id: 'ad_y_offset',
    },
    ad_dilate_erode: {
        label: 'Mask erosion (-) / dilation (+)',
        minimum: -128,
        maximum: 128,
        step: 4,
        value: 4,
        visible: true,
        elem_id: 'ad_dilate_erode',
    },
    ad_mask_merge_invert: {
        label: 'Mask merge mode',
        choices: MASK_MERGE_INVERT,
        value: 'None',
        elem_id: 'ad_mask_merge_invert',
    },
    ad_mask_blur: {
        label: 'Inpaint mask blur',
        minimum: 0,
        maximum: 64,
        step: 1,
        value: 4,
        visible: true,
        elem_id: 'ad_mask_blur',
    },
    ad_denoising_strength: {
        label: 'Inpaint denoising strength',
        minimum: 0.0,
        maximum: 1.0,
        step: 0.01,
        value: 0.4,
        visible: true,
        elem_id: 'ad_denoising_strength',
    },
    ad_inpaint_full_res: {
        label: 'Inpaint only masked',
        value: true,
        visible: true,
        elem_id: 'ad_inpaint_only_masked',
    },
    ad_inpaint_full_res_padding: {
        label: 'Inpaint only masked padding, pixels',
        minimum: 0,
        maximum: 256,
        step: 4,
        value: 32,
        visible: true,
        elem_id: 'ad_inpaint_only_masked_padding',
    },
    ad_use_inpaint_width_height: {
        label: 'Use separate width/height',
        value: false,
        visible: true,
        elem_id: 'ad_use_inpaint_width_height',
    },
    ad_inpaint_width: {
        label: 'inpaint width',
        minimum: 64,
        maximum: 2048,
        step: 4,
        value: 512,
        visible: true,
        elem_id: 'ad_inpaint_width',
    },
    ad_inpaint_height: {
        label: 'inpaint height',
        minimum: 64,
        maximum: 2048,
        step: 4,
        value: 512,
        visible: true,
        elem_id: 'ad_inpaint_height',
    },
    ad_use_steps: {
        label: 'Use separate steps',
        value: false,
        visible: true,
        elem_id: 'ad_use_steps',
    },
    ad_steps: {
        label: 'ADetailer steps',
        minimum: 1,
        maximum: 150,
        step: 1,
        value: 28,
        visible: true,
        elem_id: 'ad_steps',
    },
    ad_use_cfg_scale: {
        label: 'Use separate CFG scale',
        value: false,
        visible: true,
        elem_id: 'ad_use_cfg_scale',
    },
    ad_cfg_scale: {
        label: 'ADetailer CFG scale',
        minimum: 0.0,
        maximum: 30.0,
        step: 0.5,
        value: 7.0,
        visible: true,
        elem_id: 'ad_cfg_scale',
    },
    ad_use_noise_multiplier: {
        label: 'Use separate noise multiplier',
        value: false,
        visible: true,
        elem_id: 'ad_use_noise_multiplier',
    },
    ad_noise_multiplier: {
        label: 'Noise multiplier for img2img',
        minimum: 0.5,
        maximum: 1.5,
        step: 0.01,
        value: 1.0,
        visible: true,
        elem_id: 'ad_noise_multiplier',
    },
    ad_restore_face: {
        label: 'Restore faces after ADetailer',
        value: false,
        elem_id: 'ad_restore_face',
    },
    ad_controlnet_model: {
        label: 'ControlNet model',
        choices: ['None'],
        value: 'None',
        visible: true,
        type: 'value',
        interactive: true,
        elem_id: 'ad_controlnet_model',
    },
    ad_controlnet_weight: {
        label: 'ControlNet weight',
        minimum: 0.0,
        maximum: 1.0,
        step: 0.05,
        value: 1.0,
        visible: true,
        interactive: true,
        elem_id: 'ad_controlnet_weight',
    },
    ad_controlnet_guidance_start: {
        label: 'ControlNet guidance start',
        minimum: 0.0,
        maximum: 1.0,
        step: 0.01,
        value: 1.0,
        visible: true,
        interactive: true,
        elem_id: 'ad_controlnet_guidance_start',
    },
    ad_controlnet_guidance_end: {
        label: 'ControlNet guidance end',
        minimum: 0.0,
        maximum: 1.0,
        step: 0.01,
        value: 1.0,
        visible: true,
        interactive: true,
        elem_id: 'ad_controlnet_guidance_end',
    },
}
