/**
 * 公众号分享
 */
import http from "../http/http";
import { browser,isIOS } from "../libs/check";
import { useUserStore } from "@/store/user";

export function config(page){
	if(!browser().isWechat){
		return false;
	}
	
	if(isIOS() && page != "home"){
		return false;
	}
	
	let url = getUrl(window.location.href);
	http.get("wechat.index/config",{ url: url }).then(res=>{
		if(res.code){
			wx.config(res.data);
		}else{
			console.log("获取wx分享配置失败");
		}
	});
}

export function share(data){
	if(!browser().isWechat){
		return false;
	}
	
	let url = getUrl(window.location.href);
	wx.ready(function () {
		wx.updateAppMessageShareData({
			title: data.title, // 分享标题
			desc: data.desc || '', // 分享描述
			link: url, // 分享链接，该链接域名或路径必须与当前页面对应的公众号JS安全域名一致
			imgUrl: data.imgUrl, // 分享图标
			success: function () {}
		});

		wx.updateTimelineShareData({
			title: data.title, // 分享标题
			link: url, // 分享链接，该链接域名或路径必须与当前页面对应的公众号JS安全域名一致
			imgUrl: data.imgUrl, // 分享图标
			success: function () {}
		});
	});
}

export function getUrl(url){
	const { user } = useUserStore();
	
	// #ifdef H5 || APP-PLUS
	if(user != null){
		url += '#u=' + user.id || 0;
	}
	// #endif
	
	return url;
}