import { redirectTo } from "@/el-ui/libs/navigate";
import { browser } from "@/el-ui/libs/check";

export default {
	
	pay(order){
		// #ifdef H5
		if(order.type == "wechat"){
			if(browser.isWechat){
				wx.config(order.config);
				let options = order.options;
				let that = this;
				options.success = function(){
					uni.showToast({
						title: "您已支付成功!",
						success: function (res){
							redirectTo(order.jump);
						}
					});
				}
				
				wx.chooseWXPay(options);
			}else{
				location.href = order.url + "&redirect_url=" + location.origin + '/mobile/' + order.jump;
			}
		}else{
			utils.showLoading();
			let div = document.createElement('div');
			div.innerHTML = order.result;
			document.body.appendChild(div);
			document.forms.alipaysubmit.submit();
		}
		// #endif
		
		// #ifdef MP
		let params = order.params;
		wx.requestPayment({
			timeStamp: params.timeStamp,
			nonceStr: params.nonceStr,
			package: params.package,
			signType: params.signType,
			paySign: params.paySign,
			success (res) {
				uni.showToast({
					title: "您已支付成功!",
					success: function (res){
						redirectTo(order.jump);
					}
				});
			},
			fail (res) {
				uni.showModal({
					content: "支付失败，原因：" + JSON.stringify(res),
					showCancel: false
				})
			}
		});
		// #endif
		
		// #ifdef APP-PLUS
		if(order.type == "wechat"){
			this.requestPayment(order,"wxpay");
		}else{
			this.requestPayment(order,"alipay");
		}
		// #endif
	},
	
	/**
	 * 调起APP支付
	 */
	async requestPayment(order,type) {
		if(!order) {
			uni.showModal({
				content: '获取支付信息失败',
				showCancel: false
			})
			return
		}
		
		uni.requestPayment({
			provider: type,
			orderInfo: order.params,
			success: (e) => {
				uni.showToast({
					title: "您已支付成功!",
					success: function (res){
						redirectTo(order.jump);
					}
				});
			},
			fail: (e) => {
				uni.showModal({
					content: "支付失败,原因为: " + e.errMsg,
					showCancel: false
				});
			}
		});
	}
	
}