SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

CREATE TABLE `mall_admin` (
  `id` int(10) UNSIGNED NOT NULL COMMENT 'ID',
  `role_id` int(10) NOT NULL DEFAULT '0',
  `username` varchar(20) DEFAULT '' COMMENT '用户名',
  `password` varchar(32) DEFAULT '' COMMENT '密码',
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `salt` char(5) DEFAULT '' COMMENT '密码盐',
  `avatar` varchar(255) DEFAULT '' COMMENT '头像',
  `email` varchar(100) DEFAULT '' COMMENT '电子邮箱',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态 1:正常 0:关闭',
  `login_failure` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '失败次数',
  `login_ip` varchar(50) DEFAULT '' COMMENT '登录IP',
  `login_time` int(10) DEFAULT '0' COMMENT '登录时间',
  `create_time` int(10) DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='管理员表';

INSERT INTO `mall_admin` (`id`, `role_id`, `username`, `password`, `nickname`, `salt`, `avatar`, `email`, `status`, `login_failure`, `login_ip`, `login_time`, `create_time`, `update_time`) VALUES
(1, 1, 'admin', 'c65731b65178b8cbd281baf6a8bd018a', 'admin', 'ml9pb', '', '', 1, 0, '', 1707035832, 1707035832, 1707035832),
(2, 2, 'demo', '62682a2b2a5c48988813d35074b533ff', 'demo1', 'odl53', '', 'demo@qq.com', 1, 0, '', 1707035832, 1707035832, 1707035832);

CREATE TABLE `mall_admin_log` (
  `id` int(10) UNSIGNED NOT NULL COMMENT 'ID',
  `admin_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `url` varchar(1500) DEFAULT '' COMMENT '操作页面',
  `title` varchar(100) DEFAULT '' COMMENT '日志标题',
  `content` longtext NOT NULL COMMENT '内容',
  `useragent` varchar(255) DEFAULT '' COMMENT 'User-Agent',
  `ip` varchar(50) DEFAULT '' COMMENT 'IP',
  `create_time` int(10) DEFAULT '0' COMMENT '操作时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='管理员日志表';

CREATE TABLE `mall_admin_manage` (
  `id` bigint(20) NOT NULL,
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '名称',
  `purview` text COMMENT '权限',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:开启 0:关闭)',
  `lock` tinyint(1) NOT NULL DEFAULT '0' COMMENT '锁定'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='权限分组表';

INSERT INTO `mall_admin_manage` (`id`, `title`, `purview`, `status`, `lock`) VALUES
(1, '超级管理员', '*', 1, 1),
(2, '普通管理员', '1,2,3,4,5,41,42,43,6,44,45,46,7,8,47,48,49,9,50,51,10,11,12,13,52,64,65,14,15,16,17,18,19,20,21,53,54,22,23,24,25,26,27,28,29,30,31,35,36,63,37,32,55,56,57,58,33,59,60,66,34,61,62', 1, 0);

CREATE TABLE `mall_admin_menu` (
  `id` bigint(20) UNSIGNED NOT NULL COMMENT '主键',
  `pid` bigint(20) NOT NULL DEFAULT '0' COMMENT '父ID',
  `type` char(1) NOT NULL DEFAULT '' COMMENT '菜单类型(H导航 M菜单 B按钮)',
  `level` tinyint(1) NOT NULL DEFAULT '1' COMMENT '级别',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '菜单名称',
  `code` varchar(255) NOT NULL DEFAULT '' COMMENT '权限标识',
  `icon` varchar(50) DEFAULT '' COMMENT '菜单图标',
  `route` varchar(200) DEFAULT '' COMMENT '路由地址',
  `component` varchar(255) DEFAULT '' COMMENT '组件路径',
  `selected` varchar(255) NOT NULL DEFAULT '' COMMENT '选中路径',
  `redirect` varchar(255) NOT NULL DEFAULT '' COMMENT '跳转链接',
  `hidden` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:显示 0:隐藏)',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态 (1:正常 0:停用)',
  `sort` smallint(5) DEFAULT '0' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='菜单信息表';

INSERT INTO `mall_admin_menu` (`id`, `pid`, `type`, `level`, `name`, `code`, `icon`, `route`, `component`, `selected`, `redirect`, `hidden`, `status`, `sort`, `path`) VALUES
(1, 0, 'H', 1, '首页', '', '', '/index', '', '', '', 1, 1, 0, '1'),
(2, 1, 'M', 2, '数据概况', 'index/index', 'Histogram', '/index', '@/views/index/index.vue', '', '', 1, 1, 0, '1,2'),
(4, 157, 'M', 3, '文章管理', 'addons.archives/index', 'Edit', '/addons/archives/index', '@/views/addons/archives/index.vue', '/addons/archives/editor', '', 0, 1, 0, '156,157,4'),
(5, 157, 'M', 3, '单页管理', 'addons.page/index', 'Document', '/addons/page/index', '@/views/addons/page/index.vue', '/addons/page/editor', '', 0, 1, 0, '156,157,5'),
(6, 157, 'M', 3, '分类管理', 'addons.category/index', 'Grid', '/addons/category/index', '@/views/addons/category/index.vue', '/addons/category/editor', '', 0, 1, 0, '156,157,6'),
(7, 0, 'H', 1, '会员', '', '', '/users/index', '', '', '', 1, 1, 300, '7'),
(8, 7, 'M', 2, '会员管理', 'users.users/index', 'UserFilled', '/users/index', '@/views/users/index.vue', '/users/editor', '', 1, 1, 0, '7,8'),
(9, 7, 'M', 2, '会员等级', 'users.group/index', 'Discount', '/group/index', '@/views/group/index.vue', '/group/editor', '', 1, 1, 0, '7,9'),
(10, 7, 'M', 2, '会员设置', 'users.users/setting', 'Setting', '/users/setting', '@/views/users/setting.vue', '', '', 1, 1, 0, '7,10'),
(11, 0, 'H', 1, '装修', '', '', '/mobile/index', '', '', '', 1, 1, 400, '11'),
(12, 11, 'M', 2, '装修管理', '', 'HomeFilled', '/mobile/index', '', '', '', 1, 1, 0, '11,12'),
(13, 12, 'M', 3, '首页装修', 'diy.index/page', '', '/mobile/index', '@/views/mobile/index.vue', '', '', 1, 1, 0, '11,12,13'),
(14, 12, 'M', 3, '底部导航', 'diy.index/tabbar', '', '/mobile/tabbar', '@/views/mobile/tabbar.vue', '', '', 1, 1, 1, '11,12,14'),
(15, 12, 'M', 3, '主题颜色', 'diy.index/color', '', '/mobile/color', '@/views/mobile/color.vue', '', '', 1, 1, 4, '11,12,15'),
(16, 12, 'M', 3, '主题设置', 'diy.setting/index', '', '/mobile/setting', '@/views/mobile/setting.vue', '', '', 1, 1, 5, '11,12,16'),
(22, 157, 'M', 3, '小程序', '', 'icon-mini', '/addons/miniprogram', '', '', '', 0, 1, 0, '156,157,22'),
(23, 22, 'M', 4, '基础设置', 'addons.miniprogram/index', '', '/addons/miniprogram', '@/views/addons/miniprogram/index.vue', '', '', 0, 1, 0, '156,157,22,23'),
(26, 0, 'H', 1, '系统', '', '', '/system/setting/copy', '', '', '', 1, 1, 600, '26'),
(27, 26, 'M', 2, '基本设置', '', 'Setting', '/system/setting/copy', '', '', '', 1, 1, 0, '26,27'),
(28, 27, 'M', 3, '版权设置', 'system.system/copy', '', '/system/setting/copy', '@/views/system/setting/copy.vue', '', '', 1, 1, 0, '26,27,28'),
(29, 27, 'M', 3, '邮箱设置', 'system.system/email', '', '/system/setting/email', '@/views/system/setting/email.vue', '', '', 1, 1, 0, '26,27,29'),
(30, 27, 'M', 3, '服务协议', 'system.system/service', '', '/system/setting/service', '@/views/system/setting/service.vue', '', '', 1, 1, 0, '26,27,30'),
(31, 27, 'M', 3, '隐私协议', 'system.system/privacy', '', '/system/setting/privacy', '@/views/system/setting/privacy.vue', '', '', 1, 1, 0, '26,27,31'),
(32, 26, 'M', 2, '菜单管理', 'system.menu/index', 'Menu', '/system/menu/index', '@/views/system/menu/index.vue', '', '', 1, 1, 2, '26,32'),
(33, 26, 'M', 2, '用户管理', 'system.users/index', 'UserFilled', '/system/users/index', '@/views/system/users/index.vue', '/system/users/editor|/system/users/password', '', 1, 1, 3, '26,33'),
(34, 26, 'M', 2, '权限管理', 'system.purview/index', 'Grid', '/system/purview/index', '@/views/system/purview/index.vue', '/system/purview/editor', '', 1, 1, 4, '26,34'),
(36, 157, 'M', 3, '通知模板', 'addons.sms/index', '', '/addons/sms/index', '@/views/addons/sms/index.vue', '/addons/sms/editor', '', 0, 1, 0, '156,157,36'),
(37, 157, 'M', 3, '短信设置', 'addons.sms/setting', '', '/addons/sms/setting', '@/views/addons/sms/setting.vue', '', '', 0, 1, 0, '156,157,37'),
(38, 4, 'B', 4, '编辑', 'addons.archives/editor', '', '/addons/archives/editor', '@/views/addons/archives/editor.vue', '/addons/archives/index', '', 1, 1, 0, '156,157,4,38'),
(39, 4, 'B', 4, '状态', 'addons.archives/status', '', '', '', '', '', 1, 1, 0, '156,157,4,39'),
(40, 4, 'B', 4, '删除', 'addons.archives/delete', '', '', '', '', '', 1, 1, 0, '156,157,4,40'),
(41, 5, 'B', 4, '编辑', 'addons.page/editor', '', '/addons/page/editor', '@/views/addons/page/editor.vue', '/addons/page/index', '', 1, 1, 0, '156,157,5,41'),
(42, 5, 'B', 4, '状态', 'addons.page/status', '', '', '', '', '', 1, 1, 0, '156,157,5,42'),
(43, 5, 'B', 4, '删除', 'addons.page/delete', '', '', '', '', '', 1, 1, 0, '156,157,5,43'),
(44, 6, 'B', 4, '编辑', 'addons.category/editor', '', '/addons/category/editor', '@/views/addons/category/editor.vue', '/addons/category/index', '', 1, 1, 0, '156,157,6,44'),
(45, 6, 'B', 4, '状态', 'addons.category/status', '', '', '', '', '', 1, 1, 0, '156,157,6,45'),
(46, 6, 'B', 4, '删除', 'addons.category/delete', '', '', '', '', '', 1, 1, 0, '156,157,6,46'),
(47, 8, 'B', 3, '编辑', 'users.users/editor', '', '/users/editor', '@/views/users/editor.vue', '/users/index', '', 1, 1, 0, '7,8,47'),
(48, 8, 'B', 3, '状态', 'users.users/status', '', '', '', '', '', 1, 1, 0, '7,8,48'),
(49, 8, 'B', 3, '删除', 'users.users/delete', '', '', '', '', '', 1, 1, 0, '7,8,49'),
(50, 9, 'B', 3, '编辑', 'users.group/editor', '', '/group/editor', '@/views/group/editor.vue', '/group/index', '', 1, 1, 0, '7,9,50'),
(51, 9, 'B', 3, '删除', 'users.group/delete', '', '', '', '', '', 1, 1, 0, '7,9,51'),
(52, 13, 'B', 3, '装修页面', 'diy.index/index', '', '', '', '', '', 1, 1, 0, '11,12,13,52'),
(55, 32, 'B', 3, '编辑', 'system.menu/editor', '', '', '', '', '', 1, 1, 0, '26,32,55'),
(56, 32, 'B', 3, '状态', 'system.menu/status', '', '', '', '', '', 1, 1, 0, '26,32,56'),
(57, 32, 'B', 3, '删除', 'system.menu/delete', '', '', '', '', '', 1, 1, 0, '26,32,57'),
(58, 32, 'B', 3, '排序', 'system.menu/sort', '', '', '', '', '', 1, 1, 0, '26,32,58'),
(59, 33, 'B', 3, '编辑', 'system.users/editor', '', '/system/users/editor', '@/views/system/users/editor.vue', '/system/users/index', '', 1, 1, 0, '26,33,59'),
(60, 33, 'B', 3, '删除', 'system.users/delete', '', '', '', '', '', 1, 1, 0, '26,33,60'),
(61, 34, 'B', 3, '编辑', 'system.purview/editor', '', '/system/purview/editor', '@/views/system/purview/editor.vue', '/system/purview/index', '', 1, 1, 0, '26,34,61'),
(62, 34, 'B', 3, '删除', 'system.purview/delete', '', '', '', '', '', 1, 1, 0, '26,34,62'),
(63, 36, 'B', 4, '编辑', 'addons.sms/editor', '', '/addons/sms/editor', '@/views/addons/sms/editor.vue', '/addons/sms/index', '', 1, 1, 0, '156,157,36,63'),
(64, 13, 'B', 3, '提交数据', 'diy.index/save', '', '', '', '', '', 1, 1, 0, '11,12,13,64'),
(65, 13, 'B', 3, '更改标题', 'diy.index/title', '', '', '', '', '', 1, 1, 0, '11,12,13,65'),
(66, 33, 'B', 3, '修改密码', 'system.users/password', '', '/system/users/password', '@/views/system/users/password.vue', '/system/users/index', '', 1, 1, 0, '26,33,66'),
(67, 27, 'M', 3, '搜索设置', 'system.system/keywords', '', '/system/setting/keywords', '@/views/system/setting/keywords.vue', '', '', 1, 1, 0, '26,27,67'),
(68, 0, 'H', 1, '商城', '', '', '/shop/goods/index', '', '', '', 1, 1, 200, '68'),
(69, 68, 'M', 2, '商品管理', '', 'Shop', '/shop/goods/index', '', '', '', 1, 1, 0, '68,69'),
(70, 69, 'M', 3, '商品列表', 'shop.goods/index', '', '/shop/goods/index', '@/views/shop/goods/index.vue', '/shop/goods/editor', '', 1, 1, 0, '68,69,70'),
(71, 69, 'M', 3, '分类列表', 'shop.category/index', '', '/shop/category/index', '@/views/shop/category/index.vue', '/shop/category/editor', '', 1, 1, 0, '68,69,71'),
(72, 69, 'M', 3, '品牌列表', 'shop.brand/index', '', '/shop/brand/index', '@/views/shop/brand/index.vue', '/shop/brand/editor', '', 1, 1, 0, '68,69,72'),
(73, 69, 'M', 3, '配送模板', 'shop.distribution/index', '', '/shop/distribution/index', '@/views/shop/distribution/index.vue', '/shop/distribution/editor', '', 1, 1, 0, '68,69,73'),
(74, 68, 'M', 2, '评论管理', '', 'ChatLineRound', '/shop/comments/index', '', '', '', 1, 1, 0, '68,74'),
(75, 74, 'M', 3, '评价列表', '', '', '/shop/comments/index', '@/views/shop/comments/index.vue', '', '', 1, 1, 0, '68,74,75'),
(76, 74, 'M', 3, '商品咨询', '', '', '/shop/consult/index', '@/views/shop/consult/index.vue', '', '', 1, 1, 0, '68,74,76'),
(77, 72, 'B', 4, '编辑', 'shop.brand/editor', '', '/shop/brand/editor', '@/views/shop/brand/editor.vue', '/shop/brand/index', '', 1, 1, 0, '68,69,72,77'),
(78, 72, 'B', 4, '状态', 'shop.brand/status', '', '', '', '', '', 1, 1, 0, '68,69,72,78'),
(79, 72, 'B', 4, '删除', 'shop.brand/delete', '', '', '', '', '', 1, 1, 0, '68,69,72,79'),
(80, 71, 'B', 4, '编辑', 'shop.category/editor', '', '/shop/category/editor', '@/views/shop/category/editor.vue', '/shop/category/index', '', 1, 1, 0, '68,69,71,80'),
(81, 71, 'B', 4, '状态', 'shop.category/status', '', '', '', '', '', 1, 1, 0, '68,69,71,81'),
(82, 71, 'B', 4, '删除', 'shop.category/delete', '', '', '', '', '', 1, 1, 0, '68,69,71,82'),
(83, 73, 'B', 4, '编辑', 'shop.distribution/editor', '', '/shop/distribution/editor', '@/views/shop/distribution/editor.vue', '/shop/distribution/index', '', 1, 1, 0, '68,69,73,83'),
(84, 73, 'B', 4, '状态', 'shop.distribution/status', '', '', '', '', '', 1, 1, 0, '68,69,73,84'),
(85, 73, 'B', 4, '删除', 'shop.distribution/delete', '', '', '', '', '', 1, 1, 0, '68,69,73,85'),
(86, 69, 'M', 3, '地区列表', 'shop.region/index', '', '/shop/region/index', '@/views/shop/region/index.vue', '/shop/region/editor', '', 1, 1, 0, '68,69,86'),
(87, 86, 'B', 4, '编辑', 'shop.region/editor', '', '/shop/region/editor', '@/views/shop/region/editor.vue', '/shop/region/index', '', 1, 1, 0, '68,69,86,87'),
(88, 86, 'B', 4, '删除', 'shop.region/delete', '', '', '', '', '', 1, 1, 0, '68,69,86,88'),
(89, 70, 'B', 4, '编辑', 'shop.goods/editor', '', '/shop/goods/editor', '@/views/shop/goods/editor.vue', '/shop/goods/index', '', 1, 1, 0, '68,69,70,89'),
(90, 70, 'B', 4, '上架', 'shop.goods/market', '', '', '', '', '', 1, 1, 0, '68,69,70,90'),
(91, 70, 'B', 4, '仓库', 'shop.goods/store', '', '', '', '', '', 1, 1, 0, '68,69,70,91'),
(92, 70, 'B', 4, '删除', 'shop.goods/delete', '', '', '', '', '', 1, 1, 0, '68,69,70,92'),
(93, 69, 'M', 3, '物流列表', 'shop.freight/index', '', '/shop/freight/index', '@/views/shop/freight/index.vue', '/shop/freight/editor', '', 1, 1, 0, '68,69,93'),
(94, 93, 'B', 4, '编辑', 'shop.freight/editor', '', '/shop/freight/editor', '@/views/shop/freight/editor.vue', '/shop/freight/index', '', 1, 1, 0, '68,69,93,94'),
(95, 93, 'B', 4, '状态', 'shop.freight/status', '', '', '', '', '', 1, 1, 0, '68,69,93,95'),
(96, 93, 'B', 4, '删除', 'shop.freight/delete', '', '', '', '', '', 1, 1, 0, '68,69,93,96'),
(97, 68, 'M', 2, '商品设置', '', 'Setting', '/shop/goods/setting', '', '', '', 1, 1, 0, '68,97'),
(98, 97, 'M', 3, '基础设置', '', '', '/shop/goods/setting', '@/views/shop/goods/setting.vue', '', '', 1, 1, 0, '68,97,98'),
(99, 0, 'H', 1, '营销', '', '', '/marketing/index/index', '', '', '', 1, 1, 420, '99'),
(100, 99, 'M', 2, '营销中心', '', 'Handbag', '/marketing/index/index', '@/views/marketing/index/index.vue', '', '', 1, 1, 0, '99,100'),
(101, 100, 'M', 3, '优惠券', 'promotion.coupon/index', '', '/marketing/coupon/index', '@/views/marketing/coupon/index.vue', '/marketing/coupon/editor', '', 0, 1, 0, '99,100,101'),
(102, 100, 'M', 3, '领券记录', 'promotion.coupon/receive', '', '/marketing/coupon/receive', '@/views/marketing/coupon/receive.vue', '', '', 0, 1, 0, '99,100,102'),
(103, 101, 'B', 4, '编辑', 'promotion.coupon/editor', '', '/marketing/coupon/editor', '@/views/marketing/coupon/editor.vue', '/marketing/coupon/index', '', 1, 1, 0, '99,100,101,103'),
(104, 101, 'B', 4, '状态', 'promotion.coupon/status', '', '', '', '', '', 1, 1, 0, '99,100,101,104'),
(105, 101, 'B', 4, '删除', 'promotion.coupon/delete', '', '', '', '', '', 1, 1, 0, '99,100,101,105'),
(106, 101, 'B', 4, '分享', 'promotion.coupon/share', '', '', '', '', '', 1, 1, 0, '99,100,101,106'),
(115, 100, 'M', 3, '满额包邮', 'promotion.shipping/index', '', '/marketing/shipping/index', '@/views/marketing/shipping/index.vue', '/marketing/rebate/editor', '', 0, 1, 0, '99,100,115'),
(116, 100, 'M', 3, '满减活动', 'promotion.rebate/index', '', '/marketing/rebate/index', '@/views/marketing/rebate/index.vue', '', '', 0, 1, 0, '99,100,116'),
(117, 116, 'B', 4, '编辑', 'promotion.rebate/editor', '', '/marketing/rebate/editor', '@/views/marketing/rebate/editor.vue', '/marketing/rebate/index', '', 1, 1, 0, '99,100,116,117'),
(118, 116, 'B', 4, '状态', 'promotion.rebate/status', '', '', '', '', '', 1, 1, 0, '99,100,116,118'),
(119, 116, 'B', 4, '删除', 'promotion.rebate/delete', '', '', '', '', '', 1, 1, 0, '99,100,116,119'),
(120, 100, 'M', 3, '满额赠品', 'promotion.gift/index', '', '/marketing/gift/index', '@/views/marketing/gift/index.vue', '/marketing/gift/editor', '', 0, 1, 0, '99,100,120'),
(121, 120, 'B', 4, '编辑', 'promotion.gift/editor', '', '/marketing/gift/editor', '@/views/marketing/gift/editor.vue', '/marketing/gift/index', '', 1, 1, 0, '99,100,120,121'),
(122, 120, 'B', 4, '状态', 'promotion.gift/status', '', '', '', '', '', 1, 1, 0, '99,100,120,122'),
(123, 120, 'B', 4, '删除', 'promotion.gift/delete', '', '', '', '', '', 1, 1, 0, '99,100,120,123'),
(147, 100, 'M', 3, '充值概览', 'promotion.recharge/index', '', '/marketing/recharge/index', '@/views/marketing/recharge/index.vue', '', '', 0, 1, 0, '99,100,147'),
(148, 100, 'M', 3, '充值订单', 'promotion.recharge/order', '', '/marketing/recharge/order', '@/views/marketing/recharge/order.vue', '', '', 0, 1, 0, '99,100,148'),
(149, 100, 'M', 3, '充值设置', 'promotion.recharge/setting', '', '/marketing/recharge/setting', '@/views/marketing/recharge/setting.vue', '', '', 0, 1, 0, '99,100,149'),
(156, 0, 'H', 1, '应用', '', '', '/addons/index/index', '', '', '', 1, 1, 430, '156'),
(157, 156, 'M', 2, '应用中心', '', 'Grid', '/addons/index/index', '@/views/addons/index/index.vue', '', '', 1, 1, 0, '156,157'),
(158, 157, 'M', 3, 'H5商城', 'addons.h5/index', 'Cellphone', '/addons/h5', '@/views/addons/h5/index.vue', '', '', 0, 1, 0, '156,157,158'),
(160, 157, 'M', 3, '上传设置', 'addons.upload/index', '', '/addons/upload/index', '@/views/addons/upload/index.vue', '', '', 0, 1, 0, '156,157,160'),
(161, 157, 'M', 3, '物流设置', 'addons.delivery/index', '', '/addons/delivery/index', '@/views/addons/delivery/index.vue', '', '', 0, 1, 0, '156,157,161'),
(162, 157, 'M', 3, '支付方式', 'addons.payment/list', '', '/addons/payment/list', '@/views/addons/payment/list.vue', '', '', 0, 1, 0, '156,157,162'),
(163, 157, 'M', 3, '支付设置', 'addons.payment/index', '', '/addons/payment/index', '@/views/addons/payment/index.vue', '/addons/payment/editor', '', 0, 1, 0, '156,157,163'),
(164, 163, 'B', 4, '编辑', 'addons.payment/editor', '', '/addons/payment/editor', '@/views/addons/payment/editor.vue', '/addons/payment/index', '', 0, 1, 0, '156,157,163,164'),
(165, 163, 'B', 4, '状态', 'addons.payment/status', '', '', '', '', '', 1, 1, 0, '156,157,163,165'),
(166, 0, 'H', 1, '订单', '', '', '/order/index/index', '', '', '', 1, 1, 250, '166'),
(167, 166, 'M', 2, '订单管理', 'order.index/index', 'Handbag', '/order/index/index', '@/views/order/index/index.vue', '/order/index/editor', '', 1, 1, 0, '166,167'),
(168, 167, 'B', 3, '取消订单', 'order.index/cancel', '', '', '', '', '', 1, 1, 0, '166,167,168'),
(169, 167, 'B', 3, '修改价格', 'order.index/update', '', '', '', '', '', 1, 1, 0, '166,167,169'),
(170, 167, 'B', 3, '订单发货', 'order.index/delivery', '', '', '', '', '', 1, 1, 0, '166,167,170'),
(171, 167, 'B', 3, '处理退款', 'order.index/refund', '', '', '', '', '', 1, 1, 0, '166,167,171'),
(172, 167, 'B', 3, '订单详情', 'order.index/detail', '', '', '', '', '', 1, 1, 0, '166,167,172'),
(173, 167, 'B', 3, '查看物流', 'order.index/express', '', '', '', '', '', 1, 1, 0, '166,167,173'),
(174, 167, 'B', 3, '打印购物单', 'order.printing/cart', '', '/order/printing/cart', '@/views/order/printing/cart.vue', '/order/index/index', '', 1, 1, 0, '166,167,174'),
(175, 167, 'B', 3, '打印配货单', 'order.printing/distribution', '', '/order/printing/distribution', '@/views/order/printing/distribution.vue', '/order/index/index', '', 1, 1, 0, '166,167,175'),
(176, 167, 'B', 3, '打印合购单', 'order.printing/detail', '', '/order/printing/detail', '@/views/order/printing/detail.vue', '/order/index/index', '', 1, 1, 0, '166,167,176'),
(177, 167, 'B', 3, '打印小票单', 'order.printing/', '', '', '', '', '', 1, 1, 0, '166,167,177'),
(178, 33, 'B', 3, '店铺设置', 'system.users/setting', '', '/system/users/setting', '@/views/system/users/setting.vue', '/system/users/index', '', 1, 1, 0, '26,33,178'),
(179, 166, 'M', 2, '售后订单', 'order.refund/index', 'PriceTag', '/order/refund/index', '@/views/order/refund/index.vue', '/order/refund/detail.vue', '', 1, 1, 0, '166,179'),
(180, 166, 'M', 2, '发票管理', 'order.invoice/index', 'Postcard', '/order/invoice/index', '@/views/order/invoice/index.vue', '', '', 1, 1, 0, '166,180'),
(181, 180, 'B', 3, '审核', 'order.invoice/detail', '', '', '', '', '', 1, 1, 0, '166,180,181'),
(182, 166, 'M', 2, '订单导出', 'order.index/export', 'FolderOpened', '/order/index/export', '@/views/order/index/export.vue', '', '', 1, 1, 0, '166,182'),
(183, 182, 'B', 3, '下载', 'order.index/download', '', '', '', '', '', 1, 1, 0, '166,182,183'),
(184, 182, 'B', 3, '删除', 'order.index/delete_export', '', '', '', '', '', 1, 1, 0, '166,182,184'),
(185, 166, 'M', 2, '批量发货', 'order.shipping/index', 'Van', '/order/shipping/index', '@/views/order/shipping/index.vue', '', '', 1, 1, 0, '166,185'),
(186, 185, 'B', 3, '一键发货', 'order.shipping/detail', '', '', '', '', '', 1, 1, 0, '166,185,186'),
(187, 185, 'B', 3, '下载', 'order.shipping/download', '', '', '', '', '', 1, 1, 0, '166,185,187'),
(188, 185, 'B', 3, '删除', 'order.shipping/delete', '', '', '', '', '', 1, 1, 0, '166,185,188'),
(189, 166, 'M', 2, '订单设置', 'order.index/setting', 'Setting', '/order/index/setting', '@/views/order/index/setting.vue', '', '', 1, 1, 0, '166,189'),
(195, 157, 'M', 3, '帮助管理', 'addons.help/index', 'Tickets', '/addons/help/index', '@/views/addons/help/index.vue', '/addons/help/editor', '', 0, 1, 0, '156,157,195'),
(196, 195, 'B', 4, '编辑', 'addons.help/editor', '', '/addons/help/editor', '@/views/addons/help/editor.vue', '/addons/help/index', '', 1, 1, 0, '156,157,195,196'),
(197, 195, 'B', 4, '删除', 'addons.help/delete', '', '', '', '', '', 1, 1, 0, '156,157,195,197'),
(198, 75, 'B', 4, '查看评价', 'shop.comments/detail', '', '', '', '', '', 1, 1, 0, '68,74,75,198'),
(199, 75, 'B', 4, '删除评价', 'shop.comments/delete', '', '', '', '', '', 1, 1, 0, '68,74,75,199'),
(200, 76, 'B', 4, '查看咨询', 'shop.consult/detail', '', '', '', '', '', 1, 1, 0, '68,74,76,200'),
(201, 76, 'B', 4, '删除咨询', 'shop.consult/delete', '', '', '', '', '', 1, 1, 0, '68,74,76,201'),
(202, 12, 'M', 3, '我的专题', 'diy.topic/index', 'BrushFilled', '/mobile/topic/index', '@/views/mobile/topic/index.vue', '/mobile/topic/editor', '', 1, 1, 2, '11,12,202'),
(204, 202, 'B', 4, '编辑', 'diy.topic/editor', '', '/mobile/topic/editor', '@/views/mobile/topic/editor.vue', '/mobile/topic/index', '', 1, 1, 0, '11,12,202,204'),
(205, 202, 'B', 4, '删除', 'diy.topic/delete', '', '', '', '', '', 1, 1, 0, '11,12,202,205'),
(206, 202, 'B', 4, '装修', 'diy.topic/diy', '', '', '', '', '', 1, 1, 0, '11,12,202,206'),
(226, 0, 'H', 1, '财务', '', '', '/finance/index/index', '', '', '', 1, 1, 350, '226'),
(227, 226, 'M', 2, '提现申请', 'finance.index/index', 'WalletFilled', '/finance/index/index', '@/views/finance/index/index.vue', '/finance/index/editor', '', 1, 1, 0, '226,227'),
(228, 226, 'M', 2, '资金日志', 'finance.fund/index', 'Wallet', '/finance/fund/index', '@/views/finance/fund/index.vue', '', '', 1, 1, 0, '226,228'),
(229, 226, 'M', 2, '积分日志', 'finance.point/index', 'Coin', '/finance/point/index', '@/views/finance/point/index.vue', '', '', 1, 1, 0, '226,229'),
(230, 226, 'M', 2, '汇款方式', 'finance.withdraw/index', 'CreditCard', '/finance/withdraw/index', '@/views/finance/withdraw/index.vue', '', '', 1, 1, 0, '226,230'),
(231, 226, 'M', 2, '汇款设置', 'finance.index/setting', 'Setting', '/finance/index/setting', '@/views/finance/index/setting.vue', '', '', 1, 1, 0, '226,231'),
(232, 230, 'B', 3, '状态', 'finance.withdraw/status', '', '', '', '', '', 1, 1, 0, '226,230,232'),
(233, 227, 'B', 3, '处理', 'finance.index/editor', '', '', '', '', '', 1, 1, 0, '226,227,233'),
(234, 227, 'B', 3, '删除', 'finance.index/delete', '', '', '', '', '', 1, 1, 0, '226,227,234');

CREATE TABLE `mall_archives` (
  `id` int(11) NOT NULL,
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '分类id',
  `author_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '管理员id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `photo` varchar(255) NOT NULL DEFAULT '' COMMENT '封面',
  `intro` text COMMENT '简要',
  `content` longtext COMMENT '内容',
  `hits` int(11) NOT NULL DEFAULT '0' COMMENT '点击量',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:开启 0: 关闭)',
  `sort` smallint(6) NOT NULL DEFAULT '0' COMMENT '排序',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '生成时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '修改时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='文章表';

CREATE TABLE `mall_archives_help` (
  `id` bigint(20) UNSIGNED NOT NULL COMMENT '主键ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '帮助标题',
  `content` text NOT NULL COMMENT '帮助内容',
  `sort` smallint(6) UNSIGNED NOT NULL DEFAULT '0' COMMENT '排序(数字越小越靠前)',
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='帮助中心记录表';

INSERT INTO `mall_archives_help` (`id`, `title`, `content`, `sort`, `create_time`, `update_time`) VALUES
(1, '关于小程序', '关于小程序\n', 0, 0, 0),
(2, '关于我们', '<p>关于我们说明</p>', 0, 0, 1709628067);

CREATE TABLE `mall_attachment` (
  `id` bigint(20) UNSIGNED NOT NULL COMMENT 'ID',
  `cat_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '分类ID',
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '会员ID',
  `filename` varchar(255) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '文件名称',
  `filesize` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '文件大小',
  `mimetype` varchar(100) CHARACTER SET utf8mb4 DEFAULT '' COMMENT 'mime类型',
  `image_width` varchar(30) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '宽度',
  `image_height` varchar(30) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '高度',
  `image_type` varchar(32) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '图片类型',
  `path` varchar(255) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '物理路径',
  `storage` varchar(100) CHARACTER SET utf8mb4 NOT NULL DEFAULT 'local' COMMENT '存储位置',
  `sha1` varchar(40) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '文件 sha1编码',
  `create_time` int(10) DEFAULT '0' COMMENT '创建日期',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='附件表';

CREATE TABLE `mall_attachment_category` (
  `id` int(11) NOT NULL,
  `pid` int(11) DEFAULT '0' COMMENT '父级ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '分类名称',
  `catalog` varchar(50) DEFAULT '' COMMENT '目录'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='附件分类表';

CREATE TABLE `mall_category` (
  `id` bigint(20) NOT NULL,
  `pid` bigint(20) NOT NULL DEFAULT '0' COMMENT '父id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `cat_name` varchar(128) NOT NULL DEFAULT '' COMMENT '简短名称',
  `photo` varchar(255) NOT NULL DEFAULT '' COMMENT '封面',
  `content` longtext COMMENT '内容',
  `module` varchar(64) NOT NULL DEFAULT '' COMMENT '模型',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:开启 0:关闭)',
  `sort` smallint(6) NOT NULL DEFAULT '0' COMMENT '排序',
  `hits` bigint(20) NOT NULL DEFAULT '0' COMMENT '点击量',
  `is_menu` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1:开启 0:关闭',
  `is_lock` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1:锁定 0:允许删除',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '路径',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '修改时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='分类表';

CREATE TABLE `mall_chat_friends` (
  `id` bigint(20) NOT NULL COMMENT '主键',
  `group_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '分组id',
  `service_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商家客服',
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '会员id',
  `online` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否在线(1:在线 0:离线)',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加好友时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `online_time` int(10) NOT NULL DEFAULT '0' COMMENT '上次在线时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='联系人表';

CREATE TABLE `mall_chat_message` (
  `id` bigint(20) NOT NULL COMMENT '主键',
  `service_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商家客服id',
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '会员id',
  `goods_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商品id',
  `order_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '订单id',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT '消息类型(text image goods order)',
  `send_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '发送者(1:客服 2:会员)',
  `is_read` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否己读(1己读,0未读)',
  `content` longtext COMMENT '消息内容',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='消息表';

CREATE TABLE `mall_chat_template` (
  `id` bigint(20) NOT NULL COMMENT '主键',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `content` text COMMENT '内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1:正常 0:禁用',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='客服表';

CREATE TABLE `mall_chat_users` (
  `id` bigint(20) NOT NULL COMMENT '主键',
  `username` varchar(128) DEFAULT '' COMMENT '帐号',
  `password` varchar(255) NOT NULL DEFAULT '' COMMENT '密码',
  `salt` varchar(5) NOT NULL DEFAULT '',
  `nickname` varchar(32) NOT NULL DEFAULT '' COMMENT '昵称',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `online` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否在线(1:在线 0:离线)',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1:正常 0:禁用',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `online_time` int(10) NOT NULL DEFAULT '0' COMMENT '最后登录时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='客服表';

CREATE TABLE `mall_config` (
  `id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL COMMENT '名称',
  `value` longtext COMMENT '内容'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `mall_config` (`id`, `name`, `value`) VALUES
(1, 'users', '{\"users_bind_mobile\":0,\"users_agree\":1,\"users_verify\":[\"user\",\"code\"],\"users_oauth\":[\"weixin\"],\"avatar\":\"\\/static\\/images\\/common\\/avatar.png\",\"users_register\":1}'),
(2, 'upload', '{\"type\":\"local\",\"aliyuncs\":{\"protocol\":\"https\",\"endpoint\":\"oss-cn-shenzhen\",\"accessKeyId\":\"\",\"accessKeySecret\":\"\",\"bucket\":\"\",\"domain\":\"\"},\"qcloud\":{\"endpoint\":\"ap-guangzhou\",\"secretId\":\"\",\"secretKey\":\"\",\"bucket\":\"\",\"domain\":\"\"},\"qiniu\":{\"accessKey\":\"\",\"secretKey\":\"\",\"bucket\":\"\",\"domain\":\"\"}}'),
(3, 'email', '{\"address\":1,\"port\":2,\"username\":3,\"password\":4,\"smtp_name\":5,\"smtp_send\":6,\"is_ssl\":1}'),
(4, 'wechat', '{\"name\":\"a\",\"appid\":\"1\",\"appsecret\":\"2\",\"token\":\"3\",\"enaeskey\":\"\",\"file\":\"linux.txt\",\"qrcode\":\"\"}'),
(5, 'miniprogram', '{\"name\":\"asd\",\"appid\":\"wxf803589f77639d44\",\"appsecret\":\"5ef7fcf193787924ccaffae7ea1e061b\",\"qrcode\":\"\",\"android\":\"\",\"ios\":\"aaaaa\"}'),
(6, 'service', '{\"title\":\"服务协议\",\"content\":\"<p style=\\\"text-align: center;\\\">前言 <\\/p><p>欢迎用户使用“A3Mall商城”软件及相关服务！<\\/p><p><br><\\/p><p>“A3Mall商城”软件及相关服务，系指XX科技有限公司（以下简称 “公司”）通过合法拥有并运营的、标注名称为“A3Mall”的应用程序（以下简称““A3Mall商城”软件”）向用户提供的产品与服务，包括但不限于个性化装修、商城设置、运费设置、营销活动、积分商城等核心功能以及其他功能，为用户提供一整套的移动营销商城平台。“A3Mall商城”软件的《用户协议》(以下简称“本协议”或“协议”)是用户与公司之间就用户注册、登录、使用（以下统称“使用”）“A3Mall商城”软件及相关服务所订立的协议。 <\\/p><p><br><\\/p><p>为了更好地为用户提供服务，请用户在开始使用A3Mall商城之前，认真阅读并充分理解本协议，特别是涉及免除或者限制责任的条款、权利许可和信息使用的条款、同意开通和使用特殊单项服务的条款、法律适用和争议解决条款等。其中，免除或者限制责任条款等重要内容需要用户重点阅读。如用户未满18周岁，请在法定监护人陪同下仔细阅读并充分理解本协议，并征得法定监护人的同意后使用“A3Mall商城”软件及相关服务。 <\\/p><p><br><\\/p><p>如用户不同意本协议，这将导致公司无法为用户提供完整的产品和服务，用户也可以选择停止使用。如用户自主选择同意或使用“A3Mall商城”软件及相关服务，则视为用户已充分理解本协议，并同意作为本协议的一方当事人接受本协议以及其他与“A3Mall商城”软件及相关服务相关的协议和规则（包括但不限于《隐私政策》）的约束。 <\\/p><p><br><\\/p><p>一、“A3Mall商城”软件及相关服务 <\\/p><p><br><\\/p><p>1.1 用户使用“A3Mall商城”软件及相关服务，可以通过预装、公司已授权的第三方下载等方式获取“A3Mall商城”软件。若用户并非从公司或经公司授权的第三方获取“A3Mall商城”软件的，公司无法保证非官方版本的“A3Mall商城”软件能够正常使用，用户因此遭受的损失与公司无关。 <\\/p><p><br><\\/p><p>1.2 公司可能为不同的终端设备开发不同的应用程序软件版本，用户应当根据实际设备状况获取、下载、安装合适的版本。如用户不再使用“A3Mall商城”软件及相关服务，用户也可自行卸载相应的应用程序软件。 <\\/p><p><br><\\/p><p>1.3 为更好的提升用户体验及服务，公司将不定期提供“A3Mall商城”软件及相关服务的更新或改变（包括但不限于软件修改、升级、功能强化、开发新服务、软件替换等），用户可根据需要自行选择是否更新相应的版本。 <\\/p><p><br><\\/p><p>为保证“A3Mall商城”软件及相关服务安全、提升用户服务，在“A3Mall商城”软件及相关服务的部分或全部更新后，公司将在可行的情况下以妥当的方式（包括但不限于系统提示、公告、站内信等）提示用户，用户有权选择接受更新后的版本；如用户选择不作更新，“A3Mall商城”软件及相关服务的部分功能将受到限制或不能正常使用。 <\\/p><p><br><\\/p><p>1.4 除非得到公司事先书面授权，用户不得以任何形式对“A3Mall商城”软件及相关服务进行包括但不限于改编、复制、传播、垂直搜索、镜像或交易等未经授权的访问或使用。 <\\/p><p><br><\\/p><p>1.5 公司许可用户一项个人的、不可转让的、非独占地和非商业的合法使用“A3Mall商城”软件及相关服务的权利。本协议未明示授权的其他一切权利仍由公司保留，用户在行使该等权利前须另行获得公司的书面许可，同时公司如未行使前述任何权利，并不构成对该权利的放弃。 <\\/p><p><br><\\/p><p>1.6 用户无需注册也可开始使用“A3Mall商城”软件及相关服务，但部分功能或服务可能会受到影响。同时，用户也理解，为使用户更好地使用“A3Mall商城”软件及相关服务，保障用户的用户帐号安全，某些功能和\\/或某些单项服务项目将要求用户按照国家相关法律法规的规定，提供真实的身份信息实名注册并登录后方可使用。 <\\/p><p><br><\\/p><p>二、帐号注册 <\\/p><p><br><\\/p><p>2.1 用户在使用“A3Mall商城”软件及相关服务前需要注册一个“A3Mall商城”用户帐号。该等用户帐号应当使用微信号注册、手机号验证注册或游客模式登录，请用户使用尚未在“A3Mall商城”软件验证的手机号码，以及未被公司根据本协议封禁的用户账号进行注册、登录、使用。公司可以根据用户的需求或产品需要对帐号注册和绑定的方式进行变更，而无须事先通知用户。 &nbsp; <\\/p><p><br><\\/p><p>2.2 鉴于用户帐号的注册方式，用户同意公司在用户注册时将使用用户提供的手机号码或自动提取用户的手机号码及自动提取用户的手机设备识别码等信息用于注册。 <\\/p><p><br><\\/p><p>2.3 在用户使用时，公司需要搜集能识别用户身份的个人信息以便根据相关法律规定、相关政府部门或主管机关的要求或其他必要的情况下联系用户，或为用户提供更好的使用体验。公司可能搜集的信息包括但不限于用户的姓名、性别、年龄、出生日期、手机号码、身份证号、地址、工作信息、兴趣爱好、个人说明等；公司同意对这些信息的使用将受限于第四条用户个人隐私信息保护的约束。 <\\/p><p><br><\\/p><p>2.4 用户理解并承诺，用户所设置的用户账号不得违反国家法律法规及公司的相关规则，不得实施任何侵害国家利益、损害其他公民合法权益，有害社会道德风尚的行为，用户的用户帐号名称、头像和简介等注册信息及其他个人信息中不得出现违法和不良信息，未经他人许可不得用他人名义（包括但不限于冒用他人姓名、名称、字号、头像等足以让人引起混淆的方式）开设账号，不得恶意注册“A3Mall商城”软件的用户帐号（包括但不限于频繁注册、批量注册账号等行为）。公司有权对用户提交的信息进行审核。 <\\/p><p><br><\\/p><p>2.5 用户的用户帐号仅限于用户本人使用，未经公司书面同意，禁止以任何形式赠与、借用、出租、转让、售卖或以其他方式许可他人使用该账号。如果公司发现或者有合理理由认为使用者并非账号初始注册人，为保障账号安全，公司有权立即暂停或终止向该注册账号提供服务，或注销该账号。 <\\/p><p><br><\\/p><p>2.6 用户有责任维护用户账号、密码的安全性与保密性，并对用户以注册账号名义所从事的活动承担全部法律责任，包括但不限于用户在“A3Mall商城”软件及相关服务上进行的任何数据修改、言论发表、款项支付等操作行为可能引起的一切法律责任。用户应高度重视对账号与密码的保密，在任何情况下不向他人透露账号及密码。若发现他人未经许可使用用户的用户帐号或发生其他任何安全漏洞问题时，用户应当立即通知公司。 <\\/p><p><br><\\/p><p>2.7 在丢失账号或遗忘密码时，用户可遵照公司的申诉途径及时申诉请求找回账号或密码。用户理解并认可，公司的密码找回机制仅需要识别通过短信验证通过的手机号与系统记录资料具有一致性，而无法识别申诉人是否系真正账号有权使用者。公司特别提醒用户应妥善保管用户的用户帐号和密码。当用户使用完毕后，应安全退出。如因用户保管不当等自身原因或其他不可抗因素导致遭受盗号或密码丢失，用户将自行承担相应责任。 <\\/p><p><br><\\/p><p>2.8 在注册、使用和管理账号时，用户应保证注册账号时填写的身份信息的真实性，请用户在注册、管理账号时使用真实、准确、合法、有效的相关身份证明材料及必要信息（包括用户的姓名及电子邮件地址、联系电话、联系地址等）。依照国家相关法律法规的规定，为使用“A3Mall商城”软件及相关服务的部分功能，用户需要填写真实的身份信息，请用户按照相关法律规定完成实名认证，并注意及时更新上述相关信息。若用户提交的材料或提供的信息不规范或不符合要求的，则公司有权拒绝为用户提供相关功能，用户可能无法使用“A3Mall商城”软件及相关服务或在使用过程中部分功能受到限制。 <\\/p><p><br><\\/p><p>2.9 除自行注册“A3Mall商城”软件的用户帐号外，用户也可授权使用其合法拥有的包括但不限于公司和\\/或其关联公司其他软件用户账号，以及实名注册的第三方软件用户账号登录使用“A3Mall商城”软件及相关服务，但第三方软件或平台对此有限制或禁止的除外。当用户以前述已有账号登录使用的，应保证相应账号已进行实名注册登记，并同样适用本协议中的相关条款。 <\\/p><p><br><\\/p><p>2.10 当用户完成“A3Mall商城”软件的用户帐号注册、登录并进行合理和必要的身份验证后，用户可随时浏览、修改自己提交的个人身份信息。用户理解并同意，出于安全性和身份识别（如账号或密码找回申诉服务等）的考虑，用户可能无法修改注册时提供的初始注册信息及其他验证信息。用户也可以申请注销账号，公司会在完成个人身份、安全状态、设备信息等合理和必要的验证后协助用户注销账号，并依照用户的要求删除有关用户账号的一切信息，法律法规另有规定的除外。 <\\/p><p><br><\\/p><p>三、内容规范 <\\/p><p><br><\\/p><p>3.1本条所述内容是指用户使用“A3Mall商城”软件及相关服务过程中所制作、上载、复制、发布、传播的任何内容，包括但不限于帐号头像、名称、用户说明等注册信息及认证资料，或文字、语音、图片、视频、图文等发送、回复或自动回复消息和相关链接页面，以及其他使用“A3Mall商城”软件及相关服务所产生的内容。 <\\/p><p><br><\\/p><p>3.2用户不得利用“A3Mall商城”软件及相关服务制作、上载、复制、发布、传播如下法律、法规和政策禁止的内容： <\\/p><p><br><\\/p><p>3.2.1 反对宪法所确定的基本原则的； <\\/p><p><br><\\/p><p>3.2.2 危害国家安全，泄露国家秘密，颠覆国家政权，破坏国家统一的； <\\/p><p><br><\\/p><p>3.2.3 损害国家荣誉和利益的； <\\/p><p><br><\\/p><p>3.2.4 煽动民族仇恨、民族歧视，破坏民族团结的； <\\/p><p><br><\\/p><p>3.2.5 破坏国家宗教政策，宣扬邪教和封建迷信的； <\\/p><p><br><\\/p><p>3.2.6 散布谣言，扰乱社会秩序，破坏社会稳定的； <\\/p><p><br><\\/p><p>3.2.7 散布淫秽、色情、赌博、暴力、凶杀、恐怖或者教唆犯罪的； <\\/p><p><br><\\/p><p>3.2.8 侮辱或者诽谤他人，侵害他人合法权益的； <\\/p><p><br><\\/p><p>3.2.9 不遵守法律法规底线、社会主义制度底线、国家利益底线、公民合法权益底线、社会公共秩序底线、道德风尚底线和信息真实性底线的“七条底线”要求的； <\\/p><p><br><\\/p><p>3.2.10 含有法律、行政法规禁止的其他内容的信息； <\\/p><p><br><\\/p><p>3.2.11 若用户违反上述任一项规则，公司有权利删除用户发布的内容或封停违规用户账号。 <\\/p><p><br><\\/p><p>3.3用户不得利用“A3Mall商城”软件及相关服务制作、上载、复制、发布、传播如下干扰公司正常运营，以及侵犯其他用户或第三方合法权益的内容： <\\/p><p><br><\\/p><p>3.3.1 含有任何性或性暗示的； <\\/p><p><br><\\/p><p>3.3.2 含有辱骂、恐吓、威胁内容的； <\\/p><p><br><\\/p><p>3.3.3 含有骚扰、垃圾广告、恶意信息、诱骗信息的； <\\/p><p><br><\\/p><p>3.3.4 涉及他人隐私、个人信息或资料的； <\\/p><p><br><\\/p><p>3.3.5 侵害他人名誉权、肖像权、知识产权、商业秘密等合法权利的； <\\/p><p><br><\\/p><p>3.3.6 含有其他干扰“A3Mall商城”软件及相关服务正常运营和侵犯其他用户或第三方合法权益内容的信息。 <\\/p><p><br><\\/p><p>3.3.7 若用户违反上述任一项规则，公司有权利删除用户发布的内容或封停违规用户账号。 <\\/p><p><br><\\/p><p>四、使用规则 <\\/p><p><br><\\/p><p>4.1用户在“A3Mall商城”软件及相关服务中或通过“A3Mall商城”软件及相关服务所传送、发布的任何内容并不反映或代表，也不得被视为反映或代表公司的观点、立场或政策，公司对此不承担任何责任。 <\\/p><p><br><\\/p><p>4.2用户不得利用“A3Mall商城”软件及相关服务进行如下行为： <\\/p><p><br><\\/p><p>4.2.1 提交、发布虚假信息，或盗用他人头像或资料，冒充、利用他人名义的； <\\/p><p><br><\\/p><p>4.2.2 强制、诱导其他用户关注、点击链接页面或分享信息的； <\\/p><p><br><\\/p><p>4.2.3 虚构事实、隐瞒真相以误导、欺骗他人的； <\\/p><p><br><\\/p><p>4.2.4 利用技术手段批量建立虚假帐号的； <\\/p><p><br><\\/p><p>4.2.5 利用“A3Mall商城”软件及相关服务从事任何违法犯罪活动的； <\\/p><p><br><\\/p><p>4.2.6 制作、发布与以上行为相关的方法、工具，或对此类方法、工具进行运营或传播，无论这些行为是否为商业目的； <\\/p><p><br><\\/p><p>4.2.7 其他违反法律法规规定、侵犯其他用户合法权益、干扰公司正常运营或公司未明示授权的行为。 <\\/p><p><br><\\/p><p>4.2.8 若用户违反上述任一项规则，公司有权利封停违规用户账号。 <\\/p><p><br><\\/p><p>4.3用户须对利用“A3Mall商城”软件及相关服务传送信息的真实性、合法性、无害性、准确性、有效性等全权负责，与用户所传播的信息相关的任何法律责任由用户自行承担，与公司无关。如因此给公司或第三方造成任何损害的，用户应当依法予以全额赔偿。 <\\/p><p><br><\\/p><p>4.4公司提供的服务中可能包括广告，用户同意在使用过程中显示公司和第三方供应商、合作伙伴提供的广告。除法律法规明确规定外，用户应自行对依该广告信息进行的交易负责，对用户因依该广告信息进行的交易或前述广告商提供的内容而遭受的损失或损害，公司不承担任何责任。 <\\/p><p><br><\\/p><p>五、账号管理 <\\/p><p><br><\\/p><p>5.1用户有责任妥善保管注册帐号信息及帐号密码的安全，因用户保管不善可能导致遭受盗号或密码失窃，责任由用户自行承担。用户需要对注册帐号以及密码下的行为承担法律责任。用户同意在任何情况下不使用其他用户的帐号或密码。在用户怀疑他人使用其帐号或密码时，用户同意立即通知公司。 <\\/p><p><br><\\/p><p>5.2用户应遵守本协议的各项条款，正确、适当地使用”A3Mall商城”软件及相关服务，如因用户违反本协议中的任何条款，公司在通知用户后有权依据协议中断或终止对违约用户的用户帐号提供服务。同时，公司保留在任何时候收回”A3Mall商城”软件的用户账号、用户名的权利。 <\\/p><p><br><\\/p><p>5.3如用户注册”A3Mall商城”软件的用户账号后一年不登录或使用，公司在通知用户后，可以收回该帐号，以免造成资源浪费，由此造成的不利后果由用户自行承担。 <\\/p><p><br><\\/p><p>六、数据储存 <\\/p><p><br><\\/p><p>6.1公司不对用户在”A3Mall商城”软件及相关服务中相关数据的删除或储存失败负责。 <\\/p><p><br><\\/p><p>6.2公司可以根据实际情况自行决定用户在”A3Mall商城”软件及相关服务中数据的最长储存期限，并在服务器上为其分配数据最大存储空间等。用户可根据自己的需要自行备份”A3Mall商城”软件及相关服务中的相关数据。 <\\/p><p><br><\\/p><p>6.3如用户停止使用”A3Mall商城”软件及相关服务、或”A3Mall商城”软件及相关服务终止，公司可以从服务器上永久地删除用户的数据。”A3Mall商城”软件及相关服务停止、终止后，公司没有义务向用户返还任何数据。 <\\/p><p><br><\\/p><p>七、风险承担 <\\/p><p><br><\\/p><p>7.1用户理解并同意，公司仅为用户提供信息分享、传送及获取的平台，用户必须为自己注册的用户帐号下的一切行为负责，包括用户所传送的任何内容以及由此产生的任何后果。用户应对”A3Mall商城”软件及相关服务中的内容自行加以判断，并承担因使用内容而引起的所有风险，包括因对内容的正确性、完整性或实用性的依赖而产生的风险。公司无法且不会对因用户行为而导致的任何损失或损害承担责任。 <\\/p><p><br><\\/p><p>如果用户发现任何人违反本协议约定或以其他不当的方式使用”A3Mall商城”软件及相关服务，请立即向公司举报或投诉，公司将依本协议约定进行处理。 <\\/p><p><br><\\/p><p>7.2用户理解并同意，因业务发展需要，公司保留单方面对”A3Mall商城”软件及相关服务的全部或部分服务内容变更、暂停、终止或撤销的权利，用户需承担此风险。 <\\/p><p><br><\\/p><p>八、知识产权声明 <\\/p><p><br><\\/p><p>8.1公司在”A3Mall商城”软件及相关服务中提供的内容（包括但不限于软件、技术、程序、网页、文字、图片、图像、音频、视频、图表、版面、设计、电子文档等）的知识产权均归公司所有；公司提供”A3Mall商城”软件及相关服务时所依托软件的著作权、专利权及其他知识产权均归公司所有。未经公司许可，任何人不得擅自使用（包括但不限于通过任何机器人、蜘蛛等程序或设备监视、复制、传播、展示、镜像、上载、下载）“A3Mall商城”软件及相关服务中的内容。 <\\/p><p><br><\\/p><p>8.2用户确认并同意授权公司以公司自己的名义或委托专业第三方对侵犯用户上传发布的享有知识产权的内容进行代维权，维权形式包括但不限于：监测侵权行为、发送维权函、提起诉讼或仲裁、调解、和解等，公司有权对维权事宜做出决策并独立实施。 <\\/p><p><br><\\/p><p>8.4公司为“A3Mall商城”开发、运营提供技术支持，并对“A3Mall商城”软件及相关服务的开发和运营等过程中产生的所有数据和信息等享有法律法规允许范围内的全部权利。 <\\/p><p><br><\\/p><p>8.5请用户在任何情况下都不要私自使用公司的包括但不限于“A3Mall商城”的任何商标、服务标记、商号、域名、网站名称或其他显著品牌特征等（以下统称为“标识”）。未经公司事先书面同意，用户不得将本条款前述标识以单独或结合任何方式展示、使用或申请注册商标、进行域名注册等，也不得实施向他人明示或暗示有权展示、使用、或其他有权处理该些标识的行为。由于用户违反本协议使用公司上述商标、标识等给公司或他人造成损失的，由用户承担全部法律责任。 <\\/p><p><br><\\/p><p>8.6公司在”A3Mall商城”软件及相关服务中所涉及的图形、文字或其组成，以及其他A3Mall商城标志及产品、服务名称（以下统称“A3Mall商城标识”），其著作权或商标权归公司所有。未经公司事先书面同意，用户不得将A3Mall商城标识以任何方式展示或使用或作其他处理，也不得向他人表明用户有权展示、使用、或其他有权处理A3Mall商城标识的行为。 <\\/p><p><br><\\/p><p>8.7上述及其他任何公司或相关广告商依法拥有的知识产权均受到法律保护，未经公司或相关广告商书面许可，用户不得以任何形式进行使用或创造相关衍生作品。 <\\/p><p><br><\\/p><p>九、法律责任 <\\/p><p><br><\\/p><p>9.1如果公司发现或收到他人举报或投诉用户违反本协议约定的，公司有权不经通知随时对相关内容，包括但不限于用户资料、聊天记录进行审查、删除，并视情节轻重对违规帐号处以包括但不限于警告、帐号封禁、设备封禁 、功能封禁的处罚，且通知用户处理结果。 <\\/p><p><br><\\/p><p>9.2用户理解并同意，公司有权依合理判断对违反有关法律法规或本协议规定的行为进行处罚，对违法违规的任何用户采取适当的法律行动，并依据法律法规保存有关信息向有关部门报告等，用户应承担由此而产生的一切法律责任。 <\\/p><p><br><\\/p><p>9.3用户理解并同意，因用户违反本协议约定，导致或产生的任何第三方主张的任何索赔、要求或损失，包括合理的律师费，用户应当赔偿公司与合作公司、关联公司，并使之免受损害。 <\\/p><p><br><\\/p><p>十、不可抗力及其他免责事由 <\\/p><p><br><\\/p><p>10.1用户理解并确认，在使用”A3Mall商城”软件及相关服务的过程中，可能会遇到不可抗力等风险因素，致使”A3Mall商城”软件及相关服务发生中断。不可抗力是指不能预见、不能克服并不能避免且对一方或双方造成重大影响的客观事件，包括但不限于自然灾害如洪水、地震、瘟疫流行和风暴等以及社会事件如战争、动乱、政府行为等。出现上述情况时，公司将努力在第一时间与合作单位配合，及时进行修复，但是由此给用户或第三方造成的损失，公司及合作单位在法律允许的范围内免责。 <\\/p><p><br><\\/p><p>10.2”A3Mall商城”软件及相关服务同大多数互联网服务一样，受包括但不限于用户原因、网络服务质量、社会环境等因素的差异影响，可能受到各种安全问题的侵扰，如他人利用用户的资料，造成现实生活中的骚扰；用户下载安装的其它软件或访问的其他网站中含有“木马”等病毒，威胁到用户的计算机信息和数据的安全，继而影响”A3Mall商城”软件及相关服务的正常使用等等。用户应加强信息安全及使用者资料的保护意识，要注意加强密码保护，以免遭致损失和骚扰。 <\\/p><p><br><\\/p><p>10.3用户理解并确认，”A3Mall商城”软件及相关服务存在因不可抗力、计算机病毒或黑客攻击、系统不稳定、用户所在位置、用户关机以及其他任何技术、互联网络、通信线路原因等造成的服务中断或不能满足用户要求的风险，因此导致的用户或第三方的任何损失，公司不承担任何责任。 <\\/p><p><br><\\/p><p>10.4用户理解并确认，在使用”A3Mall商城”软件及相关服务过程中存在来自任何他人的包括误导性的、欺骗性的、威胁性的、诽谤性的、令人反感的或非法的信息，或侵犯他人权利的匿名或冒名的信息，以及伴随该等信息的行为，因此导致的用户或第三方的任何损失，公司不承担任何责任。 <\\/p><p><br><\\/p><p>10.5用户理解并确认，公司需要定期或不定期地对A3Mall商城平台或相关的设备进行检修或者维护，如因此类情况而造成服务在合理时间内的中断，公司无需为此承担任何责任，但公司应事先进行通告。 <\\/p><p><br><\\/p><p>10.6公司依据法律法规、本协议约定获得处理违法违规或违约内容的权利，该权利不构成”A3Mall商城”软件及相关服务的义务或承诺，公司不能保证及时发现违法违规或违约行为或进行相应处理。 <\\/p><p><br><\\/p><p>10.7用户理解并确认，对于公司向用户提供的下列产品或者服务的质量缺陷及其引发的任何损失，公司无需承担任何责任： <\\/p><p><br><\\/p><p>10.7.1 公司向用户免费提供的服务； <\\/p><p><br><\\/p><p>10.7.2 公司向用户赠送的任何产品或者服务。 <\\/p><p><br><\\/p><p>10.8在任何情况下，公司均不对任何间接性、后果性、惩罚性、偶然性、特殊性或刑罚性的损害，包括因用户使用”A3Mall商城”软件及相关服务而遭受的利润损失，承担责任（即使A3Mall商城已被告知该等损失的可能性亦然）。尽管本协议中可能含有相悖的规定，公司对用户承担的全部责任，无论因何原因或何种行为方式，始终不超过用户因使用公司提供的服务而支付给公司的费用(如有)。 <\\/p><p><br><\\/p><p>十一、服务的变更、中断、终止 <\\/p><p><br><\\/p><p>11.1鉴于网络服务的特殊性，用户同意公司有权随时变更、中断或终止部分或全部的服务（包括收费服务）。公司变更、中断或终止的服务，公司应当在变更、中断或终止之前通知用户，并应向受影响的用户提供等值的替代性的服务；如用户不愿意接受替代性的服务，如果该用户已经向公司支付任何费用，公司应当按照该用户实际使用服务的情况扣除相应的费用之后将剩余费用退还该用户的用户账户中。 <\\/p><p><br><\\/p><p>11.2如发生下列任何一种情形，公司有权变更、中断或终止向用户提供的免费服务或收费服务，而无需对用户或任何第三方承担任何责任： <\\/p><p><br><\\/p><p>11.2.1 根据法律规定用户应提交真实信息，而用户提供的个人资料不真实、或与注册时信息不一致又未能提供合理证明； <\\/p><p><br><\\/p><p>11.2.2用户违反相关法律法规或本协议的约定； <\\/p><p><br><\\/p><p>11.2.3 按照法律规定或有权机关的要求； <\\/p><p><br><\\/p><p>11.2.4 出于安全的原因或其他必要的情形。 <\\/p><p><br><\\/p><p>十二、其他 <\\/p><p><br><\\/p><p>12.1本协议的效力、解释及纠纷的解决，适用于中华人民共和国法律。若本协议之任何规定因与中华人民共和国的法律抵触而无效或不可执行，则这些条款将尽可能按照接近本协议原条文意旨重新解析，且本协议其它规定仍应具有完整的效力及效果。 <\\/p><p><br><\\/p><p>12.2若用户因本协议与公司发生任何争议或纠纷，双方应尽量友好协商解决；如协商不成的，用户同意应将相关争议提交提交公司所在地有管辖权的人民法院管辖。 <\\/p><p><br><\\/p><p>12.3为给用户提供更好的服务或国家法律法规、政策调整，”A3Mall商城”软件及相关服务将不时更新与变化，公司会适时对本协议进行修订，这些修订构成本协议的一部分。本协议更新后，公司会在“A3Mall商城”软件发出更新版本，以便用户及时了解本协议的最新版本。如用户继续使用“A3Mall商城”软件及相关服务，表示同意接受修订后的本协议的内容。如用户对修改后的协议条款存有异议的，请立即停止登录或使用“A3Mall商城”软件及相关服务。若用户继续登录或使用“A3Mall商城”软件及相关服务，即视为用户认可并接受修改后的协议条款。 <\\/p><p><br><\\/p><p>12.4本协议的任何条款无论因何种原因无效或不具可执行性，其余条款仍有效，对双方具有约束力。 <\\/p><p><br><\\/p><p>12.5本协议中的标题仅为方便及阅读而设，并不影响本协议中任何规定的含义或解释。 <\\/p><p><br><\\/p><p>12.6用户和公司均是独立的主体，在任何情况下本协议不构成公司对用户的任何形式的明示或暗示担保或条件，双方之间亦不构成代理、合伙、合营或雇佣关系。 <\\/p><p><br><\\/p>\"}'),
(7, 'privacy', '{\"title\":\"隐私协议\",\"content\":\"<p>更新日期： 2024年01月15日<\\/p><p><br><\\/p><p>生效日期： 2024年01月25日<\\/p><p><br><\\/p><p> <\\/p><p>公司深知个人信息对于用户的重要性，公司将按照法律法规的规定，尽力保护用户的个人信息及隐私安全。 希望用户在使用“A3Mall商城”软件及相关服务前仔细阅读并确认用户已经充分理解本条款即用户隐私政策（以下简称“隐私政策”）所写明的内容，并让用户可以按照隐私政策的指引做出用户认为适当的选择。 <\\/p><p><br><\\/p><p>隐私政策适用于用户通过公司应用程序、网页、供第三方网站和应用程序使用的A3Mall商城软件开发工具包（SDK）和应用程序编程接口（API）方式来访问和使用“A3Mall商城”软件及相关服务。 当用户使用或开启相关功能或使用服务时，为实现功能、服务所必需，公司会收集、使用相关权限或信息。 除非是为实现基本业务功能或根据法律法规要求的必要信息，用户均可以拒绝提供且不影响其他功能或服务。 公司将在隐私政策中逐项说明哪些是必要信息。 如果用户未登录用户帐号，公司会通过设备对应的标识符信息来保障信息推送的基本功能。 如果用户登录了账号，公司会根据账号信息实现信息推送。 摄像头、麦克风、通讯录权限等，均不会默认开启，只有经过用户的明示授权才会在为实现特定功能或服务时使用，用户也可以撤回授权。 特别需要指出的是，即使经过用户的授权，公司获得了这些敏感权限，也不会在相关功能或服务不需要时而收集用户的信息。 <\\/p><p><br><\\/p><p>以下公司将向用户详细介绍公司是如何收集、使用、存储、传输、共享、转让（如适用）与保护个人信息； 如何为用户了解查询、访问、删除、更正、撤回授权个人信息的方式。 其中，公司对有关用户个人信息权益的重要内容也清晰展示，请特别关注。 <\\/p><p><br><\\/p><p>公司如何收集和使用个人信息 <\\/p><p><br><\\/p><p>对 Cookie 和同类技术的使用 <\\/p><p><br><\\/p><p>公司如何共享、转让、公开披露个人信息 <\\/p><p><br><\\/p><p>公司如何存储个人信息 <\\/p><p><br><\\/p><p>公司如何保护个人信息的安全 <\\/p><p><br><\\/p><p>管理用户的个人信息 <\\/p><p><br><\\/p><p>未成年人条款 <\\/p><p><br><\\/p><p>隐私政策的修订和通知 <\\/p><p><br><\\/p><p>联系公司 <\\/p><p><br><\\/p><p>一、公司如何收集和使用个人信息 <\\/p><p><br><\\/p><p>公司会按照如下方式收集用户在使用服务时主动提供的，以及通过自动化手段收集用户在使用功能或接受服务过程中产生的信息： <\\/p><p><br><\\/p><p>1.1 注册、登录、认证 <\\/p><p><br><\\/p><p>1.1.1 当用户使用“A3Mall商城”软件及相关服务时，用户可以通过微信号、手机号来创建用户账号，并且用户可以完善相关的网络身份识别信息（头像、昵称、密码等），收集这些信息是为了帮助用户完成注册。 用户还可以根据自身需求选择填写性别、生日、地区及个人介绍填写完善用户的信息。 <\\/p><p><br><\\/p><p>1.1.2 用户也可以使用第三方账号登录并使用，用户将授权公司获取用户在第三方平台注册的公开信息（头像、昵称以及用户授权的其他信息），用于与“A3Mall商城“软件及相关服务的用户账号绑定，使用户可以直接登录并使用本产品和相关服务。 <\\/p><p><br><\\/p><p>1.1.3 在用户使用身份认证的功能或服务时，根据相关法律法规，用户可能需要提供用户的真实身份信息（包括但不限于真实姓名、身份证号码及电话号码等）以完成实名验证。 这些信息属于个人敏感信息，用户可以拒绝提供，但用户将可能无法获得相关服务，但不影响其他功能与服务的正常使用。 <\\/p><p><br><\\/p><p>1.2 关于商城 <\\/p><p><br><\\/p><p>1.2.2公司可能会向用户推荐更感兴趣的商品，为实现这一功能，公司可能会收集必要的日志信息，包括： <\\/p><p><br><\\/p><p>（1）用户操作、使用的行为信息： 点击、收藏、标记、搜索、浏览、分享； <\\/p><p><br><\\/p><p>（2）用户主动提供的信息： 反馈、点赞、评论； <\\/p><p><br><\\/p><p>（3）地理位置信息：GPS信息、WLAN接入点、蓝牙和基站等传感器信息。 <\\/p><p><br><\\/p><p>1.2.3公司收集、使用的上述信息进行了去标识化处理，数据分析仅对应特定的、无法直接关联用户身份的编码，不会与用户的真实身份相关联。 <\\/p><p><br><\\/p><p>1.2.4 公司为向用户提供“A3Mall商城”软件及相关服务中的商品、服务、奖品、奖励金，将向用户收集必要的相关用户个人信息，包括但不限于姓名、联系电话、微信号、订单信息、支付状态信息。 如果缺少相关信息，公司将无法为用户提供前述商品、服务、奖品、奖励金。 <\\/p><p><br><\\/p><p>1.2.5 如用户在”A3Mall商城”的软件及相关服务中其他用户可见的公开区域内上传或发布的信息中、用户对其他人上传或发布的信息作出的回应中公开用户的信息，该等信息可能会被他人收集并加以使用。 当用户发现他人不正当地收集或使用用户的信息时，可通过隐私政策中的“联系公司”条款所列的反馈渠道联系公司。 <\\/p><p><br><\\/p><p>1.3 信息发布和产品分享 <\\/p><p><br><\\/p><p>1.3.1用户发布评论时，公司将收集用户发布的信息，并展示用户的昵称、头像、发布内容。 <\\/p><p><br><\\/p><p>1.3.2 ”A3Mall商城”软件及相关服务中部分单项服务可能需要用户在用户的设备中开启特定的访问权限（例如用户的位置信息 、摄像头、相册、麦克风、发送短信、通讯录及\\/或日历、振动、红点标记提醒等），以实现这些权限所涉及信息的收集和使用。 用户如果拒绝授权提供，将无法使用此功能，但不影响用户正常使用”A3Mall商城”软件及相关服务的其他功能。 <\\/p><p><br><\\/p><p>1.3.3 用户因使用“A3Mall商城”软件及相关服务而被公司收集的信息，例如其他用户发布的信息中可能含有用户的部分信息（如： 在评论、留言、发布等涉及到与用户相关的信息）。 <\\/p><p><br><\\/p><p>1.3.4当用户将“A3Mall商城”软件及相关服务分享给用户的好友，涉及到使用群发邀请功能时，公司需要获取用户的联系人权限，通过调用通讯录权限完成群发，但是该权限不会默认打开，并且必须在用户授权同意下才会获取或调用。 <\\/p><p><br><\\/p><p>1.4 搜索 <\\/p><p><br><\\/p><p>用户使用公司的搜索服务时，公司会收集用户的搜索关键字信息、日志记录。 为了提供高效的搜索服务，部分前述信息会暂时存储在用户的本地存储设备之中，并可向用户展示搜索结果内容、搜索历史记录。 <\\/p><p><br><\\/p><p>1.5 安全运行 <\\/p><p><br><\\/p><p>1.5.1 安全保障功能 <\\/p><p><br><\\/p><p>公司致力于为用户提供安全、可信的产品与使用环境，提供优质而可靠的服务是公司的核心目标。 为实现安全保障功能所收集的信息是必要信息。 <\\/p><p><br><\\/p><p>1.5.2 设备信息与日志信息 <\\/p><p><br><\\/p><p>(1) 为了保障软件与服务的安全运行，公司会收集用户的设备相关信息（包括但不限于硬件型号、客户端版本、操作系统版本号、国际移动设备识别码、唯一设备标识符、网络设备硬件地址、IP 地址、WLAN接入点、基站、软件版本号、网络接入方式、类型、状态、网络质量数据、操作、使用、服务日志、设备开启、设备唤醒），设备所在位置相关信息（包括但不限于GPS位置以及能够提供相关信息的WLAN接入点、蓝牙和基站传感器信息）。 <\\/p><p><br><\\/p><p>(2) 为了预防恶意程序及安全运营所必需，公司可能会收集手机内安装的应用信息或正在运行的进程信息、应用程序的总体运行、使用情况与频率、应用崩溃情况、总体安装使用情况、性能数据或应用来源。 <\\/p><p><br><\\/p><p>(3) 公司以及公司的关联公司、合作方在获得用户授权的前提下，可能使用用户的账户信息、设备信息、服务日志信息或依法可以共享的信息，用于判断账户安全、进行身份验证、检测及防范安全事件。 <\\/p><p><br><\\/p><p>1.6 其他 <\\/p><p><br><\\/p><p>1.6.1 当用户使用公司的增值服务以提升用户体验时，公司可能会留存用户的充值或购买记录，以确保相关交易的可追溯性和安全性； 但是，公司不会因此而收集或存储用户的银行卡信息或身份认证信息。 <\\/p><p><br><\\/p><p>1.6.2 当用户与公司联系时，公司可能会保存用户的通信\\/通话记录和内容或用户留下的联系方式等信息，以便与用户联系或帮助用户解决问题，或记录相关问题的处理方案及结果。 <\\/p><p><br><\\/p><p>1.6.3 “A3Mall商城”软件需要在有网络的情况下进行使用，若当前无法连接网络，软件将尝试通过断开WLAN网络，然后重连的方式恢复软件使用。 <\\/p><p><br><\\/p><p>1.7 收集、使用个人信息目的变更 <\\/p><p><br><\\/p><p>请用户了解，随着公司业务的发展，可能会对“A3Mall商城“软件的功能和提供的服务有所调整变化。 原则上，当“A3Mall商城“软件的新功能或服务与公司当前提供的功能或服务相关时，收集与使用的个人信息将与原处理目的具有直接或合理关联。 在与原处理目的无直接或合理关联的场景下，公司收集、使用用户的个人信息，会再次进行告知，并征得用户的同意。 <\\/p><p><br><\\/p><p>1.8依法豁免征得同意收集和使用的个人信息 <\\/p><p><br><\\/p><p>请用户理解，在下列情形中，根据法律法规及相关国家标准，公司收集和使用用户的个人信息无需征得用户的授权同意： <\\/p><p><br><\\/p><p>1.8.1与国家安全、国防安全直接相关的； <\\/p><p><br><\\/p><p>1.8.2与公共安全、公共卫生、重大公共利益直接相关的； <\\/p><p><br><\\/p><p>1.8.3与犯罪侦查、起诉、审判和判决执行等直接相关的； <\\/p><p><br><\\/p><p>1.8.4出于维护个人信息主体或其他个人的生命、财产等重大合法权益但又很难得到本人同意的； <\\/p><p><br><\\/p><p>1.8.5所收集的用户的个人信息是用户自行向社会公众公开的； <\\/p><p><br><\\/p><p>1.8.6从合法公开披露的信息中收集的用户的个人信息的，如合法的新闻报道、政府信息公开等渠道； <\\/p><p><br><\\/p><p>1.8.7根据用户的要求签订或履行合同所必需的； <\\/p><p><br><\\/p><p>1.8.8用于维护软件及相关服务的安全稳定运行所必需的，例如发现、处置软件及相关服务的故障； <\\/p><p><br><\\/p><p>1.8.9为合法的新闻报道所必需的； <\\/p><p><br><\\/p><p>1.8.10学术研究机构基于公共利益开展统计或学术研究所必要，且对外提供学术研究或描述的结果时，对结果中所包含的个人信息进行去标识化处理的； <\\/p><p><br><\\/p><p>1.8.11法律法规规定的其他情形。 <\\/p><p><br><\\/p><p>特别提示用户注意，如信息无法单独或结合其他信息识别到用户的个人身份，其不属于法律意义上用户的个人信息； 当用户的信息可以单独或结合其他信息识别到用户的个人身份时或公司将无法与任何特定个人信息建立联系的数据与其他用户的个人信息结合使用时，这些信息在结合使用期间，将作为用户的个人信息按照隐私政策处理与保护。 <\\/p><p><br><\\/p><p>二、对 Cookie 和同类技术的使用 <\\/p><p><br><\\/p><p>Cookie 和同类技术是互联网中普遍使用的技术。 当用户使用”A3Mall商城”软件及相关服务时，公司可能会使用相关技术向用户的设备发送一个或多个 Cookie 或匿名标识符，以收集和存储用户访问、使用本产品时的信息。 公司承诺，不会将 Cookie 用于隐私政策所述目的之外的任何其他用途。 公司使用 Cookie 和同类技术主要为了实现以下功能或服务： <\\/p><p><br><\\/p><p>2.1 保障产品与服务的安全、高效运转 <\\/p><p><br><\\/p><p>公司可能会设置认证与保障安全性的 Cookie 或匿名标识符，使公司确认用户是否安全登录服务，或者是否遇到盗用、欺诈及其他不法行为。 这些技术还会帮助公司改进服务效率，提升登录和响应速度。 <\\/p><p><br><\\/p><p>2.2 帮助用户获得更轻松的访问体验 <\\/p><p><br><\\/p><p>使用此类技术可以帮助用户省去重复用户填写个人信息、输入搜索内容的步骤和流程（示例： 记录搜索）。 <\\/p><p><br><\\/p><p>2.3为用户推荐、展示、推送用户可能感兴趣的内容 <\\/p><p><br><\\/p><p>2.3.1公司可能会利用 Cookie 和同类技术了解用户的偏好和使用习惯，进行数据分析，以改善产品服务、推荐用户感兴趣的信息或功能，并优化用户对广告的选择。 <\\/p><p><br><\\/p><p>2.3.1在“A3Mall商城”软件的分享页中，公司可能会使用cookie对浏览活动进行记录，用于向用户推荐信息和排查崩溃、延迟的相关异常情况以及探索更好的服务方式。 <\\/p><p><br><\\/p><p>2.4 Cookie的清除 <\\/p><p><br><\\/p><p>大多数浏览器均为用户提供了清除浏览器缓存数据的功能，用户可以在浏览器设置功能中进行相应的数据清除操作； 对于“A3Mall商城”软件，如需清除Cookie，用户需要卸载“A3Mall商城”软件。 如用户进行清除，用户可能无法使用依赖于Cookie由公司提供的服务或相应功能。 <\\/p><p><br><\\/p><p>三、公司如何共享、转让、公开披露个人信息 <\\/p><p><br><\\/p><p>3.1共享 <\\/p><p><br><\\/p><p>3.1.1共享原则 <\\/p><p><br><\\/p><p>(1) 授权同意原则： 向公司的关联方或其他第三方共享用户的个人信息，需经过用户的授权同意，除非共享的个人信息是去标识化处理后的信息，且公司的关联方或其他第三方无法重新识别此类信息的自然人主体。 如果关联方或其他第三方使用信息的目的超越原授权同意范围，他们需要重新征得用户的同意。 <\\/p><p><br><\\/p><p>(2) 合法正当与最小必要原则： 向关联方或其他第三方共享的数据必须具有合法正当目的，且共享的数据以达成目的必要为限。 <\\/p><p><br><\\/p><p>(3) 安全审慎原则： 公司将审慎评估关联方或其他第三方数据使用共享信息的目的，对这些合作方的安全保障能力进行综合评估，并要求其遵循合作法律协议。 公司会对合作方获取信息的软件工具开发包（SDK）、应用程序接口（API）进行严格的安全监测，以保护数据安全。 <\\/p><p><br><\\/p><p>(4) 公司不会与公司的关联方或其他第三方共享用户的个人信息，但以下情况除外： <\\/p><p><br><\\/p><p>（a）在法律法规允许的范围内，为维护公司、公司的关联方或合作伙伴、用户或其他用户或社会公众利益、财产或安全免遭损害而有必要提供； <\\/p><p><br><\\/p><p>（b）应用户需求为用户处理用户与他人的纠纷或争议； <\\/p><p><br><\\/p><p>（c）基于学术研究而使用； <\\/p><p><br><\\/p><p>（d）基于符合法律法规的社会公共利益而使用。 <\\/p><p><br><\\/p><p>3.1.2 实现功能或服务的共享信息 <\\/p><p><br><\\/p><p>(1) 当用户在使用“A3Mall商城”软件中由公司的关联方或其他第三方提供的功能，或者当软件服务提供商、智能设备提供商、系统服务提供商与公司联合为用户提供服务时公司会将去标识化后的个人信息与这些关联方或其他第三方共享，进行综合统计并通过算法做特征与偏好分析，形成间接人群画像，用以向用户进行推荐、展示或推送用户可能感兴趣的信息，或者推送更适合用户的特定功能、服务。 <\\/p><p><br><\\/p><p>(2) 支付及收款功能： 支付和收款功能由与公司合作的第三方支付机构向用户提供服务。 第三方支付机构可能需要收集用户的姓名、微信账号信息、银行卡类型及卡号、有效期及手机号码。 银行卡号、有效期及手机号码是个人敏感信息，这些信息是支付和收款功能所必需的信息，拒绝提供将导致用户无法使用该功能，但不影响其他功能的正常使用。 <\\/p><p><br><\\/p><p>3.1.3 实现安全与分析统计的共享信息 <\\/p><p><br><\\/p><p>（1）保障使用安全： 公司非常重视账号与服务安全，为保障用户和其他用户的用户帐号与财产安全，使用户和公司的正当合法权益免受不法侵害，公司和公司的关联公司或其他服务提供商可能会共享必要的设备、账号及日志信息。 <\\/p><p><br><\\/p><p>（2）分析产品使用情况： 为分析公司服务的使用情况，提升用户使用的体验，可能会与关联方或第三方共享产品使用情况（崩溃、闪退）的统计性数据，这些数据难以与其他信息结合识别用户的个人身份。 <\\/p><p><br><\\/p><p>（3）改进网站功能和服务： 我们使用Google Analytics，一项由谷歌公司（“谷歌”）提供的网页分析服务。Google Analytics使用信息记录程序（cookies）帮助我们分析用户对网站的使用以此来编辑网站活跃性报告并提供其他与网站活跃性和互联网应用相关的服务。 我们将用此等信息改进网站功能和服务。Google Analytics会收集第一方 Cookie、与设备\\/浏览器有关的数据、IP 地址以及用户在网站\\/应用中的活动，以衡量用户与使用 Google Analytics的网站和\\/或应用进行的互动情况并报告相关统计信息。 <\\/p><p><br><\\/p><p>3.1.4 帮助用户参加营销推广活动 <\\/p><p><br><\\/p><p>当用户选择参加公司、公司的关联方或其他第三方举办的有关营销活动时，可能需要用户提供姓名、通信地址、联系方式、微信账号、银行账号信息。 这些信息是敏感个人信息， 拒绝提供可能会影响用户参加相关活动，但不会影响其他功能。 只有经过用户的同意，公司才会将这些信息与公司的关联方或第三方共享，以保障用户在联合活动中获得体验一致的服务，或委托第三方及时向用户兑现奖励。 <\\/p><p><br><\\/p><p>3.2 转让 <\\/p><p><br><\\/p><p>3.2.1公司不会转让用户的个人信息给任何其他第三方，除非征得用户的明确同意。 <\\/p><p><br><\\/p><p>3.2.2随着公司业务的持续发展，公司将有可能进行合并、收购、资产转让，用户的个人信息有可能因此而被转移。 在发生前述变更时，公司将按照法律法规及不低于隐私政策所载明的安全标准要求继受方保护用户的个人信息，否则公司将要求继受方重新征得用户的授权同意。 <\\/p><p><br><\\/p><p>3.3 披露 <\\/p><p><br><\\/p><p>3.3.1 公司不会公开披露用户的信息，除非遵循国家法律法规规定或者获得用户的同意。 公司公开披露用户的个人信息会采用符合行业内标准的安全保护措施。 <\\/p><p><br><\\/p><p>3.3.2 对违规账号、欺诈行为进行处罚公告时，公司会披露相关账号的信息。 <\\/p><p><br><\\/p><p>3.3.3当用户授权游戏或小程序后，用户和好友的头像、昵称将会在排名及相关功能中展示。 <\\/p><p><br><\\/p><p>3.4 依法豁免征得同意共享、转让、公开披露的个人信息 <\\/p><p><br><\\/p><p>请用户理解，在下列情形中，根据法律法规及国家标准，公司共享、转让、公开披露用户的个人信息无需征得用户的授权同意： <\\/p><p><br><\\/p><p>3.4.1与国家安全、国防安全直接相关的； <\\/p><p><br><\\/p><p>3.4.2与公共安全、公共卫生、重大公共利益直接相关的； <\\/p><p><br><\\/p><p>3.4.3根据适用的法律法规、法律程序的要求、强制性的行政或司法要求所必须的情况进行提供的； <\\/p><p><br><\\/p><p>3.4.4 出于维护用户或其他个人的生命、财产等重大合法权益但又很难得到本人同意的； <\\/p><p><br><\\/p><p>3.4.5用户自行向社会公众公开或事先获得用户明确的同意或授权的个人信息； <\\/p><p><br><\\/p><p>3.4.6从合法公开披露的信息中收集个人信息的，如合法的新闻报道、政府信息公开等渠道； <\\/p><p><br><\\/p><p>3.4.7符合与用户签署的相关协议（包括在线签署的电子协议以及相应的平台规则）或其他的法律文件约定所提供。 <\\/p><p><br><\\/p><p>四、公司如何存储个人信息 <\\/p><p><br><\\/p><p>4.1 存储地点 <\\/p><p><br><\\/p><p>公司依照法律法规的规定，将在境内运营过程中收集和产生的用户的个人信息存储于中华人民共和国境内。 目前，公司不会将上述信息传输至境外，如果公司向境外传输，公司将会遵循相关国家规定或者征求用户的同意。 <\\/p><p><br><\\/p><p>4.2 存储期限 <\\/p><p><br><\\/p><p>公司仅在为提供“A3Mall商城”软件及服务之目的所必需的期间内保留用户的个人信息： 用户发布的信息、评论等相关信息，在用户未撤回、删除或未注销账号期间，公司会进行保留。 超出必要期限后，公司将对用户的个人信息进行删除或匿名化处理，但法律法规另有规定的除外。 <\\/p><p><br><\\/p><p>五、公司如何保护个人信息的安全 <\\/p><p><br><\\/p><p>5.1 公司非常重视用户个人信息的安全，将努力采取合理的安全措施（包括技术方面和管理方面）来保护用户的个人信息，防止用户提供的个人信息被不当使用或未经授权的情况下被访问、公开披露、使用、修改、损坏、丢失或泄漏。 <\\/p><p><br><\\/p><p>5.2公司会使用不低于行业同行的加密技术、匿名化处理及相关合理可行的手段保护用户的个人信息，并使用安全保护机制防止用户的个人信息遭到恶意攻击。 <\\/p><p><br><\\/p><p>5.3公司会建立专门的安全部门、安全管理制度、数据安全流程保障用户的个人信息安全。 公司采取严格的数据使用和访问制度，确保只有授权人员才可访问用户的个人信息，并适时对数据和技术进行安全审计。 <\\/p><p><br><\\/p><p>5.4 尽管已经采取了上述合理有效措施，并已经遵守了相关法律规定要求的标准，但请用户理解，由于技术的限制以及可能存在的各种恶意手段，在互联网行业，即便竭尽所能加强安全措施，也不可能始终保证信息百分之百的安全，公司将尽力确保用户提供给公司的个人信息的安全性。 <\\/p><p><br><\\/p><p>5.5用户知悉并理解，用户接入公司的服务所用的系统和通讯网络，有可能因公司可控范围外的因素而出现问题。 因此，公司强烈建议用户采取积极措施保护个人信息的安全，包括但不限于使用复杂密码、定期修改密码、不将用户帐号的密码及相关个人信息透露给他人。 <\\/p><p><br><\\/p><p>5.6公司会制定应急处理预案，并在发生用户信息安全事件时立即启动应急预案，努力阻止这些安全事件的影响和后果扩大。 一旦发生用户信息安全事件（泄露、丢失）后，公司将按照法律法规的要求，及时向用户告知： 安全事件的基本情况和可能的影响、公司已经采取或将要采取的处置措施、用户可自主防范和降低风险的建议、对用户的补救措施。 公司将及时将事件相关情况以推送通知、邮件、信函、短信及相关形式告知用户，难以逐一告知时，公司会采取合理、有效的方式发布公告。 同时，公司还将按照相关监管部门要求，上报用户信息安全事件的处置情况。 <\\/p><p><br><\\/p><p>5.7用户一旦离开“A3Mall商城”软件及相关服务，浏览或使用其他软件、服务及内容资源，公司将没有能力和直接义务保护用户在”A3Mall商城”软件及相关服务之外的软件、网站提交的任何个人信息，无论用户登录、浏览或使用上述软件、网站是否基于“A3Mall商城”软件的链接或引导。 <\\/p><p><br><\\/p><p>六、管理用户的个人信息 <\\/p><p><br><\\/p><p>公司非常重视用户对个人信息的管理，并尽全力保护用户对于用户个人信息的查询、访问、修改、删除、撤回同意授权、注销账号、投诉举报以及设置隐私功能的相关权利，以使用户有能力保障用户的隐私和信息安全。 <\\/p><p><br><\\/p><p>6.1 改变或撤回授权范围 <\\/p><p><br><\\/p><p>当用户需要在用户的设备中关闭特定的访问权限（例如用户的位置信息 、摄像头、相册、麦克风、通讯录及\\/或日历），大多数移动设备都会支持用户的这项需求，具体方法请参考或联系用户移动设备的服务商或生产商。 用户开启任一权限即代表用户授权公司可以收集和使用相关信息来为用户提供对应服务，用户一旦关闭任一权限即代表用户取消了授权，公司将不再基于对应权限继续收集和使用相关信息，也无法为用户提供该权限所对应的服务。 但是，用户关闭权限的决定不会影响此前基于用户的授权所进行的信息收集及使用。 <\\/p><p><br><\\/p><p>6.2 访问、删除、更正用户的个人信息 <\\/p><p><br><\\/p><p>6.2.1 访问和修改用户账号信息 <\\/p><p><br><\\/p><p>用户可以在”A3Mall商城”软件的“我的” —“设置”选项中访问和修改用户的头像、昵称、提醒设置等账号信息。 <\\/p><p><br><\\/p><p>6.2.2 查询、访问、更改或删除用户收藏、点赞、评论、搜索历史记录等 <\\/p><p><br><\\/p><p>6.3 注销账号 <\\/p><p><br><\\/p><p>如用户需要注销”A3Mall商城”的用户帐号，请通过“A3Mall商城”软件中 “我的”—“帮助与反馈”，进入用户反馈界面进行申请, 公司将安排相关工作人员协助用户操作。 在用户注销账号前，公司将验证用户的个人身份、安全状态、设备信息等。 用户知悉并理解，注销账号的行为是不可逆的行为，当用户注销账号后，公司将删除有关用户的相关信息或进行匿名化处理，但法律法规另有规定的除外。 <\\/p><p><br><\\/p><p>6.4 投诉举报 <\\/p><p><br><\\/p><p>用户可按照公司公示的制度进行投诉或举报。 如果用户认为用户的个人信息权利可能受到侵害，或者发现侵害个人信息权利的线索（例如： 认为公司收集用户的个人信息违反法律规定或者双方约定），用户可通过 “A3Mall商城”软件中 “我的”—“帮助与反馈”，进入用户反馈界面与公司联系。 公司核查后会及时反馈用户的投诉与举报。 <\\/p><p><br><\\/p><p>6.5 访问隐私政策 <\\/p><p><br><\\/p><p>6.5.1用户可以在注册登录页面查看隐私政策全部内容。 <\\/p><p><br><\\/p><p>6.5.2请用户了解，隐私政策中所述的“A3Mall商城”软件及相关服务可能会因用户所使用的手机型号、系统版本、软件应用程序版本、移动客户端等因素而有所不同。 最终的产品和服务以用户所使用的“A3Mall商城”软件及相关服务为准。 <\\/p><p><br><\\/p><p>6.6 停止运营向用户告知 <\\/p><p><br><\\/p><p>如公司停止运营，公司将及时停止收集用户个人信息的活动，将停止运营的通知以逐一送达或公告的形式通知用户，并对所持有的用户的个人信息进行删除或匿名化处理。 <\\/p><p><br><\\/p><p>七、未成年人条款 <\\/p><p><br><\\/p><p>7.1若用户是未满18周岁的未成年人，在使用”A3Mall商城”软件及相关服务前，应在用户的父母或其他监护人监护、指导下共同阅读并同意隐私政策。 <\\/p><p><br><\\/p><p>7.2公司根据国家相关法律法规的规定保护未成年人的个人信息，只会在法律允许、父母或其他监护人明确同意或保护未成年人所必要的情况下收集、使用、储存、共享、转让或披露未成年人的个人信息； 如果公司发现在未事先获得可证实的父母同意的情况下收集了未成年人的个人信息，则会设法尽快删除相关信息。 <\\/p><p><br><\\/p><p>7.3若用户是未成年人的监护人，当用户对用户所监护的未成年人的个人信息有相关疑问时，请通过公司隐私政策公示的联系方式与公司联系。 <\\/p><p><br><\\/p><p>八、隐私政策的修订和通知 <\\/p><p>8.1为了给用户提供更好的服务，”A3Mall商城”软件及相关服务将不时更新与变化，公司会适时对隐私政策进行修订，这些修订构成隐私政策的 <\\/p><p><br><\\/p><p><br><\\/p>\"}'),
(8, 'sms', '{\"type\":\"aliyun\",\"aliyun\":{\"accessKeyId\":\"\",\"accessKeySecret\":\"\",\"singName\":\"\"},\"tencent\":{\"accessKeyId\":\"a\",\"accessKeySecret\":\"b\",\"singName\":\"d\",\"appid\":\"c\"}}'),
(9, 'weixin', '{\"appid\":\"1\",\"appsecret\":\"2\"}'),
(10, 'wechat_menu', '[]'),
(11, 'keywords', '电脑|手机|平板'),
(12, 'goods', '{\"unit\":\"件,盒,包,套,瓶,双,只,付,个,尊,把,罐,辆,升,方,块\"}'),
(13, 'point', '{\"name\":\"积分\",\"describe\":\"a) 积分不可兑现、不可转让,仅可在本平台使用;\\nb) 您在本平台参加特定活动也可使用积分,详细使用规则以具体活动时的规则为准;\\nc) 积分的数值精确到个位(小数点后全部舍弃,不进行四舍五入)\\nd) 买家在完成该笔交易(订单状态为“已签收”)后才能得到此笔交易的相应积分,如购买商品参加店铺其他优惠,则优惠的金额部分不享受积分获取;\",\"is_gift\":\"0\",\"gift_point\":\"100\",\"is_shopping\":\"0\",\"shopping_point\":\"100\",\"discount\":\"10\"}'),
(14, 'second', '[{\"open_time\":0,\"duration\":6},{\"open_time\":8,\"duration\":2},{\"open_time\":10,\"duration\":2},{\"open_time\":12,\"duration\":2},{\"open_time\":14,\"duration\":4},{\"open_time\":18,\"duration\":2},{\"open_time\":21,\"duration\":3}]'),
(15, 'recharge', '{\"order_amount\":0,\"status\":1,\"content\":\"<p>1. 账户充值仅限在线方式支付，充值金额实时到账；<\\/p><p>2. 账户充值套餐赠送的金额即时到账；<\\/p><p>3. 账户余额有效期：自充值日起至用完即止；<\\/p><p>4. 若有其它疑问，可拨打客服电话400-000-0000<\\/p>\",\"list\":[{\"order_amount\":50,\"price\":5},{\"order_amount\":100,\"price\":0},{\"order_amount\":1000,\"price\":0}],\"is_custom\":1}'),
(16, 'app', '{\"android\":\"\",\"ios\":\"\"}'),
(17, 'delivery', '{\"type\":\"aliyun\",\"aliyun\":{\"AppKey\":1,\"AppSecret\":2,\"AppCode\":3}}'),
(18, 'copy', '{\"webname\":\"A3SHOP\",\"username\":\"森子\",\"mobile\":18026740326,\"phone\":6606018,\"address\":\"源城区6号\",\"copyright\":\"asdfasdf\"}'),
(19, 'website', '{\"webname\":\"A3 MALL\",\"username\":\"森子\",\"mobile\":18026740326,\"phone\":\"\",\"address\":\"源城区6号\",\"copyright\":\"© Copyright 2020-2024  揭阳市数循通云科技 All Rights Reserved\"}'),
(20, 'order', '{\"order\":{\"cancel_time\":12,\"complete_time\":15,\"confirm_time\":10},\"cancel_time\":1,\"complete_time\":15,\"confirm_time\":10}'),
(21, 'customer', '{\"qrcode\":\"\\/uploads\\/images\\/20240320\\/bf79b1130fc76134eac97ee0fffb47ff.png\",\"name\":\"A3Mall\",\"time\":\"9:00 - 21:00\",\"content\":\"\",\"status\":1}'),
(22, 'socket', '{\"port\":2345,\"cert_path\":\"\",\"key_path\":\"\",\"ssl\":0}'),
(23, 'collection', '{\"keys\":\"\"}'),
(24, 'withdrawal', '{\"status\":1,\"amount\":100,\"commission\":5,\"content\":\"1. 单次提现金额最低100元。\\n2. 提现申请后将审核后到账，到账结果请查收对应渠道服务通知。\\n3. 如有疑问请及时联系客服。\"}'),
(25, 'printer', '{\"type\":\"xpyun\",\"xpyun\":{\"user\":\"111105289@qq.com\",\"secret_key\":\"ae18b6414bb18b02b77d72fd5694fa47\",\"device_id\":\"R1E31AB74WYA54B\",\"device_name\":\"北源小店打印机\"}}');

CREATE TABLE `mall_crontab` (
  `id` int(10) UNSIGNED NOT NULL COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '事件标题',
  `class` varchar(128) NOT NULL DEFAULT '' COMMENT '类',
  `method` varchar(128) NOT NULL DEFAULT '' COMMENT '方法',
  `schedule` varchar(100) NOT NULL DEFAULT '' COMMENT 'Crontab格式',
  `sleep` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '延迟秒数执行',
  `maximums` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '最大执行次数 0为不限',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:运行中 2:已完成 3:运行失败)',
  `executes` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '已经执行的次数',
  `expire_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '日期类型(1:无限制 2:固定时间)',
  `start_time` int(10) DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) DEFAULT '0' COMMENT '结束时间',
  `execute_time` int(10) DEFAULT '0' COMMENT '最后执行时间',
  `create_time` int(10) DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='定时任务表';

INSERT INTO `mall_crontab` (`id`, `title`, `class`, `method`, `schedule`, `sleep`, `maximums`, `status`, `executes`, `expire_type`, `start_time`, `end_time`, `execute_time`, `create_time`, `update_time`) VALUES
(1, '自动取消超时未付款订单', 'Order', 'cancel', '* * * * *', 0, 0, 1, 0, 1, 0, 0, 0, 0, 0),
(2, '订单自动超时自动收货', 'Order', 'delivery', '* * * * *', 0, 0, 1, 0, 1, 0, 0, 0, 0, 0),
(3, '未评价订单自动完成', 'Order', 'completed', '* * * * *', 0, 0, 1, 0, 1, 0, 0, 0, 0, 0),
(4, '自动清理购物车', 'Cart', 'clear', '* * * * *', 0, 0, 1, 0, 1, 0, 0, 0, 0, 0);

CREATE TABLE `mall_crontab_log` (
  `id` bigint(10) UNSIGNED NOT NULL,
  `pid` bigint(10) DEFAULT '0' COMMENT '任务ID',
  `content` text COMMENT '执行结果',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1:完成 2:失败)',
  `execute_time` int(10) NOT NULL DEFAULT '0' COMMENT '执行时间',
  `complete_time` bigint(10) NOT NULL DEFAULT '0' COMMENT '结束时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='定时任务日志表';

CREATE TABLE `mall_goods` (
  `id` bigint(20) UNSIGNED NOT NULL COMMENT '商品ID',
  `cat_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '分类id',
  `brand_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '品牌ID',
  `delivery_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '配送方式',
  `sku_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1:单规格 2:多规格',
  `fixed_freight` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '固定运费',
  `title` varchar(255) NOT NULL COMMENT '商品名称',
  `goods_number` varchar(255) NOT NULL DEFAULT '' COMMENT '商品货号',
  `goods_weight` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '重量',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `market_price` decimal(15,2) DEFAULT '0.00' COMMENT '市场价格',
  `cost_price` decimal(15,2) DEFAULT '0.00' COMMENT '成本价格',
  `store_nums` bigint(20) NOT NULL DEFAULT '0' COMMENT '库存',
  `unit` varchar(20) NOT NULL DEFAULT '' COMMENT '商品单位',
  `photo` varchar(255) DEFAULT '' COMMENT '封面图',
  `briefly` text COMMENT '简要',
  `content` longtext COMMENT '商品描述',
  `point` bigint(20) NOT NULL DEFAULT '0' COMMENT '积分',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态(0:上架 1:下架)',
  `visit` bigint(20) NOT NULL DEFAULT '0' COMMENT '浏览次数',
  `visit_init` bigint(20) NOT NULL DEFAULT '0' COMMENT '虚拟浏览',
  `favorite` bigint(20) NOT NULL DEFAULT '0' COMMENT '收藏次数',
  `sort` smallint(5) NOT NULL DEFAULT '99' COMMENT '排序',
  `exp` bigint(20) NOT NULL DEFAULT '0' COMMENT '经验值',
  `sale` bigint(20) NOT NULL DEFAULT '0' COMMENT '销量',
  `sale_init` bigint(20) NOT NULL DEFAULT '0' COMMENT '初始销量',
  `grade` bigint(20) NOT NULL DEFAULT '0' COMMENT '评分总数 ',
  `upper_time` int(10) DEFAULT '0' COMMENT '上架时间',
  `down_time` int(10) DEFAULT '0' COMMENT '下架时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品信息表';

CREATE TABLE `mall_goods_attribute` (
  `id` bigint(20) NOT NULL,
  `goods_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `name` varchar(64) NOT NULL COMMENT '名称',
  `value` longtext,
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品属性表';

CREATE TABLE `mall_goods_brand` (
  `id` bigint(20) UNSIGNED NOT NULL COMMENT '品牌ID',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `photo` varchar(255) DEFAULT '' COMMENT 'logo',
  `url` varchar(255) DEFAULT '' COMMENT '网址',
  `intro` text COMMENT '描述',
  `content` longtext COMMENT '品牌介绍',
  `sort` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态 0显示',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品品牌表';

CREATE TABLE `mall_goods_distribution` (
  `id` bigint(20) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '费用类型 0统一设置 1指定地区费用',
  `title` varchar(128) DEFAULT '' COMMENT '快递名称',
  `area_group` text COMMENT '配送区域id',
  `first_price_group` text COMMENT '配送地址对应的首重价格',
  `second_price_group` text COMMENT '配送地区对应的续重价格',
  `first_weight` bigint(20) NOT NULL DEFAULT '0' COMMENT '首重重量(克)',
  `second_weight` bigint(20) NOT NULL DEFAULT '0' COMMENT '续重重量(克)',
  `first_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '首重价格',
  `second_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '续重价格',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态(1:开启 0:关闭)',
  `is_lock` tinyint(1) NOT NULL DEFAULT '0' COMMENT '锁定(1:开启 0:关闭)',
  `sort` smallint(6) NOT NULL DEFAULT '99' COMMENT '排序',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品配送方式表';

CREATE TABLE `mall_goods_freight` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `type` varchar(255) NOT NULL COMMENT '货运类型',
  `code` varchar(255) NOT NULL DEFAULT '' COMMENT '快递编码',
  `title` varchar(255) NOT NULL COMMENT '货运公司名称',
  `url` varchar(255) NOT NULL COMMENT '网址',
  `photo` varchar(255) NOT NULL DEFAULT '' COMMENT '图标',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:启用 0:关闭)',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='货运公司';

INSERT INTO `mall_goods_freight` (`id`, `type`, `code`, `title`, `url`, `photo`, `status`, `create_time`) VALUES
(2, 'STO', 'shentong', '申通快递', 'http://www.sto.cn', '', 1, 1485851695),
(3, 'TTKDEX', 'tiantian', '天天快递', 'http://www.ttkd.cn', '', 1, 1485851695),
(4, 'YTO', 'yuantong', '圆通快递', 'http://www.yto.net.cn', '', 1, 1485851695),
(5, 'SFEXPRESS', 'shunfeng', '顺丰速运', 'http://www.sf-express.com', '', 1, 1485851695),
(6, 'YUNDA', 'yunda', '韵达快递', 'http://www.yundaex.com', '', 1, 1485851695),
(7, 'ZTO', 'zhongtong', '中通快递', 'http://www.zto.cn', '', 1, 1485851695),
(8, 'LBEX', 'longbanwuliu', '龙邦物流', 'http://www.lbex.com.cn', '', 1, 1485851695),
(9, 'ZJS', 'zhaijisong', '宅急送', 'http://www.zjs.com.cn', '', 1, 1485851695),
(11, 'HTKY', 'huitongkuaidi', '汇通快递', 'http://www.htky365.com', '', 1, 1485851695),
(12, 'CAE', 'minghangkuaidi', '民航快递', 'http://www.cae.com.cn', '', 1, 1485851695),
(13, 'CRE', 'zhongtiewuliu', '中铁快运', 'http://www.cre.cn', '', 1, 1485851695),
(16, 'DEPPON', 'debangwuliu', '德邦物流', 'http://www.deppon.com', '', 1, 1485851695);

CREATE TABLE `mall_goods_image` (
  `id` bigint(20) UNSIGNED NOT NULL COMMENT '主键ID',
  `goods_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0' COMMENT '商品ID',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '图片路径',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '创建时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品相册表';

CREATE TABLE `mall_goods_item` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `goods_id` bigint(20) UNSIGNED NOT NULL COMMENT '货品ID',
  `sku_id` text NOT NULL COMMENT 'sku唯一标识',
  `tags` varchar(32) NOT NULL DEFAULT '' COMMENT '标签',
  `spec_value` text NOT NULL COMMENT '规格值',
  `goods_number` varchar(255) NOT NULL DEFAULT '' COMMENT '货品的货号(以商品的货号加横线加数字组成)',
  `store_nums` bigint(20) NOT NULL DEFAULT '0' COMMENT '库存',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `goods_weight` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '重量',
  `thumb_image` varchar(255) NOT NULL DEFAULT '' COMMENT '规格图片'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='货品表';

CREATE TABLE `mall_goods_spec` (
  `id` bigint(20) NOT NULL,
  `goods_id` bigint(20) DEFAULT '0' COMMENT '商品ID',
  `name` varchar(64) NOT NULL COMMENT '名称',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品规格表';

CREATE TABLE `mall_goods_spec_relation` (
  `id` bigint(20) NOT NULL,
  `goods_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `spec_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '规格值ID',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品规格表';

CREATE TABLE `mall_goods_spec_value` (
  `id` bigint(20) NOT NULL,
  `goods_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `spec_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '父ID',
  `value` varchar(64) NOT NULL COMMENT '规格值',
  `thumb_image` varchar(255) NOT NULL DEFAULT '' COMMENT '规格图',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品规格表';

CREATE TABLE `mall_layout_page` (
  `id` int(11) NOT NULL,
  `type` varchar(128) NOT NULL DEFAULT '' COMMENT '页面类型',
  `page_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '添加类型（1: 系统页面 2: 用户添加）',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '页面名称',
  `photo` varchar(255) NOT NULL DEFAULT '' COMMENT '主题默认图',
  `intro` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `content` longtext COMMENT '主题配置',
  `setting` longtext COMMENT '全局设置',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（1：开启 0：关闭）',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='装修页面表';

INSERT INTO `mall_layout_page` (`id`, `type`, `page_type`, `name`, `photo`, `intro`, `content`, `setting`, `status`, `create_time`, `update_time`) VALUES
(1, 'home', 1, '首页', '', '', '', '{\"id\":100000,\"type\":\"global\",\"icon\":\"\",\"title\":\"全局设置\",\"value\":{\"list_style\":2,\"card_style\":1,\"chamfer_style\":1,\"spacing\":20,\"margin\":0,\"padding\":17,\"type\":2,\"page_background_color\":\"#f8f8f8\",\"background_color\":\"#f8f8f7\",\"status\":0,\"list\":[{\"name\":\"央视春晚主会场主持人阵容曝光\",\"image\":\"http:\\/\\/a3-cms.top:8888\\/uploads\\/images\\/20231125\\/4b74df516beec4cee556991c9eed3864.jpeg\",\"link\":{\"name\":\"央视春晚主会场主持人阵容曝光\",\"image\":\"http:\\/\\/a3-cms.top:8888\\/uploads\\/images\\/20231125\\/4b74df516beec4cee556991c9eed3864.jpeg\",\"path\":\"\\/pages\\/archives\\/view?id=2\",\"params\":{\"type\":\"archives\",\"id\":2}}},{\"name\":\"最新！梅西香港表演赛主办方：将撤回1600万港元政府资助的申请\",\"image\":\"http:\\/\\/a3-cms.top:8888\\/uploads\\/images\\/20231125\\/4b74df516beec4cee556991c9eed3864.jpeg\",\"link\":{\"name\":\"最新！梅西香港表演赛主办方：将撤回1600万港元政府资助的申请\",\"image\":\"http:\\/\\/a3-cms.top:8888\\/uploads\\/images\\/20231125\\/4b74df516beec4cee556991c9eed3864.jpeg\",\"path\":\"\\/pages\\/archives\\/view?id=1\",\"params\":{\"type\":\"archives\",\"id\":1}}}],\"limit\":10,\"group\":{\"id\":0,\"name\":\"\",\"link\":[]},\"layout_radius\":0,\"title\":\"标题\",\"title_color\":\"#333\",\"ctitle\":\"更多 >\",\"ctitle_link\":{\"id\":0,\"name\":\"\",\"link\":[]},\"ctitle_color\":\"#999\",\"is_title\":1,\"is_price\":1,\"is_button\":0}}', 1, 1690251214, 1720318255);

CREATE TABLE `mall_layout_setting` (
  `id` bigint(20) NOT NULL COMMENT '自增',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `content` longtext COMMENT '配置'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='主题配置';

INSERT INTO `mall_layout_setting` (`id`, `name`, `content`) VALUES
(1, 'color', '{\"id\":\"red-orange\",\"type\":0,\"options\":{\"backgroundColor\":\"#FF4500\",\"backgroundBgColor\":\"#F8F8F8\",\"borderColor\":\"#8C8C8C\",\"fontColor\":\"#8C8C8C\"},\"color\":\"#FF4500\",\"text\":\"红橙色\"}'),
(2, 'tabbar', '{\"color\":\"#333333\",\"selectedColor\":\"#FF4500\",\"borderStyle\":\"black\",\"backgroundColor\":\"#ffffff\",\"list\":[{\"image\":\"\\/static\\/mobile\\/tabbar\\/white\\/1.png\",\"selectedImage\":\"\\/static\\/mobile\\/tabbar\\/red-orange\\/1.png\",\"text\":\"首页\",\"status\":1,\"link\":\"pages\\/index\\/index\"},{\"image\":\"\\/static\\/mobile\\/tabbar\\/white\\/2.png\",\"selectedImage\":\"\\/static\\/mobile\\/tabbar\\/red-orange\\/2.png\",\"text\":\"分类\",\"status\":1,\"link\":\"pages\\/index\\/category\"},{\"image\":\"\\/static\\/mobile\\/tabbar\\/white\\/4.png\",\"selectedImage\":\"\\/static\\/mobile\\/tabbar\\/red-orange\\/4.png\",\"text\":\"购物车\",\"status\":1,\"link\":\"pages\\/index\\/cart\"},{\"image\":\"\\/static\\/mobile\\/tabbar\\/white\\/5.png\",\"selectedImage\":\"\\/static\\/mobile\\/tabbar\\/red-orange\\/5.png\",\"text\":\"我的\",\"status\":1,\"link\":\"pages\\/index\\/ucenter\"}],\"type\":1}'),
(3, 'site', '{\"image\":\"\\/static\\/images\\/common\\/empty.png\"}');

CREATE TABLE `mall_layout_template` (
  `id` bigint(20) NOT NULL,
  `name` varchar(50) NOT NULL COMMENT '名称',
  `photo` varchar(255) NOT NULL COMMENT '封面',
  `content` longtext NOT NULL COMMENT '内容',
  `setting` longtext,
  `author` varchar(64) NOT NULL DEFAULT '' COMMENT '作者',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '新增时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='主题模板表' ROW_FORMAT=DYNAMIC;

CREATE TABLE `mall_order` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '订单类型',
  `promoter_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '返现类型(1:普通订单 2:自购优惠 3:自购返佣 4:普通分销)',
  `order_no` varchar(255) NOT NULL DEFAULT '' COMMENT '订单号',
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0' COMMENT '用户ID',
  `promoter_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '活动商品ID',
  `pay_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '支付方式',
  `delivery_id` bigint(20) DEFAULT '0' COMMENT '配送方式',
  `status` tinyint(1) DEFAULT '1' COMMENT '订单状态(1:待确认 2:待支付 3:待发货 4:待收货 5:部分发货 6:交易完成 7:已取消 8:已关闭)',
  `pay_status` tinyint(1) DEFAULT '1' COMMENT '支付状态(1:待支付 2:已支付 3:已退款 4:部分退款)',
  `refund_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '退款状态(1:未退款 2:审批中 3:退款中 4:已退款)',
  `delivery_status` tinyint(1) DEFAULT '1' COMMENT '配送状态(1:未发货 2:已发货 3:部分发货)',
  `collect_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '收货状态(1:未收货 2:己收货)',
  `evaluate_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否评价(1:未评价 2:己评价 3:部份评价)',
  `express_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '物流公司ID',
  `express_name` varchar(64) NOT NULL DEFAULT '' COMMENT '物流公司名称',
  `express_no` varchar(255) NOT NULL DEFAULT '' COMMENT '物流单号',
  `message` varchar(255) DEFAULT '' COMMENT '用户附言',
  `note` text COMMENT '管理员备注',
  `remarks` text COMMENT '发货单备注',
  `coupon_amount` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '优惠券金额',
  `increase_amount` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '增加金额',
  `reduce_amount` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '减少金额',
  `discount` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '优惠金额',
  `real_freight` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '实付运费',
  `real_point` bigint(20) NOT NULL DEFAULT '0' COMMENT '积分支付',
  `real_amount` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '实付商品总金额',
  `payable_freight` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '总运费金额',
  `payable_amount` decimal(15,2) DEFAULT '0.00' COMMENT '应付商品总金额',
  `order_amount` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '订单总金额',
  `point` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '增加的积分',
  `trade_no` varchar(255) DEFAULT NULL COMMENT '支付平台交易号',
  `source` int(11) NOT NULL DEFAULT '0' COMMENT '订单来源',
  `is_delete` tinyint(1) DEFAULT '0' COMMENT '是否删除1为删除',
  `send_time` int(10) DEFAULT '0' COMMENT '发货时间',
  `accept_time` int(10) DEFAULT '0' COMMENT '用户收货时间',
  `evaluate_time` int(10) NOT NULL DEFAULT '0' COMMENT '用户评价时间',
  `pay_time` int(10) DEFAULT '0' COMMENT '付款时间',
  `create_time` int(10) DEFAULT '0' COMMENT '下单时间',
  `completion_time` int(10) DEFAULT '0' COMMENT '订单完成时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单表';

CREATE TABLE `mall_order_address` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `order_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `accept_name` varchar(20) NOT NULL DEFAULT '' COMMENT '收货人姓名',
  `zip` varchar(6) DEFAULT '' COMMENT '邮编',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机',
  `phone` varchar(20) DEFAULT '' COMMENT '联系电话',
  `country` varchar(32) DEFAULT '' COMMENT '国ID',
  `province` varchar(32) DEFAULT '' COMMENT '省ID',
  `city` varchar(32) DEFAULT '' COMMENT '市ID',
  `area` varchar(32) DEFAULT '' COMMENT '区ID',
  `address` varchar(250) NOT NULL COMMENT '收货地址'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='收货信息表';

CREATE TABLE `mall_order_export` (
  `id` bigint(20) UNSIGNED NOT NULL COMMENT '主键ID',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '类型(1:帐单明细 2:发货单)',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'excel文件路径',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '导出状态(1:进行中 2:已完成 3:失败)',
  `start_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '结束时间',
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '创建时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='订单导出Excel记录表';

CREATE TABLE `mall_order_goods` (
  `id` bigint(20) NOT NULL,
  `order_id` bigint(20) NOT NULL COMMENT '订单ID',
  `goods_id` bigint(20) NOT NULL COMMENT '商品ID',
  `sku_id` varchar(255) NOT NULL DEFAULT '' COMMENT '规格ID',
  `order_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '商品类型(1:购买商品 2:活动商品 3:活动赠品)',
  `goods_name` varchar(255) NOT NULL DEFAULT '' COMMENT '商品名称',
  `goods_number` varchar(255) NOT NULL DEFAULT '' COMMENT '货品的货号',
  `real_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '实际价格',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `total_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '商品总价(数量×单价)',
  `goods_total_nums` int(11) NOT NULL DEFAULT '1' COMMENT '商品数量',
  `goods_weight` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '重量',
  `goods_array` text COMMENT '保存商品额外信息',
  `is_send` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否已发货(0:未发货 1:已发货 2:已经退货)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单商品表';

CREATE TABLE `mall_order_invoice` (
  `id` bigint(20) NOT NULL COMMENT '自增ID',
  `order_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `header_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '抬头类型(1:个人 2:企业)',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '发票类型(1:普通 2:专用)',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '名称（发票抬头）',
  `duty_number` varchar(50) NOT NULL DEFAULT '' COMMENT '税号',
  `drawer_phone` varchar(30) NOT NULL DEFAULT '' COMMENT '开票人手机号',
  `email` varchar(100) NOT NULL DEFAULT '' COMMENT '开票人邮箱',
  `tell` varchar(30) NOT NULL DEFAULT '' COMMENT '注册电话',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '注册地址',
  `bank` varchar(50) NOT NULL DEFAULT '' COMMENT '注册开户银行',
  `card_number` varchar(50) NOT NULL DEFAULT '' COMMENT '银行卡号',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '开票状态(1:审核  2:成功 3:拒绝)',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '开票时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单发票管理表' ROW_FORMAT=DYNAMIC;

CREATE TABLE `mall_order_recharge` (
  `id` bigint(20) UNSIGNED NOT NULL COMMENT '订单ID',
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_no` varchar(255) NOT NULL DEFAULT '' COMMENT '订单号',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '充值方式(1:自定义金额 2:套餐充值)',
  `pay_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '支付类型',
  `pay_price` decimal(15,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '用户支付金额',
  `gift_money` decimal(15,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '赠送金额',
  `actual_money` decimal(15,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '实际到账金额',
  `pay_status` tinyint(3) UNSIGNED NOT NULL DEFAULT '1' COMMENT '支付状态(1:待支付 2:已支付 3:支付失败)',
  `transaction_id` varchar(50) NOT NULL DEFAULT '' COMMENT '支付交易号',
  `pay_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '付款时间',
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员充值订单表';

CREATE TABLE `mall_order_refunds` (
  `id` bigint(20) UNSIGNED NOT NULL COMMENT '售后单ID',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '售后类型(1:退货退款 2:换货)',
  `order_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0' COMMENT '订单ID',
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_no` varchar(255) NOT NULL DEFAULT '' COMMENT '退款单号',
  `apply_desc` varchar(255) NOT NULL DEFAULT '' COMMENT '用户申请原因(说明)',
  `audit_status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '商家审核状态(1:待审核 2:已同意 3:已拒绝)',
  `refuse_desc` varchar(1000) NOT NULL DEFAULT '' COMMENT '商家拒绝原因(说明)',
  `order_amount` decimal(15,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '实际退款金额',
  `is_user_send` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '用户是否发货(1:未发货 2:已发货)',
  `order_goods_list` text COMMENT '订单商品ID',
  `express_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户发货物流公司ID',
  `express_no` varchar(128) NOT NULL DEFAULT '' COMMENT '用户发货物流单号',
  `is_receipt` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '商家收货状态(1:未收货 2:已收货)',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '售后状态(1:进行中 2:已完成 3:已取消 4:已拒绝)',
  `send_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '用户发货时间',
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='售后单记录表';

CREATE TABLE `mall_order_refunds_address` (
  `id` int(11) UNSIGNED NOT NULL COMMENT '主键ID',
  `refund_id` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '售后单ID',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '收货人姓名',
  `phone` varchar(20) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '联系电话',
  `province` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '所在省份ID',
  `city` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '所在城市ID',
  `area` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '所在区/县ID',
  `address` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '详细地址',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '创建时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='售后单退货地址记录表';

CREATE TABLE `mall_order_shipping` (
  `id` bigint(20) NOT NULL COMMENT 'ID',
  `order_sn` varchar(255) NOT NULL DEFAULT '' COMMENT '发货号',
  `load_path` varchar(255) NOT NULL DEFAULT '' COMMENT '上传路径',
  `error_path` varchar(255) NOT NULL DEFAULT '' COMMENT '下载路径',
  `order_total` int(10) NOT NULL DEFAULT '0' COMMENT '发货订单数',
  `success_total` int(10) NOT NULL DEFAULT '0' COMMENT '成功发货数',
  `error_data` text COMMENT '失败数据json',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:进行中 2:成功 3:失败 4:未处理)',
  `create_time` int(10) DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

CREATE TABLE `mall_payment` (
  `id` bigint(20) NOT NULL,
  `code` varchar(32) NOT NULL DEFAULT '' COMMENT '标识',
  `name` varchar(50) NOT NULL COMMENT '支付名称',
  `alias_name` varchar(50) NOT NULL DEFAULT '' COMMENT '别名',
  `photo` varchar(255) NOT NULL DEFAULT '' COMMENT '图标',
  `commission_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '手续费方式 1百分比 2固定值',
  `commission` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '手续费',
  `config` text COMMENT '配置参数,json数据对象',
  `sort` smallint(5) NOT NULL DEFAULT '99' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:启用 0:禁用)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='支付方式表';

INSERT INTO `mall_payment` (`id`, `code`, `name`, `alias_name`, `photo`, `commission_type`, `commission`, `config`, `sort`, `status`) VALUES
(0, 'bank', '银行转帐', '银行转帐', '/static/images/payment/bank.png', 1, '0.00', NULL, 1000, 1),
(1, 'balance', '余额支付', '余额支付', '/static/images/payment/balance.png', 1, '0.00', NULL, 101, 1),
(2, 'wechat', '微信支付', '微信支付', '/static/images/payment/wechat.png', 1, '0.00', NULL, 99, 1),
(3, 'alipay', '支付宝', '支付宝', '/static/images/payment/alipay.png', 1, '0.00', NULL, 100, 1);

CREATE TABLE `mall_payment_terminal` (
  `id` bigint(20) NOT NULL,
  `pay_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '支付类型',
  `is_default` tinyint(1) DEFAULT '1' COMMENT '默认(1:是 0:否)',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:开启 0:关闭)',
  `terminal` tinyint(4) NOT NULL DEFAULT '1' COMMENT '客户端类型(0:PC微信扫码 1:微信公众号 2:微信小程序 10-11: APP登录)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='支付类型表';

INSERT INTO `mall_payment_terminal` (`id`, `pay_id`, `is_default`, `status`, `terminal`) VALUES
(1, 1, 1, 1, 8),
(2, 2, 0, 1, 8),
(3, 3, 0, 1, 8),
(4, 1, 0, 1, 1),
(5, 2, 0, 1, 1),
(6, 3, 1, 1, 1),
(7, 1, 0, 1, 2),
(8, 2, 0, 1, 2),
(9, 3, 1, 1, 2),
(10, 1, 0, 1, 10),
(11, 2, 1, 1, 10),
(12, 3, 0, 1, 10),
(13, 1, 0, 1, 9),
(14, 2, 1, 1, 9),
(15, 3, 0, 1, 9);

CREATE TABLE `mall_promotion_award` (
  `id` bigint(20) NOT NULL,
  `price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '赠送金额',
  `point` int(10) NOT NULL DEFAULT '0' COMMENT '赠送积分',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:启用 0:禁用)',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='新人奖励表';

CREATE TABLE `mall_promotion_bargain` (
  `id` bigint(20) NOT NULL,
  `goods_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商品id',
  `title` varchar(255) NOT NULL COMMENT '商品标题',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '砍价金额',
  `min_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '砍价商品最低价',
  `goods_num` int(11) NOT NULL DEFAULT '1' COMMENT '可购买砍价商品数量',
  `goods_max_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '用户每次砍价的最大金额',
  `goods_min_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '用户每次砍价的最小金额',
  `bargain_num` int(11) NOT NULL DEFAULT '1' COMMENT '帮砍次数',
  `rule` text COMMENT '砍价规则',
  `sales_count` int(11) NOT NULL DEFAULT '0' COMMENT '砍价商品浏览量',
  `share_count` int(11) NOT NULL DEFAULT '0' COMMENT '砍价商品分享量',
  `quota` int(10) NOT NULL DEFAULT '0' COMMENT '限购总数',
  `quota_show` int(10) NOT NULL DEFAULT '0' COMMENT '限量总数显示',
  `people_num` int(11) NOT NULL DEFAULT '1' COMMENT '砍价人数',
  `store_nums` int(11) NOT NULL DEFAULT '0' COMMENT '库存量',
  `sum_count` int(11) NOT NULL DEFAULT '0' COMMENT '已销售量',
  `content` text COMMENT '介绍',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:开启 0:关闭)',
  `thumb_image` varchar(255) DEFAULT NULL COMMENT '商品图片',
  `sort` int(10) NOT NULL DEFAULT '99' COMMENT '排序',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='砍价';

CREATE TABLE `mall_promotion_bargain_users` (
  `id` bigint(20) NOT NULL COMMENT '用户参与砍价表',
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `bargain_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '砍价商品id',
  `goods_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `bargain_price_min` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '砍价的最低价',
  `bargain_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '砍价金额',
  `price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '砍掉的价格',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态(1:参与中 2:参加成功 3:参加失败)',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户参与砍价表';

CREATE TABLE `mall_promotion_bargain_users_help` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户id',
  `bargain_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `bargain_user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户参与砍价表id',
  `price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '帮助砍价多少金额',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否自己砍价 1:是 0:否',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='砍价用户帮助表';

CREATE TABLE `mall_promotion_consume` (
  `id` bigint(20) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '类型',
  `point` int(10) NOT NULL DEFAULT '0' COMMENT '积分比率 1-100',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:启用 0:禁用)',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='新人奖励表';

CREATE TABLE `mall_promotion_coupon` (
  `id` bigint(20) NOT NULL,
  `name` varchar(128) NOT NULL DEFAULT '' COMMENT '名称',
  `reduce_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '减免金额',
  `discount` tinyint(3) NOT NULL DEFAULT '0' COMMENT '折扣券-折扣率(0-100)',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '优惠劵类型(1:满减 2:折扣)',
  `apply_range` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0:全场可用 1:部分商品可用 2:部分商品不可用',
  `push_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '推送类型(1:会员领取 2:卖家推送)',
  `total_num` int(11) NOT NULL DEFAULT '0' COMMENT '发放数量 -1 为不限制',
  `receive_num` int(11) NOT NULL DEFAULT '0' COMMENT '己领取数量',
  `order_amount` decimal(15,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '订单金额',
  `goods_list` longtext COMMENT '商品id',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:启用 0:禁用)',
  `expire_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1:领取后生效 2:固定时间',
  `expire_day` int(10) NOT NULL DEFAULT '0' COMMENT '领取后生效时间',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='优惠券表';

CREATE TABLE `mall_promotion_discount` (
  `id` bigint(20) NOT NULL,
  `title` varchar(255) NOT NULL COMMENT '活动标题',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态(1:开启 0:关闭)',
  `is_repeat` tinyint(1) NOT NULL DEFAULT '1' COMMENT '重复购买(1:是 2:否)',
  `is_people` tinyint(1) NOT NULL DEFAULT '1' COMMENT '只允许新用户购买(1:是 2:否)',
  `browse` int(10) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='限时折扣表';

CREATE TABLE `mall_promotion_discount_goods` (
  `id` bigint(20) NOT NULL,
  `pid` bigint(20) NOT NULL DEFAULT '0' COMMENT '关联ID',
  `goods_id` bigint(20) NOT NULL COMMENT '货品ID',
  `goods_number` varchar(255) NOT NULL DEFAULT '' COMMENT '货品的货号(以商品的货号加横线加数字组成)',
  `store_nums` bigint(20) NOT NULL DEFAULT '0' COMMENT '库存',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `goods_weight` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '重量',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品表';

CREATE TABLE `mall_promotion_discount_goods_item` (
  `id` bigint(20) NOT NULL,
  `pid` bigint(20) NOT NULL DEFAULT '0' COMMENT '关联ID',
  `gid` bigint(20) NOT NULL DEFAULT '0' COMMENT '关联ID',
  `goods_id` bigint(20) NOT NULL COMMENT '货品ID',
  `sku_id` text NOT NULL COMMENT 'sku唯一标识',
  `spec_value` text NOT NULL COMMENT '规格值',
  `goods_number` varchar(255) NOT NULL DEFAULT '' COMMENT '货品的货号(以商品的货号加横线加数字组成)',
  `store_nums` bigint(20) NOT NULL DEFAULT '0' COMMENT '库存',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `goods_weight` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '重量',
  `thumb_image` varchar(255) NOT NULL DEFAULT '' COMMENT '规格图片',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='货品表';

CREATE TABLE `mall_promotion_free_shipping` (
  `id` bigint(20) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '类型(1:全国 2:指定地区)',
  `order_amount` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '订单金额',
  `area_group` longtext COMMENT '指定地区json数据',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:启用 0:禁用)',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='满额包邮表';

CREATE TABLE `mall_promotion_games` (
  `id` bigint(20) NOT NULL,
  `cat_type` varchar(128) NOT NULL DEFAULT '1' COMMENT '抽奖类型',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0一共抽奖次数 1每天抽奖次数',
  `num` smallint(6) NOT NULL DEFAULT '0' COMMENT '抽奖次数',
  `point` int(10) NOT NULL DEFAULT '0' COMMENT '抽奖积分数量',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态(1:开启 0:关闭)',
  `content` longtext COMMENT '说明',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='抽奖表';

CREATE TABLE `mall_promotion_games_item` (
  `id` bigint(20) NOT NULL,
  `pid` bigint(20) NOT NULL DEFAULT '0' COMMENT '关联ID',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT '类型',
  `value` int(10) NOT NULL DEFAULT '0' COMMENT '类型值',
  `store_nums` int(10) NOT NULL DEFAULT '0' COMMENT '奖品数量',
  `chance` int(10) NOT NULL DEFAULT '0' COMMENT '概率',
  `photo` varchar(255) NOT NULL DEFAULT '' COMMENT '图片',
  `sort` smallint(6) NOT NULL DEFAULT '0' COMMENT '排序'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='抽奖奖品表';

CREATE TABLE `mall_promotion_games_log` (
  `id` int(11) NOT NULL,
  `pid` bigint(20) NOT NULL DEFAULT '0' COMMENT '父ID',
  `cat_type` varchar(128) NOT NULL DEFAULT '' COMMENT '抽奖类型',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `type` varchar(32) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '抽奖说明',
  `point` int(11) NOT NULL DEFAULT '0' COMMENT '本次抽奖消费的积分',
  `result` longtext COMMENT '中奖商品数据',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='抽奖记录表';

CREATE TABLE `mall_promotion_gift` (
  `id` bigint(20) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '活动名称',
  `order_amount` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '订单金额',
  `price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '赠送金额',
  `goods_list` longtext COMMENT '商品ID',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:启用 0:禁用)',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='满额赠品表';

CREATE TABLE `mall_promotion_group` (
  `id` bigint(20) NOT NULL,
  `goods_id` bigint(20) UNSIGNED NOT NULL COMMENT '关联商品id',
  `title` varchar(255) NOT NULL COMMENT '活动标题',
  `store_nums` bigint(20) NOT NULL DEFAULT '0' COMMENT '库存量',
  `sum_count` bigint(20) NOT NULL DEFAULT '0' COMMENT '已销售量',
  `people` int(2) NOT NULL DEFAULT '0' COMMENT '参团人数',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否关闭',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '活动价格',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `thumb_image` varchar(128) DEFAULT NULL COMMENT '商品图片',
  `sort` int(10) NOT NULL DEFAULT '99' COMMENT '排序',
  `browse` int(10) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `effective_time` int(10) NOT NULL DEFAULT '0' COMMENT '拼团订单有效时间',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='限购活动表';

CREATE TABLE `mall_promotion_group_goods` (
  `id` bigint(20) NOT NULL,
  `pid` bigint(20) NOT NULL DEFAULT '0' COMMENT '关联ID',
  `goods_id` bigint(20) NOT NULL COMMENT '货品ID',
  `sku_id` text NOT NULL COMMENT 'sku唯一标识',
  `spec_value` text NOT NULL COMMENT '规格值',
  `goods_number` varchar(255) NOT NULL DEFAULT '' COMMENT '货品的货号(以商品的货号加横线加数字组成)',
  `store_nums` bigint(20) NOT NULL DEFAULT '0' COMMENT '库存',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `goods_weight` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '重量',
  `thumb_image` varchar(255) NOT NULL DEFAULT '' COMMENT '规格图片',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='货品表';

CREATE TABLE `mall_promotion_invite` (
  `id` bigint(20) NOT NULL,
  `point` int(10) NOT NULL DEFAULT '0' COMMENT '赠送积分',
  `price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '赠送金额',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:启用 0:禁用)',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='邀请奖励表';

CREATE TABLE `mall_promotion_invite_log` (
  `id` bigint(20) NOT NULL,
  `inviter_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '邀请人',
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `point` int(10) NOT NULL DEFAULT '0' COMMENT '赠送积分',
  `price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '赠送金额',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `mall_promotion_limit` (
  `id` bigint(20) NOT NULL,
  `goods_id` bigint(20) UNSIGNED NOT NULL COMMENT '关联商品id',
  `title` varchar(255) NOT NULL COMMENT '活动标题',
  `store_nums` bigint(20) NOT NULL DEFAULT '0' COMMENT '库存量',
  `sum_count` bigint(20) NOT NULL DEFAULT '0' COMMENT '已销售量',
  `limit_min_count` bigint(20) NOT NULL DEFAULT '0' COMMENT '每人限制最少购买数量',
  `limit_max_count` bigint(20) NOT NULL DEFAULT '0' COMMENT '每人限制最多购买数量',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态(1:开启 0:关闭)',
  `is_repeat` tinyint(1) NOT NULL DEFAULT '1' COMMENT '重复购买(1:是 2:否)',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '活动价格',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `thumb_image` varchar(128) DEFAULT NULL COMMENT '商品图片',
  `sort` int(10) NOT NULL DEFAULT '99' COMMENT '排序',
  `browse` int(10) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='限购活动表';

CREATE TABLE `mall_promotion_limit_goods` (
  `id` bigint(20) NOT NULL,
  `pid` bigint(20) NOT NULL DEFAULT '0' COMMENT '关联ID',
  `goods_id` bigint(20) NOT NULL COMMENT '货品ID',
  `sku_id` text NOT NULL COMMENT 'sku唯一标识',
  `spec_value` text NOT NULL COMMENT '规格值',
  `goods_number` varchar(255) NOT NULL DEFAULT '' COMMENT '货品的货号(以商品的货号加横线加数字组成)',
  `store_nums` bigint(20) NOT NULL DEFAULT '0' COMMENT '库存',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `goods_weight` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '重量',
  `thumb_image` varchar(255) NOT NULL DEFAULT '' COMMENT '规格图片',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='货品表';

CREATE TABLE `mall_promotion_point` (
  `id` bigint(20) NOT NULL,
  `goods_id` bigint(20) NOT NULL COMMENT '关联商品id',
  `title` varchar(255) NOT NULL COMMENT '活动标题',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `point` bigint(20) NOT NULL DEFAULT '0' COMMENT '兑换商品积分数量',
  `store_nums` bigint(20) NOT NULL DEFAULT '0' COMMENT '库存量',
  `sum_count` bigint(20) NOT NULL DEFAULT '0' COMMENT '已售销量',
  `sort` int(10) NOT NULL DEFAULT '99' COMMENT '排序',
  `browse` int(10) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:启用 0:关闭)',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='积分商品表';

CREATE TABLE `mall_promotion_point_goods` (
  `id` bigint(20) NOT NULL,
  `pid` bigint(20) NOT NULL DEFAULT '0' COMMENT '关联ID',
  `goods_id` bigint(20) NOT NULL COMMENT '货品ID',
  `sku_id` text NOT NULL COMMENT 'sku唯一标识',
  `spec_value` text NOT NULL COMMENT '规格值',
  `goods_number` varchar(255) NOT NULL DEFAULT '' COMMENT '货品的货号(以商品的货号加横线加数字组成)',
  `store_nums` bigint(20) NOT NULL DEFAULT '0' COMMENT '库存',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `point` bigint(20) NOT NULL DEFAULT '0' COMMENT '积分数量',
  `goods_weight` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '重量',
  `thumb_image` varchar(255) NOT NULL DEFAULT '' COMMENT '规格图片',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='货品表';

CREATE TABLE `mall_promotion_rebate` (
  `id` bigint(20) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '活动名称',
  `order_amount` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '订单金额',
  `price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '赠送金额',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:启用 0:禁用)',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='满减活动表';

CREATE TABLE `mall_promotion_second` (
  `id` bigint(20) NOT NULL,
  `goods_id` bigint(20) UNSIGNED NOT NULL COMMENT '关联商品id',
  `title` varchar(255) NOT NULL COMMENT '活动标题',
  `store_nums` bigint(20) NOT NULL DEFAULT '0' COMMENT '库存量',
  `sum_count` bigint(20) NOT NULL DEFAULT '0' COMMENT '已销售量',
  `time_type` int(10) NOT NULL DEFAULT '0' COMMENT '时间段',
  `upper_limit` int(10) NOT NULL DEFAULT '0' COMMENT '购买上限',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:开启 0:关闭)',
  `is_repeat` tinyint(1) NOT NULL DEFAULT '1' COMMENT '重复购买(1:开启 2:关闭)',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '活动价格',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `thumb_image` varchar(128) DEFAULT NULL COMMENT '商品图片',
  `sort` int(10) NOT NULL DEFAULT '99' COMMENT '排序',
  `browse` int(10) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='限时秒杀表';

CREATE TABLE `mall_promotion_second_goods` (
  `id` bigint(20) NOT NULL,
  `pid` bigint(20) NOT NULL DEFAULT '0' COMMENT '关联ID',
  `goods_id` bigint(20) NOT NULL COMMENT '货品ID',
  `sku_id` text NOT NULL COMMENT 'sku唯一标识',
  `spec_value` text NOT NULL COMMENT '规格值',
  `goods_number` varchar(255) NOT NULL DEFAULT '' COMMENT '货品的货号(以商品的货号加横线加数字组成)',
  `store_nums` bigint(20) NOT NULL DEFAULT '0' COMMENT '库存',
  `market_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '市场价格',
  `sell_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '销售价格',
  `cost_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '成本价格',
  `goods_weight` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '重量',
  `thumb_image` varchar(255) NOT NULL DEFAULT '' COMMENT '规格图片',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='货品表';

CREATE TABLE `mall_promotion_sign` (
  `id` bigint(20) NOT NULL,
  `list` longtext COMMENT '签到规则',
  `content` longtext COMMENT '签到说明',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:启用 0:禁用)',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='签到奖励表';

CREATE TABLE `mall_region` (
  `id` bigint(20) NOT NULL COMMENT '自增id',
  `pid` bigint(20) NOT NULL DEFAULT '0' COMMENT '父id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `level` tinyint(5) NOT NULL DEFAULT '0' COMMENT '级别类型（1:省 2:市 3:区县 4:街道）',
  `sort` smallint(6) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态（1:启用 0:禁用）',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='地区';

INSERT INTO `mall_region` (`id`, `pid`, `name`, `level`, `sort`, `status`, `create_time`) VALUES
(1, 0, '北京市', 1, 0, 1, 1649559939),
(2, 0, '天津市', 1, 0, 1, 1649559939),
(3, 0, '河北省', 1, 0, 1, 1649559939),
(4, 0, '山西省', 1, 0, 1, 1649559939),
(5, 0, '内蒙古自治区', 1, 0, 1, 1649559939),
(6, 0, '辽宁省', 1, 0, 1, 1649559939),
(7, 0, '吉林省', 1, 0, 1, 1649559939),
(8, 0, '黑龙江省', 1, 0, 1, 1649559939),
(9, 0, '上海市', 1, 0, 1, 1649559939),
(10, 0, '江苏省', 1, 0, 1, 1649559939),
(11, 0, '浙江省', 1, 0, 1, 1649559939),
(12, 0, '安徽省', 1, 0, 1, 1649559939),
(13, 0, '福建省', 1, 0, 1, 1649559939),
(14, 0, '江西省', 1, 0, 1, 1649559939),
(15, 0, '山东省', 1, 0, 1, 1649559939),
(16, 0, '河南省', 1, 0, 1, 1649559939),
(17, 0, '湖北省', 1, 0, 1, 1649559939),
(18, 0, '湖南省', 1, 0, 1, 1649559939),
(19, 0, '广东省', 1, 0, 1, 1649559939),
(20, 0, '广西壮族自治区', 1, 0, 1, 1649559939),
(21, 0, '海南省', 1, 0, 1, 1649559939),
(22, 0, '重庆市', 1, 0, 1, 1649559939),
(23, 0, '四川省', 1, 0, 1, 1649559939),
(24, 0, '贵州省', 1, 0, 1, 1649559939),
(25, 0, '云南省', 1, 0, 1, 1649559939),
(26, 0, '西藏自治区', 1, 0, 1, 1649559939),
(27, 0, '陕西省', 1, 0, 1, 1649559939),
(28, 0, '甘肃省', 1, 0, 1, 1649559939),
(29, 0, '青海省', 1, 0, 1, 1649559939),
(30, 0, '宁夏回族自治区', 1, 0, 1, 1649559939),
(31, 0, '新疆维吾尔自治区', 1, 0, 1, 1649559939),
(32, 0, '台湾省', 1, 0, 1, 1649559939),
(33, 0, '香港特别行政区', 1, 0, 1, 1649559939),
(34, 0, '澳门特别行政区', 1, 0, 1, 1649559939),
(35, 0, '海外', 1, 0, 1, 1649559939),
(36, 1, '北京市', 2, 0, 1, 1649559939),
(37, 2, '天津市', 2, 0, 1, 1649559939),
(38, 3, '石家庄市', 2, 0, 1, 1649559939),
(39, 3, '唐山市', 2, 0, 1, 1649559939),
(40, 3, '秦皇岛市', 2, 0, 1, 1649559939),
(41, 3, '邯郸市', 2, 0, 1, 1649559939),
(42, 3, '邢台市', 2, 0, 1, 1649559939),
(43, 3, '保定市', 2, 0, 1, 1649559939),
(44, 3, '张家口市', 2, 0, 1, 1649559939),
(45, 3, '承德市', 2, 0, 1, 1649559939),
(46, 3, '沧州市', 2, 0, 1, 1649559939),
(47, 3, '廊坊市', 2, 0, 1, 1649559939),
(48, 3, '衡水市', 2, 0, 1, 1649559939),
(49, 4, '太原市', 2, 0, 1, 1649559939),
(50, 4, '大同市', 2, 0, 1, 1649559939),
(51, 4, '阳泉市', 2, 0, 1, 1649559939),
(52, 4, '长治市', 2, 0, 1, 1649559939),
(53, 4, '晋城市', 2, 0, 1, 1649559939),
(54, 4, '朔州市', 2, 0, 1, 1649559939),
(55, 4, '晋中市', 2, 0, 1, 1649559939),
(56, 4, '运城市', 2, 0, 1, 1649559939),
(57, 4, '忻州市', 2, 0, 1, 1649559939),
(58, 4, '临汾市', 2, 0, 1, 1649559939),
(59, 4, '吕梁市', 2, 0, 1, 1649559939),
(60, 5, '呼和浩特市', 2, 0, 1, 1649559939),
(61, 5, '包头市', 2, 0, 1, 1649559939),
(62, 5, '乌海市', 2, 0, 1, 1649559939),
(63, 5, '赤峰市', 2, 0, 1, 1649559939),
(64, 5, '通辽市', 2, 0, 1, 1649559939),
(65, 5, '鄂尔多斯市', 2, 0, 1, 1649559939),
(66, 5, '呼伦贝尔市', 2, 0, 1, 1649559939),
(67, 5, '巴彦淖尔市', 2, 0, 1, 1649559939),
(68, 5, '乌兰察布市', 2, 0, 1, 1649559939),
(69, 5, '兴安盟', 2, 0, 1, 1649559939),
(70, 5, '锡林郭勒盟', 2, 0, 1, 1649559939),
(71, 5, '阿拉善盟', 2, 0, 1, 1649559939),
(72, 6, '沈阳市', 2, 0, 1, 1649559939),
(73, 6, '大连市', 2, 0, 1, 1649559939),
(74, 6, '鞍山市', 2, 0, 1, 1649559939),
(75, 6, '抚顺市', 2, 0, 1, 1649559939),
(76, 6, '本溪市', 2, 0, 1, 1649559939),
(77, 6, '丹东市', 2, 0, 1, 1649559939),
(78, 6, '锦州市', 2, 0, 1, 1649559939),
(79, 6, '营口市', 2, 0, 1, 1649559939),
(80, 6, '阜新市', 2, 0, 1, 1649559939),
(81, 6, '辽阳市', 2, 0, 1, 1649559939),
(82, 6, '盘锦市', 2, 0, 1, 1649559939),
(83, 6, '铁岭市', 2, 0, 1, 1649559939),
(84, 6, '朝阳市', 2, 0, 1, 1649559939),
(85, 6, '葫芦岛市', 2, 0, 1, 1649559939),
(86, 7, '长春市', 2, 0, 1, 1649559939),
(87, 7, '吉林市', 2, 0, 1, 1649559939),
(88, 7, '四平市', 2, 0, 1, 1649559939),
(89, 7, '辽源市', 2, 0, 1, 1649559939),
(90, 7, '通化市', 2, 0, 1, 1649559939),
(91, 7, '白山市', 2, 0, 1, 1649559939),
(92, 7, '松原市', 2, 0, 1, 1649559939),
(93, 7, '白城市', 2, 0, 1, 1649559939),
(94, 7, '延边朝鲜族自治州', 2, 0, 1, 1649559939),
(95, 8, '哈尔滨市', 2, 0, 1, 1649559939),
(96, 8, '齐齐哈尔市', 2, 0, 1, 1649559939),
(97, 8, '鸡西市', 2, 0, 1, 1649559939),
(98, 8, '鹤岗市', 2, 0, 1, 1649559939),
(99, 8, '双鸭山市', 2, 0, 1, 1649559939),
(100, 8, '大庆市', 2, 0, 1, 1649559939),
(101, 8, '伊春市', 2, 0, 1, 1649559939),
(102, 8, '佳木斯市', 2, 0, 1, 1649559939),
(103, 8, '七台河市', 2, 0, 1, 1649559939),
(104, 8, '牡丹江市', 2, 0, 1, 1649559939),
(105, 8, '黑河市', 2, 0, 1, 1649559939),
(106, 8, '绥化市', 2, 0, 1, 1649559939),
(107, 8, '大兴安岭地区', 2, 0, 1, 1649559939),
(108, 9, '上海市', 2, 0, 1, 1649559939),
(109, 10, '南京市', 2, 0, 1, 1649559939),
(110, 10, '无锡市', 2, 0, 1, 1649559939),
(111, 10, '徐州市', 2, 0, 1, 1649559939),
(112, 10, '常州市', 2, 0, 1, 1649559939),
(113, 10, '苏州市', 2, 0, 1, 1649559939),
(114, 10, '南通市', 2, 0, 1, 1649559939),
(115, 10, '连云港市', 2, 0, 1, 1649559939),
(116, 10, '淮安市', 2, 0, 1, 1649559939),
(117, 10, '盐城市', 2, 0, 1, 1649559939),
(118, 10, '扬州市', 2, 0, 1, 1649559939),
(119, 10, '镇江市', 2, 0, 1, 1649559939),
(120, 10, '泰州市', 2, 0, 1, 1649559939),
(121, 10, '宿迁市', 2, 0, 1, 1649559939),
(122, 11, '杭州市', 2, 0, 1, 1649559939),
(123, 11, '宁波市', 2, 0, 1, 1649559939),
(124, 11, '温州市', 2, 0, 1, 1649559939),
(125, 11, '嘉兴市', 2, 0, 1, 1649559939),
(126, 11, '湖州市', 2, 0, 1, 1649559939),
(127, 11, '绍兴市', 2, 0, 1, 1649559939),
(128, 11, '金华市', 2, 0, 1, 1649559939),
(129, 11, '衢州市', 2, 0, 1, 1649559939),
(130, 11, '舟山市', 2, 0, 1, 1649559939),
(131, 11, '台州市', 2, 0, 1, 1649559939),
(132, 11, '丽水市', 2, 0, 1, 1649559939),
(133, 12, '合肥市', 2, 0, 1, 1649559939),
(134, 12, '芜湖市', 2, 0, 1, 1649559939),
(135, 12, '蚌埠市', 2, 0, 1, 1649559939),
(136, 12, '淮南市', 2, 0, 1, 1649559939),
(137, 12, '马鞍山市', 2, 0, 1, 1649559939),
(138, 12, '淮北市', 2, 0, 1, 1649559939),
(139, 12, '铜陵市', 2, 0, 1, 1649559939),
(140, 12, '安庆市', 2, 0, 1, 1649559939),
(141, 12, '黄山市', 2, 0, 1, 1649559939),
(142, 12, '滁州市', 2, 0, 1, 1649559939),
(143, 12, '阜阳市', 2, 0, 1, 1649559939),
(144, 12, '宿州市', 2, 0, 1, 1649559939),
(145, 12, '六安市', 2, 0, 1, 1649559939),
(146, 12, '亳州市', 2, 0, 1, 1649559939),
(147, 12, '池州市', 2, 0, 1, 1649559939),
(148, 12, '宣城市', 2, 0, 1, 1649559939),
(149, 13, '福州市', 2, 0, 1, 1649559939),
(150, 13, '厦门市', 2, 0, 1, 1649559939),
(151, 13, '莆田市', 2, 0, 1, 1649559939),
(152, 13, '三明市', 2, 0, 1, 1649559939),
(153, 13, '泉州市', 2, 0, 1, 1649559939),
(154, 13, '漳州市', 2, 0, 1, 1649559939),
(155, 13, '南平市', 2, 0, 1, 1649559939),
(156, 13, '龙岩市', 2, 0, 1, 1649559939),
(157, 13, '宁德市', 2, 0, 1, 1649559939),
(158, 14, '南昌市', 2, 0, 1, 1649559939),
(159, 14, '景德镇市', 2, 0, 1, 1649559939),
(160, 14, '萍乡市', 2, 0, 1, 1649559939),
(161, 14, '九江市', 2, 0, 1, 1649559939),
(162, 14, '新余市', 2, 0, 1, 1649559939),
(163, 14, '鹰潭市', 2, 0, 1, 1649559939),
(164, 14, '赣州市', 2, 0, 1, 1649559939),
(165, 14, '吉安市', 2, 0, 1, 1649559939),
(166, 14, '宜春市', 2, 0, 1, 1649559939),
(167, 14, '抚州市', 2, 0, 1, 1649559939),
(168, 14, '上饶市', 2, 0, 1, 1649559939),
(169, 15, '济南市', 2, 0, 1, 1649559939),
(170, 15, '青岛市', 2, 0, 1, 1649559939),
(171, 15, '淄博市', 2, 0, 1, 1649559939),
(172, 15, '枣庄市', 2, 0, 1, 1649559939),
(173, 15, '东营市', 2, 0, 1, 1649559939),
(174, 15, '烟台市', 2, 0, 1, 1649559939),
(175, 15, '潍坊市', 2, 0, 1, 1649559939),
(176, 15, '济宁市', 2, 0, 1, 1649559939),
(177, 15, '泰安市', 2, 0, 1, 1649559939),
(178, 15, '威海市', 2, 0, 1, 1649559939),
(179, 15, '日照市', 2, 0, 1, 1649559939),
(180, 15, '临沂市', 2, 0, 1, 1649559939),
(181, 15, '德州市', 2, 0, 1, 1649559939),
(182, 15, '聊城市', 2, 0, 1, 1649559939),
(183, 15, '滨州市', 2, 0, 1, 1649559939),
(184, 15, '菏泽市', 2, 0, 1, 1649559939),
(185, 16, '郑州市', 2, 0, 1, 1649559939),
(186, 16, '开封市', 2, 0, 1, 1649559939),
(187, 16, '洛阳市', 2, 0, 1, 1649559939),
(188, 16, '平顶山市', 2, 0, 1, 1649559939),
(189, 16, '安阳市', 2, 0, 1, 1649559939),
(190, 16, '鹤壁市', 2, 0, 1, 1649559939),
(191, 16, '新乡市', 2, 0, 1, 1649559939),
(192, 16, '焦作市', 2, 0, 1, 1649559939),
(193, 16, '濮阳市', 2, 0, 1, 1649559939),
(194, 16, '许昌市', 2, 0, 1, 1649559939),
(195, 16, '漯河市', 2, 0, 1, 1649559939),
(196, 16, '三门峡市', 2, 0, 1, 1649559939),
(197, 16, '南阳市', 2, 0, 1, 1649559939),
(198, 16, '商丘市', 2, 0, 1, 1649559939),
(199, 16, '信阳市', 2, 0, 1, 1649559939),
(200, 16, '周口市', 2, 0, 1, 1649559939),
(201, 16, '驻马店市', 2, 0, 1, 1649559939),
(202, 16, '省直辖县级行政区划', 2, 0, 1, 1649559939),
(203, 17, '武汉市', 2, 0, 1, 1649559939),
(204, 17, '黄石市', 2, 0, 1, 1649559939),
(205, 17, '十堰市', 2, 0, 1, 1649559939),
(206, 17, '宜昌市', 2, 0, 1, 1649559939),
(207, 17, '襄阳市', 2, 0, 1, 1649559939),
(208, 17, '鄂州市', 2, 0, 1, 1649559939),
(209, 17, '荆门市', 2, 0, 1, 1649559939),
(210, 17, '孝感市', 2, 0, 1, 1649559939),
(211, 17, '荆州市', 2, 0, 1, 1649559939),
(212, 17, '黄冈市', 2, 0, 1, 1649559939),
(213, 17, '咸宁市', 2, 0, 1, 1649559939),
(214, 17, '随州市', 2, 0, 1, 1649559939),
(215, 17, '恩施土家族苗族自治州', 2, 0, 1, 1649559939),
(216, 17, '省直辖县级行政区划', 2, 0, 1, 1649559939),
(217, 18, '长沙市', 2, 0, 1, 1649559939),
(218, 18, '株洲市', 2, 0, 1, 1649559939),
(219, 18, '湘潭市', 2, 0, 1, 1649559939),
(220, 18, '衡阳市', 2, 0, 1, 1649559939),
(221, 18, '邵阳市', 2, 0, 1, 1649559939),
(222, 18, '岳阳市', 2, 0, 1, 1649559939),
(223, 18, '常德市', 2, 0, 1, 1649559939),
(224, 18, '张家界市', 2, 0, 1, 1649559939),
(225, 18, '益阳市', 2, 0, 1, 1649559939),
(226, 18, '郴州市', 2, 0, 1, 1649559939),
(227, 18, '永州市', 2, 0, 1, 1649559939),
(228, 18, '怀化市', 2, 0, 1, 1649559939),
(229, 18, '娄底市', 2, 0, 1, 1649559939),
(230, 18, '湘西土家族苗族自治州', 2, 0, 1, 1649559939),
(231, 19, '广州市', 2, 0, 1, 1649559939),
(232, 19, '韶关市', 2, 0, 1, 1649559939),
(233, 19, '深圳市', 2, 0, 1, 1649559939),
(234, 19, '珠海市', 2, 0, 1, 1649559939),
(235, 19, '汕头市', 2, 0, 1, 1649559939),
(236, 19, '佛山市', 2, 0, 1, 1649559939),
(237, 19, '江门市', 2, 0, 1, 1649559939),
(238, 19, '湛江市', 2, 0, 1, 1649559939),
(239, 19, '茂名市', 2, 0, 1, 1649559939),
(240, 19, '肇庆市', 2, 0, 1, 1649559939),
(241, 19, '惠州市', 2, 0, 1, 1649559939),
(242, 19, '梅州市', 2, 0, 1, 1649559939),
(243, 19, '汕尾市', 2, 0, 1, 1649559939),
(244, 19, '河源市', 2, 0, 1, 1649559939),
(245, 19, '阳江市', 2, 0, 1, 1649559939),
(246, 19, '清远市', 2, 0, 1, 1649559939),
(247, 19, '东莞市', 2, 0, 1, 1649559939),
(248, 19, '中山市', 2, 0, 1, 1649559939),
(249, 19, '潮州市', 2, 0, 1, 1649559939),
(250, 19, '揭阳市', 2, 0, 1, 1649559939),
(251, 19, '云浮市', 2, 0, 1, 1649559939),
(252, 20, '南宁市', 2, 0, 1, 1649559939),
(253, 20, '柳州市', 2, 0, 1, 1649559939),
(254, 20, '桂林市', 2, 0, 1, 1649559939),
(255, 20, '梧州市', 2, 0, 1, 1649559939),
(256, 20, '北海市', 2, 0, 1, 1649559939),
(257, 20, '防城港市', 2, 0, 1, 1649559939),
(258, 20, '钦州市', 2, 0, 1, 1649559939),
(259, 20, '贵港市', 2, 0, 1, 1649559939),
(260, 20, '玉林市', 2, 0, 1, 1649559939),
(261, 20, '百色市', 2, 0, 1, 1649559939),
(262, 20, '贺州市', 2, 0, 1, 1649559939),
(263, 20, '河池市', 2, 0, 1, 1649559939),
(264, 20, '来宾市', 2, 0, 1, 1649559939),
(265, 20, '崇左市', 2, 0, 1, 1649559939),
(266, 21, '海口市', 2, 0, 1, 1649559939),
(267, 21, '三亚市', 2, 0, 1, 1649559939),
(268, 21, '三沙市', 2, 0, 1, 1649559939),
(269, 21, '儋州市', 2, 0, 1, 1649559939),
(270, 21, '省直辖县级行政区划', 2, 0, 1, 1649559939),
(271, 22, '重庆市', 2, 0, 1, 1649559939),
(272, 22, '县', 2, 0, 1, 1649559939),
(273, 23, '成都市', 2, 0, 1, 1649559939),
(274, 23, '自贡市', 2, 0, 1, 1649559939),
(275, 23, '攀枝花市', 2, 0, 1, 1649559939),
(276, 23, '泸州市', 2, 0, 1, 1649559939),
(277, 23, '德阳市', 2, 0, 1, 1649559939),
(278, 23, '绵阳市', 2, 0, 1, 1649559939),
(279, 23, '广元市', 2, 0, 1, 1649559939),
(280, 23, '遂宁市', 2, 0, 1, 1649559939),
(281, 23, '内江市', 2, 0, 1, 1649559939),
(282, 23, '乐山市', 2, 0, 1, 1649559939),
(283, 23, '南充市', 2, 0, 1, 1649559939),
(284, 23, '眉山市', 2, 0, 1, 1649559939),
(285, 23, '宜宾市', 2, 0, 1, 1649559939),
(286, 23, '广安市', 2, 0, 1, 1649559939),
(287, 23, '达州市', 2, 0, 1, 1649559939),
(288, 23, '雅安市', 2, 0, 1, 1649559939),
(289, 23, '巴中市', 2, 0, 1, 1649559939),
(290, 23, '资阳市', 2, 0, 1, 1649559939),
(291, 23, '阿坝藏族羌族自治州', 2, 0, 1, 1649559939),
(292, 23, '甘孜藏族自治州', 2, 0, 1, 1649559939),
(293, 23, '凉山彝族自治州', 2, 0, 1, 1649559939),
(294, 24, '贵阳市', 2, 0, 1, 1649559939),
(295, 24, '六盘水市', 2, 0, 1, 1649559939),
(296, 24, '遵义市', 2, 0, 1, 1649559939),
(297, 24, '安顺市', 2, 0, 1, 1649559939),
(298, 24, '毕节市', 2, 0, 1, 1649559939),
(299, 24, '铜仁市', 2, 0, 1, 1649559939),
(300, 24, '黔西南布依族苗族自治州', 2, 0, 1, 1649559939),
(301, 24, '黔东南苗族侗族自治州', 2, 0, 1, 1649559939),
(302, 24, '黔南布依族苗族自治州', 2, 0, 1, 1649559939),
(303, 25, '昆明市', 2, 0, 1, 1649559939),
(304, 25, '曲靖市', 2, 0, 1, 1649559939),
(305, 25, '玉溪市', 2, 0, 1, 1649559939),
(306, 25, '保山市', 2, 0, 1, 1649559939),
(307, 25, '昭通市', 2, 0, 1, 1649559939),
(308, 25, '丽江市', 2, 0, 1, 1649559939),
(309, 25, '普洱市', 2, 0, 1, 1649559939),
(310, 25, '临沧市', 2, 0, 1, 1649559939),
(311, 25, '楚雄彝族自治州', 2, 0, 1, 1649559939),
(312, 25, '红河哈尼族彝族自治州', 2, 0, 1, 1649559939),
(313, 25, '文山壮族苗族自治州', 2, 0, 1, 1649559939),
(314, 25, '西双版纳傣族自治州', 2, 0, 1, 1649559939),
(315, 25, '大理白族自治州', 2, 0, 1, 1649559939),
(316, 25, '德宏傣族景颇族自治州', 2, 0, 1, 1649559939),
(317, 25, '怒江傈僳族自治州', 2, 0, 1, 1649559939),
(318, 25, '迪庆藏族自治州', 2, 0, 1, 1649559939),
(319, 26, '拉萨市', 2, 0, 1, 1649559939),
(320, 26, '日喀则市', 2, 0, 1, 1649559939),
(321, 26, '昌都市', 2, 0, 1, 1649559939),
(322, 26, '林芝市', 2, 0, 1, 1649559939),
(323, 26, '山南市', 2, 0, 1, 1649559939),
(324, 26, '那曲市', 2, 0, 1, 1649559939),
(325, 26, '阿里地区', 2, 0, 1, 1649559939),
(326, 27, '西安市', 2, 0, 1, 1649559939),
(327, 27, '铜川市', 2, 0, 1, 1649559939),
(328, 27, '宝鸡市', 2, 0, 1, 1649559939),
(329, 27, '咸阳市', 2, 0, 1, 1649559939),
(330, 27, '渭南市', 2, 0, 1, 1649559939),
(331, 27, '延安市', 2, 0, 1, 1649559939),
(332, 27, '汉中市', 2, 0, 1, 1649559939),
(333, 27, '榆林市', 2, 0, 1, 1649559939),
(334, 27, '安康市', 2, 0, 1, 1649559939),
(335, 27, '商洛市', 2, 0, 1, 1649559939),
(336, 28, '兰州市', 2, 0, 1, 1649559939),
(337, 28, '嘉峪关市', 2, 0, 1, 1649559939),
(338, 28, '金昌市', 2, 0, 1, 1649559939),
(339, 28, '白银市', 2, 0, 1, 1649559939),
(340, 28, '天水市', 2, 0, 1, 1649559939),
(341, 28, '武威市', 2, 0, 1, 1649559939),
(342, 28, '张掖市', 2, 0, 1, 1649559939),
(343, 28, '平凉市', 2, 0, 1, 1649559939),
(344, 28, '酒泉市', 2, 0, 1, 1649559939),
(345, 28, '庆阳市', 2, 0, 1, 1649559939),
(346, 28, '定西市', 2, 0, 1, 1649559939),
(347, 28, '陇南市', 2, 0, 1, 1649559939),
(348, 28, '临夏回族自治州', 2, 0, 1, 1649559939),
(349, 28, '甘南藏族自治州', 2, 0, 1, 1649559939),
(350, 29, '西宁市', 2, 0, 1, 1649559939),
(351, 29, '海东市', 2, 0, 1, 1649559939),
(352, 29, '海北藏族自治州', 2, 0, 1, 1649559939),
(353, 29, '黄南藏族自治州', 2, 0, 1, 1649559939),
(354, 29, '海南藏族自治州', 2, 0, 1, 1649559939),
(355, 29, '果洛藏族自治州', 2, 0, 1, 1649559939),
(356, 29, '玉树藏族自治州', 2, 0, 1, 1649559939),
(357, 29, '海西蒙古族藏族自治州', 2, 0, 1, 1649559939),
(358, 30, '银川市', 2, 0, 1, 1649559939),
(359, 30, '石嘴山市', 2, 0, 1, 1649559939),
(360, 30, '吴忠市', 2, 0, 1, 1649559939),
(361, 30, '固原市', 2, 0, 1, 1649559939),
(362, 30, '中卫市', 2, 0, 1, 1649559939),
(363, 31, '乌鲁木齐市', 2, 0, 1, 1649559939),
(364, 31, '克拉玛依市', 2, 0, 1, 1649559939),
(365, 31, '吐鲁番市', 2, 0, 1, 1649559939),
(366, 31, '哈密市', 2, 0, 1, 1649559939),
(367, 31, '昌吉回族自治州', 2, 0, 1, 1649559939),
(368, 31, '博尔塔拉蒙古自治州', 2, 0, 1, 1649559939),
(369, 31, '巴音郭楞蒙古自治州', 2, 0, 1, 1649559939),
(370, 31, '阿克苏地区', 2, 0, 1, 1649559939),
(371, 31, '克孜勒苏柯尔克孜自治州', 2, 0, 1, 1649559939),
(372, 31, '喀什地区', 2, 0, 1, 1649559939),
(373, 31, '和田地区', 2, 0, 1, 1649559939),
(374, 31, '伊犁哈萨克自治州', 2, 0, 1, 1649559939),
(375, 31, '塔城地区', 2, 0, 1, 1649559939),
(376, 31, '阿勒泰地区', 2, 0, 1, 1649559939),
(377, 31, '自治区直辖县级行政区划', 2, 0, 1, 1649559939),
(378, 32, '台北市', 2, 0, 1, 1649559939),
(379, 32, '高雄市', 2, 0, 1, 1649559939),
(380, 32, '基隆市', 2, 0, 1, 1649559939),
(381, 32, '台中市', 2, 0, 1, 1649559939),
(382, 32, '台南市', 2, 0, 1, 1649559939),
(383, 32, '新竹市', 2, 0, 1, 1649559939),
(384, 32, '嘉义市', 2, 0, 1, 1649559939),
(385, 32, '台北县', 2, 0, 1, 1649559939),
(386, 32, '宜兰县', 2, 0, 1, 1649559939),
(387, 32, '桃园县', 2, 0, 1, 1649559939),
(388, 32, '新竹县', 2, 0, 1, 1649559939),
(389, 32, '苗栗县', 2, 0, 1, 1649559939),
(390, 32, '台中县', 2, 0, 1, 1649559939),
(391, 32, '彰化县', 2, 0, 1, 1649559939),
(392, 32, '南投县', 2, 0, 1, 1649559939),
(393, 32, '云林县', 2, 0, 1, 1649559939),
(394, 32, '嘉义县', 2, 0, 1, 1649559939),
(395, 32, '台南县', 2, 0, 1, 1649559939),
(396, 32, '高雄县', 2, 0, 1, 1649559939),
(397, 32, '屏东县', 2, 0, 1, 1649559939),
(398, 32, '澎湖县', 2, 0, 1, 1649559939),
(399, 32, '台东县', 2, 0, 1, 1649559939),
(400, 32, '花莲县', 2, 0, 1, 1649559939),
(401, 33, '中西区', 2, 0, 1, 1649559939),
(402, 33, '东区', 2, 0, 1, 1649559939),
(403, 33, '九龙城区', 2, 0, 1, 1649559939),
(404, 33, '观塘区', 2, 0, 1, 1649559939),
(405, 33, '南区', 2, 0, 1, 1649559939),
(406, 33, '深水埗区', 2, 0, 1, 1649559939),
(407, 33, '黄大仙区', 2, 0, 1, 1649559939),
(408, 33, '湾仔区', 2, 0, 1, 1649559939),
(409, 33, '油尖旺区', 2, 0, 1, 1649559939),
(410, 33, '离岛区', 2, 0, 1, 1649559939),
(411, 33, '葵青区', 2, 0, 1, 1649559939),
(412, 33, '北区', 2, 0, 1, 1649559939),
(413, 33, '西贡区', 2, 0, 1, 1649559939),
(414, 33, '沙田区', 2, 0, 1, 1649559939),
(415, 33, '屯门区', 2, 0, 1, 1649559939),
(416, 33, '大埔区', 2, 0, 1, 1649559939),
(417, 33, '荃湾区', 2, 0, 1, 1649559939),
(418, 33, '元朗区', 2, 0, 1, 1649559939),
(419, 34, '花地玛堂区', 2, 0, 1, 1649559939),
(420, 34, '圣安多尼堂区', 2, 0, 1, 1649559939),
(421, 34, '大堂区', 2, 0, 1, 1649559939),
(422, 34, '望德堂区', 2, 0, 1, 1649559939),
(423, 34, '风顺堂区', 2, 0, 1, 1649559939),
(424, 34, '嘉模堂区', 2, 0, 1, 1649559939),
(425, 34, '圣方济各堂区', 2, 0, 1, 1649559939),
(426, 35, '美国', 2, 0, 1, 1649559939),
(427, 35, '加拿大', 2, 0, 1, 1649559939),
(428, 35, '澳大利亚', 2, 0, 1, 1649559939),
(429, 35, '新西兰', 2, 0, 1, 1649559939),
(430, 35, '英国', 2, 0, 1, 1649559939),
(431, 35, '法国', 2, 0, 1, 1649559939),
(432, 35, '德国', 2, 0, 1, 1649559939),
(433, 35, '捷克', 2, 0, 1, 1649559939),
(434, 35, '荷兰', 2, 0, 1, 1649559939),
(435, 35, '瑞士', 2, 0, 1, 1649559939),
(436, 35, '希腊', 2, 0, 1, 1649559939),
(437, 35, '挪威', 2, 0, 1, 1649559939),
(438, 35, '瑞典', 2, 0, 1, 1649559939),
(439, 35, '丹麦', 2, 0, 1, 1649559939),
(440, 35, '芬兰', 2, 0, 1, 1649559939),
(441, 35, '爱尔兰', 2, 0, 1, 1649559939),
(442, 35, '奥地利', 2, 0, 1, 1649559939),
(443, 35, '意大利', 2, 0, 1, 1649559939),
(444, 35, '乌克兰', 2, 0, 1, 1649559939),
(445, 35, '俄罗斯', 2, 0, 1, 1649559939),
(446, 35, '西班牙', 2, 0, 1, 1649559939),
(447, 35, '韩国', 2, 0, 1, 1649559939),
(448, 35, '新加坡', 2, 0, 1, 1649559939),
(449, 35, '马来西亚', 2, 0, 1, 1649559939),
(450, 35, '印度', 2, 0, 1, 1649559939),
(451, 35, '泰国', 2, 0, 1, 1649559939),
(452, 35, '日本', 2, 0, 1, 1649559939),
(453, 35, '巴西', 2, 0, 1, 1649559939),
(454, 35, '阿根廷', 2, 0, 1, 1649559939),
(455, 35, '南非', 2, 0, 1, 1649559939),
(456, 35, '埃及', 2, 0, 1, 1649559939),
(457, 36, '东城区', 3, 0, 1, 1649559939),
(458, 36, '西城区', 3, 0, 1, 1649559939),
(459, 36, '朝阳区', 3, 0, 1, 1649559939),
(460, 36, '丰台区', 3, 0, 1, 1649559939),
(461, 36, '石景山区', 3, 0, 1, 1649559939),
(462, 36, '海淀区', 3, 0, 1, 1649559939),
(463, 36, '门头沟区', 3, 0, 1, 1649559939),
(464, 36, '房山区', 3, 0, 1, 1649559939),
(465, 36, '通州区', 3, 0, 1, 1649559939),
(466, 36, '顺义区', 3, 0, 1, 1649559939),
(467, 36, '昌平区', 3, 0, 1, 1649559939),
(468, 36, '大兴区', 3, 0, 1, 1649559939),
(469, 36, '怀柔区', 3, 0, 1, 1649559939),
(470, 36, '平谷区', 3, 0, 1, 1649559939),
(471, 36, '密云区', 3, 0, 1, 1649559939),
(472, 36, '延庆区', 3, 0, 1, 1649559939),
(473, 37, '和平区', 3, 0, 1, 1649559939),
(474, 37, '河东区', 3, 0, 1, 1649559939),
(475, 37, '河西区', 3, 0, 1, 1649559939),
(476, 37, '南开区', 3, 0, 1, 1649559939),
(477, 37, '河北区', 3, 0, 1, 1649559939),
(478, 37, '红桥区', 3, 0, 1, 1649559939),
(479, 37, '东丽区', 3, 0, 1, 1649559939),
(480, 37, '西青区', 3, 0, 1, 1649559939),
(481, 37, '津南区', 3, 0, 1, 1649559939),
(482, 37, '北辰区', 3, 0, 1, 1649559939),
(483, 37, '武清区', 3, 0, 1, 1649559939),
(484, 37, '宝坻区', 3, 0, 1, 1649559939),
(485, 37, '滨海新区', 3, 0, 1, 1649559939),
(486, 37, '宁河区', 3, 0, 1, 1649559940),
(487, 37, '静海区', 3, 0, 1, 1649559940),
(488, 37, '蓟州区', 3, 0, 1, 1649559940),
(489, 38, '长安区', 3, 0, 1, 1649559940),
(490, 38, '桥西区', 3, 0, 1, 1649559940),
(491, 38, '新华区', 3, 0, 1, 1649559940),
(492, 38, '井陉矿区', 3, 0, 1, 1649559940),
(493, 38, '裕华区', 3, 0, 1, 1649559940),
(494, 38, '藁城区', 3, 0, 1, 1649559940),
(495, 38, '鹿泉区', 3, 0, 1, 1649559940),
(496, 38, '栾城区', 3, 0, 1, 1649559940),
(497, 38, '井陉县', 3, 0, 1, 1649559940),
(498, 38, '正定县', 3, 0, 1, 1649559940),
(499, 38, '行唐县', 3, 0, 1, 1649559940),
(500, 38, '灵寿县', 3, 0, 1, 1649559940),
(501, 38, '高邑县', 3, 0, 1, 1649559940),
(502, 38, '深泽县', 3, 0, 1, 1649559940),
(503, 38, '赞皇县', 3, 0, 1, 1649559940),
(504, 38, '无极县', 3, 0, 1, 1649559940),
(505, 38, '平山县', 3, 0, 1, 1649559940),
(506, 38, '元氏县', 3, 0, 1, 1649559940),
(507, 38, '赵县', 3, 0, 1, 1649559940),
(508, 38, '石家庄高新技术产业开发区', 3, 0, 1, 1649559940),
(509, 38, '石家庄循环化工园区', 3, 0, 1, 1649559940),
(510, 38, '辛集市', 3, 0, 1, 1649559940),
(511, 38, '晋州市', 3, 0, 1, 1649559940),
(512, 38, '新乐市', 3, 0, 1, 1649559940),
(513, 39, '路南区', 3, 0, 1, 1649559940),
(514, 39, '路北区', 3, 0, 1, 1649559940),
(515, 39, '古冶区', 3, 0, 1, 1649559940),
(516, 39, '开平区', 3, 0, 1, 1649559940),
(517, 39, '丰南区', 3, 0, 1, 1649559940),
(518, 39, '丰润区', 3, 0, 1, 1649559940),
(519, 39, '曹妃甸区', 3, 0, 1, 1649559940),
(520, 39, '滦南县', 3, 0, 1, 1649559940),
(521, 39, '乐亭县', 3, 0, 1, 1649559940),
(522, 39, '迁西县', 3, 0, 1, 1649559940),
(523, 39, '玉田县', 3, 0, 1, 1649559940),
(524, 39, '河北唐山芦台经济开发区', 3, 0, 1, 1649559940),
(525, 39, '唐山市汉沽管理区', 3, 0, 1, 1649559940),
(526, 39, '唐山高新技术产业开发区', 3, 0, 1, 1649559940),
(527, 39, '河北唐山海港经济开发区', 3, 0, 1, 1649559940),
(528, 39, '遵化市', 3, 0, 1, 1649559940),
(529, 39, '迁安市', 3, 0, 1, 1649559940),
(530, 39, '滦州市', 3, 0, 1, 1649559940),
(531, 40, '海港区', 3, 0, 1, 1649559940),
(532, 40, '山海关区', 3, 0, 1, 1649559940),
(533, 40, '北戴河区', 3, 0, 1, 1649559940),
(534, 40, '抚宁区', 3, 0, 1, 1649559940),
(535, 40, '青龙满族自治县', 3, 0, 1, 1649559940),
(536, 40, '昌黎县', 3, 0, 1, 1649559940),
(537, 40, '卢龙县', 3, 0, 1, 1649559940),
(538, 40, '秦皇岛市经济技术开发区', 3, 0, 1, 1649559940),
(539, 40, '北戴河新区', 3, 0, 1, 1649559940),
(540, 41, '邯山区', 3, 0, 1, 1649559940),
(541, 41, '丛台区', 3, 0, 1, 1649559940),
(542, 41, '复兴区', 3, 0, 1, 1649559940),
(543, 41, '峰峰矿区', 3, 0, 1, 1649559940),
(544, 41, '肥乡区', 3, 0, 1, 1649559940),
(545, 41, '永年区', 3, 0, 1, 1649559940),
(546, 41, '临漳县', 3, 0, 1, 1649559940),
(547, 41, '成安县', 3, 0, 1, 1649559940),
(548, 41, '大名县', 3, 0, 1, 1649559940),
(549, 41, '涉县', 3, 0, 1, 1649559940),
(550, 41, '磁县', 3, 0, 1, 1649559940),
(551, 41, '邱县', 3, 0, 1, 1649559940),
(552, 41, '鸡泽县', 3, 0, 1, 1649559940),
(553, 41, '广平县', 3, 0, 1, 1649559940),
(554, 41, '馆陶县', 3, 0, 1, 1649559940),
(555, 41, '魏县', 3, 0, 1, 1649559940),
(556, 41, '曲周县', 3, 0, 1, 1649559940),
(557, 41, '邯郸经济技术开发区', 3, 0, 1, 1649559940),
(558, 41, '邯郸冀南新区', 3, 0, 1, 1649559940),
(559, 41, '武安市', 3, 0, 1, 1649559940),
(560, 42, '襄都区', 3, 0, 1, 1649559940),
(561, 42, '信都区', 3, 0, 1, 1649559940),
(562, 42, '任泽区', 3, 0, 1, 1649559940),
(563, 42, '南和区', 3, 0, 1, 1649559940),
(564, 42, '临城县', 3, 0, 1, 1649559940),
(565, 42, '内丘县', 3, 0, 1, 1649559940),
(566, 42, '柏乡县', 3, 0, 1, 1649559940),
(567, 42, '隆尧县', 3, 0, 1, 1649559940),
(568, 42, '宁晋县', 3, 0, 1, 1649559940),
(569, 42, '巨鹿县', 3, 0, 1, 1649559940),
(570, 42, '新河县', 3, 0, 1, 1649559940),
(571, 42, '广宗县', 3, 0, 1, 1649559940),
(572, 42, '平乡县', 3, 0, 1, 1649559940),
(573, 42, '威县', 3, 0, 1, 1649559940),
(574, 42, '清河县', 3, 0, 1, 1649559940),
(575, 42, '临西县', 3, 0, 1, 1649559940),
(576, 42, '河北邢台经济开发区', 3, 0, 1, 1649559940),
(577, 42, '南宫市', 3, 0, 1, 1649559940),
(578, 42, '沙河市', 3, 0, 1, 1649559940),
(579, 43, '竞秀区', 3, 0, 1, 1649559940),
(580, 43, '莲池区', 3, 0, 1, 1649559940),
(581, 43, '满城区', 3, 0, 1, 1649559940),
(582, 43, '清苑区', 3, 0, 1, 1649559940),
(583, 43, '徐水区', 3, 0, 1, 1649559940),
(584, 43, '涞水县', 3, 0, 1, 1649559940),
(585, 43, '阜平县', 3, 0, 1, 1649559940),
(586, 43, '定兴县', 3, 0, 1, 1649559940),
(587, 43, '唐县', 3, 0, 1, 1649559940),
(588, 43, '高阳县', 3, 0, 1, 1649559940),
(589, 43, '容城县', 3, 0, 1, 1649559940),
(590, 43, '涞源县', 3, 0, 1, 1649559940),
(591, 43, '望都县', 3, 0, 1, 1649559940),
(592, 43, '安新县', 3, 0, 1, 1649559940),
(593, 43, '易县', 3, 0, 1, 1649559940),
(594, 43, '曲阳县', 3, 0, 1, 1649559940),
(595, 43, '蠡县', 3, 0, 1, 1649559940),
(596, 43, '顺平县', 3, 0, 1, 1649559940),
(597, 43, '博野县', 3, 0, 1, 1649559940),
(598, 43, '雄县', 3, 0, 1, 1649559940),
(599, 43, '保定高新技术产业开发区', 3, 0, 1, 1649559940),
(600, 43, '保定白沟新城', 3, 0, 1, 1649559940),
(601, 43, '涿州市', 3, 0, 1, 1649559940),
(602, 43, '定州市', 3, 0, 1, 1649559940),
(603, 43, '安国市', 3, 0, 1, 1649559940),
(604, 43, '高碑店市', 3, 0, 1, 1649559940),
(605, 44, '桥东区', 3, 0, 1, 1649559940),
(606, 44, '桥西区', 3, 0, 1, 1649559940),
(607, 44, '宣化区', 3, 0, 1, 1649559940),
(608, 44, '下花园区', 3, 0, 1, 1649559940),
(609, 44, '万全区', 3, 0, 1, 1649559940),
(610, 44, '崇礼区', 3, 0, 1, 1649559940),
(611, 44, '张北县', 3, 0, 1, 1649559940),
(612, 44, '康保县', 3, 0, 1, 1649559940),
(613, 44, '沽源县', 3, 0, 1, 1649559940),
(614, 44, '尚义县', 3, 0, 1, 1649559940),
(615, 44, '蔚县', 3, 0, 1, 1649559940),
(616, 44, '阳原县', 3, 0, 1, 1649559940),
(617, 44, '怀安县', 3, 0, 1, 1649559940),
(618, 44, '怀来县', 3, 0, 1, 1649559940),
(619, 44, '涿鹿县', 3, 0, 1, 1649559940),
(620, 44, '赤城县', 3, 0, 1, 1649559940),
(621, 44, '张家口经济开发区', 3, 0, 1, 1649559940),
(622, 44, '张家口市察北管理区', 3, 0, 1, 1649559940),
(623, 44, '张家口市塞北管理区', 3, 0, 1, 1649559940),
(624, 45, '双桥区', 3, 0, 1, 1649559940),
(625, 45, '双滦区', 3, 0, 1, 1649559940),
(626, 45, '鹰手营子矿区', 3, 0, 1, 1649559940),
(627, 45, '承德县', 3, 0, 1, 1649559940),
(628, 45, '兴隆县', 3, 0, 1, 1649559940),
(629, 45, '滦平县', 3, 0, 1, 1649559940),
(630, 45, '隆化县', 3, 0, 1, 1649559940),
(631, 45, '丰宁满族自治县', 3, 0, 1, 1649559940),
(632, 45, '宽城满族自治县', 3, 0, 1, 1649559940),
(633, 45, '围场满族蒙古族自治县', 3, 0, 1, 1649559940),
(634, 45, '承德高新技术产业开发区', 3, 0, 1, 1649559940),
(635, 45, '平泉市', 3, 0, 1, 1649559940),
(636, 46, '新华区', 3, 0, 1, 1649559940),
(637, 46, '运河区', 3, 0, 1, 1649559940),
(638, 46, '沧县', 3, 0, 1, 1649559940),
(639, 46, '青县', 3, 0, 1, 1649559940),
(640, 46, '东光县', 3, 0, 1, 1649559940),
(641, 46, '海兴县', 3, 0, 1, 1649559940),
(642, 46, '盐山县', 3, 0, 1, 1649559940),
(643, 46, '肃宁县', 3, 0, 1, 1649559940),
(644, 46, '南皮县', 3, 0, 1, 1649559940),
(645, 46, '吴桥县', 3, 0, 1, 1649559940),
(646, 46, '献县', 3, 0, 1, 1649559940),
(647, 46, '孟村回族自治县', 3, 0, 1, 1649559940),
(648, 46, '河北沧州经济开发区', 3, 0, 1, 1649559940),
(649, 46, '沧州高新技术产业开发区', 3, 0, 1, 1649559940),
(650, 46, '沧州渤海新区', 3, 0, 1, 1649559940),
(651, 46, '泊头市', 3, 0, 1, 1649559940),
(652, 46, '任丘市', 3, 0, 1, 1649559940),
(653, 46, '黄骅市', 3, 0, 1, 1649559940),
(654, 46, '河间市', 3, 0, 1, 1649559940),
(655, 47, '安次区', 3, 0, 1, 1649559940),
(656, 47, '广阳区', 3, 0, 1, 1649559940),
(657, 47, '固安县', 3, 0, 1, 1649559940),
(658, 47, '永清县', 3, 0, 1, 1649559940),
(659, 47, '香河县', 3, 0, 1, 1649559940),
(660, 47, '大城县', 3, 0, 1, 1649559940),
(661, 47, '文安县', 3, 0, 1, 1649559940),
(662, 47, '大厂回族自治县', 3, 0, 1, 1649559940),
(663, 47, '廊坊经济技术开发区', 3, 0, 1, 1649559940),
(664, 47, '霸州市', 3, 0, 1, 1649559940),
(665, 47, '三河市', 3, 0, 1, 1649559940),
(666, 48, '桃城区', 3, 0, 1, 1649559940),
(667, 48, '冀州区', 3, 0, 1, 1649559940),
(668, 48, '枣强县', 3, 0, 1, 1649559940),
(669, 48, '武邑县', 3, 0, 1, 1649559940),
(670, 48, '武强县', 3, 0, 1, 1649559940),
(671, 48, '饶阳县', 3, 0, 1, 1649559940),
(672, 48, '安平县', 3, 0, 1, 1649559940),
(673, 48, '故城县', 3, 0, 1, 1649559940),
(674, 48, '景县', 3, 0, 1, 1649559940),
(675, 48, '阜城县', 3, 0, 1, 1649559940),
(676, 48, '河北衡水高新技术产业开发区', 3, 0, 1, 1649559940),
(677, 48, '衡水滨湖新区', 3, 0, 1, 1649559940),
(678, 48, '深州市', 3, 0, 1, 1649559940),
(679, 49, '小店区', 3, 0, 1, 1649559940),
(680, 49, '迎泽区', 3, 0, 1, 1649559940),
(681, 49, '杏花岭区', 3, 0, 1, 1649559940),
(682, 49, '尖草坪区', 3, 0, 1, 1649559940),
(683, 49, '万柏林区', 3, 0, 1, 1649559940),
(684, 49, '晋源区', 3, 0, 1, 1649559940),
(685, 49, '清徐县', 3, 0, 1, 1649559940),
(686, 49, '阳曲县', 3, 0, 1, 1649559940),
(687, 49, '娄烦县', 3, 0, 1, 1649559940),
(688, 49, '山西转型综合改革示范区', 3, 0, 1, 1649559940),
(689, 49, '古交市', 3, 0, 1, 1649559940),
(690, 50, '新荣区', 3, 0, 1, 1649559940),
(691, 50, '平城区', 3, 0, 1, 1649559940),
(692, 50, '云冈区', 3, 0, 1, 1649559940),
(693, 50, '云州区', 3, 0, 1, 1649559940),
(694, 50, '阳高县', 3, 0, 1, 1649559940),
(695, 50, '天镇县', 3, 0, 1, 1649559940),
(696, 50, '广灵县', 3, 0, 1, 1649559940),
(697, 50, '灵丘县', 3, 0, 1, 1649559940),
(698, 50, '浑源县', 3, 0, 1, 1649559940),
(699, 50, '左云县', 3, 0, 1, 1649559940),
(700, 50, '山西大同经济开发区', 3, 0, 1, 1649559940),
(701, 51, '城区', 3, 0, 1, 1649559940),
(702, 51, '矿区', 3, 0, 1, 1649559940),
(703, 51, '郊区', 3, 0, 1, 1649559940),
(704, 51, '平定县', 3, 0, 1, 1649559940),
(705, 51, '盂县', 3, 0, 1, 1649559940),
(706, 52, '潞州区', 3, 0, 1, 1649559940),
(707, 52, '上党区', 3, 0, 1, 1649559940),
(708, 52, '屯留区', 3, 0, 1, 1649559940),
(709, 52, '潞城区', 3, 0, 1, 1649559940),
(710, 52, '襄垣县', 3, 0, 1, 1649559940),
(711, 52, '平顺县', 3, 0, 1, 1649559940),
(712, 52, '黎城县', 3, 0, 1, 1649559940),
(713, 52, '壶关县', 3, 0, 1, 1649559940),
(714, 52, '长子县', 3, 0, 1, 1649559940),
(715, 52, '武乡县', 3, 0, 1, 1649559940),
(716, 52, '沁县', 3, 0, 1, 1649559940),
(717, 52, '沁源县', 3, 0, 1, 1649559940),
(718, 52, '山西长治高新技术产业园区', 3, 0, 1, 1649559940),
(719, 53, '城区', 3, 0, 1, 1649559940),
(720, 53, '沁水县', 3, 0, 1, 1649559940),
(721, 53, '阳城县', 3, 0, 1, 1649559940),
(722, 53, '陵川县', 3, 0, 1, 1649559940),
(723, 53, '泽州县', 3, 0, 1, 1649559940),
(724, 53, '高平市', 3, 0, 1, 1649559940),
(725, 54, '朔城区', 3, 0, 1, 1649559940),
(726, 54, '平鲁区', 3, 0, 1, 1649559940),
(727, 54, '山阴县', 3, 0, 1, 1649559940),
(728, 54, '应县', 3, 0, 1, 1649559940),
(729, 54, '右玉县', 3, 0, 1, 1649559940),
(730, 54, '山西朔州经济开发区', 3, 0, 1, 1649559940),
(731, 54, '怀仁市', 3, 0, 1, 1649559940),
(732, 55, '榆次区', 3, 0, 1, 1649559940),
(733, 55, '太谷区', 3, 0, 1, 1649559940),
(734, 55, '榆社县', 3, 0, 1, 1649559940),
(735, 55, '左权县', 3, 0, 1, 1649559940),
(736, 55, '和顺县', 3, 0, 1, 1649559940),
(737, 55, '昔阳县', 3, 0, 1, 1649559940),
(738, 55, '寿阳县', 3, 0, 1, 1649559940),
(739, 55, '祁县', 3, 0, 1, 1649559940),
(740, 55, '平遥县', 3, 0, 1, 1649559940),
(741, 55, '灵石县', 3, 0, 1, 1649559940),
(742, 55, '介休市', 3, 0, 1, 1649559940),
(743, 56, '盐湖区', 3, 0, 1, 1649559940),
(744, 56, '临猗县', 3, 0, 1, 1649559940),
(745, 56, '万荣县', 3, 0, 1, 1649559940),
(746, 56, '闻喜县', 3, 0, 1, 1649559940),
(747, 56, '稷山县', 3, 0, 1, 1649559940),
(748, 56, '新绛县', 3, 0, 1, 1649559940),
(749, 56, '绛县', 3, 0, 1, 1649559940),
(750, 56, '垣曲县', 3, 0, 1, 1649559940),
(751, 56, '夏县', 3, 0, 1, 1649559940),
(752, 56, '平陆县', 3, 0, 1, 1649559940),
(753, 56, '芮城县', 3, 0, 1, 1649559940),
(754, 56, '永济市', 3, 0, 1, 1649559940),
(755, 56, '河津市', 3, 0, 1, 1649559940),
(756, 57, '忻府区', 3, 0, 1, 1649559940),
(757, 57, '定襄县', 3, 0, 1, 1649559940),
(758, 57, '五台县', 3, 0, 1, 1649559940),
(759, 57, '代县', 3, 0, 1, 1649559940),
(760, 57, '繁峙县', 3, 0, 1, 1649559940),
(761, 57, '宁武县', 3, 0, 1, 1649559940),
(762, 57, '静乐县', 3, 0, 1, 1649559940),
(763, 57, '神池县', 3, 0, 1, 1649559940),
(764, 57, '五寨县', 3, 0, 1, 1649559940),
(765, 57, '岢岚县', 3, 0, 1, 1649559940),
(766, 57, '河曲县', 3, 0, 1, 1649559940),
(767, 57, '保德县', 3, 0, 1, 1649559940),
(768, 57, '偏关县', 3, 0, 1, 1649559940),
(769, 57, '五台山风景名胜区', 3, 0, 1, 1649559940),
(770, 57, '原平市', 3, 0, 1, 1649559940),
(771, 58, '尧都区', 3, 0, 1, 1649559940),
(772, 58, '曲沃县', 3, 0, 1, 1649559940),
(773, 58, '翼城县', 3, 0, 1, 1649559940),
(774, 58, '襄汾县', 3, 0, 1, 1649559940),
(775, 58, '洪洞县', 3, 0, 1, 1649559940),
(776, 58, '古县', 3, 0, 1, 1649559940),
(777, 58, '安泽县', 3, 0, 1, 1649559940),
(778, 58, '浮山县', 3, 0, 1, 1649559940),
(779, 58, '吉县', 3, 0, 1, 1649559940),
(780, 58, '乡宁县', 3, 0, 1, 1649559940),
(781, 58, '大宁县', 3, 0, 1, 1649559940),
(782, 58, '隰县', 3, 0, 1, 1649559940),
(783, 58, '永和县', 3, 0, 1, 1649559940),
(784, 58, '蒲县', 3, 0, 1, 1649559940),
(785, 58, '汾西县', 3, 0, 1, 1649559940),
(786, 58, '侯马市', 3, 0, 1, 1649559940),
(787, 58, '霍州市', 3, 0, 1, 1649559940),
(788, 59, '离石区', 3, 0, 1, 1649559940),
(789, 59, '文水县', 3, 0, 1, 1649559940),
(790, 59, '交城县', 3, 0, 1, 1649559940),
(791, 59, '兴县', 3, 0, 1, 1649559940),
(792, 59, '临县', 3, 0, 1, 1649559940),
(793, 59, '柳林县', 3, 0, 1, 1649559940),
(794, 59, '石楼县', 3, 0, 1, 1649559940),
(795, 59, '岚县', 3, 0, 1, 1649559940),
(796, 59, '方山县', 3, 0, 1, 1649559940),
(797, 59, '中阳县', 3, 0, 1, 1649559940),
(798, 59, '交口县', 3, 0, 1, 1649559940),
(799, 59, '孝义市', 3, 0, 1, 1649559940),
(800, 59, '汾阳市', 3, 0, 1, 1649559940),
(801, 60, '新城区', 3, 0, 1, 1649559940),
(802, 60, '回民区', 3, 0, 1, 1649559940),
(803, 60, '玉泉区', 3, 0, 1, 1649559940),
(804, 60, '赛罕区', 3, 0, 1, 1649559940),
(805, 60, '土默特左旗', 3, 0, 1, 1649559940),
(806, 60, '托克托县', 3, 0, 1, 1649559940),
(807, 60, '和林格尔县', 3, 0, 1, 1649559940),
(808, 60, '清水河县', 3, 0, 1, 1649559940),
(809, 60, '武川县', 3, 0, 1, 1649559940),
(810, 60, '呼和浩特经济技术开发区', 3, 0, 1, 1649559940),
(811, 61, '东河区', 3, 0, 1, 1649559940),
(812, 61, '昆都仑区', 3, 0, 1, 1649559940),
(813, 61, '青山区', 3, 0, 1, 1649559940),
(814, 61, '石拐区', 3, 0, 1, 1649559940),
(815, 61, '白云鄂博矿区', 3, 0, 1, 1649559940),
(816, 61, '九原区', 3, 0, 1, 1649559940),
(817, 61, '土默特右旗', 3, 0, 1, 1649559940),
(818, 61, '固阳县', 3, 0, 1, 1649559940),
(819, 61, '达尔罕茂明安联合旗', 3, 0, 1, 1649559940),
(820, 61, '包头稀土高新技术产业开发区', 3, 0, 1, 1649559940),
(821, 62, '海勃湾区', 3, 0, 1, 1649559940),
(822, 62, '海南区', 3, 0, 1, 1649559940),
(823, 62, '乌达区', 3, 0, 1, 1649559940),
(824, 63, '红山区', 3, 0, 1, 1649559940),
(825, 63, '元宝山区', 3, 0, 1, 1649559940),
(826, 63, '松山区', 3, 0, 1, 1649559940),
(827, 63, '阿鲁科尔沁旗', 3, 0, 1, 1649559940),
(828, 63, '巴林左旗', 3, 0, 1, 1649559940),
(829, 63, '巴林右旗', 3, 0, 1, 1649559940),
(830, 63, '林西县', 3, 0, 1, 1649559940),
(831, 63, '克什克腾旗', 3, 0, 1, 1649559940),
(832, 63, '翁牛特旗', 3, 0, 1, 1649559940),
(833, 63, '喀喇沁旗', 3, 0, 1, 1649559940),
(834, 63, '宁城县', 3, 0, 1, 1649559940),
(835, 63, '敖汉旗', 3, 0, 1, 1649559940),
(836, 64, '科尔沁区', 3, 0, 1, 1649559940),
(837, 64, '科尔沁左翼中旗', 3, 0, 1, 1649559940),
(838, 64, '科尔沁左翼后旗', 3, 0, 1, 1649559940),
(839, 64, '开鲁县', 3, 0, 1, 1649559940),
(840, 64, '库伦旗', 3, 0, 1, 1649559940),
(841, 64, '奈曼旗', 3, 0, 1, 1649559940),
(842, 64, '扎鲁特旗', 3, 0, 1, 1649559940),
(843, 64, '通辽经济技术开发区', 3, 0, 1, 1649559940),
(844, 64, '霍林郭勒市', 3, 0, 1, 1649559940),
(845, 65, '东胜区', 3, 0, 1, 1649559940),
(846, 65, '康巴什区', 3, 0, 1, 1649559940),
(847, 65, '达拉特旗', 3, 0, 1, 1649559940),
(848, 65, '准格尔旗', 3, 0, 1, 1649559940),
(849, 65, '鄂托克前旗', 3, 0, 1, 1649559940),
(850, 65, '鄂托克旗', 3, 0, 1, 1649559940),
(851, 65, '杭锦旗', 3, 0, 1, 1649559940),
(852, 65, '乌审旗', 3, 0, 1, 1649559940),
(853, 65, '伊金霍洛旗', 3, 0, 1, 1649559940),
(854, 66, '海拉尔区', 3, 0, 1, 1649559940),
(855, 66, '扎赉诺尔区', 3, 0, 1, 1649559940),
(856, 66, '阿荣旗', 3, 0, 1, 1649559940),
(857, 66, '莫力达瓦达斡尔族自治旗', 3, 0, 1, 1649559940),
(858, 66, '鄂伦春自治旗', 3, 0, 1, 1649559940),
(859, 66, '鄂温克族自治旗', 3, 0, 1, 1649559940),
(860, 66, '陈巴尔虎旗', 3, 0, 1, 1649559940),
(861, 66, '新巴尔虎左旗', 3, 0, 1, 1649559940),
(862, 66, '新巴尔虎右旗', 3, 0, 1, 1649559940),
(863, 66, '满洲里市', 3, 0, 1, 1649559940),
(864, 66, '牙克石市', 3, 0, 1, 1649559940),
(865, 66, '扎兰屯市', 3, 0, 1, 1649559940),
(866, 66, '额尔古纳市', 3, 0, 1, 1649559940),
(867, 66, '根河市', 3, 0, 1, 1649559940),
(868, 67, '临河区', 3, 0, 1, 1649559940),
(869, 67, '五原县', 3, 0, 1, 1649559940),
(870, 67, '磴口县', 3, 0, 1, 1649559940),
(871, 67, '乌拉特前旗', 3, 0, 1, 1649559940),
(872, 67, '乌拉特中旗', 3, 0, 1, 1649559940),
(873, 67, '乌拉特后旗', 3, 0, 1, 1649559940),
(874, 67, '杭锦后旗', 3, 0, 1, 1649559940),
(875, 68, '集宁区', 3, 0, 1, 1649559940),
(876, 68, '卓资县', 3, 0, 1, 1649559940),
(877, 68, '化德县', 3, 0, 1, 1649559940),
(878, 68, '商都县', 3, 0, 1, 1649559940),
(879, 68, '兴和县', 3, 0, 1, 1649559940),
(880, 68, '凉城县', 3, 0, 1, 1649559940),
(881, 68, '察哈尔右翼前旗', 3, 0, 1, 1649559940),
(882, 68, '察哈尔右翼中旗', 3, 0, 1, 1649559940),
(883, 68, '察哈尔右翼后旗', 3, 0, 1, 1649559940),
(884, 68, '四子王旗', 3, 0, 1, 1649559940),
(885, 68, '丰镇市', 3, 0, 1, 1649559940),
(886, 69, '乌兰浩特市', 3, 0, 1, 1649559940),
(887, 69, '阿尔山市', 3, 0, 1, 1649559940),
(888, 69, '科尔沁右翼前旗', 3, 0, 1, 1649559940),
(889, 69, '科尔沁右翼中旗', 3, 0, 1, 1649559940),
(890, 69, '扎赉特旗', 3, 0, 1, 1649559940),
(891, 69, '突泉县', 3, 0, 1, 1649559940),
(892, 70, '二连浩特市', 3, 0, 1, 1649559940),
(893, 70, '锡林浩特市', 3, 0, 1, 1649559940),
(894, 70, '阿巴嘎旗', 3, 0, 1, 1649559940),
(895, 70, '苏尼特左旗', 3, 0, 1, 1649559940),
(896, 70, '苏尼特右旗', 3, 0, 1, 1649559940),
(897, 70, '东乌珠穆沁旗', 3, 0, 1, 1649559940),
(898, 70, '西乌珠穆沁旗', 3, 0, 1, 1649559940),
(899, 70, '太仆寺旗', 3, 0, 1, 1649559940),
(900, 70, '镶黄旗', 3, 0, 1, 1649559940),
(901, 70, '正镶白旗', 3, 0, 1, 1649559940),
(902, 70, '正蓝旗', 3, 0, 1, 1649559940),
(903, 70, '多伦县', 3, 0, 1, 1649559940),
(904, 70, '乌拉盖管委会', 3, 0, 1, 1649559940),
(905, 71, '阿拉善左旗', 3, 0, 1, 1649559940),
(906, 71, '阿拉善右旗', 3, 0, 1, 1649559940),
(907, 71, '额济纳旗', 3, 0, 1, 1649559940),
(908, 71, '内蒙古阿拉善高新技术产业开发区', 3, 0, 1, 1649559940),
(909, 72, '和平区', 3, 0, 1, 1649559940),
(910, 72, '沈河区', 3, 0, 1, 1649559940),
(911, 72, '大东区', 3, 0, 1, 1649559940),
(912, 72, '皇姑区', 3, 0, 1, 1649559940),
(913, 72, '铁西区', 3, 0, 1, 1649559940),
(914, 72, '苏家屯区', 3, 0, 1, 1649559940),
(915, 72, '浑南区', 3, 0, 1, 1649559940),
(916, 72, '沈北新区', 3, 0, 1, 1649559940),
(917, 72, '于洪区', 3, 0, 1, 1649559940),
(918, 72, '辽中区', 3, 0, 1, 1649559940),
(919, 72, '康平县', 3, 0, 1, 1649559940),
(920, 72, '法库县', 3, 0, 1, 1649559940),
(921, 72, '新民市', 3, 0, 1, 1649559940),
(922, 73, '中山区', 3, 0, 1, 1649559940),
(923, 73, '西岗区', 3, 0, 1, 1649559940),
(924, 73, '沙河口区', 3, 0, 1, 1649559940),
(925, 73, '甘井子区', 3, 0, 1, 1649559940),
(926, 73, '旅顺口区', 3, 0, 1, 1649559940),
(927, 73, '金州区', 3, 0, 1, 1649559940),
(928, 73, '普兰店区', 3, 0, 1, 1649559940),
(929, 73, '长海县', 3, 0, 1, 1649559940),
(930, 73, '瓦房店市', 3, 0, 1, 1649559940),
(931, 73, '庄河市', 3, 0, 1, 1649559940),
(932, 74, '铁东区', 3, 0, 1, 1649559940),
(933, 74, '铁西区', 3, 0, 1, 1649559940),
(934, 74, '立山区', 3, 0, 1, 1649559940),
(935, 74, '千山区', 3, 0, 1, 1649559940),
(936, 74, '台安县', 3, 0, 1, 1649559940),
(937, 74, '岫岩满族自治县', 3, 0, 1, 1649559940),
(938, 74, '海城市', 3, 0, 1, 1649559940),
(939, 75, '新抚区', 3, 0, 1, 1649559940),
(940, 75, '东洲区', 3, 0, 1, 1649559940),
(941, 75, '望花区', 3, 0, 1, 1649559940),
(942, 75, '顺城区', 3, 0, 1, 1649559940),
(943, 75, '抚顺县', 3, 0, 1, 1649559940),
(944, 75, '新宾满族自治县', 3, 0, 1, 1649559940),
(945, 75, '清原满族自治县', 3, 0, 1, 1649559940),
(946, 76, '平山区', 3, 0, 1, 1649559940),
(947, 76, '溪湖区', 3, 0, 1, 1649559940),
(948, 76, '明山区', 3, 0, 1, 1649559940),
(949, 76, '南芬区', 3, 0, 1, 1649559940),
(950, 76, '本溪满族自治县', 3, 0, 1, 1649559940),
(951, 76, '桓仁满族自治县', 3, 0, 1, 1649559940),
(952, 77, '元宝区', 3, 0, 1, 1649559940),
(953, 77, '振兴区', 3, 0, 1, 1649559940),
(954, 77, '振安区', 3, 0, 1, 1649559940),
(955, 77, '宽甸满族自治县', 3, 0, 1, 1649559940),
(956, 77, '东港市', 3, 0, 1, 1649559940),
(957, 77, '凤城市', 3, 0, 1, 1649559940),
(958, 78, '古塔区', 3, 0, 1, 1649559940),
(959, 78, '凌河区', 3, 0, 1, 1649559940),
(960, 78, '太和区', 3, 0, 1, 1649559940),
(961, 78, '黑山县', 3, 0, 1, 1649559940),
(962, 78, '义县', 3, 0, 1, 1649559940),
(963, 78, '凌海市', 3, 0, 1, 1649559940),
(964, 78, '北镇市', 3, 0, 1, 1649559940),
(965, 79, '站前区', 3, 0, 1, 1649559940),
(966, 79, '西市区', 3, 0, 1, 1649559940),
(967, 79, '鲅鱼圈区', 3, 0, 1, 1649559940),
(968, 79, '老边区', 3, 0, 1, 1649559940),
(969, 79, '盖州市', 3, 0, 1, 1649559940),
(970, 79, '大石桥市', 3, 0, 1, 1649559940),
(971, 80, '海州区', 3, 0, 1, 1649559940),
(972, 80, '新邱区', 3, 0, 1, 1649559940),
(973, 80, '太平区', 3, 0, 1, 1649559940),
(974, 80, '清河门区', 3, 0, 1, 1649559940),
(975, 80, '细河区', 3, 0, 1, 1649559940),
(976, 80, '阜新蒙古族自治县', 3, 0, 1, 1649559940),
(977, 80, '彰武县', 3, 0, 1, 1649559940),
(978, 81, '白塔区', 3, 0, 1, 1649559940),
(979, 81, '文圣区', 3, 0, 1, 1649559940),
(980, 81, '宏伟区', 3, 0, 1, 1649559940),
(981, 81, '弓长岭区', 3, 0, 1, 1649559940),
(982, 81, '太子河区', 3, 0, 1, 1649559940),
(983, 81, '辽阳县', 3, 0, 1, 1649559940),
(984, 81, '灯塔市', 3, 0, 1, 1649559940),
(985, 82, '双台子区', 3, 0, 1, 1649559940),
(986, 82, '兴隆台区', 3, 0, 1, 1649559940),
(987, 82, '大洼区', 3, 0, 1, 1649559940),
(988, 82, '盘山县', 3, 0, 1, 1649559940),
(989, 83, '银州区', 3, 0, 1, 1649559940),
(990, 83, '清河区', 3, 0, 1, 1649559940),
(991, 83, '铁岭县', 3, 0, 1, 1649559940),
(992, 83, '西丰县', 3, 0, 1, 1649559940),
(993, 83, '昌图县', 3, 0, 1, 1649559940),
(994, 83, '调兵山市', 3, 0, 1, 1649559940),
(995, 83, '开原市', 3, 0, 1, 1649559940),
(996, 84, '双塔区', 3, 0, 1, 1649559940),
(997, 84, '龙城区', 3, 0, 1, 1649559940),
(998, 84, '朝阳县', 3, 0, 1, 1649559940),
(999, 84, '建平县', 3, 0, 1, 1649559940),
(1000, 84, '喀喇沁左翼蒙古族自治县', 3, 0, 1, 1649559940),
(1001, 84, '北票市', 3, 0, 1, 1649559940),
(1002, 84, '凌源市', 3, 0, 1, 1649559940),
(1003, 85, '连山区', 3, 0, 1, 1649559940),
(1004, 85, '龙港区', 3, 0, 1, 1649559940),
(1005, 85, '南票区', 3, 0, 1, 1649559940),
(1006, 85, '绥中县', 3, 0, 1, 1649559940),
(1007, 85, '建昌县', 3, 0, 1, 1649559940),
(1008, 85, '兴城市', 3, 0, 1, 1649559940),
(1009, 86, '南关区', 3, 0, 1, 1649559940),
(1010, 86, '宽城区', 3, 0, 1, 1649559940),
(1011, 86, '朝阳区', 3, 0, 1, 1649559940),
(1012, 86, '二道区', 3, 0, 1, 1649559940),
(1013, 86, '绿园区', 3, 0, 1, 1649559940),
(1014, 86, '双阳区', 3, 0, 1, 1649559940),
(1015, 86, '九台区', 3, 0, 1, 1649559940),
(1016, 86, '农安县', 3, 0, 1, 1649559940),
(1017, 86, '长春经济技术开发区', 3, 0, 1, 1649559940),
(1018, 86, '长春净月高新技术产业开发区', 3, 0, 1, 1649559940),
(1019, 86, '长春高新技术产业开发区', 3, 0, 1, 1649559940),
(1020, 86, '长春汽车经济技术开发区', 3, 0, 1, 1649559940),
(1021, 86, '榆树市', 3, 0, 1, 1649559940),
(1022, 86, '德惠市', 3, 0, 1, 1649559940),
(1023, 86, '公主岭市', 3, 0, 1, 1649559940),
(1024, 87, '昌邑区', 3, 0, 1, 1649559940),
(1025, 87, '龙潭区', 3, 0, 1, 1649559940),
(1026, 87, '船营区', 3, 0, 1, 1649559940),
(1027, 87, '丰满区', 3, 0, 1, 1649559940),
(1028, 87, '永吉县', 3, 0, 1, 1649559940),
(1029, 87, '吉林经济开发区', 3, 0, 1, 1649559940),
(1030, 87, '吉林高新技术产业开发区', 3, 0, 1, 1649559940),
(1031, 87, '吉林中国新加坡食品区', 3, 0, 1, 1649559940),
(1032, 87, '蛟河市', 3, 0, 1, 1649559940),
(1033, 87, '桦甸市', 3, 0, 1, 1649559940),
(1034, 87, '舒兰市', 3, 0, 1, 1649559940),
(1035, 87, '磐石市', 3, 0, 1, 1649559940),
(1036, 88, '铁西区', 3, 0, 1, 1649559940),
(1037, 88, '铁东区', 3, 0, 1, 1649559940),
(1038, 88, '梨树县', 3, 0, 1, 1649559940),
(1039, 88, '伊通满族自治县', 3, 0, 1, 1649559940),
(1040, 88, '双辽市', 3, 0, 1, 1649559940),
(1041, 89, '龙山区', 3, 0, 1, 1649559940),
(1042, 89, '西安区', 3, 0, 1, 1649559940),
(1043, 89, '东丰县', 3, 0, 1, 1649559940),
(1044, 89, '东辽县', 3, 0, 1, 1649559940),
(1045, 90, '东昌区', 3, 0, 1, 1649559940),
(1046, 90, '二道江区', 3, 0, 1, 1649559940),
(1047, 90, '通化县', 3, 0, 1, 1649559940),
(1048, 90, '辉南县', 3, 0, 1, 1649559940),
(1049, 90, '柳河县', 3, 0, 1, 1649559940),
(1050, 90, '梅河口市', 3, 0, 1, 1649559940),
(1051, 90, '集安市', 3, 0, 1, 1649559940),
(1052, 91, '浑江区', 3, 0, 1, 1649559940),
(1053, 91, '江源区', 3, 0, 1, 1649559940),
(1054, 91, '抚松县', 3, 0, 1, 1649559940),
(1055, 91, '靖宇县', 3, 0, 1, 1649559940),
(1056, 91, '长白朝鲜族自治县', 3, 0, 1, 1649559940),
(1057, 91, '临江市', 3, 0, 1, 1649559940),
(1058, 92, '宁江区', 3, 0, 1, 1649559940),
(1059, 92, '前郭尔罗斯蒙古族自治县', 3, 0, 1, 1649559940),
(1060, 92, '长岭县', 3, 0, 1, 1649559940),
(1061, 92, '乾安县', 3, 0, 1, 1649559940),
(1062, 92, '吉林松原经济开发区', 3, 0, 1, 1649559940),
(1063, 92, '扶余市', 3, 0, 1, 1649559940),
(1064, 93, '洮北区', 3, 0, 1, 1649559940),
(1065, 93, '镇赉县', 3, 0, 1, 1649559940),
(1066, 93, '通榆县', 3, 0, 1, 1649559940),
(1067, 93, '吉林白城经济开发区', 3, 0, 1, 1649559940),
(1068, 93, '洮南市', 3, 0, 1, 1649559940),
(1069, 93, '大安市', 3, 0, 1, 1649559940),
(1070, 94, '延吉市', 3, 0, 1, 1649559940),
(1071, 94, '图们市', 3, 0, 1, 1649559940),
(1072, 94, '敦化市', 3, 0, 1, 1649559940),
(1073, 94, '珲春市', 3, 0, 1, 1649559940),
(1074, 94, '龙井市', 3, 0, 1, 1649559940),
(1075, 94, '和龙市', 3, 0, 1, 1649559940),
(1076, 94, '汪清县', 3, 0, 1, 1649559940),
(1077, 94, '安图县', 3, 0, 1, 1649559940),
(1078, 95, '道里区', 3, 0, 1, 1649559940),
(1079, 95, '南岗区', 3, 0, 1, 1649559940),
(1080, 95, '道外区', 3, 0, 1, 1649559940),
(1081, 95, '平房区', 3, 0, 1, 1649559940),
(1082, 95, '松北区', 3, 0, 1, 1649559940),
(1083, 95, '香坊区', 3, 0, 1, 1649559940),
(1084, 95, '呼兰区', 3, 0, 1, 1649559940),
(1085, 95, '阿城区', 3, 0, 1, 1649559940),
(1086, 95, '双城区', 3, 0, 1, 1649559940),
(1087, 95, '依兰县', 3, 0, 1, 1649559940),
(1088, 95, '方正县', 3, 0, 1, 1649559940),
(1089, 95, '宾县', 3, 0, 1, 1649559940),
(1090, 95, '巴彦县', 3, 0, 1, 1649559940),
(1091, 95, '木兰县', 3, 0, 1, 1649559940),
(1092, 95, '通河县', 3, 0, 1, 1649559940),
(1093, 95, '延寿县', 3, 0, 1, 1649559940),
(1094, 95, '尚志市', 3, 0, 1, 1649559940),
(1095, 95, '五常市', 3, 0, 1, 1649559940),
(1096, 96, '龙沙区', 3, 0, 1, 1649559940),
(1097, 96, '建华区', 3, 0, 1, 1649559940),
(1098, 96, '铁锋区', 3, 0, 1, 1649559940),
(1099, 96, '昂昂溪区', 3, 0, 1, 1649559940),
(1100, 96, '富拉尔基区', 3, 0, 1, 1649559940),
(1101, 96, '碾子山区', 3, 0, 1, 1649559940),
(1102, 96, '梅里斯达斡尔族区', 3, 0, 1, 1649559940),
(1103, 96, '龙江县', 3, 0, 1, 1649559940),
(1104, 96, '依安县', 3, 0, 1, 1649559940),
(1105, 96, '泰来县', 3, 0, 1, 1649559940),
(1106, 96, '甘南县', 3, 0, 1, 1649559940),
(1107, 96, '富裕县', 3, 0, 1, 1649559940),
(1108, 96, '克山县', 3, 0, 1, 1649559940),
(1109, 96, '克东县', 3, 0, 1, 1649559940),
(1110, 96, '拜泉县', 3, 0, 1, 1649559940),
(1111, 96, '讷河市', 3, 0, 1, 1649559940),
(1112, 97, '鸡冠区', 3, 0, 1, 1649559940),
(1113, 97, '恒山区', 3, 0, 1, 1649559940),
(1114, 97, '滴道区', 3, 0, 1, 1649559940),
(1115, 97, '梨树区', 3, 0, 1, 1649559940),
(1116, 97, '城子河区', 3, 0, 1, 1649559940),
(1117, 97, '麻山区', 3, 0, 1, 1649559940),
(1118, 97, '鸡东县', 3, 0, 1, 1649559940),
(1119, 97, '虎林市', 3, 0, 1, 1649559940),
(1120, 97, '密山市', 3, 0, 1, 1649559940),
(1121, 98, '向阳区', 3, 0, 1, 1649559940),
(1122, 98, '工农区', 3, 0, 1, 1649559940),
(1123, 98, '南山区', 3, 0, 1, 1649559940),
(1124, 98, '兴安区', 3, 0, 1, 1649559940),
(1125, 98, '东山区', 3, 0, 1, 1649559940),
(1126, 98, '兴山区', 3, 0, 1, 1649559940),
(1127, 98, '萝北县', 3, 0, 1, 1649559940),
(1128, 98, '绥滨县', 3, 0, 1, 1649559940),
(1129, 99, '尖山区', 3, 0, 1, 1649559940),
(1130, 99, '岭东区', 3, 0, 1, 1649559940),
(1131, 99, '四方台区', 3, 0, 1, 1649559940),
(1132, 99, '宝山区', 3, 0, 1, 1649559940),
(1133, 99, '集贤县', 3, 0, 1, 1649559940),
(1134, 99, '友谊县', 3, 0, 1, 1649559940),
(1135, 99, '宝清县', 3, 0, 1, 1649559940),
(1136, 99, '饶河县', 3, 0, 1, 1649559940),
(1137, 100, '萨尔图区', 3, 0, 1, 1649559940),
(1138, 100, '龙凤区', 3, 0, 1, 1649559940),
(1139, 100, '让胡路区', 3, 0, 1, 1649559940),
(1140, 100, '红岗区', 3, 0, 1, 1649559940),
(1141, 100, '大同区', 3, 0, 1, 1649559940),
(1142, 100, '肇州县', 3, 0, 1, 1649559940),
(1143, 100, '肇源县', 3, 0, 1, 1649559940),
(1144, 100, '林甸县', 3, 0, 1, 1649559940),
(1145, 100, '杜尔伯特蒙古族自治县', 3, 0, 1, 1649559940),
(1146, 100, '大庆高新技术产业开发区', 3, 0, 1, 1649559940),
(1147, 101, '伊美区', 3, 0, 1, 1649559940),
(1148, 101, '乌翠区', 3, 0, 1, 1649559940),
(1149, 101, '友好区', 3, 0, 1, 1649559940),
(1150, 101, '嘉荫县', 3, 0, 1, 1649559940),
(1151, 101, '汤旺县', 3, 0, 1, 1649559940),
(1152, 101, '丰林县', 3, 0, 1, 1649559940),
(1153, 101, '大箐山县', 3, 0, 1, 1649559940),
(1154, 101, '南岔县', 3, 0, 1, 1649559940),
(1155, 101, '金林区', 3, 0, 1, 1649559940),
(1156, 101, '铁力市', 3, 0, 1, 1649559940),
(1157, 102, '向阳区', 3, 0, 1, 1649559940),
(1158, 102, '前进区', 3, 0, 1, 1649559940),
(1159, 102, '东风区', 3, 0, 1, 1649559940),
(1160, 102, '郊区', 3, 0, 1, 1649559940),
(1161, 102, '桦南县', 3, 0, 1, 1649559940),
(1162, 102, '桦川县', 3, 0, 1, 1649559940),
(1163, 102, '汤原县', 3, 0, 1, 1649559940),
(1164, 102, '同江市', 3, 0, 1, 1649559940),
(1165, 102, '富锦市', 3, 0, 1, 1649559940),
(1166, 102, '抚远市', 3, 0, 1, 1649559940),
(1167, 103, '新兴区', 3, 0, 1, 1649559940),
(1168, 103, '桃山区', 3, 0, 1, 1649559940),
(1169, 103, '茄子河区', 3, 0, 1, 1649559940),
(1170, 103, '勃利县', 3, 0, 1, 1649559940),
(1171, 104, '东安区', 3, 0, 1, 1649559940),
(1172, 104, '阳明区', 3, 0, 1, 1649559940),
(1173, 104, '爱民区', 3, 0, 1, 1649559940),
(1174, 104, '西安区', 3, 0, 1, 1649559940),
(1175, 104, '林口县', 3, 0, 1, 1649559940),
(1176, 104, '牡丹江经济技术开发区', 3, 0, 1, 1649559940),
(1177, 104, '绥芬河市', 3, 0, 1, 1649559940),
(1178, 104, '海林市', 3, 0, 1, 1649559940),
(1179, 104, '宁安市', 3, 0, 1, 1649559940),
(1180, 104, '穆棱市', 3, 0, 1, 1649559940),
(1181, 104, '东宁市', 3, 0, 1, 1649559940),
(1182, 105, '爱辉区', 3, 0, 1, 1649559940),
(1183, 105, '逊克县', 3, 0, 1, 1649559940),
(1184, 105, '孙吴县', 3, 0, 1, 1649559940),
(1185, 105, '北安市', 3, 0, 1, 1649559940),
(1186, 105, '五大连池市', 3, 0, 1, 1649559940),
(1187, 105, '嫩江市', 3, 0, 1, 1649559940),
(1188, 106, '北林区', 3, 0, 1, 1649559940),
(1189, 106, '望奎县', 3, 0, 1, 1649559940),
(1190, 106, '兰西县', 3, 0, 1, 1649559940),
(1191, 106, '青冈县', 3, 0, 1, 1649559940),
(1192, 106, '庆安县', 3, 0, 1, 1649559940),
(1193, 106, '明水县', 3, 0, 1, 1649559940),
(1194, 106, '绥棱县', 3, 0, 1, 1649559940),
(1195, 106, '安达市', 3, 0, 1, 1649559940),
(1196, 106, '肇东市', 3, 0, 1, 1649559940),
(1197, 106, '海伦市', 3, 0, 1, 1649559940),
(1198, 107, '漠河市', 3, 0, 1, 1649559940),
(1199, 107, '呼玛县', 3, 0, 1, 1649559940),
(1200, 107, '塔河县', 3, 0, 1, 1649559940),
(1201, 107, '加格达奇区', 3, 0, 1, 1649559940),
(1202, 107, '松岭区', 3, 0, 1, 1649559940),
(1203, 107, '新林区', 3, 0, 1, 1649559940),
(1204, 107, '呼中区', 3, 0, 1, 1649559940),
(1205, 108, '黄浦区', 3, 0, 1, 1649559940),
(1206, 108, '徐汇区', 3, 0, 1, 1649559940),
(1207, 108, '长宁区', 3, 0, 1, 1649559940),
(1208, 108, '静安区', 3, 0, 1, 1649559940),
(1209, 108, '普陀区', 3, 0, 1, 1649559940),
(1210, 108, '虹口区', 3, 0, 1, 1649559940),
(1211, 108, '杨浦区', 3, 0, 1, 1649559940),
(1212, 108, '闵行区', 3, 0, 1, 1649559940),
(1213, 108, '宝山区', 3, 0, 1, 1649559940),
(1214, 108, '嘉定区', 3, 0, 1, 1649559940),
(1215, 108, '浦东新区', 3, 0, 1, 1649559940),
(1216, 108, '金山区', 3, 0, 1, 1649559940),
(1217, 108, '松江区', 3, 0, 1, 1649559940),
(1218, 108, '青浦区', 3, 0, 1, 1649559940),
(1219, 108, '奉贤区', 3, 0, 1, 1649559940),
(1220, 108, '崇明区', 3, 0, 1, 1649559940),
(1221, 109, '玄武区', 3, 0, 1, 1649559940),
(1222, 109, '秦淮区', 3, 0, 1, 1649559940),
(1223, 109, '建邺区', 3, 0, 1, 1649559940),
(1224, 109, '鼓楼区', 3, 0, 1, 1649559940),
(1225, 109, '浦口区', 3, 0, 1, 1649559940),
(1226, 109, '栖霞区', 3, 0, 1, 1649559940),
(1227, 109, '雨花台区', 3, 0, 1, 1649559940),
(1228, 109, '江宁区', 3, 0, 1, 1649559940),
(1229, 109, '六合区', 3, 0, 1, 1649559940),
(1230, 109, '溧水区', 3, 0, 1, 1649559940),
(1231, 109, '高淳区', 3, 0, 1, 1649559940),
(1232, 110, '锡山区', 3, 0, 1, 1649559940),
(1233, 110, '惠山区', 3, 0, 1, 1649559940),
(1234, 110, '滨湖区', 3, 0, 1, 1649559940),
(1235, 110, '梁溪区', 3, 0, 1, 1649559940),
(1236, 110, '新吴区', 3, 0, 1, 1649559940),
(1237, 110, '江阴市', 3, 0, 1, 1649559940),
(1238, 110, '宜兴市', 3, 0, 1, 1649559940),
(1239, 111, '鼓楼区', 3, 0, 1, 1649559940),
(1240, 111, '云龙区', 3, 0, 1, 1649559940),
(1241, 111, '贾汪区', 3, 0, 1, 1649559940),
(1242, 111, '泉山区', 3, 0, 1, 1649559940),
(1243, 111, '铜山区', 3, 0, 1, 1649559940),
(1244, 111, '丰县', 3, 0, 1, 1649559940),
(1245, 111, '沛县', 3, 0, 1, 1649559940),
(1246, 111, '睢宁县', 3, 0, 1, 1649559940),
(1247, 111, '徐州经济技术开发区', 3, 0, 1, 1649559940),
(1248, 111, '新沂市', 3, 0, 1, 1649559940),
(1249, 111, '邳州市', 3, 0, 1, 1649559940),
(1250, 112, '天宁区', 3, 0, 1, 1649559940),
(1251, 112, '钟楼区', 3, 0, 1, 1649559940),
(1252, 112, '新北区', 3, 0, 1, 1649559940),
(1253, 112, '武进区', 3, 0, 1, 1649559940),
(1254, 112, '金坛区', 3, 0, 1, 1649559940),
(1255, 112, '溧阳市', 3, 0, 1, 1649559940),
(1256, 113, '虎丘区', 3, 0, 1, 1649559940),
(1257, 113, '吴中区', 3, 0, 1, 1649559940),
(1258, 113, '相城区', 3, 0, 1, 1649559940),
(1259, 113, '姑苏区', 3, 0, 1, 1649559940),
(1260, 113, '吴江区', 3, 0, 1, 1649559940),
(1261, 113, '苏州工业园区', 3, 0, 1, 1649559940),
(1262, 113, '常熟市', 3, 0, 1, 1649559940),
(1263, 113, '张家港市', 3, 0, 1, 1649559940),
(1264, 113, '昆山市', 3, 0, 1, 1649559940),
(1265, 113, '太仓市', 3, 0, 1, 1649559940),
(1266, 114, '通州区', 3, 0, 1, 1649559940),
(1267, 114, '崇川区', 3, 0, 1, 1649559940),
(1268, 114, '海门区', 3, 0, 1, 1649559940),
(1269, 114, '如东县', 3, 0, 1, 1649559940),
(1270, 114, '南通经济技术开发区', 3, 0, 1, 1649559940),
(1271, 114, '启东市', 3, 0, 1, 1649559940),
(1272, 114, '如皋市', 3, 0, 1, 1649559940),
(1273, 114, '海安市', 3, 0, 1, 1649559940),
(1274, 115, '连云区', 3, 0, 1, 1649559940),
(1275, 115, '海州区', 3, 0, 1, 1649559940),
(1276, 115, '赣榆区', 3, 0, 1, 1649559940),
(1277, 115, '东海县', 3, 0, 1, 1649559940),
(1278, 115, '灌云县', 3, 0, 1, 1649559940),
(1279, 115, '灌南县', 3, 0, 1, 1649559940),
(1280, 115, '连云港经济技术开发区', 3, 0, 1, 1649559940),
(1281, 115, '连云港高新技术产业开发区', 3, 0, 1, 1649559940),
(1282, 116, '淮安区', 3, 0, 1, 1649559940),
(1283, 116, '淮阴区', 3, 0, 1, 1649559940),
(1284, 116, '清江浦区', 3, 0, 1, 1649559940),
(1285, 116, '洪泽区', 3, 0, 1, 1649559940),
(1286, 116, '涟水县', 3, 0, 1, 1649559940),
(1287, 116, '盱眙县', 3, 0, 1, 1649559940),
(1288, 116, '金湖县', 3, 0, 1, 1649559940),
(1289, 116, '淮安经济技术开发区', 3, 0, 1, 1649559940),
(1290, 117, '亭湖区', 3, 0, 1, 1649559940),
(1291, 117, '盐都区', 3, 0, 1, 1649559940),
(1292, 117, '大丰区', 3, 0, 1, 1649559940),
(1293, 117, '响水县', 3, 0, 1, 1649559940),
(1294, 117, '滨海县', 3, 0, 1, 1649559940),
(1295, 117, '阜宁县', 3, 0, 1, 1649559940),
(1296, 117, '射阳县', 3, 0, 1, 1649559940),
(1297, 117, '建湖县', 3, 0, 1, 1649559940),
(1298, 117, '盐城经济技术开发区', 3, 0, 1, 1649559940),
(1299, 117, '东台市', 3, 0, 1, 1649559940),
(1300, 118, '广陵区', 3, 0, 1, 1649559940),
(1301, 118, '邗江区', 3, 0, 1, 1649559940),
(1302, 118, '江都区', 3, 0, 1, 1649559940),
(1303, 118, '宝应县', 3, 0, 1, 1649559940),
(1304, 118, '扬州经济技术开发区', 3, 0, 1, 1649559940),
(1305, 118, '仪征市', 3, 0, 1, 1649559940),
(1306, 118, '高邮市', 3, 0, 1, 1649559940),
(1307, 119, '京口区', 3, 0, 1, 1649559940),
(1308, 119, '润州区', 3, 0, 1, 1649559940),
(1309, 119, '丹徒区', 3, 0, 1, 1649559940),
(1310, 119, '镇江新区', 3, 0, 1, 1649559940),
(1311, 119, '丹阳市', 3, 0, 1, 1649559940),
(1312, 119, '扬中市', 3, 0, 1, 1649559940),
(1313, 119, '句容市', 3, 0, 1, 1649559940),
(1314, 120, '海陵区', 3, 0, 1, 1649559940),
(1315, 120, '高港区', 3, 0, 1, 1649559940),
(1316, 120, '姜堰区', 3, 0, 1, 1649559940),
(1317, 120, '泰州医药高新技术产业开发区', 3, 0, 1, 1649559940);
INSERT INTO `mall_region` (`id`, `pid`, `name`, `level`, `sort`, `status`, `create_time`) VALUES
(1318, 120, '兴化市', 3, 0, 1, 1649559940),
(1319, 120, '靖江市', 3, 0, 1, 1649559940),
(1320, 120, '泰兴市', 3, 0, 1, 1649559940),
(1321, 121, '宿城区', 3, 0, 1, 1649559940),
(1322, 121, '宿豫区', 3, 0, 1, 1649559940),
(1323, 121, '沭阳县', 3, 0, 1, 1649559940),
(1324, 121, '泗阳县', 3, 0, 1, 1649559940),
(1325, 121, '泗洪县', 3, 0, 1, 1649559940),
(1326, 121, '宿迁经济技术开发区', 3, 0, 1, 1649559940),
(1327, 122, '上城区', 3, 0, 1, 1649559940),
(1328, 122, '拱墅区', 3, 0, 1, 1649559940),
(1329, 122, '西湖区', 3, 0, 1, 1649559940),
(1330, 122, '滨江区', 3, 0, 1, 1649559940),
(1331, 122, '萧山区', 3, 0, 1, 1649559940),
(1332, 122, '余杭区', 3, 0, 1, 1649559940),
(1333, 122, '富阳区', 3, 0, 1, 1649559940),
(1334, 122, '临安区', 3, 0, 1, 1649559940),
(1335, 122, '临平区', 3, 0, 1, 1649559940),
(1336, 122, '钱塘区', 3, 0, 1, 1649559940),
(1337, 122, '桐庐县', 3, 0, 1, 1649559940),
(1338, 122, '淳安县', 3, 0, 1, 1649559940),
(1339, 122, '建德市', 3, 0, 1, 1649559940),
(1340, 123, '海曙区', 3, 0, 1, 1649559940),
(1341, 123, '江北区', 3, 0, 1, 1649559940),
(1342, 123, '北仑区', 3, 0, 1, 1649559940),
(1343, 123, '镇海区', 3, 0, 1, 1649559940),
(1344, 123, '鄞州区', 3, 0, 1, 1649559940),
(1345, 123, '奉化区', 3, 0, 1, 1649559940),
(1346, 123, '象山县', 3, 0, 1, 1649559940),
(1347, 123, '宁海县', 3, 0, 1, 1649559940),
(1348, 123, '余姚市', 3, 0, 1, 1649559940),
(1349, 123, '慈溪市', 3, 0, 1, 1649559940),
(1350, 124, '鹿城区', 3, 0, 1, 1649559940),
(1351, 124, '龙湾区', 3, 0, 1, 1649559940),
(1352, 124, '瓯海区', 3, 0, 1, 1649559940),
(1353, 124, '洞头区', 3, 0, 1, 1649559940),
(1354, 124, '永嘉县', 3, 0, 1, 1649559940),
(1355, 124, '平阳县', 3, 0, 1, 1649559940),
(1356, 124, '苍南县', 3, 0, 1, 1649559940),
(1357, 124, '文成县', 3, 0, 1, 1649559940),
(1358, 124, '泰顺县', 3, 0, 1, 1649559940),
(1359, 124, '温州经济技术开发区', 3, 0, 1, 1649559940),
(1360, 124, '瑞安市', 3, 0, 1, 1649559940),
(1361, 124, '乐清市', 3, 0, 1, 1649559940),
(1362, 124, '龙港市', 3, 0, 1, 1649559940),
(1363, 125, '南湖区', 3, 0, 1, 1649559940),
(1364, 125, '秀洲区', 3, 0, 1, 1649559940),
(1365, 125, '嘉善县', 3, 0, 1, 1649559940),
(1366, 125, '海盐县', 3, 0, 1, 1649559940),
(1367, 125, '海宁市', 3, 0, 1, 1649559940),
(1368, 125, '平湖市', 3, 0, 1, 1649559940),
(1369, 125, '桐乡市', 3, 0, 1, 1649559940),
(1370, 126, '吴兴区', 3, 0, 1, 1649559940),
(1371, 126, '南浔区', 3, 0, 1, 1649559940),
(1372, 126, '德清县', 3, 0, 1, 1649559940),
(1373, 126, '长兴县', 3, 0, 1, 1649559940),
(1374, 126, '安吉县', 3, 0, 1, 1649559940),
(1375, 127, '越城区', 3, 0, 1, 1649559940),
(1376, 127, '柯桥区', 3, 0, 1, 1649559940),
(1377, 127, '上虞区', 3, 0, 1, 1649559940),
(1378, 127, '新昌县', 3, 0, 1, 1649559940),
(1379, 127, '诸暨市', 3, 0, 1, 1649559940),
(1380, 127, '嵊州市', 3, 0, 1, 1649559940),
(1381, 128, '婺城区', 3, 0, 1, 1649559940),
(1382, 128, '金东区', 3, 0, 1, 1649559940),
(1383, 128, '武义县', 3, 0, 1, 1649559940),
(1384, 128, '浦江县', 3, 0, 1, 1649559940),
(1385, 128, '磐安县', 3, 0, 1, 1649559940),
(1386, 128, '兰溪市', 3, 0, 1, 1649559940),
(1387, 128, '义乌市', 3, 0, 1, 1649559940),
(1388, 128, '东阳市', 3, 0, 1, 1649559940),
(1389, 128, '永康市', 3, 0, 1, 1649559940),
(1390, 129, '柯城区', 3, 0, 1, 1649559940),
(1391, 129, '衢江区', 3, 0, 1, 1649559940),
(1392, 129, '常山县', 3, 0, 1, 1649559940),
(1393, 129, '开化县', 3, 0, 1, 1649559940),
(1394, 129, '龙游县', 3, 0, 1, 1649559940),
(1395, 129, '江山市', 3, 0, 1, 1649559940),
(1396, 130, '定海区', 3, 0, 1, 1649559940),
(1397, 130, '普陀区', 3, 0, 1, 1649559940),
(1398, 130, '岱山县', 3, 0, 1, 1649559940),
(1399, 130, '嵊泗县', 3, 0, 1, 1649559940),
(1400, 131, '椒江区', 3, 0, 1, 1649559940),
(1401, 131, '黄岩区', 3, 0, 1, 1649559940),
(1402, 131, '路桥区', 3, 0, 1, 1649559940),
(1403, 131, '三门县', 3, 0, 1, 1649559940),
(1404, 131, '天台县', 3, 0, 1, 1649559940),
(1405, 131, '仙居县', 3, 0, 1, 1649559940),
(1406, 131, '温岭市', 3, 0, 1, 1649559940),
(1407, 131, '临海市', 3, 0, 1, 1649559940),
(1408, 131, '玉环市', 3, 0, 1, 1649559940),
(1409, 132, '莲都区', 3, 0, 1, 1649559940),
(1410, 132, '青田县', 3, 0, 1, 1649559940),
(1411, 132, '缙云县', 3, 0, 1, 1649559940),
(1412, 132, '遂昌县', 3, 0, 1, 1649559940),
(1413, 132, '松阳县', 3, 0, 1, 1649559940),
(1414, 132, '云和县', 3, 0, 1, 1649559940),
(1415, 132, '庆元县', 3, 0, 1, 1649559940),
(1416, 132, '景宁畲族自治县', 3, 0, 1, 1649559940),
(1417, 132, '龙泉市', 3, 0, 1, 1649559940),
(1418, 133, '瑶海区', 3, 0, 1, 1649559940),
(1419, 133, '庐阳区', 3, 0, 1, 1649559940),
(1420, 133, '蜀山区', 3, 0, 1, 1649559940),
(1421, 133, '包河区', 3, 0, 1, 1649559940),
(1422, 133, '长丰县', 3, 0, 1, 1649559940),
(1423, 133, '肥东县', 3, 0, 1, 1649559940),
(1424, 133, '肥西县', 3, 0, 1, 1649559940),
(1425, 133, '庐江县', 3, 0, 1, 1649559940),
(1426, 133, '合肥高新技术产业开发区', 3, 0, 1, 1649559940),
(1427, 133, '合肥经济技术开发区', 3, 0, 1, 1649559940),
(1428, 133, '合肥新站高新技术产业开发区', 3, 0, 1, 1649559940),
(1429, 133, '巢湖市', 3, 0, 1, 1649559940),
(1430, 134, '镜湖区', 3, 0, 1, 1649559940),
(1431, 134, '鸠江区', 3, 0, 1, 1649559940),
(1432, 134, '弋江区', 3, 0, 1, 1649559940),
(1433, 134, '湾沚区', 3, 0, 1, 1649559940),
(1434, 134, '繁昌区', 3, 0, 1, 1649559940),
(1435, 134, '南陵县', 3, 0, 1, 1649559940),
(1436, 134, '芜湖经济技术开发区', 3, 0, 1, 1649559940),
(1437, 134, '安徽芜湖三山经济开发区', 3, 0, 1, 1649559940),
(1438, 134, '无为市', 3, 0, 1, 1649559940),
(1439, 135, '龙子湖区', 3, 0, 1, 1649559940),
(1440, 135, '蚌山区', 3, 0, 1, 1649559940),
(1441, 135, '禹会区', 3, 0, 1, 1649559940),
(1442, 135, '淮上区', 3, 0, 1, 1649559940),
(1443, 135, '怀远县', 3, 0, 1, 1649559940),
(1444, 135, '五河县', 3, 0, 1, 1649559940),
(1445, 135, '固镇县', 3, 0, 1, 1649559940),
(1446, 135, '蚌埠市高新技术开发区', 3, 0, 1, 1649559940),
(1447, 135, '蚌埠市经济开发区', 3, 0, 1, 1649559940),
(1448, 136, '大通区', 3, 0, 1, 1649559940),
(1449, 136, '田家庵区', 3, 0, 1, 1649559940),
(1450, 136, '谢家集区', 3, 0, 1, 1649559940),
(1451, 136, '八公山区', 3, 0, 1, 1649559940),
(1452, 136, '潘集区', 3, 0, 1, 1649559940),
(1453, 136, '凤台县', 3, 0, 1, 1649559940),
(1454, 136, '寿县', 3, 0, 1, 1649559940),
(1455, 137, '花山区', 3, 0, 1, 1649559940),
(1456, 137, '雨山区', 3, 0, 1, 1649559940),
(1457, 137, '博望区', 3, 0, 1, 1649559940),
(1458, 137, '当涂县', 3, 0, 1, 1649559940),
(1459, 137, '含山县', 3, 0, 1, 1649559940),
(1460, 137, '和县', 3, 0, 1, 1649559940),
(1461, 138, '杜集区', 3, 0, 1, 1649559940),
(1462, 138, '相山区', 3, 0, 1, 1649559940),
(1463, 138, '烈山区', 3, 0, 1, 1649559940),
(1464, 138, '濉溪县', 3, 0, 1, 1649559940),
(1465, 139, '铜官区', 3, 0, 1, 1649559940),
(1466, 139, '义安区', 3, 0, 1, 1649559940),
(1467, 139, '郊区', 3, 0, 1, 1649559940),
(1468, 139, '枞阳县', 3, 0, 1, 1649559940),
(1469, 140, '迎江区', 3, 0, 1, 1649559940),
(1470, 140, '大观区', 3, 0, 1, 1649559940),
(1471, 140, '宜秀区', 3, 0, 1, 1649559940),
(1472, 140, '怀宁县', 3, 0, 1, 1649559940),
(1473, 140, '太湖县', 3, 0, 1, 1649559940),
(1474, 140, '宿松县', 3, 0, 1, 1649559940),
(1475, 140, '望江县', 3, 0, 1, 1649559940),
(1476, 140, '岳西县', 3, 0, 1, 1649559940),
(1477, 140, '安徽安庆经济开发区', 3, 0, 1, 1649559940),
(1478, 140, '桐城市', 3, 0, 1, 1649559940),
(1479, 140, '潜山市', 3, 0, 1, 1649559940),
(1480, 141, '屯溪区', 3, 0, 1, 1649559940),
(1481, 141, '黄山区', 3, 0, 1, 1649559940),
(1482, 141, '徽州区', 3, 0, 1, 1649559940),
(1483, 141, '歙县', 3, 0, 1, 1649559940),
(1484, 141, '休宁县', 3, 0, 1, 1649559940),
(1485, 141, '黟县', 3, 0, 1, 1649559940),
(1486, 141, '祁门县', 3, 0, 1, 1649559940),
(1487, 142, '琅琊区', 3, 0, 1, 1649559940),
(1488, 142, '南谯区', 3, 0, 1, 1649559940),
(1489, 142, '来安县', 3, 0, 1, 1649559940),
(1490, 142, '全椒县', 3, 0, 1, 1649559940),
(1491, 142, '定远县', 3, 0, 1, 1649559940),
(1492, 142, '凤阳县', 3, 0, 1, 1649559940),
(1493, 142, '中新苏滁高新技术产业开发区', 3, 0, 1, 1649559940),
(1494, 142, '滁州经济技术开发区', 3, 0, 1, 1649559940),
(1495, 142, '天长市', 3, 0, 1, 1649559940),
(1496, 142, '明光市', 3, 0, 1, 1649559940),
(1497, 143, '颍州区', 3, 0, 1, 1649559940),
(1498, 143, '颍东区', 3, 0, 1, 1649559940),
(1499, 143, '颍泉区', 3, 0, 1, 1649559940),
(1500, 143, '临泉县', 3, 0, 1, 1649559940),
(1501, 143, '太和县', 3, 0, 1, 1649559940),
(1502, 143, '阜南县', 3, 0, 1, 1649559940),
(1503, 143, '颍上县', 3, 0, 1, 1649559940),
(1504, 143, '阜阳合肥现代产业园区', 3, 0, 1, 1649559940),
(1505, 143, '阜阳经济技术开发区', 3, 0, 1, 1649559940),
(1506, 143, '界首市', 3, 0, 1, 1649559940),
(1507, 144, '埇桥区', 3, 0, 1, 1649559940),
(1508, 144, '砀山县', 3, 0, 1, 1649559940),
(1509, 144, '萧县', 3, 0, 1, 1649559940),
(1510, 144, '灵璧县', 3, 0, 1, 1649559940),
(1511, 144, '泗县', 3, 0, 1, 1649559940),
(1512, 144, '宿州马鞍山现代产业园区', 3, 0, 1, 1649559940),
(1513, 144, '宿州经济技术开发区', 3, 0, 1, 1649559940),
(1514, 145, '金安区', 3, 0, 1, 1649559940),
(1515, 145, '裕安区', 3, 0, 1, 1649559940),
(1516, 145, '叶集区', 3, 0, 1, 1649559940),
(1517, 145, '霍邱县', 3, 0, 1, 1649559940),
(1518, 145, '舒城县', 3, 0, 1, 1649559940),
(1519, 145, '金寨县', 3, 0, 1, 1649559940),
(1520, 145, '霍山县', 3, 0, 1, 1649559941),
(1521, 146, '谯城区', 3, 0, 1, 1649559941),
(1522, 146, '涡阳县', 3, 0, 1, 1649559941),
(1523, 146, '蒙城县', 3, 0, 1, 1649559941),
(1524, 146, '利辛县', 3, 0, 1, 1649559941),
(1525, 147, '贵池区', 3, 0, 1, 1649559941),
(1526, 147, '东至县', 3, 0, 1, 1649559941),
(1527, 147, '石台县', 3, 0, 1, 1649559941),
(1528, 147, '青阳县', 3, 0, 1, 1649559941),
(1529, 148, '宣州区', 3, 0, 1, 1649559941),
(1530, 148, '郎溪县', 3, 0, 1, 1649559941),
(1531, 148, '泾县', 3, 0, 1, 1649559941),
(1532, 148, '绩溪县', 3, 0, 1, 1649559941),
(1533, 148, '旌德县', 3, 0, 1, 1649559941),
(1534, 148, '宣城市经济开发区', 3, 0, 1, 1649559941),
(1535, 148, '宁国市', 3, 0, 1, 1649559941),
(1536, 148, '广德市', 3, 0, 1, 1649559941),
(1537, 149, '鼓楼区', 3, 0, 1, 1649559941),
(1538, 149, '台江区', 3, 0, 1, 1649559941),
(1539, 149, '仓山区', 3, 0, 1, 1649559941),
(1540, 149, '马尾区', 3, 0, 1, 1649559941),
(1541, 149, '晋安区', 3, 0, 1, 1649559941),
(1542, 149, '长乐区', 3, 0, 1, 1649559941),
(1543, 149, '闽侯县', 3, 0, 1, 1649559941),
(1544, 149, '连江县', 3, 0, 1, 1649559941),
(1545, 149, '罗源县', 3, 0, 1, 1649559941),
(1546, 149, '闽清县', 3, 0, 1, 1649559941),
(1547, 149, '永泰县', 3, 0, 1, 1649559941),
(1548, 149, '平潭县', 3, 0, 1, 1649559941),
(1549, 149, '福清市', 3, 0, 1, 1649559941),
(1550, 150, '思明区', 3, 0, 1, 1649559941),
(1551, 150, '海沧区', 3, 0, 1, 1649559941),
(1552, 150, '湖里区', 3, 0, 1, 1649559941),
(1553, 150, '集美区', 3, 0, 1, 1649559941),
(1554, 150, '同安区', 3, 0, 1, 1649559941),
(1555, 150, '翔安区', 3, 0, 1, 1649559941),
(1556, 151, '城厢区', 3, 0, 1, 1649559941),
(1557, 151, '涵江区', 3, 0, 1, 1649559941),
(1558, 151, '荔城区', 3, 0, 1, 1649559941),
(1559, 151, '秀屿区', 3, 0, 1, 1649559941),
(1560, 151, '仙游县', 3, 0, 1, 1649559941),
(1561, 152, '三元区', 3, 0, 1, 1649559941),
(1562, 152, '沙县区', 3, 0, 1, 1649559941),
(1563, 152, '明溪县', 3, 0, 1, 1649559941),
(1564, 152, '清流县', 3, 0, 1, 1649559941),
(1565, 152, '宁化县', 3, 0, 1, 1649559941),
(1566, 152, '大田县', 3, 0, 1, 1649559941),
(1567, 152, '尤溪县', 3, 0, 1, 1649559941),
(1568, 152, '将乐县', 3, 0, 1, 1649559941),
(1569, 152, '泰宁县', 3, 0, 1, 1649559941),
(1570, 152, '建宁县', 3, 0, 1, 1649559941),
(1571, 152, '永安市', 3, 0, 1, 1649559941),
(1572, 153, '鲤城区', 3, 0, 1, 1649559941),
(1573, 153, '丰泽区', 3, 0, 1, 1649559941),
(1574, 153, '洛江区', 3, 0, 1, 1649559941),
(1575, 153, '泉港区', 3, 0, 1, 1649559941),
(1576, 153, '惠安县', 3, 0, 1, 1649559941),
(1577, 153, '安溪县', 3, 0, 1, 1649559941),
(1578, 153, '永春县', 3, 0, 1, 1649559941),
(1579, 153, '德化县', 3, 0, 1, 1649559941),
(1580, 153, '金门县', 3, 0, 1, 1649559941),
(1581, 153, '石狮市', 3, 0, 1, 1649559941),
(1582, 153, '晋江市', 3, 0, 1, 1649559941),
(1583, 153, '南安市', 3, 0, 1, 1649559941),
(1584, 154, '芗城区', 3, 0, 1, 1649559941),
(1585, 154, '龙文区', 3, 0, 1, 1649559941),
(1586, 154, '龙海区', 3, 0, 1, 1649559941),
(1587, 154, '长泰区', 3, 0, 1, 1649559941),
(1588, 154, '云霄县', 3, 0, 1, 1649559941),
(1589, 154, '漳浦县', 3, 0, 1, 1649559941),
(1590, 154, '诏安县', 3, 0, 1, 1649559941),
(1591, 154, '东山县', 3, 0, 1, 1649559941),
(1592, 154, '南靖县', 3, 0, 1, 1649559941),
(1593, 154, '平和县', 3, 0, 1, 1649559941),
(1594, 154, '华安县', 3, 0, 1, 1649559941),
(1595, 155, '延平区', 3, 0, 1, 1649559941),
(1596, 155, '建阳区', 3, 0, 1, 1649559941),
(1597, 155, '顺昌县', 3, 0, 1, 1649559941),
(1598, 155, '浦城县', 3, 0, 1, 1649559941),
(1599, 155, '光泽县', 3, 0, 1, 1649559941),
(1600, 155, '松溪县', 3, 0, 1, 1649559941),
(1601, 155, '政和县', 3, 0, 1, 1649559941),
(1602, 155, '邵武市', 3, 0, 1, 1649559941),
(1603, 155, '武夷山市', 3, 0, 1, 1649559941),
(1604, 155, '建瓯市', 3, 0, 1, 1649559941),
(1605, 156, '新罗区', 3, 0, 1, 1649559941),
(1606, 156, '永定区', 3, 0, 1, 1649559941),
(1607, 156, '长汀县', 3, 0, 1, 1649559941),
(1608, 156, '上杭县', 3, 0, 1, 1649559941),
(1609, 156, '武平县', 3, 0, 1, 1649559941),
(1610, 156, '连城县', 3, 0, 1, 1649559941),
(1611, 156, '漳平市', 3, 0, 1, 1649559941),
(1612, 157, '蕉城区', 3, 0, 1, 1649559941),
(1613, 157, '霞浦县', 3, 0, 1, 1649559941),
(1614, 157, '古田县', 3, 0, 1, 1649559941),
(1615, 157, '屏南县', 3, 0, 1, 1649559941),
(1616, 157, '寿宁县', 3, 0, 1, 1649559941),
(1617, 157, '周宁县', 3, 0, 1, 1649559941),
(1618, 157, '柘荣县', 3, 0, 1, 1649559941),
(1619, 157, '福安市', 3, 0, 1, 1649559941),
(1620, 157, '福鼎市', 3, 0, 1, 1649559941),
(1621, 158, '东湖区', 3, 0, 1, 1649559941),
(1622, 158, '西湖区', 3, 0, 1, 1649559941),
(1623, 158, '青云谱区', 3, 0, 1, 1649559941),
(1624, 158, '青山湖区', 3, 0, 1, 1649559941),
(1625, 158, '新建区', 3, 0, 1, 1649559941),
(1626, 158, '红谷滩区', 3, 0, 1, 1649559941),
(1627, 158, '南昌县', 3, 0, 1, 1649559941),
(1628, 158, '安义县', 3, 0, 1, 1649559941),
(1629, 158, '进贤县', 3, 0, 1, 1649559941),
(1630, 159, '昌江区', 3, 0, 1, 1649559941),
(1631, 159, '珠山区', 3, 0, 1, 1649559941),
(1632, 159, '浮梁县', 3, 0, 1, 1649559941),
(1633, 159, '乐平市', 3, 0, 1, 1649559941),
(1634, 160, '安源区', 3, 0, 1, 1649559941),
(1635, 160, '湘东区', 3, 0, 1, 1649559941),
(1636, 160, '莲花县', 3, 0, 1, 1649559941),
(1637, 160, '上栗县', 3, 0, 1, 1649559941),
(1638, 160, '芦溪县', 3, 0, 1, 1649559941),
(1639, 161, '濂溪区', 3, 0, 1, 1649559941),
(1640, 161, '浔阳区', 3, 0, 1, 1649559941),
(1641, 161, '柴桑区', 3, 0, 1, 1649559941),
(1642, 161, '武宁县', 3, 0, 1, 1649559941),
(1643, 161, '修水县', 3, 0, 1, 1649559941),
(1644, 161, '永修县', 3, 0, 1, 1649559941),
(1645, 161, '德安县', 3, 0, 1, 1649559941),
(1646, 161, '都昌县', 3, 0, 1, 1649559941),
(1647, 161, '湖口县', 3, 0, 1, 1649559941),
(1648, 161, '彭泽县', 3, 0, 1, 1649559941),
(1649, 161, '瑞昌市', 3, 0, 1, 1649559941),
(1650, 161, '共青城市', 3, 0, 1, 1649559941),
(1651, 161, '庐山市', 3, 0, 1, 1649559941),
(1652, 162, '渝水区', 3, 0, 1, 1649559941),
(1653, 162, '分宜县', 3, 0, 1, 1649559941),
(1654, 163, '月湖区', 3, 0, 1, 1649559941),
(1655, 163, '余江区', 3, 0, 1, 1649559941),
(1656, 163, '贵溪市', 3, 0, 1, 1649559941),
(1657, 164, '章贡区', 3, 0, 1, 1649559941),
(1658, 164, '南康区', 3, 0, 1, 1649559941),
(1659, 164, '赣县区', 3, 0, 1, 1649559941),
(1660, 164, '信丰县', 3, 0, 1, 1649559941),
(1661, 164, '大余县', 3, 0, 1, 1649559941),
(1662, 164, '上犹县', 3, 0, 1, 1649559941),
(1663, 164, '崇义县', 3, 0, 1, 1649559941),
(1664, 164, '安远县', 3, 0, 1, 1649559941),
(1665, 164, '定南县', 3, 0, 1, 1649559941),
(1666, 164, '全南县', 3, 0, 1, 1649559941),
(1667, 164, '宁都县', 3, 0, 1, 1649559941),
(1668, 164, '于都县', 3, 0, 1, 1649559941),
(1669, 164, '兴国县', 3, 0, 1, 1649559941),
(1670, 164, '会昌县', 3, 0, 1, 1649559941),
(1671, 164, '寻乌县', 3, 0, 1, 1649559941),
(1672, 164, '石城县', 3, 0, 1, 1649559941),
(1673, 164, '瑞金市', 3, 0, 1, 1649559941),
(1674, 164, '龙南市', 3, 0, 1, 1649559941),
(1675, 165, '吉州区', 3, 0, 1, 1649559941),
(1676, 165, '青原区', 3, 0, 1, 1649559941),
(1677, 165, '吉安县', 3, 0, 1, 1649559941),
(1678, 165, '吉水县', 3, 0, 1, 1649559941),
(1679, 165, '峡江县', 3, 0, 1, 1649559941),
(1680, 165, '新干县', 3, 0, 1, 1649559941),
(1681, 165, '永丰县', 3, 0, 1, 1649559941),
(1682, 165, '泰和县', 3, 0, 1, 1649559941),
(1683, 165, '遂川县', 3, 0, 1, 1649559941),
(1684, 165, '万安县', 3, 0, 1, 1649559941),
(1685, 165, '安福县', 3, 0, 1, 1649559941),
(1686, 165, '永新县', 3, 0, 1, 1649559941),
(1687, 165, '井冈山市', 3, 0, 1, 1649559941),
(1688, 166, '袁州区', 3, 0, 1, 1649559941),
(1689, 166, '奉新县', 3, 0, 1, 1649559941),
(1690, 166, '万载县', 3, 0, 1, 1649559941),
(1691, 166, '上高县', 3, 0, 1, 1649559941),
(1692, 166, '宜丰县', 3, 0, 1, 1649559941),
(1693, 166, '靖安县', 3, 0, 1, 1649559941),
(1694, 166, '铜鼓县', 3, 0, 1, 1649559941),
(1695, 166, '丰城市', 3, 0, 1, 1649559941),
(1696, 166, '樟树市', 3, 0, 1, 1649559941),
(1697, 166, '高安市', 3, 0, 1, 1649559941),
(1698, 167, '临川区', 3, 0, 1, 1649559941),
(1699, 167, '东乡区', 3, 0, 1, 1649559941),
(1700, 167, '南城县', 3, 0, 1, 1649559941),
(1701, 167, '黎川县', 3, 0, 1, 1649559941),
(1702, 167, '南丰县', 3, 0, 1, 1649559941),
(1703, 167, '崇仁县', 3, 0, 1, 1649559941),
(1704, 167, '乐安县', 3, 0, 1, 1649559941),
(1705, 167, '宜黄县', 3, 0, 1, 1649559941),
(1706, 167, '金溪县', 3, 0, 1, 1649559941),
(1707, 167, '资溪县', 3, 0, 1, 1649559941),
(1708, 167, '广昌县', 3, 0, 1, 1649559941),
(1709, 168, '信州区', 3, 0, 1, 1649559941),
(1710, 168, '广丰区', 3, 0, 1, 1649559941),
(1711, 168, '广信区', 3, 0, 1, 1649559941),
(1712, 168, '玉山县', 3, 0, 1, 1649559941),
(1713, 168, '铅山县', 3, 0, 1, 1649559941),
(1714, 168, '横峰县', 3, 0, 1, 1649559941),
(1715, 168, '弋阳县', 3, 0, 1, 1649559941),
(1716, 168, '余干县', 3, 0, 1, 1649559941),
(1717, 168, '鄱阳县', 3, 0, 1, 1649559941),
(1718, 168, '万年县', 3, 0, 1, 1649559941),
(1719, 168, '婺源县', 3, 0, 1, 1649559941),
(1720, 168, '德兴市', 3, 0, 1, 1649559941),
(1721, 169, '历下区', 3, 0, 1, 1649559941),
(1722, 169, '市中区', 3, 0, 1, 1649559941),
(1723, 169, '槐荫区', 3, 0, 1, 1649559941),
(1724, 169, '天桥区', 3, 0, 1, 1649559941),
(1725, 169, '历城区', 3, 0, 1, 1649559941),
(1726, 169, '长清区', 3, 0, 1, 1649559941),
(1727, 169, '章丘区', 3, 0, 1, 1649559941),
(1728, 169, '济阳区', 3, 0, 1, 1649559941),
(1729, 169, '莱芜区', 3, 0, 1, 1649559941),
(1730, 169, '钢城区', 3, 0, 1, 1649559941),
(1731, 169, '平阴县', 3, 0, 1, 1649559941),
(1732, 169, '商河县', 3, 0, 1, 1649559941),
(1733, 169, '济南高新技术产业开发区', 3, 0, 1, 1649559941),
(1734, 170, '市南区', 3, 0, 1, 1649559941),
(1735, 170, '市北区', 3, 0, 1, 1649559941),
(1736, 170, '黄岛区', 3, 0, 1, 1649559941),
(1737, 170, '崂山区', 3, 0, 1, 1649559941),
(1738, 170, '李沧区', 3, 0, 1, 1649559941),
(1739, 170, '城阳区', 3, 0, 1, 1649559941),
(1740, 170, '即墨区', 3, 0, 1, 1649559941),
(1741, 170, '青岛高新技术产业开发区', 3, 0, 1, 1649559941),
(1742, 170, '胶州市', 3, 0, 1, 1649559941),
(1743, 170, '平度市', 3, 0, 1, 1649559941),
(1744, 170, '莱西市', 3, 0, 1, 1649559941),
(1745, 171, '淄川区', 3, 0, 1, 1649559941),
(1746, 171, '张店区', 3, 0, 1, 1649559941),
(1747, 171, '博山区', 3, 0, 1, 1649559941),
(1748, 171, '临淄区', 3, 0, 1, 1649559941),
(1749, 171, '周村区', 3, 0, 1, 1649559941),
(1750, 171, '桓台县', 3, 0, 1, 1649559941),
(1751, 171, '高青县', 3, 0, 1, 1649559941),
(1752, 171, '沂源县', 3, 0, 1, 1649559941),
(1753, 172, '市中区', 3, 0, 1, 1649559941),
(1754, 172, '薛城区', 3, 0, 1, 1649559941),
(1755, 172, '峄城区', 3, 0, 1, 1649559941),
(1756, 172, '台儿庄区', 3, 0, 1, 1649559941),
(1757, 172, '山亭区', 3, 0, 1, 1649559941),
(1758, 172, '滕州市', 3, 0, 1, 1649559941),
(1759, 173, '东营区', 3, 0, 1, 1649559941),
(1760, 173, '河口区', 3, 0, 1, 1649559941),
(1761, 173, '垦利区', 3, 0, 1, 1649559941),
(1762, 173, '利津县', 3, 0, 1, 1649559941),
(1763, 173, '广饶县', 3, 0, 1, 1649559941),
(1764, 173, '东营经济技术开发区', 3, 0, 1, 1649559941),
(1765, 173, '东营港经济开发区', 3, 0, 1, 1649559941),
(1766, 174, '芝罘区', 3, 0, 1, 1649559941),
(1767, 174, '福山区', 3, 0, 1, 1649559941),
(1768, 174, '牟平区', 3, 0, 1, 1649559941),
(1769, 174, '莱山区', 3, 0, 1, 1649559941),
(1770, 174, '蓬莱区', 3, 0, 1, 1649559941),
(1771, 174, '烟台高新技术产业开发区', 3, 0, 1, 1649559941),
(1772, 174, '烟台经济技术开发区', 3, 0, 1, 1649559941),
(1773, 174, '龙口市', 3, 0, 1, 1649559941),
(1774, 174, '莱阳市', 3, 0, 1, 1649559941),
(1775, 174, '莱州市', 3, 0, 1, 1649559941),
(1776, 174, '招远市', 3, 0, 1, 1649559941),
(1777, 174, '栖霞市', 3, 0, 1, 1649559941),
(1778, 174, '海阳市', 3, 0, 1, 1649559941),
(1779, 175, '潍城区', 3, 0, 1, 1649559941),
(1780, 175, '寒亭区', 3, 0, 1, 1649559941),
(1781, 175, '坊子区', 3, 0, 1, 1649559941),
(1782, 175, '奎文区', 3, 0, 1, 1649559941),
(1783, 175, '临朐县', 3, 0, 1, 1649559941),
(1784, 175, '昌乐县', 3, 0, 1, 1649559941),
(1785, 175, '潍坊滨海经济技术开发区', 3, 0, 1, 1649559941),
(1786, 175, '青州市', 3, 0, 1, 1649559941),
(1787, 175, '诸城市', 3, 0, 1, 1649559941),
(1788, 175, '寿光市', 3, 0, 1, 1649559941),
(1789, 175, '安丘市', 3, 0, 1, 1649559941),
(1790, 175, '高密市', 3, 0, 1, 1649559941),
(1791, 175, '昌邑市', 3, 0, 1, 1649559941),
(1792, 176, '任城区', 3, 0, 1, 1649559941),
(1793, 176, '兖州区', 3, 0, 1, 1649559941),
(1794, 176, '微山县', 3, 0, 1, 1649559941),
(1795, 176, '鱼台县', 3, 0, 1, 1649559941),
(1796, 176, '金乡县', 3, 0, 1, 1649559941),
(1797, 176, '嘉祥县', 3, 0, 1, 1649559941),
(1798, 176, '汶上县', 3, 0, 1, 1649559941),
(1799, 176, '泗水县', 3, 0, 1, 1649559941),
(1800, 176, '梁山县', 3, 0, 1, 1649559941),
(1801, 176, '济宁高新技术产业开发区', 3, 0, 1, 1649559941),
(1802, 176, '曲阜市', 3, 0, 1, 1649559941),
(1803, 176, '邹城市', 3, 0, 1, 1649559941),
(1804, 177, '泰山区', 3, 0, 1, 1649559941),
(1805, 177, '岱岳区', 3, 0, 1, 1649559941),
(1806, 177, '宁阳县', 3, 0, 1, 1649559941),
(1807, 177, '东平县', 3, 0, 1, 1649559941),
(1808, 177, '新泰市', 3, 0, 1, 1649559941),
(1809, 177, '肥城市', 3, 0, 1, 1649559941),
(1810, 178, '环翠区', 3, 0, 1, 1649559941),
(1811, 178, '文登区', 3, 0, 1, 1649559941),
(1812, 178, '威海火炬高技术产业开发区', 3, 0, 1, 1649559941),
(1813, 178, '威海经济技术开发区', 3, 0, 1, 1649559941),
(1814, 178, '威海临港经济技术开发区', 3, 0, 1, 1649559941),
(1815, 178, '荣成市', 3, 0, 1, 1649559941),
(1816, 178, '乳山市', 3, 0, 1, 1649559941),
(1817, 179, '东港区', 3, 0, 1, 1649559941),
(1818, 179, '岚山区', 3, 0, 1, 1649559941),
(1819, 179, '五莲县', 3, 0, 1, 1649559941),
(1820, 179, '莒县', 3, 0, 1, 1649559941),
(1821, 179, '日照经济技术开发区', 3, 0, 1, 1649559941),
(1822, 180, '兰山区', 3, 0, 1, 1649559941),
(1823, 180, '罗庄区', 3, 0, 1, 1649559941),
(1824, 180, '河东区', 3, 0, 1, 1649559941),
(1825, 180, '沂南县', 3, 0, 1, 1649559941),
(1826, 180, '郯城县', 3, 0, 1, 1649559941),
(1827, 180, '沂水县', 3, 0, 1, 1649559941),
(1828, 180, '兰陵县', 3, 0, 1, 1649559941),
(1829, 180, '费县', 3, 0, 1, 1649559941),
(1830, 180, '平邑县', 3, 0, 1, 1649559941),
(1831, 180, '莒南县', 3, 0, 1, 1649559941),
(1832, 180, '蒙阴县', 3, 0, 1, 1649559941),
(1833, 180, '临沭县', 3, 0, 1, 1649559941),
(1834, 180, '临沂高新技术产业开发区', 3, 0, 1, 1649559941),
(1835, 181, '德城区', 3, 0, 1, 1649559941),
(1836, 181, '陵城区', 3, 0, 1, 1649559941),
(1837, 181, '宁津县', 3, 0, 1, 1649559941),
(1838, 181, '庆云县', 3, 0, 1, 1649559941),
(1839, 181, '临邑县', 3, 0, 1, 1649559941),
(1840, 181, '齐河县', 3, 0, 1, 1649559941),
(1841, 181, '平原县', 3, 0, 1, 1649559941),
(1842, 181, '夏津县', 3, 0, 1, 1649559941),
(1843, 181, '武城县', 3, 0, 1, 1649559941),
(1844, 181, '德州经济技术开发区', 3, 0, 1, 1649559941),
(1845, 181, '德州运河经济开发区', 3, 0, 1, 1649559941),
(1846, 181, '乐陵市', 3, 0, 1, 1649559941),
(1847, 181, '禹城市', 3, 0, 1, 1649559941),
(1848, 182, '东昌府区', 3, 0, 1, 1649559941),
(1849, 182, '茌平区', 3, 0, 1, 1649559941),
(1850, 182, '阳谷县', 3, 0, 1, 1649559941),
(1851, 182, '莘县', 3, 0, 1, 1649559941),
(1852, 182, '东阿县', 3, 0, 1, 1649559941),
(1853, 182, '冠县', 3, 0, 1, 1649559941),
(1854, 182, '高唐县', 3, 0, 1, 1649559941),
(1855, 182, '临清市', 3, 0, 1, 1649559941),
(1856, 183, '滨城区', 3, 0, 1, 1649559941),
(1857, 183, '沾化区', 3, 0, 1, 1649559941),
(1858, 183, '惠民县', 3, 0, 1, 1649559941),
(1859, 183, '阳信县', 3, 0, 1, 1649559941),
(1860, 183, '无棣县', 3, 0, 1, 1649559941),
(1861, 183, '博兴县', 3, 0, 1, 1649559941),
(1862, 183, '邹平市', 3, 0, 1, 1649559941),
(1863, 184, '牡丹区', 3, 0, 1, 1649559941),
(1864, 184, '定陶区', 3, 0, 1, 1649559941),
(1865, 184, '曹县', 3, 0, 1, 1649559941),
(1866, 184, '单县', 3, 0, 1, 1649559941),
(1867, 184, '成武县', 3, 0, 1, 1649559941),
(1868, 184, '巨野县', 3, 0, 1, 1649559941),
(1869, 184, '郓城县', 3, 0, 1, 1649559941),
(1870, 184, '鄄城县', 3, 0, 1, 1649559941),
(1871, 184, '东明县', 3, 0, 1, 1649559941),
(1872, 184, '菏泽经济技术开发区', 3, 0, 1, 1649559941),
(1873, 184, '菏泽高新技术开发区', 3, 0, 1, 1649559941),
(1874, 185, '中原区', 3, 0, 1, 1649559941),
(1875, 185, '二七区', 3, 0, 1, 1649559941),
(1876, 185, '管城回族区', 3, 0, 1, 1649559941),
(1877, 185, '金水区', 3, 0, 1, 1649559941),
(1878, 185, '上街区', 3, 0, 1, 1649559941),
(1879, 185, '惠济区', 3, 0, 1, 1649559941),
(1880, 185, '中牟县', 3, 0, 1, 1649559941),
(1881, 185, '郑州经济技术开发区', 3, 0, 1, 1649559941),
(1882, 185, '郑州高新技术产业开发区', 3, 0, 1, 1649559941),
(1883, 185, '郑州航空港经济综合实验区', 3, 0, 1, 1649559941),
(1884, 185, '巩义市', 3, 0, 1, 1649559941),
(1885, 185, '荥阳市', 3, 0, 1, 1649559941),
(1886, 185, '新密市', 3, 0, 1, 1649559941),
(1887, 185, '新郑市', 3, 0, 1, 1649559941),
(1888, 185, '登封市', 3, 0, 1, 1649559941),
(1889, 186, '龙亭区', 3, 0, 1, 1649559941),
(1890, 186, '顺河回族区', 3, 0, 1, 1649559941),
(1891, 186, '鼓楼区', 3, 0, 1, 1649559941),
(1892, 186, '禹王台区', 3, 0, 1, 1649559941),
(1893, 186, '祥符区', 3, 0, 1, 1649559941),
(1894, 186, '杞县', 3, 0, 1, 1649559941),
(1895, 186, '通许县', 3, 0, 1, 1649559941),
(1896, 186, '尉氏县', 3, 0, 1, 1649559941),
(1897, 186, '兰考县', 3, 0, 1, 1649559941),
(1898, 187, '老城区', 3, 0, 1, 1649559941),
(1899, 187, '西工区', 3, 0, 1, 1649559941),
(1900, 187, '瀍河回族区', 3, 0, 1, 1649559941),
(1901, 187, '涧西区', 3, 0, 1, 1649559941),
(1902, 187, '偃师区', 3, 0, 1, 1649559941),
(1903, 187, '孟津区', 3, 0, 1, 1649559941),
(1904, 187, '洛龙区', 3, 0, 1, 1649559941),
(1905, 187, '新安县', 3, 0, 1, 1649559941),
(1906, 187, '栾川县', 3, 0, 1, 1649559941),
(1907, 187, '嵩县', 3, 0, 1, 1649559941),
(1908, 187, '汝阳县', 3, 0, 1, 1649559941),
(1909, 187, '宜阳县', 3, 0, 1, 1649559941),
(1910, 187, '洛宁县', 3, 0, 1, 1649559941),
(1911, 187, '伊川县', 3, 0, 1, 1649559941),
(1912, 187, '洛阳高新技术产业开发区', 3, 0, 1, 1649559941),
(1913, 188, '新华区', 3, 0, 1, 1649559941),
(1914, 188, '卫东区', 3, 0, 1, 1649559941),
(1915, 188, '石龙区', 3, 0, 1, 1649559941),
(1916, 188, '湛河区', 3, 0, 1, 1649559941),
(1917, 188, '宝丰县', 3, 0, 1, 1649559941),
(1918, 188, '叶县', 3, 0, 1, 1649559941),
(1919, 188, '鲁山县', 3, 0, 1, 1649559941),
(1920, 188, '郏县', 3, 0, 1, 1649559941),
(1921, 188, '平顶山高新技术产业开发区', 3, 0, 1, 1649559941),
(1922, 188, '平顶山市城乡一体化示范区', 3, 0, 1, 1649559941),
(1923, 188, '舞钢市', 3, 0, 1, 1649559941),
(1924, 188, '汝州市', 3, 0, 1, 1649559941),
(1925, 189, '文峰区', 3, 0, 1, 1649559941),
(1926, 189, '北关区', 3, 0, 1, 1649559941),
(1927, 189, '殷都区', 3, 0, 1, 1649559941),
(1928, 189, '龙安区', 3, 0, 1, 1649559941),
(1929, 189, '安阳县', 3, 0, 1, 1649559941),
(1930, 189, '汤阴县', 3, 0, 1, 1649559941),
(1931, 189, '滑县', 3, 0, 1, 1649559941),
(1932, 189, '内黄县', 3, 0, 1, 1649559941),
(1933, 189, '安阳高新技术产业开发区', 3, 0, 1, 1649559941),
(1934, 189, '林州市', 3, 0, 1, 1649559941),
(1935, 190, '鹤山区', 3, 0, 1, 1649559941),
(1936, 190, '山城区', 3, 0, 1, 1649559941),
(1937, 190, '淇滨区', 3, 0, 1, 1649559941),
(1938, 190, '浚县', 3, 0, 1, 1649559941),
(1939, 190, '淇县', 3, 0, 1, 1649559941),
(1940, 190, '鹤壁经济技术开发区', 3, 0, 1, 1649559941),
(1941, 191, '红旗区', 3, 0, 1, 1649559941),
(1942, 191, '卫滨区', 3, 0, 1, 1649559941),
(1943, 191, '凤泉区', 3, 0, 1, 1649559941),
(1944, 191, '牧野区', 3, 0, 1, 1649559941),
(1945, 191, '新乡县', 3, 0, 1, 1649559941),
(1946, 191, '获嘉县', 3, 0, 1, 1649559941),
(1947, 191, '原阳县', 3, 0, 1, 1649559941),
(1948, 191, '延津县', 3, 0, 1, 1649559941),
(1949, 191, '封丘县', 3, 0, 1, 1649559941),
(1950, 191, '新乡高新技术产业开发区', 3, 0, 1, 1649559941),
(1951, 191, '新乡经济技术开发区', 3, 0, 1, 1649559941),
(1952, 191, '新乡市平原城乡一体化示范区', 3, 0, 1, 1649559941),
(1953, 191, '卫辉市', 3, 0, 1, 1649559941),
(1954, 191, '辉县市', 3, 0, 1, 1649559941),
(1955, 191, '长垣市', 3, 0, 1, 1649559941),
(1956, 192, '解放区', 3, 0, 1, 1649559941),
(1957, 192, '中站区', 3, 0, 1, 1649559941),
(1958, 192, '马村区', 3, 0, 1, 1649559941),
(1959, 192, '山阳区', 3, 0, 1, 1649559941),
(1960, 192, '修武县', 3, 0, 1, 1649559941),
(1961, 192, '博爱县', 3, 0, 1, 1649559941),
(1962, 192, '武陟县', 3, 0, 1, 1649559941),
(1963, 192, '温县', 3, 0, 1, 1649559941),
(1964, 192, '焦作城乡一体化示范区', 3, 0, 1, 1649559941),
(1965, 192, '沁阳市', 3, 0, 1, 1649559941),
(1966, 192, '孟州市', 3, 0, 1, 1649559941),
(1967, 193, '华龙区', 3, 0, 1, 1649559941),
(1968, 193, '清丰县', 3, 0, 1, 1649559941),
(1969, 193, '南乐县', 3, 0, 1, 1649559941),
(1970, 193, '范县', 3, 0, 1, 1649559941),
(1971, 193, '台前县', 3, 0, 1, 1649559941),
(1972, 193, '濮阳县', 3, 0, 1, 1649559941),
(1973, 193, '河南濮阳工业园区', 3, 0, 1, 1649559941),
(1974, 193, '濮阳经济技术开发区', 3, 0, 1, 1649559941),
(1975, 194, '魏都区', 3, 0, 1, 1649559941),
(1976, 194, '建安区', 3, 0, 1, 1649559941),
(1977, 194, '鄢陵县', 3, 0, 1, 1649559941),
(1978, 194, '襄城县', 3, 0, 1, 1649559941),
(1979, 194, '许昌经济技术开发区', 3, 0, 1, 1649559941),
(1980, 194, '禹州市', 3, 0, 1, 1649559941),
(1981, 194, '长葛市', 3, 0, 1, 1649559941),
(1982, 195, '源汇区', 3, 0, 1, 1649559941),
(1983, 195, '郾城区', 3, 0, 1, 1649559941),
(1984, 195, '召陵区', 3, 0, 1, 1649559941),
(1985, 195, '舞阳县', 3, 0, 1, 1649559941),
(1986, 195, '临颍县', 3, 0, 1, 1649559941),
(1987, 195, '漯河经济技术开发区', 3, 0, 1, 1649559941),
(1988, 196, '湖滨区', 3, 0, 1, 1649559941),
(1989, 196, '陕州区', 3, 0, 1, 1649559941),
(1990, 196, '渑池县', 3, 0, 1, 1649559941),
(1991, 196, '卢氏县', 3, 0, 1, 1649559941),
(1992, 196, '河南三门峡经济开发区', 3, 0, 1, 1649559941),
(1993, 196, '义马市', 3, 0, 1, 1649559941),
(1994, 196, '灵宝市', 3, 0, 1, 1649559941),
(1995, 197, '宛城区', 3, 0, 1, 1649559941),
(1996, 197, '卧龙区', 3, 0, 1, 1649559941),
(1997, 197, '南召县', 3, 0, 1, 1649559941),
(1998, 197, '方城县', 3, 0, 1, 1649559941),
(1999, 197, '西峡县', 3, 0, 1, 1649559941),
(2000, 197, '镇平县', 3, 0, 1, 1649559941),
(2001, 197, '内乡县', 3, 0, 1, 1649559941),
(2002, 197, '淅川县', 3, 0, 1, 1649559941),
(2003, 197, '社旗县', 3, 0, 1, 1649559941),
(2004, 197, '唐河县', 3, 0, 1, 1649559941),
(2005, 197, '新野县', 3, 0, 1, 1649559941),
(2006, 197, '桐柏县', 3, 0, 1, 1649559941),
(2007, 197, '南阳高新技术产业开发区', 3, 0, 1, 1649559941),
(2008, 197, '南阳市城乡一体化示范区', 3, 0, 1, 1649559941),
(2009, 197, '邓州市', 3, 0, 1, 1649559941),
(2010, 198, '梁园区', 3, 0, 1, 1649559941),
(2011, 198, '睢阳区', 3, 0, 1, 1649559941),
(2012, 198, '民权县', 3, 0, 1, 1649559941),
(2013, 198, '睢县', 3, 0, 1, 1649559941),
(2014, 198, '宁陵县', 3, 0, 1, 1649559941),
(2015, 198, '柘城县', 3, 0, 1, 1649559941),
(2016, 198, '虞城县', 3, 0, 1, 1649559941),
(2017, 198, '夏邑县', 3, 0, 1, 1649559941),
(2018, 198, '豫东综合物流产业聚集区', 3, 0, 1, 1649559941),
(2019, 198, '河南商丘经济开发区', 3, 0, 1, 1649559941),
(2020, 198, '永城市', 3, 0, 1, 1649559941),
(2021, 199, '浉河区', 3, 0, 1, 1649559941),
(2022, 199, '平桥区', 3, 0, 1, 1649559941),
(2023, 199, '罗山县', 3, 0, 1, 1649559941),
(2024, 199, '光山县', 3, 0, 1, 1649559941),
(2025, 199, '新县', 3, 0, 1, 1649559941),
(2026, 199, '商城县', 3, 0, 1, 1649559941),
(2027, 199, '固始县', 3, 0, 1, 1649559941),
(2028, 199, '潢川县', 3, 0, 1, 1649559941),
(2029, 199, '淮滨县', 3, 0, 1, 1649559941),
(2030, 199, '息县', 3, 0, 1, 1649559941),
(2031, 199, '信阳高新技术产业开发区', 3, 0, 1, 1649559941),
(2032, 200, '川汇区', 3, 0, 1, 1649559941),
(2033, 200, '淮阳区', 3, 0, 1, 1649559941),
(2034, 200, '扶沟县', 3, 0, 1, 1649559941),
(2035, 200, '西华县', 3, 0, 1, 1649559941),
(2036, 200, '商水县', 3, 0, 1, 1649559941),
(2037, 200, '沈丘县', 3, 0, 1, 1649559941),
(2038, 200, '郸城县', 3, 0, 1, 1649559941),
(2039, 200, '太康县', 3, 0, 1, 1649559941),
(2040, 200, '鹿邑县', 3, 0, 1, 1649559941),
(2041, 200, '河南周口经济开发区', 3, 0, 1, 1649559941),
(2042, 200, '项城市', 3, 0, 1, 1649559941),
(2043, 201, '驿城区', 3, 0, 1, 1649559941),
(2044, 201, '西平县', 3, 0, 1, 1649559941),
(2045, 201, '上蔡县', 3, 0, 1, 1649559941),
(2046, 201, '平舆县', 3, 0, 1, 1649559941),
(2047, 201, '正阳县', 3, 0, 1, 1649559941),
(2048, 201, '确山县', 3, 0, 1, 1649559941),
(2049, 201, '泌阳县', 3, 0, 1, 1649559941),
(2050, 201, '汝南县', 3, 0, 1, 1649559941),
(2051, 201, '遂平县', 3, 0, 1, 1649559941),
(2052, 201, '新蔡县', 3, 0, 1, 1649559941),
(2053, 201, '河南驻马店经济开发区', 3, 0, 1, 1649559941),
(2054, 202, '济源市', 3, 0, 1, 1649559941),
(2055, 203, '江岸区', 3, 0, 1, 1649559941),
(2056, 203, '江汉区', 3, 0, 1, 1649559941),
(2057, 203, '硚口区', 3, 0, 1, 1649559941),
(2058, 203, '汉阳区', 3, 0, 1, 1649559941),
(2059, 203, '武昌区', 3, 0, 1, 1649559941),
(2060, 203, '青山区', 3, 0, 1, 1649559941),
(2061, 203, '洪山区', 3, 0, 1, 1649559941),
(2062, 203, '东西湖区', 3, 0, 1, 1649559941),
(2063, 203, '汉南区', 3, 0, 1, 1649559941),
(2064, 203, '蔡甸区', 3, 0, 1, 1649559941),
(2065, 203, '江夏区', 3, 0, 1, 1649559941),
(2066, 203, '黄陂区', 3, 0, 1, 1649559941),
(2067, 203, '新洲区', 3, 0, 1, 1649559941),
(2068, 204, '黄石港区', 3, 0, 1, 1649559941),
(2069, 204, '西塞山区', 3, 0, 1, 1649559941),
(2070, 204, '下陆区', 3, 0, 1, 1649559941),
(2071, 204, '铁山区', 3, 0, 1, 1649559941),
(2072, 204, '阳新县', 3, 0, 1, 1649559941),
(2073, 204, '大冶市', 3, 0, 1, 1649559941),
(2074, 205, '茅箭区', 3, 0, 1, 1649559941),
(2075, 205, '张湾区', 3, 0, 1, 1649559941),
(2076, 205, '郧阳区', 3, 0, 1, 1649559941),
(2077, 205, '郧西县', 3, 0, 1, 1649559941),
(2078, 205, '竹山县', 3, 0, 1, 1649559941),
(2079, 205, '竹溪县', 3, 0, 1, 1649559941),
(2080, 205, '房县', 3, 0, 1, 1649559941),
(2081, 205, '丹江口市', 3, 0, 1, 1649559941),
(2082, 206, '西陵区', 3, 0, 1, 1649559941),
(2083, 206, '伍家岗区', 3, 0, 1, 1649559941),
(2084, 206, '点军区', 3, 0, 1, 1649559941),
(2085, 206, '猇亭区', 3, 0, 1, 1649559941),
(2086, 206, '夷陵区', 3, 0, 1, 1649559941),
(2087, 206, '远安县', 3, 0, 1, 1649559941),
(2088, 206, '兴山县', 3, 0, 1, 1649559941),
(2089, 206, '秭归县', 3, 0, 1, 1649559941),
(2090, 206, '长阳土家族自治县', 3, 0, 1, 1649559941),
(2091, 206, '五峰土家族自治县', 3, 0, 1, 1649559941),
(2092, 206, '宜都市', 3, 0, 1, 1649559941),
(2093, 206, '当阳市', 3, 0, 1, 1649559941),
(2094, 206, '枝江市', 3, 0, 1, 1649559941),
(2095, 207, '襄城区', 3, 0, 1, 1649559941),
(2096, 207, '樊城区', 3, 0, 1, 1649559941),
(2097, 207, '襄州区', 3, 0, 1, 1649559941),
(2098, 207, '南漳县', 3, 0, 1, 1649559941),
(2099, 207, '谷城县', 3, 0, 1, 1649559941),
(2100, 207, '保康县', 3, 0, 1, 1649559941),
(2101, 207, '老河口市', 3, 0, 1, 1649559941),
(2102, 207, '枣阳市', 3, 0, 1, 1649559941),
(2103, 207, '宜城市', 3, 0, 1, 1649559941),
(2104, 208, '梁子湖区', 3, 0, 1, 1649559941),
(2105, 208, '华容区', 3, 0, 1, 1649559941),
(2106, 208, '鄂城区', 3, 0, 1, 1649559941),
(2107, 209, '东宝区', 3, 0, 1, 1649559941),
(2108, 209, '掇刀区', 3, 0, 1, 1649559941),
(2109, 209, '沙洋县', 3, 0, 1, 1649559941),
(2110, 209, '钟祥市', 3, 0, 1, 1649559941),
(2111, 209, '京山市', 3, 0, 1, 1649559941),
(2112, 210, '孝南区', 3, 0, 1, 1649559941),
(2113, 210, '孝昌县', 3, 0, 1, 1649559941),
(2114, 210, '大悟县', 3, 0, 1, 1649559941),
(2115, 210, '云梦县', 3, 0, 1, 1649559941),
(2116, 210, '应城市', 3, 0, 1, 1649559941),
(2117, 210, '安陆市', 3, 0, 1, 1649559941),
(2118, 210, '汉川市', 3, 0, 1, 1649559941),
(2119, 211, '沙市区', 3, 0, 1, 1649559941),
(2120, 211, '荆州区', 3, 0, 1, 1649559941),
(2121, 211, '公安县', 3, 0, 1, 1649559941),
(2122, 211, '江陵县', 3, 0, 1, 1649559941),
(2123, 211, '荆州经济技术开发区', 3, 0, 1, 1649559941),
(2124, 211, '石首市', 3, 0, 1, 1649559941),
(2125, 211, '洪湖市', 3, 0, 1, 1649559941),
(2126, 211, '松滋市', 3, 0, 1, 1649559941),
(2127, 211, '监利市', 3, 0, 1, 1649559941),
(2128, 212, '黄州区', 3, 0, 1, 1649559941),
(2129, 212, '团风县', 3, 0, 1, 1649559941),
(2130, 212, '红安县', 3, 0, 1, 1649559941),
(2131, 212, '罗田县', 3, 0, 1, 1649559941),
(2132, 212, '英山县', 3, 0, 1, 1649559941),
(2133, 212, '浠水县', 3, 0, 1, 1649559941),
(2134, 212, '蕲春县', 3, 0, 1, 1649559941),
(2135, 212, '黄梅县', 3, 0, 1, 1649559941),
(2136, 212, '龙感湖管理区', 3, 0, 1, 1649559941),
(2137, 212, '麻城市', 3, 0, 1, 1649559941),
(2138, 212, '武穴市', 3, 0, 1, 1649559941),
(2139, 213, '咸安区', 3, 0, 1, 1649559941),
(2140, 213, '嘉鱼县', 3, 0, 1, 1649559941),
(2141, 213, '通城县', 3, 0, 1, 1649559941),
(2142, 213, '崇阳县', 3, 0, 1, 1649559941),
(2143, 213, '通山县', 3, 0, 1, 1649559941),
(2144, 213, '赤壁市', 3, 0, 1, 1649559941),
(2145, 214, '曾都区', 3, 0, 1, 1649559941),
(2146, 214, '随县', 3, 0, 1, 1649559941),
(2147, 214, '广水市', 3, 0, 1, 1649559941),
(2148, 215, '恩施市', 3, 0, 1, 1649559941),
(2149, 215, '利川市', 3, 0, 1, 1649559941),
(2150, 215, '建始县', 3, 0, 1, 1649559941),
(2151, 215, '巴东县', 3, 0, 1, 1649559941),
(2152, 215, '宣恩县', 3, 0, 1, 1649559941),
(2153, 215, '咸丰县', 3, 0, 1, 1649559941),
(2154, 215, '来凤县', 3, 0, 1, 1649559941),
(2155, 215, '鹤峰县', 3, 0, 1, 1649559941),
(2156, 216, '仙桃市', 3, 0, 1, 1649559941),
(2157, 216, '潜江市', 3, 0, 1, 1649559941),
(2158, 216, '天门市', 3, 0, 1, 1649559941),
(2159, 216, '神农架林区', 3, 0, 1, 1649559941),
(2160, 217, '芙蓉区', 3, 0, 1, 1649559941),
(2161, 217, '天心区', 3, 0, 1, 1649559941),
(2162, 217, '岳麓区', 3, 0, 1, 1649559941),
(2163, 217, '开福区', 3, 0, 1, 1649559941),
(2164, 217, '雨花区', 3, 0, 1, 1649559941),
(2165, 217, '望城区', 3, 0, 1, 1649559941),
(2166, 217, '长沙县', 3, 0, 1, 1649559941),
(2167, 217, '浏阳市', 3, 0, 1, 1649559941),
(2168, 217, '宁乡市', 3, 0, 1, 1649559941),
(2169, 218, '荷塘区', 3, 0, 1, 1649559941),
(2170, 218, '芦淞区', 3, 0, 1, 1649559941),
(2171, 218, '石峰区', 3, 0, 1, 1649559941),
(2172, 218, '天元区', 3, 0, 1, 1649559941),
(2173, 218, '渌口区', 3, 0, 1, 1649559941),
(2174, 218, '攸县', 3, 0, 1, 1649559941),
(2175, 218, '茶陵县', 3, 0, 1, 1649559941),
(2176, 218, '炎陵县', 3, 0, 1, 1649559941),
(2177, 218, '云龙示范区', 3, 0, 1, 1649559941),
(2178, 218, '醴陵市', 3, 0, 1, 1649559941),
(2179, 219, '雨湖区', 3, 0, 1, 1649559941),
(2180, 219, '岳塘区', 3, 0, 1, 1649559941),
(2181, 219, '湘潭县', 3, 0, 1, 1649559941),
(2182, 219, '湖南湘潭高新技术产业园区', 3, 0, 1, 1649559941),
(2183, 219, '湘潭昭山示范区', 3, 0, 1, 1649559941),
(2184, 219, '湘潭九华示范区', 3, 0, 1, 1649559941),
(2185, 219, '湘乡市', 3, 0, 1, 1649559941),
(2186, 219, '韶山市', 3, 0, 1, 1649559941),
(2187, 220, '珠晖区', 3, 0, 1, 1649559941),
(2188, 220, '雁峰区', 3, 0, 1, 1649559941),
(2189, 220, '石鼓区', 3, 0, 1, 1649559941),
(2190, 220, '蒸湘区', 3, 0, 1, 1649559941),
(2191, 220, '南岳区', 3, 0, 1, 1649559941),
(2192, 220, '衡阳县', 3, 0, 1, 1649559941),
(2193, 220, '衡南县', 3, 0, 1, 1649559941),
(2194, 220, '衡山县', 3, 0, 1, 1649559941),
(2195, 220, '衡东县', 3, 0, 1, 1649559941),
(2196, 220, '祁东县', 3, 0, 1, 1649559941),
(2197, 220, '衡阳综合保税区', 3, 0, 1, 1649559941),
(2198, 220, '湖南衡阳高新技术产业园区', 3, 0, 1, 1649559941),
(2199, 220, '湖南衡阳松木经济开发区', 3, 0, 1, 1649559941),
(2200, 220, '耒阳市', 3, 0, 1, 1649559941),
(2201, 220, '常宁市', 3, 0, 1, 1649559941),
(2202, 221, '双清区', 3, 0, 1, 1649559941),
(2203, 221, '大祥区', 3, 0, 1, 1649559941),
(2204, 221, '北塔区', 3, 0, 1, 1649559941),
(2205, 221, '新邵县', 3, 0, 1, 1649559941),
(2206, 221, '邵阳县', 3, 0, 1, 1649559941),
(2207, 221, '隆回县', 3, 0, 1, 1649559941),
(2208, 221, '洞口县', 3, 0, 1, 1649559941),
(2209, 221, '绥宁县', 3, 0, 1, 1649559941),
(2210, 221, '新宁县', 3, 0, 1, 1649559941),
(2211, 221, '城步苗族自治县', 3, 0, 1, 1649559941),
(2212, 221, '武冈市', 3, 0, 1, 1649559941),
(2213, 221, '邵东市', 3, 0, 1, 1649559941),
(2214, 222, '岳阳楼区', 3, 0, 1, 1649559941),
(2215, 222, '云溪区', 3, 0, 1, 1649559941),
(2216, 222, '君山区', 3, 0, 1, 1649559941),
(2217, 222, '岳阳县', 3, 0, 1, 1649559941),
(2218, 222, '华容县', 3, 0, 1, 1649559941),
(2219, 222, '湘阴县', 3, 0, 1, 1649559941),
(2220, 222, '平江县', 3, 0, 1, 1649559941),
(2221, 222, '岳阳市屈原管理区', 3, 0, 1, 1649559941),
(2222, 222, '汨罗市', 3, 0, 1, 1649559941),
(2223, 222, '临湘市', 3, 0, 1, 1649559941),
(2224, 223, '武陵区', 3, 0, 1, 1649559941),
(2225, 223, '鼎城区', 3, 0, 1, 1649559941),
(2226, 223, '安乡县', 3, 0, 1, 1649559941),
(2227, 223, '汉寿县', 3, 0, 1, 1649559941),
(2228, 223, '澧县', 3, 0, 1, 1649559941),
(2229, 223, '临澧县', 3, 0, 1, 1649559941),
(2230, 223, '桃源县', 3, 0, 1, 1649559941),
(2231, 223, '石门县', 3, 0, 1, 1649559941),
(2232, 223, '常德市西洞庭管理区', 3, 0, 1, 1649559941),
(2233, 223, '津市市', 3, 0, 1, 1649559941),
(2234, 224, '永定区', 3, 0, 1, 1649559941),
(2235, 224, '武陵源区', 3, 0, 1, 1649559941),
(2236, 224, '慈利县', 3, 0, 1, 1649559941),
(2237, 224, '桑植县', 3, 0, 1, 1649559941),
(2238, 225, '资阳区', 3, 0, 1, 1649559941),
(2239, 225, '赫山区', 3, 0, 1, 1649559941),
(2240, 225, '南县', 3, 0, 1, 1649559941),
(2241, 225, '桃江县', 3, 0, 1, 1649559941),
(2242, 225, '安化县', 3, 0, 1, 1649559941),
(2243, 225, '益阳市大通湖管理区', 3, 0, 1, 1649559941),
(2244, 225, '湖南益阳高新技术产业园区', 3, 0, 1, 1649559941),
(2245, 225, '沅江市', 3, 0, 1, 1649559941),
(2246, 226, '北湖区', 3, 0, 1, 1649559941),
(2247, 226, '苏仙区', 3, 0, 1, 1649559941),
(2248, 226, '桂阳县', 3, 0, 1, 1649559941),
(2249, 226, '宜章县', 3, 0, 1, 1649559941),
(2250, 226, '永兴县', 3, 0, 1, 1649559941),
(2251, 226, '嘉禾县', 3, 0, 1, 1649559941),
(2252, 226, '临武县', 3, 0, 1, 1649559941),
(2253, 226, '汝城县', 3, 0, 1, 1649559941),
(2254, 226, '桂东县', 3, 0, 1, 1649559941),
(2255, 226, '安仁县', 3, 0, 1, 1649559941),
(2256, 226, '资兴市', 3, 0, 1, 1649559941),
(2257, 227, '零陵区', 3, 0, 1, 1649559941),
(2258, 227, '冷水滩区', 3, 0, 1, 1649559941),
(2259, 227, '东安县', 3, 0, 1, 1649559941),
(2260, 227, '双牌县', 3, 0, 1, 1649559941),
(2261, 227, '道县', 3, 0, 1, 1649559941),
(2262, 227, '江永县', 3, 0, 1, 1649559941),
(2263, 227, '宁远县', 3, 0, 1, 1649559941),
(2264, 227, '蓝山县', 3, 0, 1, 1649559941),
(2265, 227, '新田县', 3, 0, 1, 1649559941),
(2266, 227, '江华瑶族自治县', 3, 0, 1, 1649559941),
(2267, 227, '永州经济技术开发区', 3, 0, 1, 1649559941),
(2268, 227, '永州市回龙圩管理区', 3, 0, 1, 1649559941),
(2269, 227, '祁阳市', 3, 0, 1, 1649559941),
(2270, 228, '鹤城区', 3, 0, 1, 1649559941),
(2271, 228, '中方县', 3, 0, 1, 1649559941),
(2272, 228, '沅陵县', 3, 0, 1, 1649559941),
(2273, 228, '辰溪县', 3, 0, 1, 1649559941),
(2274, 228, '溆浦县', 3, 0, 1, 1649559941),
(2275, 228, '会同县', 3, 0, 1, 1649559941),
(2276, 228, '麻阳苗族自治县', 3, 0, 1, 1649559941),
(2277, 228, '新晃侗族自治县', 3, 0, 1, 1649559941),
(2278, 228, '芷江侗族自治县', 3, 0, 1, 1649559941),
(2279, 228, '靖州苗族侗族自治县', 3, 0, 1, 1649559941),
(2280, 228, '通道侗族自治县', 3, 0, 1, 1649559941),
(2281, 228, '怀化市洪江管理区', 3, 0, 1, 1649559941),
(2282, 228, '洪江市', 3, 0, 1, 1649559941),
(2283, 229, '娄星区', 3, 0, 1, 1649559941),
(2284, 229, '双峰县', 3, 0, 1, 1649559941),
(2285, 229, '新化县', 3, 0, 1, 1649559941),
(2286, 229, '冷水江市', 3, 0, 1, 1649559941),
(2287, 229, '涟源市', 3, 0, 1, 1649559941),
(2288, 230, '吉首市', 3, 0, 1, 1649559941),
(2289, 230, '泸溪县', 3, 0, 1, 1649559941),
(2290, 230, '凤凰县', 3, 0, 1, 1649559941),
(2291, 230, '花垣县', 3, 0, 1, 1649559941),
(2292, 230, '保靖县', 3, 0, 1, 1649559941),
(2293, 230, '古丈县', 3, 0, 1, 1649559941),
(2294, 230, '永顺县', 3, 0, 1, 1649559941),
(2295, 230, '龙山县', 3, 0, 1, 1649559941),
(2296, 231, '荔湾区', 3, 0, 1, 1649559941),
(2297, 231, '越秀区', 3, 0, 1, 1649559941),
(2298, 231, '海珠区', 3, 0, 1, 1649559941),
(2299, 231, '天河区', 3, 0, 1, 1649559941),
(2300, 231, '白云区', 3, 0, 1, 1649559941),
(2301, 231, '黄埔区', 3, 0, 1, 1649559941),
(2302, 231, '番禺区', 3, 0, 1, 1649559941),
(2303, 231, '花都区', 3, 0, 1, 1649559941),
(2304, 231, '南沙区', 3, 0, 1, 1649559941),
(2305, 231, '从化区', 3, 0, 1, 1649559941),
(2306, 231, '增城区', 3, 0, 1, 1649559941),
(2307, 232, '武江区', 3, 0, 1, 1649559941),
(2308, 232, '浈江区', 3, 0, 1, 1649559941),
(2309, 232, '曲江区', 3, 0, 1, 1649559941),
(2310, 232, '始兴县', 3, 0, 1, 1649559941),
(2311, 232, '仁化县', 3, 0, 1, 1649559941),
(2312, 232, '翁源县', 3, 0, 1, 1649559941),
(2313, 232, '乳源瑶族自治县', 3, 0, 1, 1649559941),
(2314, 232, '新丰县', 3, 0, 1, 1649559941),
(2315, 232, '乐昌市', 3, 0, 1, 1649559941),
(2316, 232, '南雄市', 3, 0, 1, 1649559941),
(2317, 233, '罗湖区', 3, 0, 1, 1649559941),
(2318, 233, '福田区', 3, 0, 1, 1649559941),
(2319, 233, '南山区', 3, 0, 1, 1649559941),
(2320, 233, '宝安区', 3, 0, 1, 1649559941),
(2321, 233, '龙岗区', 3, 0, 1, 1649559941),
(2322, 233, '盐田区', 3, 0, 1, 1649559941),
(2323, 233, '龙华区', 3, 0, 1, 1649559941),
(2324, 233, '坪山区', 3, 0, 1, 1649559941),
(2325, 233, '光明区', 3, 0, 1, 1649559941),
(2326, 233, '大鹏新区', 3, 0, 1, 1649559941),
(2327, 234, '香洲区', 3, 0, 1, 1649559941),
(2328, 234, '斗门区', 3, 0, 1, 1649559941),
(2329, 234, '金湾区', 3, 0, 1, 1649559941),
(2330, 235, '龙湖区', 3, 0, 1, 1649559941),
(2331, 235, '金平区', 3, 0, 1, 1649559941),
(2332, 235, '濠江区', 3, 0, 1, 1649559941),
(2333, 235, '潮阳区', 3, 0, 1, 1649559941),
(2334, 235, '潮南区', 3, 0, 1, 1649559941),
(2335, 235, '澄海区', 3, 0, 1, 1649559941),
(2336, 235, '南澳县', 3, 0, 1, 1649559941),
(2337, 236, '禅城区', 3, 0, 1, 1649559941),
(2338, 236, '南海区', 3, 0, 1, 1649559941),
(2339, 236, '顺德区', 3, 0, 1, 1649559941),
(2340, 236, '三水区', 3, 0, 1, 1649559941),
(2341, 236, '高明区', 3, 0, 1, 1649559941),
(2342, 237, '蓬江区', 3, 0, 1, 1649559941),
(2343, 237, '江海区', 3, 0, 1, 1649559941),
(2344, 237, '新会区', 3, 0, 1, 1649559941),
(2345, 237, '台山市', 3, 0, 1, 1649559941),
(2346, 237, '开平市', 3, 0, 1, 1649559941),
(2347, 237, '鹤山市', 3, 0, 1, 1649559941),
(2348, 237, '恩平市', 3, 0, 1, 1649559941),
(2349, 238, '赤坎区', 3, 0, 1, 1649559941),
(2350, 238, '霞山区', 3, 0, 1, 1649559941),
(2351, 238, '坡头区', 3, 0, 1, 1649559941),
(2352, 238, '麻章区', 3, 0, 1, 1649559941),
(2353, 238, '遂溪县', 3, 0, 1, 1649559941),
(2354, 238, '徐闻县', 3, 0, 1, 1649559941),
(2355, 238, '廉江市', 3, 0, 1, 1649559941),
(2356, 238, '雷州市', 3, 0, 1, 1649559941),
(2357, 238, '吴川市', 3, 0, 1, 1649559941),
(2358, 239, '茂南区', 3, 0, 1, 1649559941),
(2359, 239, '电白区', 3, 0, 1, 1649559941),
(2360, 239, '高州市', 3, 0, 1, 1649559941),
(2361, 239, '化州市', 3, 0, 1, 1649559941),
(2362, 239, '信宜市', 3, 0, 1, 1649559941),
(2363, 240, '端州区', 3, 0, 1, 1649559941),
(2364, 240, '鼎湖区', 3, 0, 1, 1649559941),
(2365, 240, '高要区', 3, 0, 1, 1649559941),
(2366, 240, '广宁县', 3, 0, 1, 1649559941),
(2367, 240, '怀集县', 3, 0, 1, 1649559941),
(2368, 240, '封开县', 3, 0, 1, 1649559941),
(2369, 240, '德庆县', 3, 0, 1, 1649559941),
(2370, 240, '四会市', 3, 0, 1, 1649559941),
(2371, 241, '惠城区', 3, 0, 1, 1649559941),
(2372, 241, '惠阳区', 3, 0, 1, 1649559941),
(2373, 241, '博罗县', 3, 0, 1, 1649559941),
(2374, 241, '惠东县', 3, 0, 1, 1649559941),
(2375, 241, '龙门县', 3, 0, 1, 1649559941),
(2376, 242, '梅江区', 3, 0, 1, 1649559941),
(2377, 242, '梅县区', 3, 0, 1, 1649559941),
(2378, 242, '大埔县', 3, 0, 1, 1649559941),
(2379, 242, '丰顺县', 3, 0, 1, 1649559941),
(2380, 242, '五华县', 3, 0, 1, 1649559941),
(2381, 242, '平远县', 3, 0, 1, 1649559941),
(2382, 242, '蕉岭县', 3, 0, 1, 1649559941),
(2383, 242, '兴宁市', 3, 0, 1, 1649559941),
(2384, 243, '城区', 3, 0, 1, 1649559941),
(2385, 243, '海丰县', 3, 0, 1, 1649559941),
(2386, 243, '陆河县', 3, 0, 1, 1649559941),
(2387, 243, '陆丰市', 3, 0, 1, 1649559941),
(2388, 244, '源城区', 3, 0, 1, 1649559941),
(2389, 244, '紫金县', 3, 0, 1, 1649559941),
(2390, 244, '龙川县', 3, 0, 1, 1649559941),
(2391, 244, '连平县', 3, 0, 1, 1649559941),
(2392, 244, '和平县', 3, 0, 1, 1649559941),
(2393, 244, '东源县', 3, 0, 1, 1649559941),
(2394, 245, '江城区', 3, 0, 1, 1649559941),
(2395, 245, '阳东区', 3, 0, 1, 1649559941),
(2396, 245, '阳西县', 3, 0, 1, 1649559941),
(2397, 245, '阳春市', 3, 0, 1, 1649559941),
(2398, 246, '清城区', 3, 0, 1, 1649559941),
(2399, 246, '清新区', 3, 0, 1, 1649559941),
(2400, 246, '佛冈县', 3, 0, 1, 1649559941),
(2401, 246, '阳山县', 3, 0, 1, 1649559941),
(2402, 246, '连山壮族瑶族自治县', 3, 0, 1, 1649559941),
(2403, 246, '连南瑶族自治县', 3, 0, 1, 1649559941),
(2404, 246, '英德市', 3, 0, 1, 1649559941),
(2405, 246, '连州市', 3, 0, 1, 1649559941),
(2406, 247, '东莞市', 3, 0, 1, 1649559941),
(2407, 248, '中山市', 3, 0, 1, 1649559941),
(2408, 249, '湘桥区', 3, 0, 1, 1649559941),
(2409, 249, '潮安区', 3, 0, 1, 1649559941),
(2410, 249, '饶平县', 3, 0, 1, 1649559941),
(2411, 250, '榕城区', 3, 0, 1, 1649559941),
(2412, 250, '揭东区', 3, 0, 1, 1649559941),
(2413, 250, '揭西县', 3, 0, 1, 1649559941),
(2414, 250, '惠来县', 3, 0, 1, 1649559941),
(2415, 250, '普宁市', 3, 0, 1, 1649559941),
(2416, 251, '云城区', 3, 0, 1, 1649559941),
(2417, 251, '云安区', 3, 0, 1, 1649559941),
(2418, 251, '新兴县', 3, 0, 1, 1649559941),
(2419, 251, '郁南县', 3, 0, 1, 1649559941),
(2420, 251, '罗定市', 3, 0, 1, 1649559941),
(2421, 252, '兴宁区', 3, 0, 1, 1649559941),
(2422, 252, '青秀区', 3, 0, 1, 1649559941),
(2423, 252, '江南区', 3, 0, 1, 1649559941),
(2424, 252, '西乡塘区', 3, 0, 1, 1649559941),
(2425, 252, '良庆区', 3, 0, 1, 1649559941),
(2426, 252, '邕宁区', 3, 0, 1, 1649559941),
(2427, 252, '武鸣区', 3, 0, 1, 1649559941),
(2428, 252, '隆安县', 3, 0, 1, 1649559941),
(2429, 252, '马山县', 3, 0, 1, 1649559941),
(2430, 252, '上林县', 3, 0, 1, 1649559941),
(2431, 252, '宾阳县', 3, 0, 1, 1649559941),
(2432, 252, '横州市', 3, 0, 1, 1649559941),
(2433, 253, '城中区', 3, 0, 1, 1649559941),
(2434, 253, '鱼峰区', 3, 0, 1, 1649559941),
(2435, 253, '柳南区', 3, 0, 1, 1649559941),
(2436, 253, '柳北区', 3, 0, 1, 1649559941),
(2437, 253, '柳江区', 3, 0, 1, 1649559941),
(2438, 253, '柳城县', 3, 0, 1, 1649559941),
(2439, 253, '鹿寨县', 3, 0, 1, 1649559941),
(2440, 253, '融安县', 3, 0, 1, 1649559941),
(2441, 253, '融水苗族自治县', 3, 0, 1, 1649559941),
(2442, 253, '三江侗族自治县', 3, 0, 1, 1649559941),
(2443, 254, '秀峰区', 3, 0, 1, 1649559941),
(2444, 254, '叠彩区', 3, 0, 1, 1649559941),
(2445, 254, '象山区', 3, 0, 1, 1649559941),
(2446, 254, '七星区', 3, 0, 1, 1649559941),
(2447, 254, '雁山区', 3, 0, 1, 1649559941),
(2448, 254, '临桂区', 3, 0, 1, 1649559941),
(2449, 254, '阳朔县', 3, 0, 1, 1649559941),
(2450, 254, '灵川县', 3, 0, 1, 1649559941),
(2451, 254, '全州县', 3, 0, 1, 1649559941),
(2452, 254, '兴安县', 3, 0, 1, 1649559941),
(2453, 254, '永福县', 3, 0, 1, 1649559941),
(2454, 254, '灌阳县', 3, 0, 1, 1649559941),
(2455, 254, '龙胜各族自治县', 3, 0, 1, 1649559941),
(2456, 254, '资源县', 3, 0, 1, 1649559941),
(2457, 254, '平乐县', 3, 0, 1, 1649559941),
(2458, 254, '恭城瑶族自治县', 3, 0, 1, 1649559941),
(2459, 254, '荔浦市', 3, 0, 1, 1649559941),
(2460, 255, '万秀区', 3, 0, 1, 1649559941),
(2461, 255, '长洲区', 3, 0, 1, 1649559941),
(2462, 255, '龙圩区', 3, 0, 1, 1649559941),
(2463, 255, '苍梧县', 3, 0, 1, 1649559941),
(2464, 255, '藤县', 3, 0, 1, 1649559941),
(2465, 255, '蒙山县', 3, 0, 1, 1649559941),
(2466, 255, '岑溪市', 3, 0, 1, 1649559941),
(2467, 256, '海城区', 3, 0, 1, 1649559941),
(2468, 256, '银海区', 3, 0, 1, 1649559941),
(2469, 256, '铁山港区', 3, 0, 1, 1649559941),
(2470, 256, '合浦县', 3, 0, 1, 1649559941),
(2471, 257, '港口区', 3, 0, 1, 1649559941),
(2472, 257, '防城区', 3, 0, 1, 1649559941),
(2473, 257, '上思县', 3, 0, 1, 1649559941),
(2474, 257, '东兴市', 3, 0, 1, 1649559941),
(2475, 258, '钦南区', 3, 0, 1, 1649559941),
(2476, 258, '钦北区', 3, 0, 1, 1649559941),
(2477, 258, '灵山县', 3, 0, 1, 1649559941),
(2478, 258, '浦北县', 3, 0, 1, 1649559941),
(2479, 259, '港北区', 3, 0, 1, 1649559941),
(2480, 259, '港南区', 3, 0, 1, 1649559941),
(2481, 259, '覃塘区', 3, 0, 1, 1649559941),
(2482, 259, '平南县', 3, 0, 1, 1649559941),
(2483, 259, '桂平市', 3, 0, 1, 1649559941),
(2484, 260, '玉州区', 3, 0, 1, 1649559941),
(2485, 260, '福绵区', 3, 0, 1, 1649559941),
(2486, 260, '容县', 3, 0, 1, 1649559941),
(2487, 260, '陆川县', 3, 0, 1, 1649559941),
(2488, 260, '博白县', 3, 0, 1, 1649559941),
(2489, 260, '兴业县', 3, 0, 1, 1649559941),
(2490, 260, '北流市', 3, 0, 1, 1649559941),
(2491, 261, '右江区', 3, 0, 1, 1649559941),
(2492, 261, '田阳区', 3, 0, 1, 1649559941),
(2493, 261, '田东县', 3, 0, 1, 1649559941),
(2494, 261, '德保县', 3, 0, 1, 1649559941),
(2495, 261, '那坡县', 3, 0, 1, 1649559941),
(2496, 261, '凌云县', 3, 0, 1, 1649559941),
(2497, 261, '乐业县', 3, 0, 1, 1649559941),
(2498, 261, '田林县', 3, 0, 1, 1649559941),
(2499, 261, '西林县', 3, 0, 1, 1649559941),
(2500, 261, '隆林各族自治县', 3, 0, 1, 1649559941),
(2501, 261, '靖西市', 3, 0, 1, 1649559941),
(2502, 261, '平果市', 3, 0, 1, 1649559941),
(2503, 262, '八步区', 3, 0, 1, 1649559941),
(2504, 262, '平桂区', 3, 0, 1, 1649559941),
(2505, 262, '昭平县', 3, 0, 1, 1649559941),
(2506, 262, '钟山县', 3, 0, 1, 1649559941),
(2507, 262, '富川瑶族自治县', 3, 0, 1, 1649559941),
(2508, 263, '金城江区', 3, 0, 1, 1649559941),
(2509, 263, '宜州区', 3, 0, 1, 1649559941),
(2510, 263, '南丹县', 3, 0, 1, 1649559941),
(2511, 263, '天峨县', 3, 0, 1, 1649559941),
(2512, 263, '凤山县', 3, 0, 1, 1649559941),
(2513, 263, '东兰县', 3, 0, 1, 1649559941),
(2514, 263, '罗城仫佬族自治县', 3, 0, 1, 1649559941),
(2515, 263, '环江毛南族自治县', 3, 0, 1, 1649559941),
(2516, 263, '巴马瑶族自治县', 3, 0, 1, 1649559941),
(2517, 263, '都安瑶族自治县', 3, 0, 1, 1649559941),
(2518, 263, '大化瑶族自治县', 3, 0, 1, 1649559942),
(2519, 264, '兴宾区', 3, 0, 1, 1649559942),
(2520, 264, '忻城县', 3, 0, 1, 1649559942),
(2521, 264, '象州县', 3, 0, 1, 1649559942),
(2522, 264, '武宣县', 3, 0, 1, 1649559942),
(2523, 264, '金秀瑶族自治县', 3, 0, 1, 1649559942),
(2524, 264, '合山市', 3, 0, 1, 1649559942),
(2525, 265, '江州区', 3, 0, 1, 1649559942),
(2526, 265, '扶绥县', 3, 0, 1, 1649559942),
(2527, 265, '宁明县', 3, 0, 1, 1649559942),
(2528, 265, '龙州县', 3, 0, 1, 1649559942),
(2529, 265, '大新县', 3, 0, 1, 1649559942),
(2530, 265, '天等县', 3, 0, 1, 1649559942),
(2531, 265, '凭祥市', 3, 0, 1, 1649559942),
(2532, 266, '秀英区', 3, 0, 1, 1649559942),
(2533, 266, '龙华区', 3, 0, 1, 1649559942),
(2534, 266, '琼山区', 3, 0, 1, 1649559942),
(2535, 266, '美兰区', 3, 0, 1, 1649559942),
(2536, 267, '海棠区', 3, 0, 1, 1649559942),
(2537, 267, '吉阳区', 3, 0, 1, 1649559942),
(2538, 267, '天涯区', 3, 0, 1, 1649559942),
(2539, 267, '崖州区', 3, 0, 1, 1649559942),
(2540, 268, '西沙群岛', 3, 0, 1, 1649559942),
(2541, 268, '南沙群岛', 3, 0, 1, 1649559942),
(2542, 268, '中沙群岛的岛礁及其海域', 3, 0, 1, 1649559942),
(2543, 269, '儋州市', 3, 0, 1, 1649559942),
(2544, 270, '五指山市', 3, 0, 1, 1649559942),
(2545, 270, '琼海市', 3, 0, 1, 1649559942),
(2546, 270, '文昌市', 3, 0, 1, 1649559942),
(2547, 270, '万宁市', 3, 0, 1, 1649559942),
(2548, 270, '东方市', 3, 0, 1, 1649559942),
(2549, 270, '定安县', 3, 0, 1, 1649559942),
(2550, 270, '屯昌县', 3, 0, 1, 1649559942),
(2551, 270, '澄迈县', 3, 0, 1, 1649559942),
(2552, 270, '临高县', 3, 0, 1, 1649559942),
(2553, 270, '白沙黎族自治县', 3, 0, 1, 1649559942),
(2554, 270, '昌江黎族自治县', 3, 0, 1, 1649559942),
(2555, 270, '乐东黎族自治县', 3, 0, 1, 1649559942),
(2556, 270, '陵水黎族自治县', 3, 0, 1, 1649559942),
(2557, 270, '保亭黎族苗族自治县', 3, 0, 1, 1649559942),
(2558, 270, '琼中黎族苗族自治县', 3, 0, 1, 1649559942),
(2559, 271, '万州区', 3, 0, 1, 1649559942),
(2560, 271, '涪陵区', 3, 0, 1, 1649559942),
(2561, 271, '渝中区', 3, 0, 1, 1649559942),
(2562, 271, '大渡口区', 3, 0, 1, 1649559942),
(2563, 271, '江北区', 3, 0, 1, 1649559942),
(2564, 271, '沙坪坝区', 3, 0, 1, 1649559942),
(2565, 271, '九龙坡区', 3, 0, 1, 1649559942),
(2566, 271, '南岸区', 3, 0, 1, 1649559942),
(2567, 271, '北碚区', 3, 0, 1, 1649559942),
(2568, 271, '綦江区', 3, 0, 1, 1649559942),
(2569, 271, '大足区', 3, 0, 1, 1649559942),
(2570, 271, '渝北区', 3, 0, 1, 1649559942),
(2571, 271, '巴南区', 3, 0, 1, 1649559942),
(2572, 271, '黔江区', 3, 0, 1, 1649559942),
(2573, 271, '长寿区', 3, 0, 1, 1649559942),
(2574, 271, '江津区', 3, 0, 1, 1649559942),
(2575, 271, '合川区', 3, 0, 1, 1649559942),
(2576, 271, '永川区', 3, 0, 1, 1649559942),
(2577, 271, '南川区', 3, 0, 1, 1649559942),
(2578, 271, '璧山区', 3, 0, 1, 1649559942),
(2579, 271, '铜梁区', 3, 0, 1, 1649559942);
INSERT INTO `mall_region` (`id`, `pid`, `name`, `level`, `sort`, `status`, `create_time`) VALUES
(2580, 271, '潼南区', 3, 0, 1, 1649559942),
(2581, 271, '荣昌区', 3, 0, 1, 1649559942),
(2582, 271, '开州区', 3, 0, 1, 1649559942),
(2583, 271, '梁平区', 3, 0, 1, 1649559942),
(2584, 271, '武隆区', 3, 0, 1, 1649559942),
(2585, 272, '城口县', 3, 0, 1, 1649559942),
(2586, 272, '丰都县', 3, 0, 1, 1649559942),
(2587, 272, '垫江县', 3, 0, 1, 1649559942),
(2588, 272, '忠县', 3, 0, 1, 1649559942),
(2589, 272, '云阳县', 3, 0, 1, 1649559942),
(2590, 272, '奉节县', 3, 0, 1, 1649559942),
(2591, 272, '巫山县', 3, 0, 1, 1649559942),
(2592, 272, '巫溪县', 3, 0, 1, 1649559942),
(2593, 272, '石柱土家族自治县', 3, 0, 1, 1649559942),
(2594, 272, '秀山土家族苗族自治县', 3, 0, 1, 1649559942),
(2595, 272, '酉阳土家族苗族自治县', 3, 0, 1, 1649559942),
(2596, 272, '彭水苗族土家族自治县', 3, 0, 1, 1649559942),
(2597, 273, '锦江区', 3, 0, 1, 1649559942),
(2598, 273, '青羊区', 3, 0, 1, 1649559942),
(2599, 273, '金牛区', 3, 0, 1, 1649559942),
(2600, 273, '武侯区', 3, 0, 1, 1649559942),
(2601, 273, '成华区', 3, 0, 1, 1649559942),
(2602, 273, '龙泉驿区', 3, 0, 1, 1649559942),
(2603, 273, '青白江区', 3, 0, 1, 1649559942),
(2604, 273, '新都区', 3, 0, 1, 1649559942),
(2605, 273, '温江区', 3, 0, 1, 1649559942),
(2606, 273, '双流区', 3, 0, 1, 1649559942),
(2607, 273, '郫都区', 3, 0, 1, 1649559942),
(2608, 273, '新津区', 3, 0, 1, 1649559942),
(2609, 273, '金堂县', 3, 0, 1, 1649559942),
(2610, 273, '大邑县', 3, 0, 1, 1649559942),
(2611, 273, '蒲江县', 3, 0, 1, 1649559942),
(2612, 273, '都江堰市', 3, 0, 1, 1649559942),
(2613, 273, '彭州市', 3, 0, 1, 1649559942),
(2614, 273, '邛崃市', 3, 0, 1, 1649559942),
(2615, 273, '崇州市', 3, 0, 1, 1649559942),
(2616, 273, '简阳市', 3, 0, 1, 1649559942),
(2617, 274, '自流井区', 3, 0, 1, 1649559942),
(2618, 274, '贡井区', 3, 0, 1, 1649559942),
(2619, 274, '大安区', 3, 0, 1, 1649559942),
(2620, 274, '沿滩区', 3, 0, 1, 1649559942),
(2621, 274, '荣县', 3, 0, 1, 1649559942),
(2622, 274, '富顺县', 3, 0, 1, 1649559942),
(2623, 275, '东区', 3, 0, 1, 1649559942),
(2624, 275, '西区', 3, 0, 1, 1649559942),
(2625, 275, '仁和区', 3, 0, 1, 1649559942),
(2626, 275, '米易县', 3, 0, 1, 1649559942),
(2627, 275, '盐边县', 3, 0, 1, 1649559942),
(2628, 276, '江阳区', 3, 0, 1, 1649559942),
(2629, 276, '纳溪区', 3, 0, 1, 1649559942),
(2630, 276, '龙马潭区', 3, 0, 1, 1649559942),
(2631, 276, '泸县', 3, 0, 1, 1649559942),
(2632, 276, '合江县', 3, 0, 1, 1649559942),
(2633, 276, '叙永县', 3, 0, 1, 1649559942),
(2634, 276, '古蔺县', 3, 0, 1, 1649559942),
(2635, 277, '旌阳区', 3, 0, 1, 1649559942),
(2636, 277, '罗江区', 3, 0, 1, 1649559942),
(2637, 277, '中江县', 3, 0, 1, 1649559942),
(2638, 277, '广汉市', 3, 0, 1, 1649559942),
(2639, 277, '什邡市', 3, 0, 1, 1649559942),
(2640, 277, '绵竹市', 3, 0, 1, 1649559942),
(2641, 278, '涪城区', 3, 0, 1, 1649559942),
(2642, 278, '游仙区', 3, 0, 1, 1649559942),
(2643, 278, '安州区', 3, 0, 1, 1649559942),
(2644, 278, '三台县', 3, 0, 1, 1649559942),
(2645, 278, '盐亭县', 3, 0, 1, 1649559942),
(2646, 278, '梓潼县', 3, 0, 1, 1649559942),
(2647, 278, '北川羌族自治县', 3, 0, 1, 1649559942),
(2648, 278, '平武县', 3, 0, 1, 1649559942),
(2649, 278, '江油市', 3, 0, 1, 1649559942),
(2650, 279, '利州区', 3, 0, 1, 1649559942),
(2651, 279, '昭化区', 3, 0, 1, 1649559942),
(2652, 279, '朝天区', 3, 0, 1, 1649559942),
(2653, 279, '旺苍县', 3, 0, 1, 1649559942),
(2654, 279, '青川县', 3, 0, 1, 1649559942),
(2655, 279, '剑阁县', 3, 0, 1, 1649559942),
(2656, 279, '苍溪县', 3, 0, 1, 1649559942),
(2657, 280, '船山区', 3, 0, 1, 1649559942),
(2658, 280, '安居区', 3, 0, 1, 1649559942),
(2659, 280, '蓬溪县', 3, 0, 1, 1649559942),
(2660, 280, '大英县', 3, 0, 1, 1649559942),
(2661, 280, '射洪市', 3, 0, 1, 1649559942),
(2662, 281, '市中区', 3, 0, 1, 1649559942),
(2663, 281, '东兴区', 3, 0, 1, 1649559942),
(2664, 281, '威远县', 3, 0, 1, 1649559942),
(2665, 281, '资中县', 3, 0, 1, 1649559942),
(2666, 281, '内江经济开发区', 3, 0, 1, 1649559942),
(2667, 281, '隆昌市', 3, 0, 1, 1649559942),
(2668, 282, '市中区', 3, 0, 1, 1649559942),
(2669, 282, '沙湾区', 3, 0, 1, 1649559942),
(2670, 282, '五通桥区', 3, 0, 1, 1649559942),
(2671, 282, '金口河区', 3, 0, 1, 1649559942),
(2672, 282, '犍为县', 3, 0, 1, 1649559942),
(2673, 282, '井研县', 3, 0, 1, 1649559942),
(2674, 282, '夹江县', 3, 0, 1, 1649559942),
(2675, 282, '沐川县', 3, 0, 1, 1649559942),
(2676, 282, '峨边彝族自治县', 3, 0, 1, 1649559942),
(2677, 282, '马边彝族自治县', 3, 0, 1, 1649559942),
(2678, 282, '峨眉山市', 3, 0, 1, 1649559942),
(2679, 283, '顺庆区', 3, 0, 1, 1649559942),
(2680, 283, '高坪区', 3, 0, 1, 1649559942),
(2681, 283, '嘉陵区', 3, 0, 1, 1649559942),
(2682, 283, '南部县', 3, 0, 1, 1649559942),
(2683, 283, '营山县', 3, 0, 1, 1649559942),
(2684, 283, '蓬安县', 3, 0, 1, 1649559942),
(2685, 283, '仪陇县', 3, 0, 1, 1649559942),
(2686, 283, '西充县', 3, 0, 1, 1649559942),
(2687, 283, '阆中市', 3, 0, 1, 1649559942),
(2688, 284, '东坡区', 3, 0, 1, 1649559942),
(2689, 284, '彭山区', 3, 0, 1, 1649559942),
(2690, 284, '仁寿县', 3, 0, 1, 1649559942),
(2691, 284, '洪雅县', 3, 0, 1, 1649559942),
(2692, 284, '丹棱县', 3, 0, 1, 1649559942),
(2693, 284, '青神县', 3, 0, 1, 1649559942),
(2694, 285, '翠屏区', 3, 0, 1, 1649559942),
(2695, 285, '南溪区', 3, 0, 1, 1649559942),
(2696, 285, '叙州区', 3, 0, 1, 1649559942),
(2697, 285, '江安县', 3, 0, 1, 1649559942),
(2698, 285, '长宁县', 3, 0, 1, 1649559942),
(2699, 285, '高县', 3, 0, 1, 1649559942),
(2700, 285, '珙县', 3, 0, 1, 1649559942),
(2701, 285, '筠连县', 3, 0, 1, 1649559942),
(2702, 285, '兴文县', 3, 0, 1, 1649559942),
(2703, 285, '屏山县', 3, 0, 1, 1649559942),
(2704, 286, '广安区', 3, 0, 1, 1649559942),
(2705, 286, '前锋区', 3, 0, 1, 1649559942),
(2706, 286, '岳池县', 3, 0, 1, 1649559942),
(2707, 286, '武胜县', 3, 0, 1, 1649559942),
(2708, 286, '邻水县', 3, 0, 1, 1649559942),
(2709, 286, '华蓥市', 3, 0, 1, 1649559942),
(2710, 287, '通川区', 3, 0, 1, 1649559942),
(2711, 287, '达川区', 3, 0, 1, 1649559942),
(2712, 287, '宣汉县', 3, 0, 1, 1649559942),
(2713, 287, '开江县', 3, 0, 1, 1649559942),
(2714, 287, '大竹县', 3, 0, 1, 1649559942),
(2715, 287, '渠县', 3, 0, 1, 1649559942),
(2716, 287, '达州经济开发区', 3, 0, 1, 1649559942),
(2717, 287, '万源市', 3, 0, 1, 1649559942),
(2718, 288, '雨城区', 3, 0, 1, 1649559942),
(2719, 288, '名山区', 3, 0, 1, 1649559942),
(2720, 288, '荥经县', 3, 0, 1, 1649559942),
(2721, 288, '汉源县', 3, 0, 1, 1649559942),
(2722, 288, '石棉县', 3, 0, 1, 1649559942),
(2723, 288, '天全县', 3, 0, 1, 1649559942),
(2724, 288, '芦山县', 3, 0, 1, 1649559942),
(2725, 288, '宝兴县', 3, 0, 1, 1649559942),
(2726, 289, '巴州区', 3, 0, 1, 1649559942),
(2727, 289, '恩阳区', 3, 0, 1, 1649559942),
(2728, 289, '通江县', 3, 0, 1, 1649559942),
(2729, 289, '南江县', 3, 0, 1, 1649559942),
(2730, 289, '平昌县', 3, 0, 1, 1649559942),
(2731, 289, '巴中经济开发区', 3, 0, 1, 1649559942),
(2732, 290, '雁江区', 3, 0, 1, 1649559942),
(2733, 290, '安岳县', 3, 0, 1, 1649559942),
(2734, 290, '乐至县', 3, 0, 1, 1649559942),
(2735, 291, '马尔康市', 3, 0, 1, 1649559942),
(2736, 291, '汶川县', 3, 0, 1, 1649559942),
(2737, 291, '理县', 3, 0, 1, 1649559942),
(2738, 291, '茂县', 3, 0, 1, 1649559942),
(2739, 291, '松潘县', 3, 0, 1, 1649559942),
(2740, 291, '九寨沟县', 3, 0, 1, 1649559942),
(2741, 291, '金川县', 3, 0, 1, 1649559942),
(2742, 291, '小金县', 3, 0, 1, 1649559942),
(2743, 291, '黑水县', 3, 0, 1, 1649559942),
(2744, 291, '壤塘县', 3, 0, 1, 1649559942),
(2745, 291, '阿坝县', 3, 0, 1, 1649559942),
(2746, 291, '若尔盖县', 3, 0, 1, 1649559942),
(2747, 291, '红原县', 3, 0, 1, 1649559942),
(2748, 292, '康定市', 3, 0, 1, 1649559942),
(2749, 292, '泸定县', 3, 0, 1, 1649559942),
(2750, 292, '丹巴县', 3, 0, 1, 1649559942),
(2751, 292, '九龙县', 3, 0, 1, 1649559942),
(2752, 292, '雅江县', 3, 0, 1, 1649559942),
(2753, 292, '道孚县', 3, 0, 1, 1649559942),
(2754, 292, '炉霍县', 3, 0, 1, 1649559942),
(2755, 292, '甘孜县', 3, 0, 1, 1649559942),
(2756, 292, '新龙县', 3, 0, 1, 1649559942),
(2757, 292, '德格县', 3, 0, 1, 1649559942),
(2758, 292, '白玉县', 3, 0, 1, 1649559942),
(2759, 292, '石渠县', 3, 0, 1, 1649559942),
(2760, 292, '色达县', 3, 0, 1, 1649559942),
(2761, 292, '理塘县', 3, 0, 1, 1649559942),
(2762, 292, '巴塘县', 3, 0, 1, 1649559942),
(2763, 292, '乡城县', 3, 0, 1, 1649559942),
(2764, 292, '稻城县', 3, 0, 1, 1649559942),
(2765, 292, '得荣县', 3, 0, 1, 1649559942),
(2766, 293, '西昌市', 3, 0, 1, 1649559942),
(2767, 293, '会理市', 3, 0, 1, 1649559942),
(2768, 293, '木里藏族自治县', 3, 0, 1, 1649559942),
(2769, 293, '盐源县', 3, 0, 1, 1649559942),
(2770, 293, '德昌县', 3, 0, 1, 1649559942),
(2771, 293, '会东县', 3, 0, 1, 1649559942),
(2772, 293, '宁南县', 3, 0, 1, 1649559942),
(2773, 293, '普格县', 3, 0, 1, 1649559942),
(2774, 293, '布拖县', 3, 0, 1, 1649559942),
(2775, 293, '金阳县', 3, 0, 1, 1649559942),
(2776, 293, '昭觉县', 3, 0, 1, 1649559942),
(2777, 293, '喜德县', 3, 0, 1, 1649559942),
(2778, 293, '冕宁县', 3, 0, 1, 1649559942),
(2779, 293, '越西县', 3, 0, 1, 1649559942),
(2780, 293, '甘洛县', 3, 0, 1, 1649559942),
(2781, 293, '美姑县', 3, 0, 1, 1649559942),
(2782, 293, '雷波县', 3, 0, 1, 1649559942),
(2783, 294, '南明区', 3, 0, 1, 1649559942),
(2784, 294, '云岩区', 3, 0, 1, 1649559942),
(2785, 294, '花溪区', 3, 0, 1, 1649559942),
(2786, 294, '乌当区', 3, 0, 1, 1649559942),
(2787, 294, '白云区', 3, 0, 1, 1649559942),
(2788, 294, '观山湖区', 3, 0, 1, 1649559942),
(2789, 294, '开阳县', 3, 0, 1, 1649559942),
(2790, 294, '息烽县', 3, 0, 1, 1649559942),
(2791, 294, '修文县', 3, 0, 1, 1649559942),
(2792, 294, '清镇市', 3, 0, 1, 1649559942),
(2793, 295, '钟山区', 3, 0, 1, 1649559942),
(2794, 295, '六枝特区', 3, 0, 1, 1649559942),
(2795, 295, '水城区', 3, 0, 1, 1649559942),
(2796, 295, '盘州市', 3, 0, 1, 1649559942),
(2797, 296, '红花岗区', 3, 0, 1, 1649559942),
(2798, 296, '汇川区', 3, 0, 1, 1649559942),
(2799, 296, '播州区', 3, 0, 1, 1649559942),
(2800, 296, '桐梓县', 3, 0, 1, 1649559942),
(2801, 296, '绥阳县', 3, 0, 1, 1649559942),
(2802, 296, '正安县', 3, 0, 1, 1649559942),
(2803, 296, '道真仡佬族苗族自治县', 3, 0, 1, 1649559942),
(2804, 296, '务川仡佬族苗族自治县', 3, 0, 1, 1649559942),
(2805, 296, '凤冈县', 3, 0, 1, 1649559942),
(2806, 296, '湄潭县', 3, 0, 1, 1649559942),
(2807, 296, '余庆县', 3, 0, 1, 1649559942),
(2808, 296, '习水县', 3, 0, 1, 1649559942),
(2809, 296, '赤水市', 3, 0, 1, 1649559942),
(2810, 296, '仁怀市', 3, 0, 1, 1649559942),
(2811, 297, '西秀区', 3, 0, 1, 1649559942),
(2812, 297, '平坝区', 3, 0, 1, 1649559942),
(2813, 297, '普定县', 3, 0, 1, 1649559942),
(2814, 297, '镇宁布依族苗族自治县', 3, 0, 1, 1649559942),
(2815, 297, '关岭布依族苗族自治县', 3, 0, 1, 1649559942),
(2816, 297, '紫云苗族布依族自治县', 3, 0, 1, 1649559942),
(2817, 298, '七星关区', 3, 0, 1, 1649559942),
(2818, 298, '大方县', 3, 0, 1, 1649559942),
(2819, 298, '金沙县', 3, 0, 1, 1649559942),
(2820, 298, '织金县', 3, 0, 1, 1649559942),
(2821, 298, '纳雍县', 3, 0, 1, 1649559942),
(2822, 298, '威宁彝族回族苗族自治县', 3, 0, 1, 1649559942),
(2823, 298, '赫章县', 3, 0, 1, 1649559942),
(2824, 298, '黔西市', 3, 0, 1, 1649559942),
(2825, 299, '碧江区', 3, 0, 1, 1649559942),
(2826, 299, '万山区', 3, 0, 1, 1649559942),
(2827, 299, '江口县', 3, 0, 1, 1649559942),
(2828, 299, '玉屏侗族自治县', 3, 0, 1, 1649559942),
(2829, 299, '石阡县', 3, 0, 1, 1649559942),
(2830, 299, '思南县', 3, 0, 1, 1649559942),
(2831, 299, '印江土家族苗族自治县', 3, 0, 1, 1649559942),
(2832, 299, '德江县', 3, 0, 1, 1649559942),
(2833, 299, '沿河土家族自治县', 3, 0, 1, 1649559942),
(2834, 299, '松桃苗族自治县', 3, 0, 1, 1649559942),
(2835, 300, '兴义市', 3, 0, 1, 1649559942),
(2836, 300, '兴仁市', 3, 0, 1, 1649559942),
(2837, 300, '普安县', 3, 0, 1, 1649559942),
(2838, 300, '晴隆县', 3, 0, 1, 1649559942),
(2839, 300, '贞丰县', 3, 0, 1, 1649559942),
(2840, 300, '望谟县', 3, 0, 1, 1649559942),
(2841, 300, '册亨县', 3, 0, 1, 1649559942),
(2842, 300, '安龙县', 3, 0, 1, 1649559942),
(2843, 301, '凯里市', 3, 0, 1, 1649559942),
(2844, 301, '黄平县', 3, 0, 1, 1649559942),
(2845, 301, '施秉县', 3, 0, 1, 1649559942),
(2846, 301, '三穗县', 3, 0, 1, 1649559942),
(2847, 301, '镇远县', 3, 0, 1, 1649559942),
(2848, 301, '岑巩县', 3, 0, 1, 1649559942),
(2849, 301, '天柱县', 3, 0, 1, 1649559942),
(2850, 301, '锦屏县', 3, 0, 1, 1649559942),
(2851, 301, '剑河县', 3, 0, 1, 1649559942),
(2852, 301, '台江县', 3, 0, 1, 1649559942),
(2853, 301, '黎平县', 3, 0, 1, 1649559942),
(2854, 301, '榕江县', 3, 0, 1, 1649559942),
(2855, 301, '从江县', 3, 0, 1, 1649559942),
(2856, 301, '雷山县', 3, 0, 1, 1649559942),
(2857, 301, '麻江县', 3, 0, 1, 1649559942),
(2858, 301, '丹寨县', 3, 0, 1, 1649559942),
(2859, 302, '都匀市', 3, 0, 1, 1649559942),
(2860, 302, '福泉市', 3, 0, 1, 1649559942),
(2861, 302, '荔波县', 3, 0, 1, 1649559942),
(2862, 302, '贵定县', 3, 0, 1, 1649559942),
(2863, 302, '瓮安县', 3, 0, 1, 1649559942),
(2864, 302, '独山县', 3, 0, 1, 1649559942),
(2865, 302, '平塘县', 3, 0, 1, 1649559942),
(2866, 302, '罗甸县', 3, 0, 1, 1649559942),
(2867, 302, '长顺县', 3, 0, 1, 1649559942),
(2868, 302, '龙里县', 3, 0, 1, 1649559942),
(2869, 302, '惠水县', 3, 0, 1, 1649559942),
(2870, 302, '三都水族自治县', 3, 0, 1, 1649559942),
(2871, 303, '五华区', 3, 0, 1, 1649559942),
(2872, 303, '盘龙区', 3, 0, 1, 1649559942),
(2873, 303, '官渡区', 3, 0, 1, 1649559942),
(2874, 303, '西山区', 3, 0, 1, 1649559942),
(2875, 303, '东川区', 3, 0, 1, 1649559942),
(2876, 303, '呈贡区', 3, 0, 1, 1649559942),
(2877, 303, '晋宁区', 3, 0, 1, 1649559942),
(2878, 303, '富民县', 3, 0, 1, 1649559942),
(2879, 303, '宜良县', 3, 0, 1, 1649559942),
(2880, 303, '石林彝族自治县', 3, 0, 1, 1649559942),
(2881, 303, '嵩明县', 3, 0, 1, 1649559942),
(2882, 303, '禄劝彝族苗族自治县', 3, 0, 1, 1649559942),
(2883, 303, '寻甸回族彝族自治县', 3, 0, 1, 1649559942),
(2884, 303, '安宁市', 3, 0, 1, 1649559942),
(2885, 304, '麒麟区', 3, 0, 1, 1649559942),
(2886, 304, '沾益区', 3, 0, 1, 1649559942),
(2887, 304, '马龙区', 3, 0, 1, 1649559942),
(2888, 304, '陆良县', 3, 0, 1, 1649559942),
(2889, 304, '师宗县', 3, 0, 1, 1649559942),
(2890, 304, '罗平县', 3, 0, 1, 1649559942),
(2891, 304, '富源县', 3, 0, 1, 1649559942),
(2892, 304, '会泽县', 3, 0, 1, 1649559942),
(2893, 304, '宣威市', 3, 0, 1, 1649559942),
(2894, 305, '红塔区', 3, 0, 1, 1649559942),
(2895, 305, '江川区', 3, 0, 1, 1649559942),
(2896, 305, '通海县', 3, 0, 1, 1649559942),
(2897, 305, '华宁县', 3, 0, 1, 1649559942),
(2898, 305, '易门县', 3, 0, 1, 1649559942),
(2899, 305, '峨山彝族自治县', 3, 0, 1, 1649559942),
(2900, 305, '新平彝族傣族自治县', 3, 0, 1, 1649559942),
(2901, 305, '元江哈尼族彝族傣族自治县', 3, 0, 1, 1649559942),
(2902, 305, '澄江市', 3, 0, 1, 1649559942),
(2903, 306, '隆阳区', 3, 0, 1, 1649559942),
(2904, 306, '施甸县', 3, 0, 1, 1649559942),
(2905, 306, '龙陵县', 3, 0, 1, 1649559942),
(2906, 306, '昌宁县', 3, 0, 1, 1649559942),
(2907, 306, '腾冲市', 3, 0, 1, 1649559942),
(2908, 307, '昭阳区', 3, 0, 1, 1649559942),
(2909, 307, '鲁甸县', 3, 0, 1, 1649559942),
(2910, 307, '巧家县', 3, 0, 1, 1649559942),
(2911, 307, '盐津县', 3, 0, 1, 1649559942),
(2912, 307, '大关县', 3, 0, 1, 1649559942),
(2913, 307, '永善县', 3, 0, 1, 1649559942),
(2914, 307, '绥江县', 3, 0, 1, 1649559942),
(2915, 307, '镇雄县', 3, 0, 1, 1649559942),
(2916, 307, '彝良县', 3, 0, 1, 1649559942),
(2917, 307, '威信县', 3, 0, 1, 1649559942),
(2918, 307, '水富市', 3, 0, 1, 1649559942),
(2919, 308, '古城区', 3, 0, 1, 1649559942),
(2920, 308, '玉龙纳西族自治县', 3, 0, 1, 1649559942),
(2921, 308, '永胜县', 3, 0, 1, 1649559942),
(2922, 308, '华坪县', 3, 0, 1, 1649559942),
(2923, 308, '宁蒗彝族自治县', 3, 0, 1, 1649559942),
(2924, 309, '思茅区', 3, 0, 1, 1649559942),
(2925, 309, '宁洱哈尼族彝族自治县', 3, 0, 1, 1649559942),
(2926, 309, '墨江哈尼族自治县', 3, 0, 1, 1649559942),
(2927, 309, '景东彝族自治县', 3, 0, 1, 1649559942),
(2928, 309, '景谷傣族彝族自治县', 3, 0, 1, 1649559942),
(2929, 309, '镇沅彝族哈尼族拉祜族自治县', 3, 0, 1, 1649559942),
(2930, 309, '江城哈尼族彝族自治县', 3, 0, 1, 1649559942),
(2931, 309, '孟连傣族拉祜族佤族自治县', 3, 0, 1, 1649559942),
(2932, 309, '澜沧拉祜族自治县', 3, 0, 1, 1649559942),
(2933, 309, '西盟佤族自治县', 3, 0, 1, 1649559942),
(2934, 310, '临翔区', 3, 0, 1, 1649559942),
(2935, 310, '凤庆县', 3, 0, 1, 1649559942),
(2936, 310, '云县', 3, 0, 1, 1649559942),
(2937, 310, '永德县', 3, 0, 1, 1649559942),
(2938, 310, '镇康县', 3, 0, 1, 1649559942),
(2939, 310, '双江拉祜族佤族布朗族傣族自治县', 3, 0, 1, 1649559942),
(2940, 310, '耿马傣族佤族自治县', 3, 0, 1, 1649559942),
(2941, 310, '沧源佤族自治县', 3, 0, 1, 1649559942),
(2942, 311, '楚雄市', 3, 0, 1, 1649559942),
(2943, 311, '禄丰市', 3, 0, 1, 1649559942),
(2944, 311, '双柏县', 3, 0, 1, 1649559942),
(2945, 311, '牟定县', 3, 0, 1, 1649559942),
(2946, 311, '南华县', 3, 0, 1, 1649559942),
(2947, 311, '姚安县', 3, 0, 1, 1649559942),
(2948, 311, '大姚县', 3, 0, 1, 1649559942),
(2949, 311, '永仁县', 3, 0, 1, 1649559942),
(2950, 311, '元谋县', 3, 0, 1, 1649559942),
(2951, 311, '武定县', 3, 0, 1, 1649559942),
(2952, 312, '个旧市', 3, 0, 1, 1649559942),
(2953, 312, '开远市', 3, 0, 1, 1649559942),
(2954, 312, '蒙自市', 3, 0, 1, 1649559942),
(2955, 312, '弥勒市', 3, 0, 1, 1649559942),
(2956, 312, '屏边苗族自治县', 3, 0, 1, 1649559942),
(2957, 312, '建水县', 3, 0, 1, 1649559942),
(2958, 312, '石屏县', 3, 0, 1, 1649559942),
(2959, 312, '泸西县', 3, 0, 1, 1649559942),
(2960, 312, '元阳县', 3, 0, 1, 1649559942),
(2961, 312, '红河县', 3, 0, 1, 1649559942),
(2962, 312, '金平苗族瑶族傣族自治县', 3, 0, 1, 1649559942),
(2963, 312, '绿春县', 3, 0, 1, 1649559942),
(2964, 312, '河口瑶族自治县', 3, 0, 1, 1649559942),
(2965, 313, '文山市', 3, 0, 1, 1649559942),
(2966, 313, '砚山县', 3, 0, 1, 1649559942),
(2967, 313, '西畴县', 3, 0, 1, 1649559942),
(2968, 313, '麻栗坡县', 3, 0, 1, 1649559942),
(2969, 313, '马关县', 3, 0, 1, 1649559942),
(2970, 313, '丘北县', 3, 0, 1, 1649559942),
(2971, 313, '广南县', 3, 0, 1, 1649559942),
(2972, 313, '富宁县', 3, 0, 1, 1649559942),
(2973, 314, '景洪市', 3, 0, 1, 1649559942),
(2974, 314, '勐海县', 3, 0, 1, 1649559942),
(2975, 314, '勐腊县', 3, 0, 1, 1649559942),
(2976, 315, '大理市', 3, 0, 1, 1649559942),
(2977, 315, '漾濞彝族自治县', 3, 0, 1, 1649559942),
(2978, 315, '祥云县', 3, 0, 1, 1649559942),
(2979, 315, '宾川县', 3, 0, 1, 1649559942),
(2980, 315, '弥渡县', 3, 0, 1, 1649559942),
(2981, 315, '南涧彝族自治县', 3, 0, 1, 1649559942),
(2982, 315, '巍山彝族回族自治县', 3, 0, 1, 1649559942),
(2983, 315, '永平县', 3, 0, 1, 1649559942),
(2984, 315, '云龙县', 3, 0, 1, 1649559942),
(2985, 315, '洱源县', 3, 0, 1, 1649559942),
(2986, 315, '剑川县', 3, 0, 1, 1649559942),
(2987, 315, '鹤庆县', 3, 0, 1, 1649559942),
(2988, 316, '瑞丽市', 3, 0, 1, 1649559942),
(2989, 316, '芒市', 3, 0, 1, 1649559942),
(2990, 316, '梁河县', 3, 0, 1, 1649559942),
(2991, 316, '盈江县', 3, 0, 1, 1649559942),
(2992, 316, '陇川县', 3, 0, 1, 1649559942),
(2993, 317, '泸水市', 3, 0, 1, 1649559942),
(2994, 317, '福贡县', 3, 0, 1, 1649559942),
(2995, 317, '贡山独龙族怒族自治县', 3, 0, 1, 1649559942),
(2996, 317, '兰坪白族普米族自治县', 3, 0, 1, 1649559942),
(2997, 318, '香格里拉市', 3, 0, 1, 1649559942),
(2998, 318, '德钦县', 3, 0, 1, 1649559942),
(2999, 318, '维西傈僳族自治县', 3, 0, 1, 1649559942),
(3000, 319, '城关区', 3, 0, 1, 1649559942),
(3001, 319, '堆龙德庆区', 3, 0, 1, 1649559942),
(3002, 319, '达孜区', 3, 0, 1, 1649559942),
(3003, 319, '林周县', 3, 0, 1, 1649559942),
(3004, 319, '当雄县', 3, 0, 1, 1649559942),
(3005, 319, '尼木县', 3, 0, 1, 1649559942),
(3006, 319, '曲水县', 3, 0, 1, 1649559942),
(3007, 319, '墨竹工卡县', 3, 0, 1, 1649559942),
(3008, 319, '格尔木藏青工业园区', 3, 0, 1, 1649559942),
(3009, 319, '拉萨经济技术开发区', 3, 0, 1, 1649559942),
(3010, 319, '西藏文化旅游创意园区', 3, 0, 1, 1649559942),
(3011, 319, '达孜工业园区', 3, 0, 1, 1649559942),
(3012, 320, '桑珠孜区', 3, 0, 1, 1649559942),
(3013, 320, '南木林县', 3, 0, 1, 1649559942),
(3014, 320, '江孜县', 3, 0, 1, 1649559942),
(3015, 320, '定日县', 3, 0, 1, 1649559942),
(3016, 320, '萨迦县', 3, 0, 1, 1649559942),
(3017, 320, '拉孜县', 3, 0, 1, 1649559942),
(3018, 320, '昂仁县', 3, 0, 1, 1649559942),
(3019, 320, '谢通门县', 3, 0, 1, 1649559942),
(3020, 320, '白朗县', 3, 0, 1, 1649559942),
(3021, 320, '仁布县', 3, 0, 1, 1649559942),
(3022, 320, '康马县', 3, 0, 1, 1649559942),
(3023, 320, '定结县', 3, 0, 1, 1649559942),
(3024, 320, '仲巴县', 3, 0, 1, 1649559942),
(3025, 320, '亚东县', 3, 0, 1, 1649559942),
(3026, 320, '吉隆县', 3, 0, 1, 1649559942),
(3027, 320, '聂拉木县', 3, 0, 1, 1649559942),
(3028, 320, '萨嘎县', 3, 0, 1, 1649559942),
(3029, 320, '岗巴县', 3, 0, 1, 1649559942),
(3030, 321, '卡若区', 3, 0, 1, 1649559942),
(3031, 321, '江达县', 3, 0, 1, 1649559942),
(3032, 321, '贡觉县', 3, 0, 1, 1649559942),
(3033, 321, '类乌齐县', 3, 0, 1, 1649559942),
(3034, 321, '丁青县', 3, 0, 1, 1649559942),
(3035, 321, '察雅县', 3, 0, 1, 1649559942),
(3036, 321, '八宿县', 3, 0, 1, 1649559942),
(3037, 321, '左贡县', 3, 0, 1, 1649559942),
(3038, 321, '芒康县', 3, 0, 1, 1649559942),
(3039, 321, '洛隆县', 3, 0, 1, 1649559942),
(3040, 321, '边坝县', 3, 0, 1, 1649559942),
(3041, 322, '巴宜区', 3, 0, 1, 1649559942),
(3042, 322, '工布江达县', 3, 0, 1, 1649559942),
(3043, 322, '米林县', 3, 0, 1, 1649559942),
(3044, 322, '墨脱县', 3, 0, 1, 1649559942),
(3045, 322, '波密县', 3, 0, 1, 1649559942),
(3046, 322, '察隅县', 3, 0, 1, 1649559942),
(3047, 322, '朗县', 3, 0, 1, 1649559942),
(3048, 323, '乃东区', 3, 0, 1, 1649559942),
(3049, 323, '扎囊县', 3, 0, 1, 1649559942),
(3050, 323, '贡嘎县', 3, 0, 1, 1649559942),
(3051, 323, '桑日县', 3, 0, 1, 1649559942),
(3052, 323, '琼结县', 3, 0, 1, 1649559942),
(3053, 323, '曲松县', 3, 0, 1, 1649559942),
(3054, 323, '措美县', 3, 0, 1, 1649559942),
(3055, 323, '洛扎县', 3, 0, 1, 1649559942),
(3056, 323, '加查县', 3, 0, 1, 1649559942),
(3057, 323, '隆子县', 3, 0, 1, 1649559942),
(3058, 323, '错那县', 3, 0, 1, 1649559942),
(3059, 323, '浪卡子县', 3, 0, 1, 1649559942),
(3060, 324, '色尼区', 3, 0, 1, 1649559942),
(3061, 324, '嘉黎县', 3, 0, 1, 1649559942),
(3062, 324, '比如县', 3, 0, 1, 1649559942),
(3063, 324, '聂荣县', 3, 0, 1, 1649559942),
(3064, 324, '安多县', 3, 0, 1, 1649559942),
(3065, 324, '申扎县', 3, 0, 1, 1649559942),
(3066, 324, '索县', 3, 0, 1, 1649559942),
(3067, 324, '班戈县', 3, 0, 1, 1649559942),
(3068, 324, '巴青县', 3, 0, 1, 1649559942),
(3069, 324, '尼玛县', 3, 0, 1, 1649559942),
(3070, 324, '双湖县', 3, 0, 1, 1649559942),
(3071, 325, '普兰县', 3, 0, 1, 1649559942),
(3072, 325, '札达县', 3, 0, 1, 1649559942),
(3073, 325, '噶尔县', 3, 0, 1, 1649559942),
(3074, 325, '日土县', 3, 0, 1, 1649559942),
(3075, 325, '革吉县', 3, 0, 1, 1649559942),
(3076, 325, '改则县', 3, 0, 1, 1649559942),
(3077, 325, '措勤县', 3, 0, 1, 1649559942),
(3078, 326, '新城区', 3, 0, 1, 1649559942),
(3079, 326, '碑林区', 3, 0, 1, 1649559942),
(3080, 326, '莲湖区', 3, 0, 1, 1649559942),
(3081, 326, '灞桥区', 3, 0, 1, 1649559942),
(3082, 326, '未央区', 3, 0, 1, 1649559942),
(3083, 326, '雁塔区', 3, 0, 1, 1649559942),
(3084, 326, '阎良区', 3, 0, 1, 1649559942),
(3085, 326, '临潼区', 3, 0, 1, 1649559942),
(3086, 326, '长安区', 3, 0, 1, 1649559942),
(3087, 326, '高陵区', 3, 0, 1, 1649559942),
(3088, 326, '鄠邑区', 3, 0, 1, 1649559942),
(3089, 326, '蓝田县', 3, 0, 1, 1649559942),
(3090, 326, '周至县', 3, 0, 1, 1649559942),
(3091, 327, '王益区', 3, 0, 1, 1649559942),
(3092, 327, '印台区', 3, 0, 1, 1649559942),
(3093, 327, '耀州区', 3, 0, 1, 1649559942),
(3094, 327, '宜君县', 3, 0, 1, 1649559942),
(3095, 328, '渭滨区', 3, 0, 1, 1649559942),
(3096, 328, '金台区', 3, 0, 1, 1649559942),
(3097, 328, '陈仓区', 3, 0, 1, 1649559942),
(3098, 328, '凤翔区', 3, 0, 1, 1649559942),
(3099, 328, '岐山县', 3, 0, 1, 1649559942),
(3100, 328, '扶风县', 3, 0, 1, 1649559942),
(3101, 328, '眉县', 3, 0, 1, 1649559942),
(3102, 328, '陇县', 3, 0, 1, 1649559942),
(3103, 328, '千阳县', 3, 0, 1, 1649559942),
(3104, 328, '麟游县', 3, 0, 1, 1649559942),
(3105, 328, '凤县', 3, 0, 1, 1649559942),
(3106, 328, '太白县', 3, 0, 1, 1649559942),
(3107, 329, '秦都区', 3, 0, 1, 1649559942),
(3108, 329, '杨陵区', 3, 0, 1, 1649559942),
(3109, 329, '渭城区', 3, 0, 1, 1649559942),
(3110, 329, '三原县', 3, 0, 1, 1649559942),
(3111, 329, '泾阳县', 3, 0, 1, 1649559942),
(3112, 329, '乾县', 3, 0, 1, 1649559942),
(3113, 329, '礼泉县', 3, 0, 1, 1649559942),
(3114, 329, '永寿县', 3, 0, 1, 1649559942),
(3115, 329, '长武县', 3, 0, 1, 1649559942),
(3116, 329, '旬邑县', 3, 0, 1, 1649559942),
(3117, 329, '淳化县', 3, 0, 1, 1649559942),
(3118, 329, '武功县', 3, 0, 1, 1649559942),
(3119, 329, '兴平市', 3, 0, 1, 1649559942),
(3120, 329, '彬州市', 3, 0, 1, 1649559942),
(3121, 330, '临渭区', 3, 0, 1, 1649559942),
(3122, 330, '华州区', 3, 0, 1, 1649559942),
(3123, 330, '潼关县', 3, 0, 1, 1649559942),
(3124, 330, '大荔县', 3, 0, 1, 1649559942),
(3125, 330, '合阳县', 3, 0, 1, 1649559942),
(3126, 330, '澄城县', 3, 0, 1, 1649559942),
(3127, 330, '蒲城县', 3, 0, 1, 1649559942),
(3128, 330, '白水县', 3, 0, 1, 1649559942),
(3129, 330, '富平县', 3, 0, 1, 1649559942),
(3130, 330, '韩城市', 3, 0, 1, 1649559942),
(3131, 330, '华阴市', 3, 0, 1, 1649559942),
(3132, 331, '宝塔区', 3, 0, 1, 1649559942),
(3133, 331, '安塞区', 3, 0, 1, 1649559942),
(3134, 331, '延长县', 3, 0, 1, 1649559942),
(3135, 331, '延川县', 3, 0, 1, 1649559942),
(3136, 331, '志丹县', 3, 0, 1, 1649559942),
(3137, 331, '吴起县', 3, 0, 1, 1649559942),
(3138, 331, '甘泉县', 3, 0, 1, 1649559942),
(3139, 331, '富县', 3, 0, 1, 1649559942),
(3140, 331, '洛川县', 3, 0, 1, 1649559942),
(3141, 331, '宜川县', 3, 0, 1, 1649559942),
(3142, 331, '黄龙县', 3, 0, 1, 1649559942),
(3143, 331, '黄陵县', 3, 0, 1, 1649559942),
(3144, 331, '子长市', 3, 0, 1, 1649559942),
(3145, 332, '汉台区', 3, 0, 1, 1649559942),
(3146, 332, '南郑区', 3, 0, 1, 1649559942),
(3147, 332, '城固县', 3, 0, 1, 1649559942),
(3148, 332, '洋县', 3, 0, 1, 1649559942),
(3149, 332, '西乡县', 3, 0, 1, 1649559942),
(3150, 332, '勉县', 3, 0, 1, 1649559942),
(3151, 332, '宁强县', 3, 0, 1, 1649559942),
(3152, 332, '略阳县', 3, 0, 1, 1649559942),
(3153, 332, '镇巴县', 3, 0, 1, 1649559942),
(3154, 332, '留坝县', 3, 0, 1, 1649559942),
(3155, 332, '佛坪县', 3, 0, 1, 1649559942),
(3156, 333, '榆阳区', 3, 0, 1, 1649559942),
(3157, 333, '横山区', 3, 0, 1, 1649559942),
(3158, 333, '府谷县', 3, 0, 1, 1649559942),
(3159, 333, '靖边县', 3, 0, 1, 1649559942),
(3160, 333, '定边县', 3, 0, 1, 1649559942),
(3161, 333, '绥德县', 3, 0, 1, 1649559942),
(3162, 333, '米脂县', 3, 0, 1, 1649559942),
(3163, 333, '佳县', 3, 0, 1, 1649559942),
(3164, 333, '吴堡县', 3, 0, 1, 1649559942),
(3165, 333, '清涧县', 3, 0, 1, 1649559942),
(3166, 333, '子洲县', 3, 0, 1, 1649559942),
(3167, 333, '神木市', 3, 0, 1, 1649559942),
(3168, 334, '汉滨区', 3, 0, 1, 1649559942),
(3169, 334, '汉阴县', 3, 0, 1, 1649559942),
(3170, 334, '石泉县', 3, 0, 1, 1649559942),
(3171, 334, '宁陕县', 3, 0, 1, 1649559942),
(3172, 334, '紫阳县', 3, 0, 1, 1649559942),
(3173, 334, '岚皋县', 3, 0, 1, 1649559942),
(3174, 334, '平利县', 3, 0, 1, 1649559942),
(3175, 334, '镇坪县', 3, 0, 1, 1649559942),
(3176, 334, '白河县', 3, 0, 1, 1649559942),
(3177, 334, '旬阳市', 3, 0, 1, 1649559942),
(3178, 335, '商州区', 3, 0, 1, 1649559942),
(3179, 335, '洛南县', 3, 0, 1, 1649559942),
(3180, 335, '丹凤县', 3, 0, 1, 1649559942),
(3181, 335, '商南县', 3, 0, 1, 1649559942),
(3182, 335, '山阳县', 3, 0, 1, 1649559942),
(3183, 335, '镇安县', 3, 0, 1, 1649559942),
(3184, 335, '柞水县', 3, 0, 1, 1649559942),
(3185, 336, '城关区', 3, 0, 1, 1649559942),
(3186, 336, '七里河区', 3, 0, 1, 1649559942),
(3187, 336, '西固区', 3, 0, 1, 1649559942),
(3188, 336, '安宁区', 3, 0, 1, 1649559942),
(3189, 336, '红古区', 3, 0, 1, 1649559942),
(3190, 336, '永登县', 3, 0, 1, 1649559942),
(3191, 336, '皋兰县', 3, 0, 1, 1649559942),
(3192, 336, '榆中县', 3, 0, 1, 1649559942),
(3193, 336, '兰州新区', 3, 0, 1, 1649559942),
(3194, 337, '嘉峪关市', 3, 0, 1, 1649559942),
(3195, 338, '金川区', 3, 0, 1, 1649559942),
(3196, 338, '永昌县', 3, 0, 1, 1649559942),
(3197, 339, '白银区', 3, 0, 1, 1649559942),
(3198, 339, '平川区', 3, 0, 1, 1649559942),
(3199, 339, '靖远县', 3, 0, 1, 1649559942),
(3200, 339, '会宁县', 3, 0, 1, 1649559942),
(3201, 339, '景泰县', 3, 0, 1, 1649559942),
(3202, 340, '秦州区', 3, 0, 1, 1649559942),
(3203, 340, '麦积区', 3, 0, 1, 1649559942),
(3204, 340, '清水县', 3, 0, 1, 1649559942),
(3205, 340, '秦安县', 3, 0, 1, 1649559942),
(3206, 340, '甘谷县', 3, 0, 1, 1649559942),
(3207, 340, '武山县', 3, 0, 1, 1649559942),
(3208, 340, '张家川回族自治县', 3, 0, 1, 1649559942),
(3209, 341, '凉州区', 3, 0, 1, 1649559942),
(3210, 341, '民勤县', 3, 0, 1, 1649559942),
(3211, 341, '古浪县', 3, 0, 1, 1649559942),
(3212, 341, '天祝藏族自治县', 3, 0, 1, 1649559942),
(3213, 342, '甘州区', 3, 0, 1, 1649559942),
(3214, 342, '肃南裕固族自治县', 3, 0, 1, 1649559942),
(3215, 342, '民乐县', 3, 0, 1, 1649559942),
(3216, 342, '临泽县', 3, 0, 1, 1649559942),
(3217, 342, '高台县', 3, 0, 1, 1649559942),
(3218, 342, '山丹县', 3, 0, 1, 1649559942),
(3219, 343, '崆峒区', 3, 0, 1, 1649559942),
(3220, 343, '泾川县', 3, 0, 1, 1649559942),
(3221, 343, '灵台县', 3, 0, 1, 1649559942),
(3222, 343, '崇信县', 3, 0, 1, 1649559942),
(3223, 343, '庄浪县', 3, 0, 1, 1649559942),
(3224, 343, '静宁县', 3, 0, 1, 1649559942),
(3225, 343, '华亭市', 3, 0, 1, 1649559942),
(3226, 344, '肃州区', 3, 0, 1, 1649559942),
(3227, 344, '金塔县', 3, 0, 1, 1649559942),
(3228, 344, '瓜州县', 3, 0, 1, 1649559942),
(3229, 344, '肃北蒙古族自治县', 3, 0, 1, 1649559942),
(3230, 344, '阿克塞哈萨克族自治县', 3, 0, 1, 1649559942),
(3231, 344, '玉门市', 3, 0, 1, 1649559942),
(3232, 344, '敦煌市', 3, 0, 1, 1649559942),
(3233, 345, '西峰区', 3, 0, 1, 1649559942),
(3234, 345, '庆城县', 3, 0, 1, 1649559942),
(3235, 345, '环县', 3, 0, 1, 1649559942),
(3236, 345, '华池县', 3, 0, 1, 1649559942),
(3237, 345, '合水县', 3, 0, 1, 1649559942),
(3238, 345, '正宁县', 3, 0, 1, 1649559942),
(3239, 345, '宁县', 3, 0, 1, 1649559942),
(3240, 345, '镇原县', 3, 0, 1, 1649559942),
(3241, 346, '安定区', 3, 0, 1, 1649559942),
(3242, 346, '通渭县', 3, 0, 1, 1649559942),
(3243, 346, '陇西县', 3, 0, 1, 1649559942),
(3244, 346, '渭源县', 3, 0, 1, 1649559942),
(3245, 346, '临洮县', 3, 0, 1, 1649559942),
(3246, 346, '漳县', 3, 0, 1, 1649559942),
(3247, 346, '岷县', 3, 0, 1, 1649559942),
(3248, 347, '武都区', 3, 0, 1, 1649559942),
(3249, 347, '成县', 3, 0, 1, 1649559942),
(3250, 347, '文县', 3, 0, 1, 1649559942),
(3251, 347, '宕昌县', 3, 0, 1, 1649559942),
(3252, 347, '康县', 3, 0, 1, 1649559942),
(3253, 347, '西和县', 3, 0, 1, 1649559942),
(3254, 347, '礼县', 3, 0, 1, 1649559942),
(3255, 347, '徽县', 3, 0, 1, 1649559942),
(3256, 347, '两当县', 3, 0, 1, 1649559942),
(3257, 348, '临夏市', 3, 0, 1, 1649559942),
(3258, 348, '临夏县', 3, 0, 1, 1649559942),
(3259, 348, '康乐县', 3, 0, 1, 1649559942),
(3260, 348, '永靖县', 3, 0, 1, 1649559942),
(3261, 348, '广河县', 3, 0, 1, 1649559942),
(3262, 348, '和政县', 3, 0, 1, 1649559942),
(3263, 348, '东乡族自治县', 3, 0, 1, 1649559942),
(3264, 348, '积石山保安族东乡族撒拉族自治县', 3, 0, 1, 1649559942),
(3265, 349, '合作市', 3, 0, 1, 1649559942),
(3266, 349, '临潭县', 3, 0, 1, 1649559942),
(3267, 349, '卓尼县', 3, 0, 1, 1649559942),
(3268, 349, '舟曲县', 3, 0, 1, 1649559942),
(3269, 349, '迭部县', 3, 0, 1, 1649559942),
(3270, 349, '玛曲县', 3, 0, 1, 1649559942),
(3271, 349, '碌曲县', 3, 0, 1, 1649559942),
(3272, 349, '夏河县', 3, 0, 1, 1649559942),
(3273, 350, '城东区', 3, 0, 1, 1649559942),
(3274, 350, '城中区', 3, 0, 1, 1649559942),
(3275, 350, '城西区', 3, 0, 1, 1649559942),
(3276, 350, '城北区', 3, 0, 1, 1649559942),
(3277, 350, '湟中区', 3, 0, 1, 1649559942),
(3278, 350, '大通回族土族自治县', 3, 0, 1, 1649559942),
(3279, 350, '湟源县', 3, 0, 1, 1649559942),
(3280, 351, '乐都区', 3, 0, 1, 1649559942),
(3281, 351, '平安区', 3, 0, 1, 1649559942),
(3282, 351, '民和回族土族自治县', 3, 0, 1, 1649559942),
(3283, 351, '互助土族自治县', 3, 0, 1, 1649559942),
(3284, 351, '化隆回族自治县', 3, 0, 1, 1649559942),
(3285, 351, '循化撒拉族自治县', 3, 0, 1, 1649559942),
(3286, 352, '门源回族自治县', 3, 0, 1, 1649559942),
(3287, 352, '祁连县', 3, 0, 1, 1649559942),
(3288, 352, '海晏县', 3, 0, 1, 1649559942),
(3289, 352, '刚察县', 3, 0, 1, 1649559942),
(3290, 353, '同仁市', 3, 0, 1, 1649559942),
(3291, 353, '尖扎县', 3, 0, 1, 1649559942),
(3292, 353, '泽库县', 3, 0, 1, 1649559942),
(3293, 353, '河南蒙古族自治县', 3, 0, 1, 1649559942),
(3294, 354, '共和县', 3, 0, 1, 1649559942),
(3295, 354, '同德县', 3, 0, 1, 1649559942),
(3296, 354, '贵德县', 3, 0, 1, 1649559942),
(3297, 354, '兴海县', 3, 0, 1, 1649559942),
(3298, 354, '贵南县', 3, 0, 1, 1649559942),
(3299, 355, '玛沁县', 3, 0, 1, 1649559942),
(3300, 355, '班玛县', 3, 0, 1, 1649559942),
(3301, 355, '甘德县', 3, 0, 1, 1649559942),
(3302, 355, '达日县', 3, 0, 1, 1649559942),
(3303, 355, '久治县', 3, 0, 1, 1649559942),
(3304, 355, '玛多县', 3, 0, 1, 1649559942),
(3305, 356, '玉树市', 3, 0, 1, 1649559942),
(3306, 356, '杂多县', 3, 0, 1, 1649559942),
(3307, 356, '称多县', 3, 0, 1, 1649559942),
(3308, 356, '治多县', 3, 0, 1, 1649559942),
(3309, 356, '囊谦县', 3, 0, 1, 1649559942),
(3310, 356, '曲麻莱县', 3, 0, 1, 1649559942),
(3311, 357, '格尔木市', 3, 0, 1, 1649559942),
(3312, 357, '德令哈市', 3, 0, 1, 1649559942),
(3313, 357, '茫崖市', 3, 0, 1, 1649559942),
(3314, 357, '乌兰县', 3, 0, 1, 1649559942),
(3315, 357, '都兰县', 3, 0, 1, 1649559942),
(3316, 357, '天峻县', 3, 0, 1, 1649559942),
(3317, 357, '大柴旦行政委员会', 3, 0, 1, 1649559942),
(3318, 358, '兴庆区', 3, 0, 1, 1649559942),
(3319, 358, '西夏区', 3, 0, 1, 1649559942),
(3320, 358, '金凤区', 3, 0, 1, 1649559942),
(3321, 358, '永宁县', 3, 0, 1, 1649559942),
(3322, 358, '贺兰县', 3, 0, 1, 1649559942),
(3323, 358, '灵武市', 3, 0, 1, 1649559942),
(3324, 359, '大武口区', 3, 0, 1, 1649559942),
(3325, 359, '惠农区', 3, 0, 1, 1649559942),
(3326, 359, '平罗县', 3, 0, 1, 1649559942),
(3327, 360, '利通区', 3, 0, 1, 1649559942),
(3328, 360, '红寺堡区', 3, 0, 1, 1649559942),
(3329, 360, '盐池县', 3, 0, 1, 1649559942),
(3330, 360, '同心县', 3, 0, 1, 1649559942),
(3331, 360, '青铜峡市', 3, 0, 1, 1649559942),
(3332, 361, '原州区', 3, 0, 1, 1649559942),
(3333, 361, '西吉县', 3, 0, 1, 1649559942),
(3334, 361, '隆德县', 3, 0, 1, 1649559942),
(3335, 361, '泾源县', 3, 0, 1, 1649559942),
(3336, 361, '彭阳县', 3, 0, 1, 1649559942),
(3337, 362, '沙坡头区', 3, 0, 1, 1649559942),
(3338, 362, '中宁县', 3, 0, 1, 1649559942),
(3339, 362, '海原县', 3, 0, 1, 1649559942),
(3340, 363, '天山区', 3, 0, 1, 1649559942),
(3341, 363, '沙依巴克区', 3, 0, 1, 1649559942),
(3342, 363, '新市区', 3, 0, 1, 1649559942),
(3343, 363, '水磨沟区', 3, 0, 1, 1649559942),
(3344, 363, '头屯河区', 3, 0, 1, 1649559942),
(3345, 363, '达坂城区', 3, 0, 1, 1649559942),
(3346, 363, '米东区', 3, 0, 1, 1649559942),
(3347, 363, '乌鲁木齐县', 3, 0, 1, 1649559942),
(3348, 364, '独山子区', 3, 0, 1, 1649559942),
(3349, 364, '克拉玛依区', 3, 0, 1, 1649559942),
(3350, 364, '白碱滩区', 3, 0, 1, 1649559942),
(3351, 364, '乌尔禾区', 3, 0, 1, 1649559942),
(3352, 365, '高昌区', 3, 0, 1, 1649559942),
(3353, 365, '鄯善县', 3, 0, 1, 1649559942),
(3354, 365, '托克逊县', 3, 0, 1, 1649559942),
(3355, 366, '伊州区', 3, 0, 1, 1649559942),
(3356, 366, '巴里坤哈萨克自治县', 3, 0, 1, 1649559942),
(3357, 366, '伊吾县', 3, 0, 1, 1649559942),
(3358, 367, '昌吉市', 3, 0, 1, 1649559942),
(3359, 367, '阜康市', 3, 0, 1, 1649559942),
(3360, 367, '呼图壁县', 3, 0, 1, 1649559942),
(3361, 367, '玛纳斯县', 3, 0, 1, 1649559942),
(3362, 367, '奇台县', 3, 0, 1, 1649559942),
(3363, 367, '吉木萨尔县', 3, 0, 1, 1649559942),
(3364, 367, '木垒哈萨克自治县', 3, 0, 1, 1649559942),
(3365, 368, '博乐市', 3, 0, 1, 1649559942),
(3366, 368, '阿拉山口市', 3, 0, 1, 1649559942),
(3367, 368, '精河县', 3, 0, 1, 1649559942),
(3368, 368, '温泉县', 3, 0, 1, 1649559942),
(3369, 369, '库尔勒市', 3, 0, 1, 1649559942),
(3370, 369, '轮台县', 3, 0, 1, 1649559942),
(3371, 369, '尉犁县', 3, 0, 1, 1649559942),
(3372, 369, '若羌县', 3, 0, 1, 1649559942),
(3373, 369, '且末县', 3, 0, 1, 1649559942),
(3374, 369, '焉耆回族自治县', 3, 0, 1, 1649559942),
(3375, 369, '和静县', 3, 0, 1, 1649559942),
(3376, 369, '和硕县', 3, 0, 1, 1649559942),
(3377, 369, '博湖县', 3, 0, 1, 1649559942),
(3378, 369, '库尔勒经济技术开发区', 3, 0, 1, 1649559942),
(3379, 370, '阿克苏市', 3, 0, 1, 1649559942),
(3380, 370, '库车市', 3, 0, 1, 1649559942),
(3381, 370, '温宿县', 3, 0, 1, 1649559942),
(3382, 370, '沙雅县', 3, 0, 1, 1649559942),
(3383, 370, '新和县', 3, 0, 1, 1649559942),
(3384, 370, '拜城县', 3, 0, 1, 1649559942),
(3385, 370, '乌什县', 3, 0, 1, 1649559942),
(3386, 370, '阿瓦提县', 3, 0, 1, 1649559942),
(3387, 370, '柯坪县', 3, 0, 1, 1649559942),
(3388, 371, '阿图什市', 3, 0, 1, 1649559942),
(3389, 371, '阿克陶县', 3, 0, 1, 1649559942),
(3390, 371, '阿合奇县', 3, 0, 1, 1649559942),
(3391, 371, '乌恰县', 3, 0, 1, 1649559942),
(3392, 372, '喀什市', 3, 0, 1, 1649559942),
(3393, 372, '疏附县', 3, 0, 1, 1649559942),
(3394, 372, '疏勒县', 3, 0, 1, 1649559942),
(3395, 372, '英吉沙县', 3, 0, 1, 1649559942),
(3396, 372, '泽普县', 3, 0, 1, 1649559942),
(3397, 372, '莎车县', 3, 0, 1, 1649559942),
(3398, 372, '叶城县', 3, 0, 1, 1649559942),
(3399, 372, '麦盖提县', 3, 0, 1, 1649559942),
(3400, 372, '岳普湖县', 3, 0, 1, 1649559942),
(3401, 372, '伽师县', 3, 0, 1, 1649559942),
(3402, 372, '巴楚县', 3, 0, 1, 1649559942),
(3403, 372, '塔什库尔干塔吉克自治县', 3, 0, 1, 1649559942),
(3404, 373, '和田市', 3, 0, 1, 1649559942),
(3405, 373, '和田县', 3, 0, 1, 1649559942),
(3406, 373, '墨玉县', 3, 0, 1, 1649559942),
(3407, 373, '皮山县', 3, 0, 1, 1649559942),
(3408, 373, '洛浦县', 3, 0, 1, 1649559942),
(3409, 373, '策勒县', 3, 0, 1, 1649559942),
(3410, 373, '于田县', 3, 0, 1, 1649559942),
(3411, 373, '民丰县', 3, 0, 1, 1649559942),
(3412, 374, '伊宁市', 3, 0, 1, 1649559942),
(3413, 374, '奎屯市', 3, 0, 1, 1649559942),
(3414, 374, '霍尔果斯市', 3, 0, 1, 1649559942),
(3415, 374, '伊宁县', 3, 0, 1, 1649559942),
(3416, 374, '察布查尔锡伯自治县', 3, 0, 1, 1649559942),
(3417, 374, '霍城县', 3, 0, 1, 1649559942),
(3418, 374, '巩留县', 3, 0, 1, 1649559942),
(3419, 374, '新源县', 3, 0, 1, 1649559942),
(3420, 374, '昭苏县', 3, 0, 1, 1649559942),
(3421, 374, '特克斯县', 3, 0, 1, 1649559942),
(3422, 374, '尼勒克县', 3, 0, 1, 1649559942),
(3423, 375, '塔城市', 3, 0, 1, 1649559942),
(3424, 375, '乌苏市', 3, 0, 1, 1649559942),
(3425, 375, '沙湾市', 3, 0, 1, 1649559942),
(3426, 375, '额敏县', 3, 0, 1, 1649559942),
(3427, 375, '托里县', 3, 0, 1, 1649559942),
(3428, 375, '裕民县', 3, 0, 1, 1649559942),
(3429, 375, '和布克赛尔蒙古自治县', 3, 0, 1, 1649559942),
(3430, 376, '阿勒泰市', 3, 0, 1, 1649559942),
(3431, 376, '布尔津县', 3, 0, 1, 1649559942),
(3432, 376, '富蕴县', 3, 0, 1, 1649559942),
(3433, 376, '福海县', 3, 0, 1, 1649559942),
(3434, 376, '哈巴河县', 3, 0, 1, 1649559942),
(3435, 376, '青河县', 3, 0, 1, 1649559942),
(3436, 376, '吉木乃县', 3, 0, 1, 1649559942),
(3437, 377, '石河子市', 3, 0, 1, 1649559942),
(3438, 377, '阿拉尔市', 3, 0, 1, 1649559942),
(3439, 377, '图木舒克市', 3, 0, 1, 1649559942),
(3440, 377, '五家渠市', 3, 0, 1, 1649559942),
(3441, 377, '北屯市', 3, 0, 1, 1649559942),
(3442, 377, '铁门关市', 3, 0, 1, 1649559942),
(3443, 377, '双河市', 3, 0, 1, 1649559942),
(3444, 377, '可克达拉市', 3, 0, 1, 1649559942),
(3445, 377, '昆玉市', 3, 0, 1, 1649559942),
(3446, 377, '胡杨河市', 3, 0, 1, 1649559942),
(3447, 377, '新星市', 3, 0, 1, 1649559942);

CREATE TABLE `mall_sms_log` (
  `id` bigint(20) NOT NULL COMMENT 'id',
  `scene_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '场景id',
  `mobile` varchar(11) NOT NULL COMMENT '手机号码',
  `content` text NOT NULL COMMENT '发送内容',
  `code` varchar(32) DEFAULT NULL COMMENT '发送关键字（注册、找回密码）',
  `nums` int(5) DEFAULT '0' COMMENT '验证次数',
  `verify_status` tinyint(1) DEFAULT '0' COMMENT '验证状态（0:否 1:是）',
  `send_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '发送状态(0:发送中 1:发送成功；2:发送失败)',
  `results` text COMMENT '短信结果',
  `create_time` int(10) DEFAULT '0' COMMENT '创建时间',
  `send_time` int(10) NOT NULL DEFAULT '0' COMMENT '发送时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='短信记录表';

CREATE TABLE `mall_sms_template` (
  `id` bigint(20) NOT NULL,
  `scene_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '调用ID',
  `scene_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '通知类型(1:验证码 2: 业务通知)',
  `scene_name` varchar(255) NOT NULL DEFAULT '' COMMENT '短信模板名称',
  `template_id` varchar(255) NOT NULL DEFAULT '' COMMENT '短信模板ID',
  `template_content` longtext COMMENT '模板内容',
  `template_params` text COMMENT '模板参数',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1:开启 0:关闭'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `mall_sms_template` (`id`, `scene_id`, `scene_type`, `scene_name`, `template_id`, `template_content`, `template_params`, `status`) VALUES
(1, 100, 1, '登录验证', 'SMS_189245228', '您正在登录，验证码${code}，切勿将验证码泄露于他人，本条验证码有效期5分钟！', '{\"code\":\"${code}\"}', 1),
(2, 101, 1, '绑定手机', 'SMS_189245228', '您正在绑定手机号，验证码${code}，切勿将验证码泄露于他人，本条验证码有效期5分钟！', '{\"code\":\"${code}\"}', 1),
(3, 102, 1, '变更手机', 'SMS_189245228', '您正在变更手机号，验证码${code}，切勿将验证码泄露于他人，本条验证码有效期5分钟！', '{\"code\":\"${code}\"}', 1),
(4, 103, 1, '找回密码', 'SMS_189245228', '您正在找回登录密码，验证码${code}，切勿将验证码泄露于他人，本条验证码有效期5分钟！', '{\"code\":\"${code}\"}', 1);

CREATE TABLE `mall_statistics_search` (
  `id` bigint(20) NOT NULL,
  `name` varchar(128) NOT NULL DEFAULT '' COMMENT '关键字',
  `num` bigint(20) NOT NULL DEFAULT '0' COMMENT '搜索次数'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='搜索关键字统计表';

CREATE TABLE `mall_statistics_search_goods` (
  `id` bigint(20) NOT NULL,
  `goods_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商品id',
  `name` varchar(128) NOT NULL DEFAULT '' COMMENT '关键字',
  `referer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0: PC 1: 手机网页 2: APP 3: 公众号 4: 小程序',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0: PC 1: 手机网页 2: APP(0: android 1: ios) 3: 公众号 4: 小程序(0:微信 1:支付宝 2:百度 3:字节跳动 4:QQ)',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='搜索关键字表';

CREATE TABLE `mall_users` (
  `id` int(10) UNSIGNED NOT NULL COMMENT 'ID',
  `group_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '组别ID',
  `username` varchar(32) DEFAULT '' COMMENT '用户名',
  `nickname` varchar(50) DEFAULT '' COMMENT '昵称',
  `password` varchar(128) DEFAULT '' COMMENT '密码',
  `salt` char(5) DEFAULT '' COMMENT '密码盐',
  `email` varchar(100) DEFAULT '' COMMENT '电子邮箱',
  `mobile` varchar(11) DEFAULT '' COMMENT '手机号',
  `avatar` varchar(255) DEFAULT '' COMMENT '头像',
  `gender` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '性别',
  `birthday` varchar(32) DEFAULT '' COMMENT '生日',
  `money` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '余额',
  `score` bigint(20) NOT NULL DEFAULT '0' COMMENT '积分',
  `successions` int(10) UNSIGNED NOT NULL DEFAULT '1' COMMENT '连续登录天数',
  `maxsuccessions` int(10) UNSIGNED NOT NULL DEFAULT '1' COMMENT '最大连续登录天数',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1:正常,2:审核,3:锁定,4:注销)',
  `terminal` tinyint(1) NOT NULL DEFAULT '1' COMMENT '客户端类型(0:PC微信扫码 1:微信公众号 2:微信小程序 3:支付宝小程序 4:百度小程序 5:抖音小程序 6:QQ小程序 7:360小程序 8:PC 9:H5 10:苹果APP 11:安卓APP)',
  `sign_count` int(10) NOT NULL DEFAULT '0' COMMENT '签到天数',
  `inviter_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '邀请人',
  `prev_time` int(10) NOT NULL DEFAULT '0' COMMENT '上次登录时间',
  `login_time` int(10) NOT NULL DEFAULT '0' COMMENT '登录时间',
  `login_ip` varchar(50) DEFAULT '' COMMENT '登录IP',
  `login_failure` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '失败次数',
  `join_ip` varchar(50) DEFAULT '' COMMENT '加入IP',
  `join_time` int(10) DEFAULT '0' COMMENT '加入时间',
  `create_time` int(10) DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员表';

CREATE TABLE `mall_users_address` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `accept_name` varchar(20) NOT NULL DEFAULT '' COMMENT '收货人姓名',
  `zip` varchar(6) DEFAULT '' COMMENT '邮编',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机',
  `phone` varchar(20) DEFAULT '' COMMENT '联系电话',
  `country` bigint(20) DEFAULT '0' COMMENT '国ID',
  `province` bigint(20) NOT NULL DEFAULT '0' COMMENT '省ID',
  `city` bigint(20) NOT NULL DEFAULT '0' COMMENT '市ID',
  `area` bigint(20) NOT NULL DEFAULT '0' COMMENT '区ID',
  `address` varchar(250) NOT NULL COMMENT '收货地址',
  `is_default` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否默认,0:为非默认,1:默认',
  `create_time` int(10) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='收货信息表';

CREATE TABLE `mall_users_auth` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `openid` varchar(255) NOT NULL DEFAULT '' COMMENT '用户标识',
  `unionid` varchar(255) NOT NULL DEFAULT '' COMMENT '联合ID',
  `terminal` tinyint(4) NOT NULL DEFAULT '1' COMMENT '客户端类型(0:PC微信扫码 1:微信公众号 2:微信小程序 10-11: APP登录)',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户授权表';

CREATE TABLE `mall_users_cart` (
  `id` bigint(20) NOT NULL COMMENT '自增ID',
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `goods_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `sku_id` varchar(255) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `goods_num` int(10) NOT NULL DEFAULT '0' COMMENT '购买数量',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='购物车表' ROW_FORMAT=COMPACT;

CREATE TABLE `mall_users_collect` (
  `id` bigint(20) UNSIGNED NOT NULL COMMENT '自增ID',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '类型(1:收藏 2:点赞)',
  `category` tinyint(1) NOT NULL DEFAULT '0' COMMENT '活动商品(0:普通商品 1:拼团活动 2:限时秒杀 3:砍价活动 4:限时折扣 5:限购活动 6:积分商品)',
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0' COMMENT '用户ID',
  `activity_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '活动商品ID',
  `goods_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0' COMMENT '商品ID',
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '建立时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品点赞和收藏表';

CREATE TABLE `mall_users_comment` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_goods_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '订单商品ID',
  `order_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单类型',
  `goods_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `spec_value` text COMMENT '规格值',
  `images` text COMMENT '评论图片json',
  `content` text COMMENT '评论内容',
  `reply_content` text COMMENT '回复评论内容',
  `point` tinyint(1) NOT NULL DEFAULT '0' COMMENT '评论的分数',
  `describes` tinyint(1) NOT NULL DEFAULT '0' COMMENT '描述',
  `service` tinyint(1) NOT NULL DEFAULT '0' COMMENT '服务',
  `logistics` tinyint(1) NOT NULL DEFAULT '0' COMMENT '物流',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '评论状态：0：未评论 1:已评论',
  `reply_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未处理 1己处理',
  `comment_time` int(10) NOT NULL DEFAULT '0' COMMENT '评论时间',
  `reply_time` int(10) NOT NULL DEFAULT '0' COMMENT '回复评论时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品评论表';

CREATE TABLE `mall_users_consult` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT '0' COMMENT '咨询人会员ID，非会员为空',
  `goods_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `content` text COMMENT '回复内容',
  `reply_content` longtext COMMENT '回复内容',
  `status` tinyint(1) DEFAULT '0' COMMENT '0：待回复 1已回复',
  `create_time` int(10) DEFAULT '0' COMMENT '咨询时间',
  `reply_time` int(10) DEFAULT '0' COMMENT '回复时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='咨询表';

CREATE TABLE `mall_users_coupon` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `coupon_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '优惠券ID',
  `order_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态(1:已使用 0:未使用)',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员优惠券表';

CREATE TABLE `mall_users_group` (
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(50) DEFAULT '' COMMENT '组名',
  `order_amount` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '购买到达指定金额开启',
  `price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '充值到达指定金额开启',
  `is_paid` tinyint(1) NOT NULL DEFAULT '0' COMMENT '付费会员(1:已开通 0:未开通)',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态 0:关闭 1:正常',
  `limit_time` tinyint(1) NOT NULL DEFAULT '0' COMMENT '开通付费会员年限(单位：年)',
  `sort` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `create_time` int(10) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员组表';

INSERT INTO `mall_users_group` (`id`, `name`, `order_amount`, `price`, `is_paid`, `status`, `limit_time`, `sort`, `create_time`, `update_time`) VALUES
(1, '普通会员', '0.00', '0.00', 0, 1, 0, 0, 1709088550, 1709088560);

CREATE TABLE `mall_users_invoice` (
  `id` bigint(20) NOT NULL COMMENT '自增ID',
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `header_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '抬头类型1:个人2：企业',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '发票类型1：普通2：专用',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '名称（发票抬头）',
  `duty_number` varchar(50) NOT NULL DEFAULT '' COMMENT '税号',
  `drawer_phone` varchar(30) NOT NULL DEFAULT '' COMMENT '开票人手机号',
  `email` varchar(100) NOT NULL DEFAULT '' COMMENT '开票人邮箱',
  `tell` varchar(30) NOT NULL DEFAULT '' COMMENT '注册电话',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '注册地址',
  `bank` varchar(50) NOT NULL DEFAULT '' COMMENT '注册开户银行',
  `card_number` varchar(50) NOT NULL DEFAULT '' COMMENT '银行卡号',
  `is_default` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否默认',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户发票管理表' ROW_FORMAT=DYNAMIC;

CREATE TABLE `mall_users_log` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户id',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '动作类型(1:金额操作 2:订单充值 3:订单退款)',
  `operation` tinyint(1) NOT NULL DEFAULT '0' COMMENT '操作(0:充值 1:提现)',
  `value` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '金额',
  `description` text COMMENT '说明',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员日志表';

CREATE TABLE `mall_users_meta` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '会员ID',
  `sign` varchar(32) NOT NULL DEFAULT '' COMMENT '标识',
  `content` longtext COMMENT '内容',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '修改时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `mall_users_point_log` (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '类型(1:增加 2:减少)',
  `value` int(11) NOT NULL DEFAULT '0' COMMENT '变动数量',
  `content` text COMMENT '描述/说明',
  `remark` varchar(500) NOT NULL DEFAULT '' COMMENT '管理员备注',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户积分变动明细表';

CREATE TABLE `mall_users_sign_log` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `description` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '签到说明',
  `point` int(10) NOT NULL DEFAULT '0' COMMENT '积分',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='签到记录表';

CREATE TABLE `mall_users_visit` (
  `id` bigint(20) NOT NULL COMMENT '自增ID',
  `category` tinyint(1) NOT NULL DEFAULT '0' COMMENT '活动商品(0:普通商品 1:拼团活动 2:限时秒杀 3:砍价活动 4:限时折扣 5:限购活动 6:积分商品)  ',
  `activity_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '活动商品ID',
  `goods_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `count` bigint(20) NOT NULL DEFAULT '0' COMMENT '访问次数',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员足迹表';

CREATE TABLE `mall_users_withdraw` (
  `id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT '0' COMMENT '用户ID',
  `pay_id` smallint(6) DEFAULT '0' COMMENT '支付方式',
  `order_no` varchar(255) NOT NULL DEFAULT '' COMMENT '提现单号',
  `pay_fee` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '提现手续费',
  `price` decimal(15,2) DEFAULT '0.00' COMMENT '提现金额',
  `settlement_price` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '汇款金额',
  `mark` varchar(512) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0' COMMENT '0 审核中 1 已提现 2 未通过',
  `content` longtext COMMENT '转帐信息',
  `create_time` int(10) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) DEFAULT '0' COMMENT '处理时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户提现表';

CREATE TABLE `mall_users_withdrawal_bank` (
  `id` bigint(20) NOT NULL COMMENT '自增ID',
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '会员ID',
  `pay_id` int(10) NOT NULL DEFAULT '0' COMMENT '支付类型',
  `content` longtext COMMENT 'json数据',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '建立时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户提现信息保存表';

CREATE TABLE `mall_wechat_account_reply` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '回复名称',
  `keyword` varchar(64) NOT NULL DEFAULT '' COMMENT '关键词',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '回复类型(1:默认回复 2:关注回复 3:回复规则)',
  `matching_type` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '匹配方式(1:完全匹配 2:模糊匹配)',
  `content_type` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '内容类型(1:文本)',
  `content` text COMMENT '回复内容',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '启动状态(1:开启 0:关闭)',
  `sort` int(11) UNSIGNED NOT NULL DEFAULT '50' COMMENT '排序',
  `create_time` int(10) DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  `delete_time` int(10) DEFAULT '0' COMMENT '删除时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='公众号消息回调表';

CREATE TABLE `mall_withdraw_terminal` (
  `id` bigint(20) NOT NULL,
  `pay_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '支付类型',
  `is_default` tinyint(1) DEFAULT '1' COMMENT '默认(1:是 0:否)',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1:开启 0:关闭)',
  `terminal` tinyint(4) NOT NULL DEFAULT '1' COMMENT '客户端类型(0:PC微信扫码 1:微信公众号 2:微信小程序 10-11: APP登录)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='支付类型表';

INSERT INTO `mall_withdraw_terminal` (`id`, `pay_id`, `is_default`, `status`, `terminal`) VALUES
(1, 1, 1, 1, 8),
(2, 2, 0, 1, 8),
(3, 3, 0, 1, 8),
(4, 1, 0, 1, 1),
(5, 2, 1, 1, 1),
(6, 3, 0, 1, 1),
(7, 1, 0, 1, 2),
(8, 2, 1, 1, 2),
(9, 3, 0, 1, 2),
(10, 1, 0, 1, 10),
(11, 2, 1, 1, 10),
(12, 3, 0, 1, 10),
(13, 1, 0, 1, 9),
(14, 2, 1, 1, 9),
(15, 3, 0, 1, 9),
(16, 0, 1, 1, 8),
(17, 0, 0, 1, 1),
(18, 0, 0, 1, 2),
(19, 0, 0, 1, 10),
(20, 0, 0, 1, 9);


ALTER TABLE `mall_admin`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`) USING BTREE;

ALTER TABLE `mall_admin_log`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_admin_manage`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_admin_menu`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_archives`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pid` (`pid`);

ALTER TABLE `mall_archives_help`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_attachment`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_attachment_category`
  ADD PRIMARY KEY (`id`) USING BTREE,
  ADD KEY `pid` (`pid`);

ALTER TABLE `mall_category`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pid` (`pid`);

ALTER TABLE `mall_chat_friends`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `service_id` (`service_id`),
  ADD KEY `group_id` (`group_id`);

ALTER TABLE `mall_chat_message`
  ADD PRIMARY KEY (`id`),
  ADD KEY `goods_id` (`goods_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `order_id` (`order_id`),
  ADD KEY `service_id` (`service_id`);

ALTER TABLE `mall_chat_template`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_chat_users`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_config`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_crontab`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_crontab_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pid` (`pid`);

ALTER TABLE `mall_goods`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cat_id` (`cat_id`),
  ADD KEY `brand_id` (`brand_id`),
  ADD KEY `title` (`title`);

ALTER TABLE `mall_goods_attribute`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_goods_brand`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_goods_distribution`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_goods_freight`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_goods_image`
  ADD PRIMARY KEY (`id`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_goods_item`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_goods_spec`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_goods_spec_relation`
  ADD PRIMARY KEY (`id`),
  ADD KEY `goods_id` (`goods_id`),
  ADD KEY `spec_id` (`spec_id`),
  ADD KEY `spec_value_id` (`spec_value_id`);

ALTER TABLE `mall_goods_spec_value`
  ADD PRIMARY KEY (`id`),
  ADD KEY `spec_id` (`spec_id`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_layout_page`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_layout_setting`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_layout_template`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_order`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_no` (`order_no`),
  ADD KEY `user_id` (`user_id`);

ALTER TABLE `mall_order_address`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `order_id` (`order_id`);

ALTER TABLE `mall_order_export`
  ADD PRIMARY KEY (`id`),
  ADD KEY `status` (`status`);

ALTER TABLE `mall_order_goods`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_id` (`order_id`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_order_invoice`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_id` (`order_id`),
  ADD KEY `user_id` (`user_id`);

ALTER TABLE `mall_order_recharge`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

ALTER TABLE `mall_order_refunds`
  ADD PRIMARY KEY (`id`),
  ADD KEY `type` (`type`),
  ADD KEY `order_id` (`order_id`),
  ADD KEY `user_id` (`user_id`);

ALTER TABLE `mall_order_refunds_address`
  ADD PRIMARY KEY (`id`),
  ADD KEY `refund_id` (`refund_id`);

ALTER TABLE `mall_order_shipping`
  ADD PRIMARY KEY (`id`) USING BTREE;

ALTER TABLE `mall_payment`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_payment_terminal`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_promotion_award`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_promotion_bargain`
  ADD PRIMARY KEY (`id`),
  ADD KEY `goods_id` (`goods_id`),
  ADD KEY `sort` (`sort`);

ALTER TABLE `mall_promotion_bargain_users`
  ADD PRIMARY KEY (`id`) USING BTREE,
  ADD KEY `user_id` (`user_id`),
  ADD KEY `bargain_id` (`bargain_id`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_promotion_bargain_users_help`
  ADD PRIMARY KEY (`id`) USING BTREE;

ALTER TABLE `mall_promotion_consume`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_promotion_coupon`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_promotion_discount`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_promotion_discount_goods`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pid` (`pid`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_promotion_discount_goods_item`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pid` (`pid`),
  ADD KEY `goods_id` (`goods_id`),
  ADD KEY `gid` (`gid`);

ALTER TABLE `mall_promotion_free_shipping`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_promotion_games`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_promotion_games_item`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_promotion_games_log`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_promotion_gift`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_promotion_group`
  ADD PRIMARY KEY (`id`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_promotion_group_goods`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pid` (`pid`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_promotion_invite`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_promotion_invite_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `inviter_id` (`inviter_id`),
  ADD KEY `user_id` (`user_id`);

ALTER TABLE `mall_promotion_limit`
  ADD PRIMARY KEY (`id`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_promotion_limit_goods`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pid` (`pid`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_promotion_point`
  ADD PRIMARY KEY (`id`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_promotion_point_goods`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pid` (`pid`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_promotion_rebate`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_promotion_second`
  ADD PRIMARY KEY (`id`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_promotion_second_goods`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pid` (`pid`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_promotion_sign`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_region`
  ADD PRIMARY KEY (`id`) USING BTREE,
  ADD KEY `pid` (`pid`);

ALTER TABLE `mall_sms_log`
  ADD PRIMARY KEY (`id`) USING BTREE;

ALTER TABLE `mall_sms_template`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_statistics_search`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_statistics_search_goods`
  ADD PRIMARY KEY (`id`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_users`
  ADD PRIMARY KEY (`id`),
  ADD KEY `username` (`username`),
  ADD KEY `email` (`email`),
  ADD KEY `mobile` (`mobile`);

ALTER TABLE `mall_users_address`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

ALTER TABLE `mall_users_auth`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_users_cart`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `goods_id` (`goods_id`),
  ADD KEY `product_id` (`sku_id`(191));

ALTER TABLE `mall_users_collect`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `goods_id` (`goods_id`),
  ADD KEY `activity_id` (`activity_id`);

ALTER TABLE `mall_users_comment`
  ADD PRIMARY KEY (`id`),
  ADD KEY `goods_id` (`goods_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `order_id` (`order_id`),
  ADD KEY `order_goods_id` (`order_goods_id`);

ALTER TABLE `mall_users_consult`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `goods_id` (`goods_id`);

ALTER TABLE `mall_users_coupon`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `coupon_id` (`coupon_id`),
  ADD KEY `order_id` (`order_id`);

ALTER TABLE `mall_users_group`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_users_invoice`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

ALTER TABLE `mall_users_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

ALTER TABLE `mall_users_meta`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

ALTER TABLE `mall_users_point_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

ALTER TABLE `mall_users_sign_log`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `mall_users_visit`
  ADD PRIMARY KEY (`id`),
  ADD KEY `category` (`category`),
  ADD KEY `goods_id` (`goods_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `activity_id` (`activity_id`);

ALTER TABLE `mall_users_withdraw`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `pay_id` (`pay_id`);

ALTER TABLE `mall_users_withdrawal_bank`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `pay_id` (`pay_id`);

ALTER TABLE `mall_wechat_account_reply`
  ADD PRIMARY KEY (`id`) USING BTREE;

ALTER TABLE `mall_withdraw_terminal`
  ADD PRIMARY KEY (`id`);


ALTER TABLE `mall_admin`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID', AUTO_INCREMENT=3;

ALTER TABLE `mall_admin_log`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID';

ALTER TABLE `mall_admin_manage`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

ALTER TABLE `mall_admin_menu`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键', AUTO_INCREMENT=237;

ALTER TABLE `mall_archives`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_archives_help`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键ID', AUTO_INCREMENT=3;

ALTER TABLE `mall_attachment`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID';

ALTER TABLE `mall_attachment_category`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_category`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_chat_friends`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键';

ALTER TABLE `mall_chat_message`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键';

ALTER TABLE `mall_chat_template`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键';

ALTER TABLE `mall_chat_users`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键';

ALTER TABLE `mall_config`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=26;

ALTER TABLE `mall_crontab`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID', AUTO_INCREMENT=5;

ALTER TABLE `mall_crontab_log`
  MODIFY `id` bigint(10) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_goods`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '商品ID';

ALTER TABLE `mall_goods_attribute`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_goods_brand`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '品牌ID';

ALTER TABLE `mall_goods_distribution`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_goods_freight`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=17;

ALTER TABLE `mall_goods_image`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键ID';

ALTER TABLE `mall_goods_item`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_goods_spec`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_goods_spec_relation`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_goods_spec_value`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_layout_page`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

ALTER TABLE `mall_layout_setting`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增', AUTO_INCREMENT=4;

ALTER TABLE `mall_layout_template`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

ALTER TABLE `mall_order`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_order_address`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_order_export`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键ID';

ALTER TABLE `mall_order_goods`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_order_invoice`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID';

ALTER TABLE `mall_order_recharge`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '订单ID';

ALTER TABLE `mall_order_refunds`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '售后单ID';

ALTER TABLE `mall_order_refunds_address`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键ID';

ALTER TABLE `mall_order_shipping`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'ID';

ALTER TABLE `mall_payment`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

ALTER TABLE `mall_payment_terminal`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

ALTER TABLE `mall_promotion_award`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_bargain`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_bargain_users`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '用户参与砍价表';

ALTER TABLE `mall_promotion_bargain_users_help`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_consume`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_coupon`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_discount`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_discount_goods`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_discount_goods_item`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_free_shipping`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_games`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_games_item`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_games_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_gift`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_group`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_group_goods`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_invite`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_invite_log`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_limit`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_limit_goods`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_point`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_point_goods`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_rebate`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_second`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_second_goods`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_promotion_sign`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_region`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增id', AUTO_INCREMENT=3448;

ALTER TABLE `mall_sms_log`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id';

ALTER TABLE `mall_sms_template`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

ALTER TABLE `mall_statistics_search`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_statistics_search_goods`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_users`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID';

ALTER TABLE `mall_users_address`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_users_auth`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_users_cart`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID';

ALTER TABLE `mall_users_collect`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增ID';

ALTER TABLE `mall_users_comment`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_users_consult`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_users_coupon`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_users_group`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

ALTER TABLE `mall_users_invoice`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID';

ALTER TABLE `mall_users_log`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_users_meta`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_users_point_log`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID';

ALTER TABLE `mall_users_sign_log`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_users_visit`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID';

ALTER TABLE `mall_users_withdraw`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_users_withdrawal_bank`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID';

ALTER TABLE `mall_wechat_account_reply`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `mall_withdraw_terminal`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=21;
