<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\service\wechat;

use app\adminapi\model\WechatAccountReply as WechatAccountReplyModel;
use app\common\library\wechat\Wechat;
use app\common\service\Config;

/**
 * @package app\common\service\wechat
 * @class Menu
 * @author xzncit 2024-01-31
 */
class Menu {

    /**
     * @return array|mixed|null
     */
    public static function detail(){
        return [
            "menu"  => Config::getArray("wechat_menu",[]),
            "reply" => WechatAccountReplyModel::where(["status"=>1,"type"=>3])->select()->toArray()
        ];
    }

    /**
     * 公众号菜单
     * @param array $params
     * @return bool
     * @throws \think\db\exception\DbException
     */
    public static function save($params=[]){
        Config::save("wechat_menu",$params);
        if(empty($params)){
            Wechat::create("wechat")->menu->delete();
        }else{
            Wechat::create("wechat")->menu->create(['button' => $params]);
        }

        return true;
    }

}