<?php

namespace app\common\service\promotion;

use app\common\model\promotion\FreeShipping as FreeShippingModel;

/**
 * @package app\common\service\promotion
 * @class Shipping
 * @author xzncit 2024/3/22
 */
class Shipping {

    public static function freeFreight($orderAmount,$realFreight,$address){
        $row = FreeShippingModel::where("status",1)->find();
        if(empty($row)){
            return $realFreight;
        }

        if($row["type"] == 1){
            if($row["order_amount"] == 0 || $orderAmount >= $row["order_amount"]){
                return 0;
            }

            return $realFreight;
        }

        if($row["type"] == 2 && empty($row["area_group"])){
            return $realFreight;
        }

        $area = [];
        $area[] = $address["province"];
        $area[] = $address["city"];
        if(!empty($address["area"])){
            $area[] = $address["area"];
        }

        $flag = true;
        $areaGroup = explode(",",$row["area_group"]);
        foreach($area as $value){
            if(!in_array($value,$areaGroup)){
                $flag = false;
                break;
            }
        }

        if(!$flag){
            return $realFreight;
        }

        if($row["order_amount"] == 0 || $orderAmount >= $row["order_amount"]){
            return 0;
        }

        return $realFreight;
    }

}