<?php

namespace app\common\service\promotion;

use app\common\model\promotion\Rebate as RebateModel;
use app\common\library\utils\BC;

/**
 * @package app\common\service\promotion
 * @class Rebate
 * @author xzncit 2024/3/22
 */
class Rebate {

    public static function discount($orderAmount){
        $row = RebateModel::where("status",1)
            ->where("order_amount","<=",$orderAmount)
            ->whereTime('start_time', '<=', time())
            ->whereTime('end_time', '>=', time())
            ->order("order_amount","ASC")->find();

        if(empty($row)){
            return 0;
        }

        return $row["price"];
    }

}