<?php

namespace app\common\service\promotion;

use app\common\library\utils\Image;
use app\common\model\goods\Goods as GoodsModel;
use app\common\model\goods\GoodsItem as GoodsItemModel;
use app\common\model\goods\Spec as SpecModel;
use app\common\model\promotion\Gift as GiftModel;

/**
 * @package app\common\service\promotion
 * @class Gift
 * @author xzncit 2024/3/23
 */
class Gift {

    /**
     * @param $order
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function goods($order){
        if($order["type"] != 0){
            return [];
        }

        $row = GiftModel::where("status",1)
            ->where("order_amount","<=",$order["real_amount"])
            ->whereTime('start_time', '<=', time())
            ->whereTime('end_time', '>=', time())
            ->order("order_amount","ASC")->find();

        if(empty($row) || empty($row["goods_list"])){
            return [];
        }

        $array = explode(",",$row["goods_list"]);
        $goodsList = [];
        foreach($array as $value){
            $goods = GoodsModel::where(["id"=>$value])->find();
            if(empty($goods) || ($goods["sku_type"] == 1 && $goods["store_nums"] <= 0)){
                continue;
            }

            $result = [
                "order_type"        => 3,
                "goods_id"          => $goods["id"],
                "sku_id"            => 0,
                "photo"             => Image::thumb($goods["photo"]),
                "goods_name"        => $goods["title"],
                "goods_number"      => $goods["goods_number"],
                "real_price"        => $goods["sell_price"],
                "sell_price"        => $goods["sell_price"],
                "market_price"      => $goods["market_price"],
                "cost_price"        => $goods["cost_price"],
                "store_nums"        => $goods["store_nums"],
                "total_price"       => $goods["sell_price"],
                "goods_total_nums"  => 1,
                "goods_weight"      => $goods["goods_weight"],
                "goods_array"       => ""
            ];

            if($goods["sku_type"] == 2){
                $condition   = [];
                $condition[] = ["goods_id","=",$goods["id"]];
                $condition[] = ["store_nums",">",0];
                $goodsItem = GoodsItemModel::where($condition)->orderRaw("rand()")->find();
                if(empty($goodsItem)){
                    continue;
                }

                $result["sku_id"]        = $goodsItem["sku_id"];
                $result["real_price"]    = $goodsItem["sell_price"];
                $result["sell_price"]    = $goodsItem["sell_price"];
                $result["market_price"]  = $goodsItem["market_price"];
                $result["cost_price"]    = $goodsItem["cost_price"];
                $result["goods_weight"]  = $goodsItem["goods_weight"];
                $result["store_nums"]    = $goodsItem["store_nums"];
                $result["total_price"]   = $goodsItem["sell_price"];
                $result["goods_array"] = [
                    "name"      => SpecModel::getSpecInfo($goodsItem["spec_value"]),
                    "value"     => $goodsItem["spec_value"]
                ];

                $goods["goods_weight"] = $goodsItem["goods_weight"];
            }

            $result["real_freight"] = 0;
            $goodsList[] = $result;
        }

        return $goodsList;
    }

}