<?php

namespace app\common\service\promotion;

use app\common\model\order\Order as OrderModel;
use app\common\model\promotion\Discount as DiscountModel;
use app\common\model\promotion\DiscountGoods as DiscountGoodsModel;
use app\common\model\promotion\DiscountGoodsItem as DiscountGoodsItemModel;
use app\common\service\Users as UsersService;

/**
 * @package app\common\service\promotion
 * @class Discount
 * @author xzncit 2024/3/24
 */
class Discount {

    public static $array = [];

    public static function special($sellPrice,$goodsId,$skuId=0){
        self::$array = [
            "id"    => 0,
            "price" => 0,
            "type"  => 0, // 1:限时购 2:新人购
        ];

        self::$array["price"] = $sellPrice;
        $goods = DiscountGoodsModel::where("goods_id",$goodsId)->where("status",1)->find();
        if(empty($goods)){
            return self::$array;
        }

        $discount = DiscountModel::where("id",$goods["pid"])->where("status",1)->find();
        if(empty($discount)){
            return self::$array;
        }

        if($discount["is_people"] == 1){
            if(OrderModel::where("user_id",UsersService::auth("id",0))->count()){
                return self::$array;
            }

            self::$array["type"] = 2;
        }else{
            self::$array["type"] = 1;
        }

        if($discount["is_repeat"] == 2){
            if(OrderModel::where("user_id",UsersService::auth("id",0))->where("type",4)->where("promoter_id",self::$array["id"])->count()){
                return self::$array;
            }
        }

        self::$array["id"]    = $discount["id"];
        self::$array["price"] = $goods["sell_price"];
        if(empty($skuId)){
            return self::$array;
        }

        $condition = [];
        $condition[] = ["pid","=",$discount["id"]];
        $condition[] = ["gid","=",$goods["id"]];
        $condition[] = ["goods_id","=",$goodsId];
        $condition[] = ["sku_id","=",$skuId];
        $goodsItem = DiscountGoodsItemModel::where($condition)->find();
        if(empty($goodsItem)){
            return self::$array;
        }

        self::$array["price"] = $goodsItem["sell_price"];
        return self::$array;
    }

    public static function getItem($name){
        return isset(self::$array[$name]) ? self::$array[$name] : 0;
    }

}