<?php

namespace app\common\service\promotion;

use app\common\model\promotion\Consume as ConsumeModel;

/**
 * @package app\common\service\promotion
 * @class Consume
 * @author xzncit 2024/3/22
 */
class Consume {

    public static function reward($order){
        if($order["type"] != 0){
            return 0;
        }

        $consume = ConsumeModel::where("status",1)->find();
        if(empty($consume) || $consume["point"] <= 0){
            return 0;
        }

        if($order["order_amount"] <= 0){
            return 0;
        }

        $point = intval($order["order_amount"] - round(((100 - $consume["point"]) / 100) * $order["order_amount"],2));
        if($point < 0){
            return 0;
        }

        return $point;
    }

}