<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\service\diy;

use app\common\model\diy\LayoutSetting as LayoutSettingModel;

/**
 * @package app\common\service\diy
 * @class Setting
 * @author xzncit 2023-12-25
 */
class Setting {

    /**
     * @param array|null $condition
     * @param mixed $default
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function get($condition=null,$default=null){
        if(is_string($condition)){
            $condition = ["name"=>$condition];
        }

        $row = LayoutSettingModel::where($condition)->find();
        if(empty($row)){
            return $default;
        }

        return json_decode($row["content"],true);
    }

    /**
     * @param $data
     * @param array $condition
     * @return LayoutSettingModel|bool|\think\Model
     * @throws \think\db\exception\DbException
     */
    public static function save($data,$condition=[]){
        if(LayoutSettingModel::where($condition)->count()){
            return LayoutSettingModel::where($condition)->save([
                "content"   => json_encode($data,JSON_UNESCAPED_UNICODE | JSON_NUMERIC_CHECK)
            ]);
        }else{
            return LayoutSettingModel::create([
                "name"      => $condition["name"],
                "content"   => json_encode($data,JSON_UNESCAPED_UNICODE | JSON_NUMERIC_CHECK)
            ]);
        }
    }

}