<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\service;

use app\adminapi\model\order\Order as OrderModel;
use app\common\model\goods\Freight as FreightModel;
use app\common\model\order\OrderAddress as OrderAddressModel;
use app\common\library\express\aliyun\Aliyun;

/**
 * @package app\common\service
 * @class Express
 * @author xzncit 2024-02-26
 */
class Express {

    /**
     * 查询物流
     * @param $id
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function query($id){
        $row = OrderModel::where("id",$id)->find();
        if(empty($row)){
            throw new \Exception("您要查找的订单不存在",0);
        }

        $address = OrderAddressModel::where("order_id",$id)->find();
        $array = [
            "expName"       => $row["express_name"],
            "expSite"       => $address["url"]??"",
            "expPhone"      => $address["phone"]??"",
            "number"        => $row["express_no"],
            "takeTime"      => "",
            "updateTime"    => "",
            "address"       => '['.$address["accept_name"].']' . '['.$address["mobile"].']' . implode(",",[$address["province"],$address["city"],$address["area"],$address["address"]]),
            "list"          => []
        ];

        if($row["pay_status"] == 1){
            $array["list"][] = [
                "content"   => "该订单未支付",
                "timestamp" => date("Y-m-d H:i:s")
            ];
            return $array;
        }

        $array["list"][] = [
            "content"   => "商品已下单，商家备货中",
            "timestamp" => date("Y-m-d H:i:s",$row["create_time"])
        ];
        if($row["delivery_status"] == 1){
            return $array;
        }

        $freight = FreightModel::where("id",$row["express_id"])->find();
        if(empty($freight)){
            $array["list"][] = [
                "content"   => "您分配的物流方式不存在",
                "timestamp" => date("Y-m-d H:i:s")
            ];

            return $array;
        }

        $array["expName"] = $freight["title"];
        if($freight["type"] == "SFEXPRESS"){
            $row["express_no"] = $row["express_no"] . ":" . substr($address["mobile"],-4);
        }

        $array["takeTime"]   = date("Y-m-d H:i:s",$row["send_time"]);
        $array["updateTime"] = date("Y-m-d H:i:s",$row["send_time"]);
        $array["list"][]       = [
            "content"   => "商家已发货，等待快递上门揽收",
            "timestamp" => date("Y-m-d H:i:s",$row["send_time"])
        ];

        $result = Aliyun::query($row["express_no"],strtolower($freight["type"]));
        foreach($result["list"] as $value){
            $array["list"][] = [
                "content"   => $value["status"],
                "timestamp" => $value["time"]
            ];
        }

        return $array;
    }

}