<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\service;

use app\common\library\utils\Helper;
use app\common\model\Config as ConfigModel;

/**
 * @package app\common\service
 * @class Config
 * @author xzncit 2023-09-05
 */
class Config {

    /**
     * 保存
     * @param $name
     * @param null $value
     * @param array $filter
     * @return bool
     * @throws \think\db\exception\DbException
     */
    public static function save($name,$value=null,$filter=[]){
        if(is_string($name)){
            $name = [$name=>$value];
        }

        foreach($name as $key=>$value){
            $content = self::getFilterData($value,$filter);
            if(ConfigModel::where("name",$key)->count()){
                ConfigModel::where("name",$key)->save(["value"=>$content]);
            }else{
                ConfigModel::create(["name"=>$key,"value"=>$content]);
            }
        }

        return true;
    }

    /**
     * 获取指定列
     * @param $name
     * @param $column
     * @param $default
     * @param $merge
     * @return array
     */
    public static function getColumns($name,$column=[],$default=null,$merge=false){
        $array = self::getArray($name,$default,$merge);
        return Helper::getArrayFilter($array,$column);
    }

    /**
     * 获取配置
     * @param string $name
     * @param mixed $default
     * @param bool $merge
     * @return array|mixed|null
     */
    public static function getArray(string $name,$default=null,$merge=false){
        $keys = explode(".",$name);
        $name = array_shift($keys);
        $value = self::getString($name);
        $array = !empty($value) ? json_decode($value,true) : [];

        if(empty($array) || empty($keys)){
            if($merge && is_array($default) && is_array($array)){
                return array_merge($default,$array);
            }

            return !empty($array) ? $array : $default;
        }

        $temp = $_temp = null;
        for($i=0; $i<count($keys);$i++){
            if(empty($temp)){
                $temp  = empty($array[$keys[$i]]) ? null : $array[$keys[$i]];
            }else{
                $_temp = $temp[$keys[$i]];
                $temp  = $_temp;
            }
        }

        if($merge && is_array($default) && is_array($temp)){
            return array_merge($default,$temp);
        }

        return empty($temp) ? $default : $temp;
    }

    /**
     * 获取配置值
     * @param mixed $name
     * @param null  $default
     * @return mixed
     */
    public static function getString($name,$default=null){
        return ConfigModel::where("name",$name)->value("value",$default);
    }

    /**
     * 过滤数据
     * @param mixed $data
     * @param array $filter
     * @return array|false|mixed|string
     */
    protected static function getFilterData($data,$filter=[]){
        $value = self::filterSpace($data,$filter);
        return is_array($value) ? json_encode($value,JSON_UNESCAPED_UNICODE | JSON_NUMERIC_CHECK) : $value;
    }

    /**
     * 过滤空格
     * @param $data
     * @return array|false|mixed|string
     */
    protected static function filterSpace($data,$filter=[]){
        if(is_array($data)){
            $array = [];
            foreach($data as $k=>$v){
                if(in_array($k,$filter)) continue;
                $array[$k] = is_array($v) ? self::filterSpace($v) : trim($v);
            }

            $data = $array;
        }else{
            $data = trim($data);
        }

        return $data;
    }

}