<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\model\goods;

use think\Model;

/**
 * @package app\common\model\goods
 * @class SpecValue
 * @author xzncit 2024-02-15
 */
class SpecValue extends Model {

    protected $name = "goods_spec_value";

    /**
     * @param $goods_id
     * @param $spec_id
     * @param $value
     * @return mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function edit($goods_id,$spec_id,$value){
        if(isset($value["id"]) && self::where("id",$value["id"])->find()){
            self::where("id",$value["id"])->save([
                "value"       => $value["value"],
                "spec_id"     => $spec_id,
                "thumb_image" => $value["thumb_image"],
            ]);

            return $value["id"];
        }

        return self::create([
            "goods_id"      => $goods_id,
            "spec_id"       => $spec_id,
            "value"         => $value["value"],
            "thumb_image"   => $value["thumb_image"],
            "create_time"   => time()
        ])->id;
    }

}