<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\model\goods;

use think\Model;
use app\common\library\utils\Helper;

/**
 * @package app\common\model\goods
 * @class Goods
 * @author xzncit 2024-02-15
 */
class Goods extends Model {

    protected $name = "goods";

    /**
     * 获取商品区间价格
     * @param $data
     * @param $column
     * @return array|int[]
     */
    public static function getGoodsPrice($data,$column){
        $array = Helper::getArrayColumn($data,$column);
        if(empty($array)){
            return [0,0];
        }

        return [min($array), max($array)];
    }

}