<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\model;

use think\facade\Request;
use think\Model;

/**
 * @package app\common\model
 * @class AdminLog
 * @author xzncit 2023-09-04
 */
class AdminLog extends Model{

    protected $name = "admin_log";

    /**
     * 写入日志
     * @param $id
     * @param string $title
     * @param string $content
     * @return AdminLog|Model
     */
    public static function write($id,$title="",$content=""){
        return self::create([
            "admin_id"      => $id,
            "title"         => $title,
            "content"       => $content,
            "useragent"     => $_SERVER["HTTP_USER_AGENT"]??"",
            "ip"            => Request::ip(),
            "create_time"   => time()
        ]);
    }

    public static function read(){}

}