<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\library\wechat;

use app\common\service\Config;
use xzncit\Factory as WechatFactory;

/**
 * @package app\common\library\wechat
 * @class Wechat
 * @author xzncit 2024-01-29
 */
class Wechat {

    /**
     * @param string $type
     * @return \xzncit\mini\MiniProgram|\xzncit\wechat\Wechat
     * @throws \Exception
     */
    public static function create($type=""){
        if(!in_array($type,["miniprogram","wechat"])){
            throw new \Exception("您填写的微信接口配置参数错误",0);
        }

        $config = Config::getArray($type,[]);
        if($type == "miniprogram"){
            return WechatFactory::MiniProgram([
                "appid"     => trim($config["appid"]??""),
                "appsecret" => trim($config["appsecret"]??"")
            ]);
        }

        return WechatFactory::Wechat([
            "token"     => trim($config["token"]??""),
            "appid"     => trim($config["appid"]??""),
            "appsecret" => trim($config["appsecret"]??""),
            "enaeskey"  => trim($config["enaeskey"]??"")
        ]);
    }

}