<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\library\utils;

use Endroid\QrCode\QrCode as QrCodeEndroid;

/**
 * @package app\common\library\utils
 * @class QrCode
 * @author xzncit 2024-03-05
 */
class QrCode {

    /**
     * @param $content
     * @throws \Endroid\QrCode\Exceptions\ImageFunctionFailedException
     * @throws \Endroid\QrCode\Exceptions\ImageFunctionUnknownException
     * @throws \Endroid\QrCode\Exceptions\ImageTypeInvalidException
     */
    public static function create($content){
        $qr = new QrCodeEndroid();
        $qr->setText($content)->setSize(300)->setPadding(10)->setImageType('png');
        return \think\Response::create($qr->get(),"html", 200, [
            'Content-Type' => $qr->getContentType()
        ])->send();
    }

}