<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\library\utils;

use Overtrue\Pinyin\Converter;
use Overtrue\Pinyin\Pinyin as PinyinUtils;

/**
 * 汉字转拼音
 * @package app\common\library\utils
 * @class Pinyin
 * @author xzncit 2023-08-25
 */
class Pinyin {

    /**
     * @param string $data
     * @param string $toneStyle
     * @return mixed
     */
    public static function convert($data,$toneStyle=Converter::TONE_STYLE_NONE){
        return PinyinUtils::name($data,$toneStyle);
    }

    /**
     * @param string $value
     * @param string $join
     * @return string
     */
    public static function getString($value,$join=""){
        return implode($join,self::convert($value)->toArray());
    }

    /**
     * @param string $data
     * @return array
     */
    public static function getArray($data){
        return self::convert($data)->toArray();
    }

}