<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\library\utils;

/**
 * @package app\common\library\utils
 * @class helper
 * @author xzncit 2024-02-16
 */
class Helper {

    /**
     * 获取数组中指定的列
     * @param $data
     * @param $column
     * @return array
     */
    public static function getArrayColumn($data, $column) {
        $array = [];
        foreach ($data as $item) {
            if(!empty($item[$column])) $array[] = $item[$column];
        }

        return $array;
    }

    /**
     * 过滤数组
     * @param $array
     * @param $field
     * @return array
     */
    public static function getArrayFilter($array,$field=[],$reverse=false){
        $list = [];
        foreach($array as $key=>$value){
            if(is_array($value)){
                $list[$key] = self::getArrayFilter($value,$field,$reverse);
            }else{
                if(!$reverse && in_array($key,$field)){
                    $list[$key] = $value;
                }else if($reverse && !in_array($key,$field)){
                    $list[$key] = $value;
                }
            }
        }

        return $list;
    }

}