<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\library\utils;

/**
 * @package app\common\library\utils
 * @class Date
 * @author xzncit 2023-09-04
 */
class Date {

    /**
     * 获取微秒时间，常用于计算程序的运行时间
     * @return float
     */
    public static function microtime(){
        list($usec, $sec) = explode(" ", microtime());
        return ((float)$usec + (float)$sec);
    }

    /**
     * 获取时间范围
     * @param int|string $start 开始时间
     * @param int|string $end   结束时间
     * @param string     $type  类型
     * @return array
     */
    public static function range($start, $end, $type="d"){
        $array  = ['d'=>['Y-m-d','+1 days'],'m'=>['Y-m','+1 months'],'y'=>['Y','+1 years']];
        if(!is_numeric($start)){
            $start  = strtotime($start);
        }

        if(!is_numeric($end)){
            $end    = strtotime($end);
        }

        $result = [];
        while ($start <= $end) {
            $result[] = date($array[$type][0], $start);
            $start    = strtotime($array[$type][1], $start);
        }

        return $result;
    }

    /**
     * 计算两个时间中差几天
     * @param int $startTime 时间缀
     * @param int $endTime   时间缀
     * @return float|int
     */
    public static function diff($startTime,$endTime){
        $diffSeconds = $endTime - $startTime;
        $diffDays    = $diffSeconds / 86400;
        return $diffDays;
    }

    /**
     * 格式化时间
     * @param $time
     * @return string
     */
    public static function format($time){
        $nowTime        = time();
        $todayTime      = strtotime(date('Y-m-d'));
        $yesterdayTime  = $todayTime - 86400;
        $nowWeek        = date('w',$nowTime);
        $nowWeekTime    = $todayTime - ($nowWeek - 1) * 86400;
        $nowYearTime    = strtotime(date('Y-01-01'));
        $theWeek        = date('w',$time);
        $array          = [ "1"=>"一", "2"=>"二", "3"=>"三", "4"=>"四", "5"=>"五", "6"=>"六", "7"=>"日" ];

        // 未来
        if($time >= $nowTime){
            return '';
        }

        // 今天
        if($time > $todayTime){
            $diff_time = $nowTime - $time;
            if($diff_time < 60){
                return $diff_time . '秒前';
            }elseif($diff_time < 3600){
                return intval($diff_time / 60) . '分钟前';
            }

            return intval($diff_time / 3600) . '小时前';
        }elseif($time > $yesterdayTime){ // 昨天
            return '昨天 ' . date('H:i',$time);
        }elseif($time > $nowWeekTime){ // 这周内
            return '周' . ( $array[$theWeek] ?? '' ) . ' ' . date('H:i',$time);
        }elseif($time > $nowYearTime){ // 今年
            return date('m月d日',$time) . ' ' . date('H:i',$time);
        }

        // 更早
        return date('Y月m月d日',$time) . ' ' . date('H:i',$time);
    }

}