<?php

namespace app\common\library\payment;

use app\common\exception\BaseException;
use app\common\model\order\Order as OrderModel;
use app\common\model\Users as UsersModel;
use app\common\model\promotion\BargainUsers as BargainUsersModel;

/**
 * @package app\common\library\payment
 * @class Balance
 * @author xzncit 2024/3/16
 */
class Balance {

    public function create($order){
        $user = UsersModel::where("id",$order["user_id"])->find();
        if(empty($user)){
            throw new BaseException("用户不存在",0);
        }

        if($order["order_amount"] > $user["money"]){
            throw new BaseException("您的余额不足",0);
        }

        UsersModel::where("id",$order["user_id"])->dec("money",$order["order_amount"])->update();
        OrderModel::where("id",$order["order_id"])->save([
            "status"=>3,
            "pay_status"=>2,
            "trade_no"=>orderNo(),
            "pay_time"=>time()
        ]);

        if($order["type"] == 3){
            BargainUsersModel::where(["user_id"=>$order["user_id"],"bargain_id"=>$order["promoter_id"]])->save(["status"=>2]);
        }

        return [ "isPay"=>1 ];
    }

}