<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\library\jwt;

use Lcobucci\JWT\Configuration;
use Lcobucci\JWT\Signer;
use Lcobucci\JWT\Signer\Key\InMemory;

/**
 * @package app\common\library\jwt
 * @class Config
 * @author xzncit 2023-09-04
 */
class Config {

    public static function get(){
        $configuration = Configuration::forSymmetricSigner(
            new Signer\Hmac\Sha256(),
            InMemory::base64Encoded(env("jwt_secret_key"))
        );

        return $configuration;
    }

    public static function getHost(){
        return env("web_url");
    }

    public static function getSign(){
        return env("jwt_sign");
    }

}