<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\library\file;

/**
 * 文件类
 * @package app\common\library\utils
 * @class File
 * @author xzncit 2023-09-02
 */
class File {

    /**
     * 获取程序根目录
     * @return string
     */
    public static function getPath() {
        return dirname(dirname(dirname(dirname(__DIR__)))) . "/";
    }

    /**
     * mb转kb|Bytes
     * @param string $type
     * @return float|int
     */
    public static function to($type="kb"){
        $fileSize = min(intval(get_cfg_var('upload_max_filesize')),intval(get_cfg_var('post_max_size')),intval(get_cfg_var('memory_limit')));
        switch($type){
            case "bytes":
                return ($fileSize * 1024) * 1024;
            case "kb":
                return $fileSize * 1024;
        }
    }

    /**
     * 获取文件大小
     * @param $size
     * @return string
     */
    public static function size($size=0){
        if($size <= 0){
            return "0 Byte";
        }

        $unit = ["Byte", "KB", "MB", "GB", "TB", "PB"];
        return round($size / pow(1024, ($i = floor(log($size, 1024)))), 2) . ' ' . $unit[$i];
    }

    /**
     * 获取目录大小
     * @param $directory
     * @return false|int
     */
    public static function getDirSize($directory) {
        if(!file_exists($directory)){
            return 0;
        }

        $dir_size = 0;
        if(($dir_handle = opendir($directory)) != false){
            while(($filename = readdir($dir_handle)) != false){
                if($filename != '.' && $filename != '..'){
                    $subFile = $directory . '/' . $filename;
                    if(is_dir($subFile)) $dir_size += self::getDirSize($subFile);
                    if(is_file($subFile)) $dir_size += filesize($subFile);
                }
            }

            closedir($dir_handle);
            return $dir_size;
        }
    }

    /**
     * 删除文件或目录
     * @param string $file
     * @return bool
     */
    public static function delete($file) {
        if(empty($file) || !file_exists($file)){
            return false;
        }

        if(is_file($file)) {
            return unlink($file);
        }

        $ret = true;
        if(($handle = opendir($file)) != false){
            while(($filename = readdir($handle)) != false){
                if($filename == '.' || $filename == '..') continue;
                if(!self::delete($file . '/' . $filename)) $ret = false;
            }
        }else{
            $ret = false;
        }

        closedir($handle);
        if(file_exists($file) && !rmdir($file)){
            $ret = false;
        }

        return $ret;
    }

}