<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\library\express\aliyun;

use xzncit\Factory;
use app\common\service\Config as ConfigService;

/**
 * @package app\common\library\express\aliyun
 * @class Aliyun
 * @author xzncit 2024-02-26
 */
class Aliyun {

    /**
     * @param string $numberNo
     * @param string $type
     * @return array
     * @throws \Exception
     */
    public static function query($numberNo="",$type=""){
        // return json_decode('{"status":"0","msg":"ok","result":{"number":"780098068058","type":"zto","list":[{"time":"2018-03-09 11:59:26","status":"【石家庄市】快件已在【长安三部】 签收,签收人: 本人,感谢使用中通快递,期待再次为您服务!"},{"time":"2018-03-09 09:03:10","status":"【石家庄市】 快件已到达 【长安三部】（0311-85344265）,业务员 容晓光（15908220064） 正在第1次派件, 请保持电话畅通,并耐心等待"},{"time":"2018-03-08 23:43:44","status":"【石家庄市】 快件离开 【石家庄】 发往 【长安三部】"},{"time":"2018-03-08 21:00:44","status":"【石家庄市】 快件到达 【石家庄】"},{"time":"2018-03-07 01:38:45","status":"【广州市】 快件离开 【广州中心】 发往 【石家庄】"},{"time":"2018-03-07 01:36:53","status":"【广州市】 快件到达 【广州中心】"},{"time":"2018-03-07 00:40:57","status":"【广州市】 快件离开 【广州花都】 发往 【石家庄中转】"},{"time":"2018-03-07 00:01:55","status":"【广州市】 【广州花都】（020-37738523） 的 马溪 （18998345739） 已揽收"}],"deliverystatus":"3","issign":"1","expName":"中通快递","expSite":"www.zto.com","expPhone":"95311","courier":"容晓光","courierPhone":"15908220064","updateTime":"2019-08-27 13:56:19","takeTime":"2天20小时14分","logo":"https://img3.fegine.com/express/zto.jpg"}}',true)["result"];
        try{
            $config = ConfigService::getArray("delivery.aliyun",["AppKey"=>"","AppSecret"=>"","AppCode"=>""]);
            return Factory::Delivery([
                "AppKey"=>$config["AppKey"],
                "AppSecret"=>$config["AppSecret"],
                "AppCode"=>$config["AppCode"],
            ])->aliyun->query($numberNo,$type);
        }catch (\Exception $ex){
            return ["list"=>[]];
        }
    }

}