<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\exception;

use Exception;

/**
 * 自定义异常类
 * @package app\common\exception
 * @class BaseException
 * @author xzncit 2023-08-23
 */
class BaseException extends Exception {

    /**
     * @var array|null
     */
    protected $raw = [];

    /**
     * BaseException constructor.
     * @param string $message
     * @param int $code
     * @param null $data
     */
    public function __construct($message = "", $code = 0,$data = null){
        parent::__construct($message, $code);
        $this->raw = $data;
    }

    /**
     * @param null $field
     * @return mixed|null
     */
    public function getRaw($field=null){
        if(empty($field)){
            return $this->raw;
        }

        if(isset($this->raw[$field])){
            return $this->raw[$field];
        }

        return null;
    }

}