<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\enum;

/**
 * @package app\common\enum
 * @class Terminal
 * @author xzncit 2024-01-24
 */
class Terminal {

    const MP_QRCODE       = 0;  // PC微信扫码
    const MP_WECHAT       = 1;  // 微信公众号
    const MP_WEIXIN       = 2;  // 微信小程序
    const MP_ALIPAY       = 3;  // 支付宝小程序
    const MP_BAIDU        = 4;  // 百度小程序
    const MP_TOUTIAO      = 5;  // 抖音小程序
    const MP_QQ           = 6;  // QQ小程序
    const MP_360          = 7;  // 360小程序
    const PC              = 8;  // PC
    const H5              = 9;  // H5
    const IOS             = 10; // 苹果APP
    const ANDROID         = 11; // 安卓APP
    const UNKNOWN         = 12; // 未知类型

    /**
     * 获取终端文字
     * @param int $type
     * @return string|string[]
     */
    public static function get($type=0){
        $array = [
            self::MP_QRCODE     => "微信扫码",
            self::MP_WECHAT     => "微信公众号",
            self::MP_WEIXIN     => "微信小程序",
            self::MP_ALIPAY     => "支付宝小程序",
            self::MP_BAIDU      => "百度小程序",
            self::MP_TOUTIAO    => "抖音小程序",
            self::MP_QQ         => "QQ小程序",
            self::MP_360        => "360小程序",
            self::PC            => "PC",
            self::H5            => "H5",
            self::IOS           => "苹果APP",
            self::ANDROID       => "安卓APP",
            self::UNKNOWN       => "未知类型"
        ];

        return isset($array[$type]) ? $array[$type] : $array;
    }

    /**
     * @param $type
     * @return int|string
     */
    public static function getTerminalNo($type){
        $array = [
            "qrcode"           => self::MP_QRCODE,
            "wechat"           => self::MP_WECHAT,
            "mp-weixin"        => self::MP_WEIXIN,
            "mp-alipay"        => self::MP_ALIPAY,
            "mp-baidu"         => self::MP_BAIDU,
            "mp-toutiao"       => self::MP_TOUTIAO,
            "mp-qq"            => self::MP_QQ,
            "mp-360"           => self::MP_360,
            "pc"               => self::PC,
            "h5"               => self::H5,
            "app-ios"          => self::IOS,
            "app-android"      => self::ANDROID
        ];

        return $array[$type] ?? self::UNKNOWN;
    }

}