<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\enum;

/**
 * @package app\common\enum
 * @class Sms
 * @author xzncit 2024-01-24
 */
class Sms {
    /*
     * 100=>登录验证
     * 101=>绑定手机
     * 102=>变更手机
     * 103=>找回密码
     */
    const USER_LOGIN    = 100;
    const USER_BIND     = 101;
    const USER_CHANGE   = 102;
    const USER_PASSWORD = 103;

    /**
     * @param $value
     * @return int|null
     */
    public static function getType($value){
        $array = [
            "login"     => self::USER_LOGIN,
            "bind"      => self::USER_BIND,
            "change"    => self::USER_CHANGE,
            "password"  => self::USER_PASSWORD,
        ];

        return $array[$value]??null;
    }

}