<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\enum;

/**
 * @package app\common\enum
 * @class OrderRefunds
 * @author xzncit 2024-02-27
 */
class OrderRefunds {

    const UNKNOWN = "未知类型";

    /**
     * 售后类型
     * @param $value
     * @return string
     */
    public static function type($value){
        $array = [1=>"退货退款",2=>"换货"];
        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 商家审核状态
     * @param $value
     * @return string
     */
    public static function auditStatus($value){
        $array = [1=>"待审核",2=>"已同意",3=>"已拒绝"];
        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 用户是否发货
     * @param $value
     * @return string
     */
    public static function isUserSend($value){
        $array = [1=>"未发货",2=>"已发货"];
        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 商家收货状态
     * @param $value
     * @return string
     */
    public static function isReceipt($value){
        $array = [1=>"未收货",2=>"已收货"];
        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 售后状态
     * @param $value
     * @return string
     */
    public static function status($value){
        $array = [1=>"进行中",2=>"已完成",3=>"已取消",4=>"已拒绝"];
        return $array[$value]??self::UNKNOWN;
    }

}