<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\enum;

/**
 * @package app\common\enum
 * @class OrderInvoice
 * @author xzncit 2024-02-27
 */
class OrderInvoice {

    const UNKNOWN = "未知类型";

    /**
     * 抬头类型
     * @param $value
     * @return string
     */
    public static function headerType($value){
        $array = [1=>"个人",2=>"企业"];
        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 发票类型
     * @param $value
     * @return string
     */
    public static function type($value){
        $array = [1=>"普通",2=>"专用"];
        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 开票状态
     * @param $value
     * @return string
     */
    public static function status($value){
        $array = [1=>"审核",2=>"成功",3=>"拒绝"];
        return $array[$value]??self::UNKNOWN;
    }

}