<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\common\enum;

/**
 * @package app\common\enum
 * @class Order
 * @author xzncit 2024-02-25
 */
class Order {

    const UNKNOWN = "未知类型";

    /**
     * 订单状态
     * @param $value
     * @return int
     */
    public static function active($value){
        if(empty($value)){
            return 0;
        }

        if(in_array($value["status"],[1,2])){
            return 1; // 未支付
        }

        if($value["status"] == 3){
            return 2; // 待发货
        }

        if(in_array($value["refund_status"],[2,3])){
            return 3; // 退款中
        }

        if($value["refund_status"] == 4){
            return 4; // 退款完成
        }

        if($value["status"] == 4 || $value["status"] == 5){
            if(in_array($value["refund_status"],[2,3])){
                return 3; // 退款中
            }

            if($value["refund_status"] == 4){
                return 4; // 退款完成
            }

            return 5; // 已发货,部分发货
        }

        if($value["status"] == 6){
            if(in_array($value["evaluate_status"],[1,3])){
                return 7; // 订单未评价
            }

            return 6; // 完成订单
        }

        if($value["status"] == 7){
            return 8; // 订单取消
        }

        if($value["status"] == 8){
            return 9; // 订单关闭
        }

        return 0;
    }

    /**
     * 获取订单进程状态描述
     * @param $value
     * @return string
     */
    public static function activeText($value){
        $array = [
            0=>self::UNKNOWN,
            1=>"未支付",
            2=>"待发货",
            3=>"订单退款",
            4=>"退款完成",
            5=>"待收货",
            6=>"订单完成",
            7=>"待评价",
            8=>"订单已取消",
            9=>"订单已关闭"
        ];

        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 订单类型
     * @param $value
     * @return string
     */
    public static function type($value){
        $array = [
            "0"=>"普通订单",
            "1"=>"拼团活动",
            "2"=>"限时秒杀",
            "3"=>"砍价活动",
            "4"=>"限时折扣",
            "5"=>"限购活动",
            "6"=>"积分商品"
        ];

        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 获取订单类型
     * @param $value
     * @return string
     */
    public static function getType($value){
        $array = [
            "goods"     => "0",
            "group"     => "1",
            "second"    => "2",
            "bargain"   => "3",
            "discount"  => "4",
            "limit"     => "5",
            "point"     => "6"
        ];

        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 返现类型
     * @param $value
     * @return string
     */
    public static function promoterType($value){
        $array = [
            "1"=>"普通订单",
            "2"=>"自购优惠",
            "3"=>"自购返佣",
            "4"=>"普通分销"
        ];

        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 订单执行状态
     * @param $value
     * @return string
     */
    public static function status($value){
        $array = [
            "1"=>"待确认",
            "2"=>"待支付",
            "3"=>"待发货",
            "4"=>"待收货",
            "5"=>"部分发货",
            "6"=>"交易完成",
            "7"=>"已取消",
            "8"=>"已关闭"
        ];

        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 支付状态
     * @param $value
     * @return string
     */
    public static function payStatus($value){
        $array = [
            "1"=>"待支付",
            "2"=>"已支付",
            "3"=>"已退款",
            "4"=>"部分退款"
        ];

        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 退款状态
     * @param $value
     * @return string
     */
    public static function refundStatus($value){
        $array = [
            "1"=>"未退款",
            "2"=>"审批中",
            "3"=>"退款中",
            "4"=>"已退款"
        ];

        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 配送状态
     * @param $value
     * @return string
     */
    public static function deliveryStatus($value){
        $array = [
            "1"=>"未发货",
            "2"=>"已发货",
            "3"=>"部分发货"
        ];

        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 收货状态
     * @param $value
     * @return string
     */
    public static function collectStatus($value){
        $array = [
            "1"=>"未收货",
            "2"=>"己收货"
        ];

        return $array[$value]??self::UNKNOWN;
    }

    /**
     * 是否评价
     * @param $value
     * @return string
     */
    public static function evaluateStatus($value){
        $array = [
            "1"=>"未评价",
            "2"=>"己评价",
            "3"=>"部份评价"
        ];

        return $array[$value]??self::UNKNOWN;
    }

}