<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\validate\ucenter;

use think\Validate;

/**
 * @package app\api\validate\ucenter
 * @class Invoice
 * @author xzncit 2024-03-14
 */
class Invoice extends Validate {

    protected $rule = [
        'name'          => 'require',
        'drawer_phone'  => 'require|mobile',
        'email'         => 'require|email',
        'duty_number'   => 'checkDutyNumber'
    ];

    protected $message  =   [
        'name.require'          => '请输入发票抬头',
        'drawer_phone.require'  => '请输入手机',
        'drawer_phone.mobile'   => '您填写的手机号码不合法',
        'email.require'         => '请输入邮箱',
        'email.email'           => '您填写的邮箱不正确'
    ];

    public function checkDutyNumber($value,$rule,$data=[]){
        if($data["header_type"] == 2 && empty($value)){
            return "请输入税号";
        }

        return true;
    }

}