<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\validate\ucenter;

use think\Validate;

/**
 * @package app\api\validate\ucenter
 * @class Address
 * @author xzncit 2024-03-03
 */
class Address extends Validate {

    protected $rule = [
        'accept_name'     => 'require',
        'mobile'          => 'require|mobile',
        'province'        => 'require',
        'city'            => 'require',
        'area'            => 'require',
        'address'         => 'require'
    ];

    protected $message  =   [
        'accept_name.require'   => '请输入姓名',
        'mobile.require'        => '请输入手机',
        'mobile.mobile'         => '您填写的手机号码不合法',
        'province.require'      => '请选择省',
        'city.require'          => '请选择市',
        'area.require'          => '请选择区',
        'address.require'       => '请输入详细地址'
    ];

}