<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\validate;

use think\Validate;

/**
 * @package app\api\validate
 * @class Password
 * @author xzncit 2024-01-27
 */
class Password extends Validate {

    protected $rule = [
        'old_password'                  => 'require',
        'password'                      => 'require|checkPassword|min:6|max:20',
        'confirm_password'              => 'require|confirm:password'
    ];

    protected $message  =   [
        'old_password.require'          => '请输入原密码',
        'password.require'              => '请输入新密码',
        'password.min'                  => '密码长度不能少于6个字符',
        'password.max'                  => '密码长度不能超过20个字符',
        'confirm_password.require'      => '请输入确认密码',
        'confirm_password.confirm'      => '您输入的两次密码不相等'
    ];

    /**
     * @var array
     */
    protected $scene = [];

    /**
     * 检查密码
     * @param $value
     * @param $rule
     * @param array $data
     * @return bool|string
     */
    protected function checkPassword($value, $rule, $data=[]){
        if(preg_match("/(\s)/i",$value)){
            return "您填写的密码包含空格字符";
        }

        return true;
    }

}