<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\validate;

use app\common\library\utils\Check;
use app\common\model\Users as UsersModel;
use think\Validate;

/**
 * @package app\api\validate
 * @class Forget
 * @author xzncit 2024-01-25
 */
class Forget extends Validate {

    protected $rule = [
        'username'          => 'require|checkUsername',
        'code'              => 'require',
        'password'          => 'require|checkPassword|min:6|max:20',
        'confirm_password'  => 'require|confirm:password'
    ];

    protected $message  =   [
        'username.require'          => '请输入手机号',
        'code.require'              => '请输入验证码',
        'password.require'          => '请输入密码',
        'password.min'              => '密码长度不能少于6个字符',
        'password.max'              => '密码长度不能超过20个字符',
        'confirm_password.require'  => '请输入确认密码',
        'confirm_password.confirm'  => '您输入的两次密码不相等'
    ];

    /**
     * @var array
     */
    protected $scene = [];

    /**
     * 检查手机号是否存在
     * @param $value
     * @param $rule
     * @param array $data
     * @return bool|string
     * @throws \think\db\exception\DbException
     */
    protected function checkUsername($value, $rule, $data=[]){
        if(!Check::mobile($value)){
            return "您填写的手机号码不正确";
        }

        if(!UsersModel::where("mobile",$value)->count()){
            return "您要找回密码的用户手机号不存在";
        }

        return true;
    }

    /**
     * 检查密码
     * @param $value
     * @param $rule
     * @param array $data
     * @return bool|string
     */
    protected function checkPassword($value, $rule, $data=[]){
        if(preg_match("/(\s)/i",$value)){
            return "您填写的密码包含空格字符";
        }

        return true;
    }

}