<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\validate;

use app\common\library\utils\Check;
use think\Validate;

/**
 * @package app\api\validate
 * @class Bind
 * @author xzncit 2024-01-25
 */
class Bind extends Validate {

    protected $rule = [
        'username'          => 'require|checkUserName',
        'code'              => 'require'
    ];

    protected $message  =   [
        'username.require'          => '请输入手机',
        'code.require'              => '请输入验证码'
    ];

    /**
     * @var array
     */
    protected $scene = [];

    /**
     * 验证用户名
     * @param $value
     * @param $rule
     * @param array $data
     * @return bool|string
     */
    protected function checkUserName($value, $rule, $data=[]){
        if(!Check::mobile($value)){
            return "您填写的手机号码不正确";
        }

        return true;
    }

}