<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service\ucenter;

use app\api\model\users\UsersVisit as UsersVisitModel;
use app\common\exception\BaseException;
use app\common\library\utils\Image;
use app\common\service\Users as UsersService;

/**
 * @package app\api\service\ucenter
 * @class Visit
 * @author xzncit 2024-03-04
 */
class Visit {

    /**
     * 列表
     * @param array $params
     * @return array
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params=[]){
        $array = [
            "total" => 0,
            "list"  => [],
            "size"  => 10
        ];

        $condition   = [];
        $condition[] = ["user_id","=",UsersService::get("id",0)];
        $page  = $params["page"]??1;
        $count = UsersVisitModel::withJoin("goods")->where($condition)->count();
        $array["list"] = UsersVisitModel::withJoin("goods")->where($condition)->page($page,$array["size"])->order('create_time','DESC')->select()->map(function ($value){
            $goods = $value["goods"];
            return [
                "id"             => $value["id"],
                "category"       => $value["category"],
                "activity_id"    => $value["activity_id"],
                "goods_id"       => $value["goods_id"],
                "title"          => $goods["title"],
                "price"          => $goods["sell_price"],
                "photo"          => Image::thumb($goods["photo"],["prefix"=>"medium"])
            ];
        });

        $array["total"] = ceil($count / $array["size"]);
        if($array["total"] == $page -1){
            throw new BaseException("没有数据了哦！",-1,$array);
        }

        return $array;
    }

}