<?php

namespace app\api\service\ucenter;

use app\common\exception\BaseException;
use app\common\service\Config;
use app\common\library\utils\BC;
use app\common\model\order\Recharge as RechargeModel;
use app\common\service\Users as UsersService;

/**
 * @package app\api\service\ucenter
 * @class Recharge
 * @author xzncit 2024/3/17
 */
class Recharge {

    /**
     * 获取充值配置
     * @return array|mixed|null
     */
    public static function pay($params){
        if(empty($params["price"])){
            throw new BaseException("请填写充值金额",0);
        }

        $order = [
            "user_id"=>UsersService::get("id"),
            "order_no"=>'P'. orderNo(),
            "pay_price"=>$params["price"],
            "gift_money"=>0,
            "actual_money"=>$params["price"],
            "create_time"=>time()
        ];

        $list = Config::getArray("recharge.list");
        foreach($list as $value){
            if($value["order_amount"] == $params["price"]){
                $order["pay_price"]    = $value["order_amount"];
                $order["gift_money"]   = $value["price"];
                $order["actual_money"] = BC::add($order["gift_money"],$order["pay_price"]);
                break;
            }
        }

        return RechargeModel::create($order)->id;
    }

    public static function log($params=[]){
        $array = [
            "total" => 0,
            "list"  => [],
            "size"  => 10
        ];

        $condition   = [];
        $condition[] = ["user_id","=",UsersService::get("id",0)];
        $page  = $params["page"]??1;
        $count = RechargeModel::where($condition)->count();
        $array["list"] = RechargeModel::where($condition)->page($page,$array["size"])->order('id','desc')->select()->map(function ($value){
            return [
                "order_no"           => $value["order_no"],
                "pay_status"         => $value["pay_status"],
                "gift_money"         => $value["gift_money"],
                "pay_price"          => $value["pay_price"],
                "actual_money"       => $value["actual_money"],
                "create_time"   => date("Y-m-d H:i:s",$value["create_time"])
            ];
        });

        $array["total"] = ceil($count / $array["size"]);
        if($array["total"] == $page -1){
            throw new BaseException("没有数据了哦！",-1,$array);
        }

        return $array;
    }

}