<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service\ucenter;

use app\common\model\users\UsersInvoice as UsersInvoiceModel;
use app\common\service\Users as UsersService;

/**
 * @package app\api\service\ucenter
 * @class Invoice
 * @author xzncit 2024-03-13
 */
class Invoice {

    public static function getList(){
        return UsersInvoiceModel::where("user_id",UsersService::get("id",0))->select()->map(function ($res){
            return $res;
        });
    }

    /**
     * 详情
     * @param $id
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $row = UsersInvoiceModel::where(["user_id"=>UsersService::get("id",0),"id"=>$id])->find();
        if(empty($row)){
            return [];
        }

        return $row;
    }

    /**
     * 保存
     * @param $data
     */
    public static function save($data){
        $data["user_id"] = UsersService::get("id",0);
        if(isset($data["id"]) && $row = UsersInvoiceModel::where("id",$data["id"])->where("user_id",UsersService::get("id",0))->find()){
            UsersInvoiceModel::where("id",$data["id"])->where("user_id",UsersService::get("id",0))->save($data);
        }else{
            $data["create_time"] = time();
            UsersInvoiceModel::create($data);
        }
    }

    /**
     * 删除
     * @param $id
     */
    public static function delete($id){
        return UsersInvoiceModel::where("id",$id)->where("user_id",UsersService::get("id",0))->delete();
    }

}