<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service\ucenter;

use app\common\exception\BaseException;
use app\common\model\ArchivesHelp as ArchivesHelpModel;

/**
 * @package app\api\service\ucenter
 * @class Help
 * @author xzncit 2024-03-05
 */
class Help {

    /**
     * 列表
     * @return ArchivesHelpModel[]|array|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList(){
        return ArchivesHelpModel::select()->map(function ($res){
            return [
                "id"    => $res["id"],
                "title" => $res["title"]
            ];
        });
    }

    /**
     * 详情
     * @param $id
     * @return array
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $row = ArchivesHelpModel::where("id",$id)->find();
        if(empty($row)){
            throw new BaseException("内容不存在",404);
        }

        return [
            "title"     => $row["title"],
            "content"   => $row["content"]
        ];
    }

}