<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service\ucenter;

use app\common\library\utils\Image;
use app\common\service\Users as UsersService;
use app\api\model\users\UsersCollect as UsersCollectModel;
use app\common\exception\BaseException;

/**
 * @package app\api\service\ucenter
 * @class Collect
 * @author xzncit 2024-03-04
 */
class Collect {

    /**
     * 列表
     * @param array $params
     * @return array
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params=[]){
        $array = [
            "total" => 0,
            "list"  => [],
            "size"  => 10
        ];

        $condition   = [];
        $condition[] = ["user_id","=",UsersService::get("id",0)];
        $page  = $params["page"]??1;
        $count = UsersCollectModel::withJoin("goods")->where($condition)->count();
        $array["list"] = UsersCollectModel::withJoin("goods")->where($condition)->page($page,$array["size"])->order('id','desc')->select()->map(function ($value){
            $goods = $value["goods"];
            return [
                "id"    => $value["id"],
                "title" => $goods["title"],
                "price" => $goods["sell_price"],
                "photo" => Image::thumb($goods["photo"],["prefix"=>"medium"])
            ];
        });

        $array["total"] = ceil($count / $array["size"]);
        if($array["total"] == $page -1){
            throw new BaseException("没有数据了哦！",-1,$array);
        }

        return $array;
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        return UsersCollectModel::where(["id"=>$id,"user_id"=>UsersService::get("id",0)])->delete();
    }

}