<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service\diy\widget;

use app\common\library\utils\Image;
use app\common\model\Archives as ArchivesModel;

/**
 * @package app\api\service\diy\widget
 * @class Archives
 * @author xzncit 2024-02-05
 */
class Archives {

    /**
     * 返回组件数据
     * @param $value
     * @return mixed
     */
    public function getData($value){
        if($value["type"] == 1){
            $value["list"] = $this->getArticle($value["list"]);
        }else{
            $value["list"] = $this->getCategoryArticleList($value["group"]);
        }

        unset($value["group"]);
        return $value;
    }

    protected function getArticle($data){
        $array = [];
        foreach($data as $key=>$value){
            $array[$key] = [
                "name"          => $value["name"],
                "image"         => Image::thumb(Image::parseUrl($value["image"]),["prefix"=>"medium"]),
                "link"          => [
                    "path"  => $value["link"]["path"] ?? ""
                ]
            ];
        }

        return $array;
    }

    protected function getCategoryArticleList($data){
        $condition = [];
        if(!empty($data["id"])){
            $result = getCategoryChildren(["pid"=>$data["id"]]);
            $result[] = $data["id"];
            $condition[] = ["pid","in",$result];
        }

        $goods = ArchivesModel::where($condition)->limit($data["limit"]??20)->select()->toArray();

        $array = [];
        foreach($goods as $key=>$value){
            $array[$key] = [
                "name"          => $value["title"],
                "image"         => Image::thumb(Image::parseUrl($value["photo"]),["prefix"=>"medium"]),
                "link"          => [
                    "path"  => "/pages/archives/view?id=" . $value["id"]
                ]
            ];
        }

        return $array;
    }

}